package math.matrix;

import java.awt.*;
import javax.swing.*;
import math.axes.CartesianAxPanel;
import math.line.LineUtil;
import math.shapes.Line;

public class Matrix30 extends JFrame{
	private static final long serialVersionUID = 431281611636634328L;
	public static final int fw = 1000;
	public static final int fh = 1000;

	public static void main(String[] args) {
		SwingUtilities.invokeLater(() -> new Matrix30(new LinePanel30()));
	}

	public Matrix30(JComponent comp){
		setLayout(null);
		setPreferredSize(new Dimension(fw, fh));
		setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
				- (fw / 2),
				(Toolkit.getDefaultToolkit().getScreenSize().height / 2)
						- (fh / 2), fw, fh);
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setTitle("Ramka Graficzna");
		//	setResizable(false);
		JPanel panel = (JPanel) comp;
		panel.setLocation((fw - panel.getWidth()) / 2,
				(fh - panel.getHeight()) / 2);
		add(panel);
		setVisible(true);
	}
}

class LinePanel30 extends CartesianAxPanel {
	private static final long serialVersionUID = 8115404932220947612L;

	@Override
	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D)g;
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
				RenderingHints.VALUE_ANTIALIAS_ON);
		Line line1 = LineUtil.findLine(3, 2, -17);
		LineUtil.drawLine(line1, g2, Color.BLACK, 30);
		Line line2 = LineUtil.findLine(5, -3, -3);
		LineUtil.drawLine(line2, g2, Color.BLACK, 30);
	}
}
