package math.logics3;

import java.io.Serializable;

public class Kleene implements Serializable, Comparable<Kleene> {
    private static final long serialVersionUID = 6486229772313401705L;
    private int value;

    public Kleene() {
        this(-1);
    }

    public Kleene(int value) throws IllegalArgumentException {
        switch (value) {
            case -1:
            case 0:
            case 1:
                this.value = value;
                break;
            default:
                throw new IllegalArgumentException(
                        "Wartość może być tylko 1, -1 lub 0");
        }
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        switch (value) {
            case -1:
            case 1:
            case 0:
                this.value = value;
                break;
            default:
                throw new IllegalArgumentException(
                        "Wartość może być tylko 1, -1 lub 0");
        }
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (getClass() != other.getClass()) {
            return false;
        }
        Kleene o = (Kleene) other;
        return value == o.getValue();
    }

    @Override
    public int hashCode() {
        return 7 * Integer.valueOf(value).hashCode();
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @Override
    public int compareTo(Kleene o) {
        int c = -5;
        if (value == o.value) {
            c = 0;
        }
        if (value > o.value) {
            c = 1;
        }
        if (value < o.value) {
            c = -1;
        }
        return c;
    }

    public static Kleene not(Kleene tri) {
        Kleene temp = new Kleene();
        int val = tri.getValue();
        if (val == 0) {
            temp.setValue(1);
        } else if (val == 1) {
            temp.setValue(0);
        }
        return temp;
    }

    public static Kleene and(Kleene p, Kleene q) {
        int a = p.getValue();
        int b = q.getValue();
        Kleene temp = new Kleene();
        if ((a == 0) && (b == 0)) {
            temp.setValue(0);
        }
        if ((a == 0) && (b == -1)) {
            temp.setValue(0);
        }
        if ((a == 0) && (b == 1)) {
            temp.setValue(0);
        }
        if ((a == -1) && (b == 0)) {
            temp.setValue(0);
        }
        if ((a == -1) && (b == -1)) {
            temp.setValue(-1);
        }
        if ((a == -1) && (b == 1)) {
            temp.setValue(-1);
        }
        if ((a == 1) && (b == 0)) {
            temp.setValue(0);
        }
        if ((a == 1) && (b == -1)) {
            temp.setValue(-1);
        }
        if ((a == 1) && (b == 1)) {
            temp.setValue(1);
        }
        return temp;
    }

    public static Kleene or(Kleene p, Kleene q) {
        int a = p.getValue();
        int b = q.getValue();
        Kleene temp = new Kleene();
        if ((a == 0) && (b == 0)) {
            temp.setValue(0);
        }
        if ((a == 0) && (b == -1)) {
            temp.setValue(-1);
        }
        if ((a == 0) && (b == 1)) {
            temp.setValue(1);
        }
        if ((a == -1) && (b == 0)) {
            temp.setValue(-1);
        }
        if ((a == -1) && (b == -1)) {
            temp.setValue(-1);
        }
        if ((a == -1) && (b == 1)) {
            temp.setValue(1);
        }
        if ((a == 1) && (b == 0)) {
            temp.setValue(1);
        }
        if ((a == 1) && (b == -1)) {
            temp.setValue(1);
        }
        if ((a == 1) && (b == 1)) {
            temp.setValue(1);
        }
        return temp;
    }

    public static Kleene imp(Kleene p, Kleene q) {
        int a = p.getValue();
        int b = q.getValue();
        Kleene temp = new Kleene();
        if ((a == 0) && (b == 0)) {
            temp.setValue(1);
        }
        if ((a == 0) && (b == -1)) {
            temp.setValue(1);
        }
        if ((a == 0) && (b == 1)) {
            temp.setValue(1);
        }
        if ((a == -1) && (b == 0)) {
            temp.setValue(-1);
        }
        if ((a == -1) && (b == -1)) {
            temp.setValue(-1);
        }
        if ((a == -1) && (b == 1)) {
            temp.setValue(1);
        }
        if ((a == 1) && (b == 0)) {
            temp.setValue(0);
        }
        if ((a == 1) && (b == -1)) {
            temp.setValue(-1);
        }
        if ((a == 1) && (b == 1)) {
            temp.setValue(1);
        }
        return temp;
    }

    public static Kleene nxor(Kleene p, Kleene q) {
        int a = p.getValue();
        int b = q.getValue();
        Kleene temp = new Kleene();
        if ((a == 0) && (b == 0)) {
            temp.setValue(1);
        }
        if ((a == 0) && (b == -1)) {
            temp.setValue(-1);
        }
        if ((a == 0) && (b == 1)) {
            temp.setValue(0);
        }
        if ((a == -1) && (b == 0)) {
            temp.setValue(-1);
        }
        if ((a == -1) && (b == -1)) {
            temp.setValue(-1);
        }
        if ((a == -1) && (b == 1)) {
            temp.setValue(-1);
        }
        if ((a == 1) && (b == 0)) {
            temp.setValue(0);
        }
        if ((a == 1) && (b == -1)) {
            temp.setValue(-1);
        }
        if ((a == 1) && (b == 1)) {
            temp.setValue(1);
        }
        return temp;
    }
}
