package math.functions;

import math.axes.Ax;
import math.axes.PShape;

import javax.swing.*;
import java.awt.*;

class Funct11 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Funct11(new AxPanel11()));
    }

    Funct11(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class AxPanel11 extends JPanel {
    private static final long serialVersionUID = 5218506428064759030L;
    private static final int w = 860;
    private static final int h = 860;
    private static final int offset = 40;

    public AxPanel11() {
        setPreferredSize(new Dimension(w, h));
        setSize(w, h);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        //--
        g2.drawRect(0 + offset, 0 + offset, 380, 380);
        Ax diag1 = new Ax(0, 0, 380, 380, -2, -2, 12, 40, g2, 2, 2, offset);
        diag1.drawTitle("Wykres funkcji: y=3x-|x-2|+1");
        diag1.drawGrid(Color.LIGHT_GRAY);
        diag1.drawAx(Color.BLACK, Color.BLACK);
        for (float i = 0f; i < 10f; i = i + 0.01f) {
            diag1.fillPoint(i, 3 * i - Math.abs(i - 2) + 1, 2, PShape.Circle,
                    Color.GREEN);
        }
        diag1.drawXLegend(true);
        diag1.drawYLegend(true);
    }
}