package math.curve;

import javax.swing.*;
import java.awt.*;

public class Curve01 extends JFrame {
    private static final long serialVersionUID = -2341107131516119572L;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Curve01(new Asteroida()));
    }

    public Curve01(JComponent comp) {
        setLayout(null);
        int fh = 1000;
        int fw = 1000;
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fw / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class Asteroida extends JPanel {
    private static final long serialVersionUID = 4145929212344860830L;
    private static final int w = 800;
    private static final int h = 800;

    public Asteroida() {
        setPreferredSize(new Dimension(w, h));
        setSize(w, h);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        CurveUtil.asteroida(g2, Color.BLUE, 150, 1000);
    }
}