package math.axes;

public class Rzutowanie {
    private final float rx;
    private final float ry;
    private final float rw;
    private final float rh;
    private final float sx;
    private final float sy;
    private final float sw;
    private final float sh;

    public Rzutowanie(float sx, float sy, float sw, float sh, float rx,
                      float ry, float rw, float rh) {
        this.sx = sx;
        this.sy = sy;
        this.sw = sw;
        this.sh = sh;
        this.rx = rx;
        this.ry = ry;
        this.rw = rw;
        this.rh = rh;
    }

    public float getSX(float realx) {
        if ((realx < rx) || (realx > (rx + rw))) {
            throw new IllegalArgumentException("Argument poza podanym zakresem");
        }
        return sx + ((realx - rx) / rw) * sw;
    }

    public float getSY(float realy) {
        if ((realy < ry) || (realy > (ry + rh))) {
            throw new IllegalArgumentException("Argument poza podanym zakresem");
        }
        return sy + ((realy - ry) / rh) * sh;
    }

    public float getRX(float screenx) {
        if ((screenx < sx) || (screenx > (sx + sw))) {
            throw new IllegalArgumentException("Argument poza podanym zakresem");
        }
        return rx + ((screenx - sx) / sw) * rw;
    }

    public float getRY(float screeny) {
        if ((screeny < sy) || (screeny > (sy + sh))) {
            throw new IllegalArgumentException("Argument poza podanym zakresem");
        }
        return ry + ((screeny - sy) / sh) * rh;
    }

    public float getRwSw() {
        return rw / sw;
    }

    public float getSwRw() {
        return sw / rw;
    }

    public float getRhSh() {
        return rh / sh;
    }

    public float getShRh() {
        return sh / rh;
    }
}
