package math.utils;

import math.linear.Vector3;

public class Tuple3d {
    private double x;
    private double y;
    private double z;

    public Tuple3d() {
        this(0, 0, 0);
    }

    public Tuple3d(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double distance(Tuple3d tuple) {
        return Math
                .sqrt(x * tuple.getX() + y * tuple.getY() + z * tuple.getZ());
    }

    @Override
    public String toString() {
        return "[" + x + ", " + y + ", " + z + "]";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        if (!(obj instanceof Tuple3d)) {
            return false;
        }
        Tuple3d t2 = (Tuple3d) obj;
        return (x == t2.getX()) && (y == t2.getY() && (z == t2.getZ()));
    }

    @Override
    public int hashCode() {
        return 17 * Double.valueOf(x).hashCode() + 19 * Double.valueOf(y).hashCode()
                * 23 * Double.valueOf(z).hashCode();
    }

    public double getX() {
        return x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getZ() {
        return z;
    }

    public void setZ(double z) {
        this.z = z;
    }

    public Vector3 toVector3() {
        return new Vector3(x, y, z);
    }
}
