package math.utils;

import math.linear.*;

public class Tuple2d{
	private double x;
	private double y;

	public Tuple2d(){
		this(0, 0);
	}

	public Tuple2d(double x, double y){
		this.x = x;
		this.y = y;
	}

	public double distance(Tuple2d tuple) {
		double x = this.x - tuple.x;
		double y = this.y - tuple.getY();
		return Math.sqrt(x * x + y * y);
	}

	@Override
	public String toString() {
		return "[" + x + ", " + y + "]";
	}

	@Override
	public boolean equals(Object obj) {
		if(this == obj){
			return true;
		}
		if(obj == null){
			return false;
		}
		if(getClass() != obj.getClass()){
			return false;
		}
		if(!(obj instanceof Tuple2d)){
			return false;
		}
		Tuple2d t2 = (Tuple2d)obj;
		return (x == t2.getX()) && (y == t2.getY());
	}

	@Override
	public int hashCode() {
		return 17 * Double.valueOf(x).hashCode() + 19 * Double.valueOf(y).hashCode();
	}

	public double getX() {
		return x;
	}

	public void setX(double x) {
		this.x = x;
	}

	public double getY() {
		return y;
	}

	public void setY(double y) {
		this.y = y;
	}

	public Vector2 toVector2() {
		return new Vector2(x, y);
	}
}
