package math.polynomials;

import math.complex.CType;
import math.complex.Complex;

public class QuadEquat {
    private final double a;
    private final double b;
    private final double c;
    private final double delta;
    private double[] roots;
    private Complex[] croots = null;
    //współrzędne wierzchołka paraboli
    private double p;
    private double q;

    public QuadEquat(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
        delta = b * b - 4 * a * c;
        if (delta < 0) {
            croots = new Complex[2];
            croots[0] = new Complex(-b / (2 * a), -Math.sqrt(-delta) / (2 * a),
                    CType.Normal);
            croots[1] = new Complex(-b / (2 * a), Math.sqrt(-delta) / (2 * a),
                    CType.Normal);
        } else if (delta == 0) {//pierwiastki są jednakowe
            roots = new double[2];
            roots[0] = -b / (2 * a);
            roots[1] = -b / (2 * a);
        } else {
            roots = new double[2];
            roots[0] = (-b - Math.sqrt(delta)) / (2 * a);
            roots[1] = (-b + Math.sqrt(delta)) / (2 * a);
        }
        p = -b / (2 * a);
        if (p == -0.0) {
            p = 0.0;
        }
        q = -delta / (4 * a);
        if (q == -0.0) {
            q = 0.0;
        }
    }

    public double getA() {
        return a;
    }

    public double getB() {
        return b;
    }

    public double getC() {
        return c;
    }

    public double getDelta() {
        return delta;
    }

    public double[] getRoots() {
        return roots;
    }

    public Complex[] getCroots() {
        return croots;
    }

    public double getP() {
        return p;
    }

    public double getQ() {
        return q;
    }

    public boolean isComplete() {
        //noinspection RedundantIfStatement
        if ((a != 0) && (b != 0) && (c != 0)) {
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        String mark1 = "";
        String mark2 = "";
        String mark3 = "";
        if (a >= 0) {
            mark1 = "";
        }
        if (b >= 0) {
            mark2 = "+";
        }
        if (c >= 0) {
            mark3 = "+";
        }
        return mark1 + a + "x^2" + mark2 + b + "x" + mark3 + c;
    }

    public String toStringCanonic() {
        String mark1 = "";
        String mark2 = "";
        String mark3 = "";
        if (a >= 0) {
            mark1 = "";
        }
        if (p >= 0) {
            mark2 = "+";
        }
        if (q >= 0) {
            mark3 = "+";
        }
        if (q > 0 || q < 0) {
            return mark1 + a + "(x" + mark2 + p + ")^2" + mark3 + q;
        } else {
            return mark1 + a + "(x" + mark2 + p + ")^2";
        }
    }

    public String toStringProduct() {
        String mark1 = "";
        String mark2 = "";
        String mark3 = "";
        if (a >= 0) {
            mark1 = "";
        }
        if (roots != null) {
            if (roots[0] >= 0) {
                mark2 = "+";
            }
            if (roots[1] >= 0) {
                mark3 = "+";
            }
        }
        if (delta >= 0) {
            if (delta > 0) {
                return mark1 + a + "(x" + mark2 + roots[0] + ")(x" + mark3
                        + roots[1] + ")";
            } else {
                return mark1 + a + "(x" + mark2 + roots[0] + ")^2";
            }
        } else {
            return mark1 + a + "(x" + mark2 + croots[0].toString(CType.Normal)
                    + ")(x" + mark3 + croots[1].toString(CType.Normal) + ")";
        }
    }

    public double sumViete() {
        return -b / a;
    }

    public double productViete() {
        return c / a;
    }
}
