package math.matrix;

import javax.swing.*;
import javax.swing.table.TableCellRenderer;
import java.awt.*;
import java.text.DecimalFormat;

public class MatrixReenderer extends JLabel implements TableCellRenderer {
    private static final long serialVersionUID = 18737557295563L;

    public MatrixReenderer() {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value,
                                                   boolean isSelected, boolean hasFocus, int row, int column) {
        DecimalFormat form = new DecimalFormat("##0.00");
        String str = null;
        if (value instanceof String) {
            str = (String) value;
        }
        if (value instanceof Double) {
            Double d = (Double) value;
            str = form.format(d);
        }
        if (str.startsWith("-")) {
            setForeground(Color.RED);
        } else {
            setForeground(Color.BLACK);
        }
        this.setHorizontalAlignment(JLabel.RIGHT);
        setText(str);
        return this;
    }
}
