package math.matrix;

import math.axes.CartesianAxPanel;
import math.linear.LinearUtil;
import math.linear.Vector2;

import javax.swing.*;
import java.awt.*;

public class Matrix16 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Matrix16(new VectorPanel16()));
    }

    public Matrix16(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        //	setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class VectorPanel16 extends CartesianAxPanel {
    private static final long serialVersionUID = 8115404932220947612L;

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        Vector2 vector1 = new Vector2(4.0, 4.0);
        LinearUtil.drawVector(vector1, g2, Color.BLUE);
        Vector2 vector2 = new Vector2(4.0, 1.0);
        LinearUtil.drawVector(vector2, g2, Color.BLUE);
        Vector2 vector3 = vector1.cross(vector2);
        LinearUtil.drawVector(vector3, g2, Color.RED);
        double len = vector3.getLength();
        g2.drawString("len: " + len, 430, 280);
    }
}
