package math.linear;


public class Polar{
	private double radius; //promien
	private double angle; //kat 

	public Polar(){
		this(0.0, 0.0);
	}

	public Polar(double radius, double angle){
		this.radius = radius;
		this.angle = angle;
	}

	public Polar(double[] array) throws IllegalArgumentException{
		if(array.length == 2){
			radius = array[0];
			angle = array[1];
		}
		else{
			throw new IllegalArgumentException("Niewłaściwa długość tablicy");
		}
	}

	public Polar(Polar polar){
		radius = polar.radius;
		angle = polar.angle;
	}

	public Polar(Vector2 vector){
		radius = Math.sqrt(Math.pow(vector.getY(), 2)
				+ Math.pow(vector.getX(), 2));
		angle = Math.atan2(vector.getY(), vector.getX());
	}

	public Vector2 toCart() {
		double xx = radius * Math.cos(angle);
		double yy = radius * Math.sin(angle);
		return new Vector2(xx, yy);
	}

	@Override
	public String toString() {
		return ("[r: " + radius + ",  \u03C6" + ": " + angle + " \u00BA]");
	}

	@Override
	public boolean equals(Object obj) {
		if(this == obj){
			return true;
		}
		if(obj == null){
			return false;
		}
		if(getClass() != obj.getClass()){
			return false;
		}
		if(!(obj instanceof Polar)){
			return false;
		}
		Polar t2 = (Polar)obj;
		return (radius == t2.getRadius()) && (angle == t2.getAngle());
	}

	@Override
	public int hashCode() {
		return 17 * Double.valueOf(radius).hashCode() + 19
				* Double.valueOf(angle).hashCode();
	}

	public double getRadius() {
		return radius;
	}

	public void setRadius(double radius) {
		this.radius = radius;
	}

	public double getAngle() {
		return angle;
	}

	public void setAngle(double angle) {
		this.angle = angle;
	}

	public void mult(double d) {
		radius *= d;
	}
}
