package math.functions;

import math.axes.Ax;
import math.axes.PShape;

import javax.swing.*;
import java.awt.*;

class Funct16 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Funct16(new AxPanel16()));
    }

    Funct16(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class AxPanel16 extends JPanel {
    private static final long serialVersionUID = 5218506428064759030L;
    private static final int w = 860;
    private static final int h = 860;
    private static final int offset = 40;

    public AxPanel16() {
        setPreferredSize(new Dimension(w, h));
        setSize(w, h);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        //--
        //g2.drawRect(0 + offset, 0 + offset, 360, 360);
        Ax diag1 = new Ax(0, 0, 280, 280, -2, -4, 14, 40, g2, 2, 2, offset);
        diag1.drawGrid(Color.LIGHT_GRAY);
        diag1.drawAx(Color.BLACK, Color.BLACK);
        diag1.drawTitle("Wykres funkcji: y=3x+2 ");
        for (float i = -1; i < 10.0; i = i + 0.01f) {
            diag1.drawPoint(i, 3f * i + 2f, 1, PShape.Circle, Color.BLUE);
            //System.out.println(i + " " + 3 * i + 2);
        }
        diag1.drawXLegend(true);
        diag1.drawYLegend(true);
    }
}