package math.functions;

import math.axes.Ax;
import math.axes.PShape;

import javax.swing.*;
import java.awt.*;

class Funct12 extends JFrame {
    private static final long serialVersionUID = 431281611636634328L;
    public static final int fw = 1000;
    public static final int fh = 1000;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(() -> new Funct12(new AxPanel12()));
    }

    Funct12(JComponent comp) {
        setLayout(null);
        setPreferredSize(new Dimension(fw, fh));
        setBounds((Toolkit.getDefaultToolkit().getScreenSize().width / 2)
                        - (fw / 2),
                (Toolkit.getDefaultToolkit().getScreenSize().height / 2)
                        - (fh / 2), fw, fh);
        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        setTitle("Ramka Graficzna");
        setResizable(false);
        JPanel panel = (JPanel) comp;
        panel.setLocation((fw - panel.getWidth()) / 2,
                (fh - panel.getHeight()) / 2);
        add(panel);
        setVisible(true);
    }
}

class AxPanel12 extends JPanel {
    private static final long serialVersionUID = 5218506428064759030L;
    private static final int w = 860;
    private static final int h = 860;
    private static final int offset = 40;

    public AxPanel12() {
        setPreferredSize(new Dimension(w, h));
        setSize(w, h);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        //--
        g2.drawRect(0 + offset, 0 + offset, 380, 180);
        Ax diag1 = new Ax(0, 0, 380, 180, 0, 0, 20, 1, g2, 2, 1, offset);
        diag1.drawTitle("Wyrazy ciągu: n/(n+1)");
        diag1.drawGrid(Color.LIGHT_GRAY);
        diag1.drawAx(Color.BLACK, Color.BLACK);
        for (float i = 0f; i < 21f; i = i + 1) {
            diag1.fillPoint(i, i / (i + 1), 6, PShape.Circle, Color.GREEN);
        }
        diag1.drawXLegend(true);
        diag1.drawYLegend(true);
    }
}