package math.axes;

import javax.swing.*;
import java.awt.*;

public class AxPanel extends JPanel {
    private static final long serialVersionUID = 5218506428064759030L;
    private static final int w = 860;
    private static final int h = 860;
    private static final int offset = 40;

    public AxPanel() {
        setPreferredSize(new Dimension(w, h));
        setSize(w, h);
        setBackground(Color.WHITE);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D) g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
                RenderingHints.VALUE_ANTIALIAS_ON);
        //--
        //g2.drawRect(0 + offset, 0 + offset, 360, 360);
        Ax diag1 = new Ax(0, 0, 360, 360, 0, 0, 100, 10000, g2, 20, 1000, offset);
        diag1.drawGrid(Color.LIGHT_GRAY);
        diag1.drawAx(Color.BLACK, Color.BLACK);
        diag1.drawTitle("Bardzo ważny wykres 1");
        for (float i = 0; i < 100; i = i + 0.1f) {
            diag1.fillPoint(i, i * i, 1, PShape.Circle, Color.BLUE);
        }
        diag1.drawXLegend(true);
        diag1.drawYLegend(true);
        //--
        //g2.drawRect(420 + offset, 0 + offset, 360, 360);
        Ax diag2 = new Ax(420, 0, 360, 360, -20, -20, 100, 100, g2, 20, 20, offset);
        diag2.drawGrid(Color.LIGHT_GRAY);
        diag2.drawAx(Color.BLACK, Color.BLACK);
        diag2.drawTitle("Bardzo ważny wykres 2");
        for (int i = -20; i < 81; i++) {
            diag2.fillPoint(i, i, 2, PShape.Square, Color.GREEN);
        }
        diag2.drawXLegend(true);
        diag2.drawYLegend(true);
        //--
        //g2.drawRect(0 + offset, 420 + offset, 360, 360);
        Ax diag3 = new Ax(0, 420, 360, 360, -80, -80, 100, 100, g2, 20, 20, offset);
        diag3.drawGrid(Color.LIGHT_GRAY);
        diag3.drawAx(Color.BLACK, Color.BLACK);
        diag3.drawTitle("Bardzo ważny wykres 3");
        for (int i = -80; i < 20; i++) {
            diag3.fillPoint(i, i, 2, PShape.Cross, Color.CYAN);
        }
        diag3.drawXLegend(true);
        diag3.drawYLegend(true);
        //--
        //g2.drawRect(420 + offset, 420 + offset, 360, 360);
        Ax diag4 = new Ax(420, 420, 360, 360, -120, -120, 100, 100, g2, 20, 10,
                offset);
        diag4.drawGrid(Color.LIGHT_GRAY);
        diag4.drawAx(Color.BLACK, Color.BLACK);
        diag4.drawTitle("Bardzo ważny wykres 4");
        for (int i = -120; i < -21; i++) {
            diag4.fillPoint(i, i, 2, PShape.Circle, Color.BLUE);
        }
        diag4.drawXLegend(true);
        diag4.drawYLegend(true);
    }
}