<?php
/**
* Xaneon Alias Manager 1.0 for Mambo 4.5.1
* @package Alias_Manager_1.0
* @version 1.0.3a
* @copyright (c) 2004 Xaneon Development (dev.xaneon.com)
* @license GNU/GPL
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/**
* This file was originally based on the sef.php included with Mambo 4.5.1a,
* but has been substantially refactored and rewritten since then.
*/

function sefDoAliasRequest( $uri, &$config ) {
  global $REQUEST_URI;

  if ($config->base_url != '') {
    if (substr( $uri, 0, strlen( $config->base_url ) ) == $config->base_url) {
      $uri = substr( $uri, strlen( $config->base_url ) );
    }
  }

  $overrides = array();
  $resolved = false;

  if (($row = mosAliasMapper::resolveTarget( $uri, $config ))) {
    if (strpos( $row->target, "://") !== false) {
      // External address; clean up output buffers and send an HTTP redirect.
      while (@ob_end_clean());
      die( mosRedirect( $row->target ) );
    }

    // If the URL is not the Mambo root URL (/), change request info
    // according to the target. We refuse to map the root URL on incoming
    // requests because doing that interferes with Mambo's normal operation
    // in cases when the user has mapped the root to a certain kind of
    // target (e.g. if '/' is mapped to com_frontpage, login won't work)
    $resolved = true;
    if ($uri != '/') {
      $uri = $row->target;
      $_SERVER["REQUEST_URI"] = $REQUEST_URI = $config->base_url . $uri;
    }

    if (strlen( $row->language ) > 0) {
      sefLoadAliasFile( "alias.langs.php" );
      $lang = sefGetLangName( $row->language );
      $locale = sefGetLocale( $row->language, $lang );
      if (!is_null( $lang )) {
        $overrides["mosConfig_lang"] = $lang;
        $overrides["mosConfig_locale"] = $locale;
      }
    }

  } // resolveTarget
  else if (strpos( substr( $uri, 1), '/' ) !== false) {

    global $mosConfig_absolute_path;
    $component = explode('/', substr( $uri, 1), 2);
    if ($component[0] != "content") {
      $component_path = "$mosConfig_absolute_path/components/com_" . $component[0];
      if (file_exists( $component_path )) {
        $resolved = true;
        $uri = "/component/option,com_" . substr($uri, 1);
        $_SERVER["REQUEST_URI"] = $REQUEST_URI = $config->base_url . $uri;
      }
    }

  }

  // Check if the alias has been mapped onto a non-SEF Mambo URL, in which
  // case we must now manually set its URL parameters into the relevant
  // PHP global request arrays. Otherwise, while the alias record will cause
  // URLs to be properly rewritten on the way out, the incoming request
  // won't work as expected.
  if ($resolved && (strpos( $uri, "/index.php?" ) === 0
      || strpos( $uri, "/index2.php?" ) === 0)) {
    // Comment out the following line if you need URL targets written as
    // XHTML (i.e. using &amp; instead of just &) to work.
    //$uri = str_replace( "&amp;", '&', $uri );
    $params = split( "\?", $uri );
    $params = split( "&", $params[1] );
    foreach ($params as $param) {
      list($key, $value) = explode( "=", $param, 2);
      $_GET[$key] = $_REQUEST[$key] = $value;
    }
  }

  // If URL validation is on, generate a 404 error for invalid requests.
  if (!$resolved && $uri != '/' && is_numeric( $config->validate_urls )) {
    $validation_level = @intval( $config->validate_urls );

    switch ($validation_level) {
      case 1:
        // Check whether it is either a non-SEF or SEF standard Mambo URL
        // (index.php?option=... or /content/... or /component/...)
        if (strpos( $uri, "/content" ) === 0 
            || strpos( $uri, "/component" ) === 0
            || strpos( $uri, "/index.php" ) === 0
            || strpos( $uri, "/index2.php" ) === 0) {
          break;
        }
        // Fall through to next case statement
      case 3:
        global $mosConfig_live_site;
        $url = ($config->err404_page != '' ? $config->err404_page : '/');
        if (strpos( $url, "://") === false) {
          $url = $mosConfig_live_site . $url;
        }
        // Prevent infinite recursion; trust that the URL the user entered as
        // the error page is indeed valid and that Mambo will accept it.
        if ($url != $mosConfig_live_site . $uri) {
          while (@ob_end_clean());
          die( mosRedirect( $url ) );
          break;
        }
      default:
        $resolved = true;
    }
  }

  return count( $overrides ) > 0 ? $overrides : null;
}

function sefDoContentRequest( &$uri, &$url_array ) {
  global $REQUEST_URI, $QUERY_STRING;

  /**
  * Content
  * http://www.domain.com/$option/$task/$sectionid/$id/$Itemid/$limit/$limitstart
  */

  $uri = explode("content/", $uri);
  $option = "com_content";
  $_REQUEST['option'] = $_GET['option'] = $option;
  $pos = array_search ("content", $url_array);

  // $option/$task/$sectionid/$id/$Itemid/$limit/$limitstart
  if (isset($url_array[$pos+6]) && $url_array[$pos+6]!="") {
    $task = $url_array[$pos+1];
    $sectionid = $url_array[$pos+2];
    $id = $url_array[$pos+3];
    $Itemid = $url_array[$pos+4];
    $limit = $url_array[$pos+5];
    $limitstart = $url_array[$pos+6];
    $QUERY_STRING = "option=com_content&task=$task&sectionid=$sectionid&id=$id&Itemid=$Itemid&limit=$limit&limitstart=$limitstart";
    // $option/$task/$id/$Itemid/$limit/$limitstart
  }
  else if (isset($url_array[$pos+5]) && $url_array[$pos+5]!="") {
    $task = $url_array[$pos+1];
    $id = $url_array[$pos+2];
    $Itemid = $url_array[$pos+3];
    $limit = $url_array[$pos+4];
    $limitstart = $url_array[$pos+5];
    $QUERY_STRING = "option=com_content&task=$task&id=$id&Itemid=$Itemid&limit=$limit&limitstart=$limitstart";
    // $option/$task/$sectionid/$id/$Itemid
  }
  else if (!(isset($url_array[$pos+5]) && $url_array[$pos+5]!="") && isset($url_array[$pos+4]) && $url_array[$pos+4]!="") {
    $task = $url_array[$pos+1];
    $sectionid = $url_array[$pos+2];
    $id = $url_array[$pos+3];
    $Itemid = $url_array[$pos+4];
    $QUERY_STRING = "option=com_content&task=$task&sectionid=$sectionid&id=$id&Itemid=$Itemid";
    // $option/$task/$id/$Itemid
  }
  else if (!(isset($url_array[$pos+4]) && $url_array[$pos+4]!="") && (isset($url_array[$pos+3]) && $url_array[$pos+3]!="")) {
    $task = $url_array[$pos+1];
    $id = $url_array[$pos+2];
    $Itemid = $url_array[$pos+3];
    $QUERY_STRING = "option=com_content&task=$task&id=$id&Itemid=$Itemid";
    // $option/$task/$id
  }
  else if (!(isset($url_array[$pos+3]) && $url_array[$pos+3]!="") && (isset($url_array[$pos+2]) && $url_array[$pos+2]!="")) {
    $task = $url_array[$pos+1];
    $id = $url_array[$pos+2];
    $QUERY_STRING = "option=com_content&task=$task&id=$id";
    // $option/$task
  }
  else if (!(isset($url_array[$pos+2]) && $url_array[$pos+2]!="") && (isset($url_array[$pos+1]) && $url_array[$pos+1]!="")) {
    $task = $url_array[$pos+1];
    $QUERY_STRING = "option=com_content&task=$task";
  }

  $params = array("task", "sectionid", "id", "Itemid", "limit", "limitstart");
  foreach ($params as $param) {
    if (isset($$param)) {
      $_GET[$param] = $_REQUEST[$param] = $$param;
    }
  }

  $_SERVER["QUERY_STRING"] = $QUERY_STRING;
  $_SERVER["REQUEST_URI"] = $REQUEST_URI = $uri[0]."index.php?".$QUERY_STRING;
}

function sefDoComponentRequest( &$uri, &$url_array ) {
  global $REQUEST_URI, $QUERY_STRING;

  /*
    Components
    http://www.domain.com/component/$name,$value
  */

  $uri = explode( "component/", $uri );
  $uri_array = explode("/", $uri[1]);
  $QUERY_STRING = "";

  foreach($uri_array as $value) {
    $temp = explode(",", $value);
    if (isset($temp[0]) && $temp[0]!="" && isset($temp[1]) && $temp[1]!="") {
      $_GET[$temp[0]] = $_REQUEST[$temp[0]] = $temp[1];
      $QUERY_STRING .= $temp[0]=="option" ? "$temp[0]=$temp[1]" : "&$temp[0]=$temp[1]";
    }
  }

  $_SERVER["QUERY_STRING"] = $QUERY_STRING;
  $_SERVER["REQUEST_URI"] = $REQUEST_URI = $uri[0]."index.php?".$QUERY_STRING;
}

function sefRelToAbsAlias( $string, &$config ) {
  if (($uri = mosAliasMapper::resolveAlias( $string ))) {
    $string = $uri;
  }

  if ($config->auto_short_components == '1'
      && eregi( "/component/option,com_", $string )) {
    $string = str_replace( "/component/option,com_", "/", $string );
  }

  if ($config->absolute_urls == '1') {
    global $mosConfig_live_site;
    $string = $mosConfig_live_site . $string;
  }
  else if ($config->base_url != '') {
    $string = $config->base_url . $string;
  }

  return $string;
}

function sefRelToAbsMamboContent( $string, $shorten = false ) {
  /*
    Content
    index.php?option=com_content&task=$task&sectionid=$sectionid&id=$id&Itemid=$Itemid&limit=$limit&limitstart=$limitstart
  */
  $sefstr = "content/";
  if (eregi( "&task=", $string )) {
    $temp = split( "&task=", $string );
    $temp = split( "&", $temp[1] );
    $sefstr .= $temp[0] . '/';
  }
  if (eregi( "&sectionid=", $string )) {
    $temp = split( "&sectionid=", $string );
    $temp = split( "&", $temp[1] );
    $sefstr .= $temp[0] . '/';
  }
  if (eregi( "&id=", $string) ) {
    $temp = split( "&id=", $string );
    $temp = split( "&", $temp[1] );
    $sefstr .= $temp[0] . '/';
  }
  if (eregi( "&Itemid=", $string )) {
    $temp = split( "&Itemid=", $string );
    $temp = split( "&", $temp[1] );
    $sefstr .= $temp[0] . '/';
  }
  if (eregi( "&limit=", $string )) {
    $temp = split( "&limit=", $string );
    $temp = split( "&", $temp[1] );
    $sefstr .= $temp[0] . '/';
  }
  if (eregi( "&limitstart=", $string )) {
    $temp = split( "&limitstart=", $string );
    $temp = split( "&", $temp[1] );
    $sefstr .= $temp[0] . '/';
  }
  return $sefstr;
}

function sefRelToAbsMamboComponent( $string, $shorten = false ) {
  /*
    Components
    index.php?option=com_xxxx&...
  */
  $sefstr1 = "component/";
  $sefstr2 = "";

  $temp = split( "\?", $string );
  $temp = split( "&", $temp[1] );
  foreach ($temp as $key => $value) {
    if ($shorten) {
      $opt = explode("=com_", $value, 2);
      if ($opt[0] == "option") {
        $sefstr1 = $opt[1] . "/";
      }
      else {
        $sefstr2 .= "$value/";
      }
    }
    else {
      $sefstr2 .= "$value/";
    }
  }

  return $sefstr1 . str_replace( '=', ',', $sefstr2 );
}

function sefRelToAbsMambo( $string, $shorten = false ) {

  if (!eregi( "^(([^:/?#]+):)", $string ) && !strcasecmp( substr( $string, 0, 9 ), "index.php" )) {
    // Replace all & with &amp;
    //$string = str_replace( "&amp;", '&', $string );
    //$string = str_replace( '&', '&amp;', $string );

    // Home index.php
    if ($string == "index.php") $string = "";

    if ( (eregi("option=com_content", $string) || eregi("option=content", $string) )
        && !eregi("task=new", $string) && !eregi("task=edit", $string) ) {
      $string = sefRelToAbsMamboContent( $string, $shorten );
    }
    else if (eregi("option=com_", $string) && !eregi("option=com_registration", $string)
        && !eregi("task=new", $string) && !eregi("task=edit", $string)) {
      $string = sefRelToAbsMamboComponent( $string, $shorten );
    }
    $string = "/$string";
  }

  return $string;
}

class mosAliasMapper {
  function getDatabase() {
    global $mosConfig_host, $mosConfig_user, $mosConfig_password;
    global $mosConfig_db, $mosConfig_dbprefix;
    global $database;
    if (!is_object( $database )) {
      $database = new database(
        $mosConfig_host, $mosConfig_user, $mosConfig_password,
        $mosConfig_db, $mosConfig_dbprefix );
    }
    return $database;
  }

  function resolveTarget( $alias, &$config, $recurse = true ) {
    if (!is_string( $alias ) || is_null( $alias )) return $alias;
    $db = mosAliasMapper::getDatabase();
    $alias = $db->getEscaped( $alias );
    $query = "SELECT target, language FROM #__alias WHERE url = '$alias' AND published = '1'";
    $db->setQuery( $query );
    $row = null;
    $db->loadObject( $row );

    if ($recurse && is_null( $row )) { // Not found, and recursion specified

      $last_char = $alias[strlen( $alias ) - 1];
      if ($config->auto_trailing_slashes == '1' && $last_char != '/'
        && strpos( $alias, "." ) === false) { // Doesn't contain dot
        // Apache-style 'directory' handling
        $alias .= '/';
        $row = mosAliasMapper::resolveTarget( $alias, $config, false );
      }
      else if ($config->auto_index_pages == '1' && $last_char == '/') {
        // Look for index.html or index.php if directory index not found
        $alias .= "index.html";
        $row = mosAliasMapper::resolveTarget( $alias, $config, false );
      }

      if (!is_null( $row )) { // If found
        $row->target = $alias;

        // We can only do an external redirect in case this is a GET request;
        // otherwise all (possibly) included POST data would get lost, which
        // would affect the workings of Mambo's login/logout, for example.
        if ($_SERVER["REQUEST_METHOD"] == "GET") {
          // Force external HTTP redirect to the right address
          global $mosConfig_live_site;
          $row->target = $mosConfig_live_site . $row->target;
        }
      }
    }

    return $row;
  }

  function resolveAlias( $target ) {
    $db = mosAliasMapper::getDatabase();
    $target = $db->getEscaped( $target );
    $query = "SELECT url FROM #__alias WHERE target = '$target' AND published = '1'";
    $db->setQuery( $query );
    $alias = $db->loadResult();
    return $alias;
  }
}

?>