<?php
// $Id: mosforms.php,v 1.12 2005/06/18 13:33:40 rob_clayburn Exp $
/**
 * All rights reserved Mambo Open Source is Free Software Released under GNU/GPL
 * License: http://www.gnu.org/copyleft/gpl.html
 * 
 * @package  MosForms
 * @Copyright (C) Rob Clayburn
 * @version $Revision: 1.12 $
 */
 
 // TODO : mosforms : 0.5 : module to display summary of data, filtered by name/date etc

// MOS Intruder Alerts
defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

session_start();

global $Itemid, $database, $mainframe;

require_once("components/$option/mosform_parent.class.php");

require_once($mainframe->getPath('front_html'));

require_once($mainframe->getPath('class'));

require_once("components/$option/mosform_functions.php");

require_once("components/$option/mosform_connection.class.php");

if(file_exists( "administrator/components/$option/language/$mosConfig_lang.php")){

	require_once "administrator/components/$option/language/$mosConfig_lang.php";

}else{
	
	require_once "administrator/components/$option/language/english.php";
	
}
	

$params = new stdClass();

if ( $Itemid ) {
	
	$menu = new mosMenu( $database );
	
	$menu->load( $Itemid );
	
	$params =& new mosParameters( $menu->params );
	
} else {
	
	$menu = "";
	
	$params =& new mosParameters( '' );
	
}

$act 		= $params->get( 'act', '');

$form_id 	= $params->get( 'mosform', '0' );

$tableId 	= $params->get( 'tableid', '');
			
$rowId 		= mosGetParam( $_REQUEST, 'rowid', '');

$tableId 	= mosGetParam( $_REQUEST, 'tableid', $tableId); //overwrites itemid value if set in querystring or post data

$form_id 	= mosGetParam($_REQUEST, 'mosform', $form_id);	//overwrites itemid value if set in querystring or post data

$act 		= mosGetParam($_REQUEST, 'act', $act);			//overwrites act value if set in querystring or post data

$orderBy 	= mosGetParam( $_REQUEST, 'orderby', '');

$orderDir 	= mosGetParam( $_REQUEST, 'orderdir', 'asc');



updateOrderSession($orderBy, $orderDir);

if(!isset($_SESSION['aOrder'])){
	
	$_SESSION['aOrder'] = array();

}

if($orderBy != ''){
	
	$_SESSION['aOrder'][$orderBy] = $orderDir;
	
}


if (!isset ($act)) {
	
	$act = "";
	
} 

switch ($act) {
	
	case "delete": // deletes rows from the mosform table

		$aIds = mosGetParam($_POST, 'ids', array());
		
		deleteTableRows($option, $aIds, $tableId);
		
		break;
	
	case "filter": // filters the mosform table results
	
		writeTable($tableId, $option, $orderBy, $_SESSION['aOrder']);
		
		break;
		
	case "processform":
		
		processForm( $option, $form_id, $tableId, $rowId );

		break;
		
	case "viewtable":
	
		writeTable($tableId, $option, $orderBy, $_SESSION['aOrder']);
		
		break;
		
	case "viewform":
		
		makeForm($tableId, $option, $form_id, $rowId, true);

		break;
		
	case "viewtablerowdetails":
		
		makeForm($tableId, $option, $form_id, $rowId, '0');
		
		break;
		
	default:
		
		//TODO : mosforms : 0.5 : pattemplate display for  form 
		
		makeForm($tableId, $option, $form_id, $rowId, '1');

		break;
}

/**
 * creates a form object to process the forms data
 * @param string component name
 * @param int form id
 * @param int table id
 * @param int row id
 */

function processForm($option, $formId, $tableId, $rowId){
		
	global $database;
	
	$oForm = new mosForms( $database );
		
	$oForm->load($formId);
	
	$oForm->setAdmin(false);
	
	$oForm->processForm($_POST, $tableId, $rowId, $option, '' );
}

/**
 * collates data to write out the form
 * @param int table id
 * @param string component name
 * @param int form id
 * @param int table row id
 * @param bol if the form is not editable then display a viewonly datasheet 
 */
function makeForm($tableId = '', $option, $formId, $rowId, $editable){

	global $database;
	
	$arErrors = array();

	if($tableId != ''){
		
		$oTable = loadTable($tableId, $option);	
		
		$oConn = new mosForm_Connection( $database );
	
		$ok = $oConn->load($oTable->connection_id);	
	
		$mosformDb = $oConn->loadTableConnectionDB();
		echo "<!--";print_r($mosformDb);echo"-->";
		if(!$mosformDb){
			echo "could not connect to database";
			//exit();
		}
			
		$table = $oTable->db_table_name;
		
		$key = $oTable->db_primary_key;
		
		$sql = "select * from $table";
		
		if($rowId != ''){
		
			$sql .= " where $key = '$rowId'";
				
		}
		
		$mosformDb->setQuery($sql);
	
		$elementData = $mosformDb->loadObjectList();
		
		if($rowId != ''){
			
			$formDefaultData = mosObjectToArray($elementData[0]);
			
		}else{
			
			$formDefaultData = $_REQUEST;
			
		}
		
	}else{
			
		$formDefaultData = $_REQUEST;
		
	}
	
	$formDefaultData2 = array();
	
	foreach($formDefaultData as $key=>$val){

		$Newkey = preg_replace("/[^A-Za-z0-9]/", "_", $key); // replace all non alphanumeric characters with _
		
		$formDefaultData2[$Newkey] = $val;
		
	}
	
	writeForm($formId, $arErrors, $formDefaultData2, '', $tableId, $rowId, $editable);		
}

/**
 * deletes rows for the given table info
 * @param string component name
 * @param array ids to delete
 * @param int table id
 */
 
function deleteTableRows($option, $aIds, $tableId){
	
	global $Itemid, $database;
	
	$oTable = loadTable($tableId, $option);
	
	$oConn = new mosForm_Connection( $database );
	
	$oConn->load( $oTable->connection_id );
	
	$mosformDb = $oConn->loadTableConnectionDB( );
	
	$primaryKey = $oTable->db_primary_key;
	
	$table = $oTable->db_table_name;
	
	foreach($aIds as $id){
		
		$mosformDb->setQuery("delete from $table where $primaryKey = '$id'");
		
		if (!$mosformDb->query()) {
		
			$msg = $mosformDb->getErrorMsg() . "\n";
		
		} 
		
		//echo $msg;
		
	}
	
	mosRedirect( "index.php?option=$option&Itemid=$Itemid", $msg );
}

/** takes a table id and returns a table object
 * @param int table id
 * @param string component name
 * @return object table
 */
 
function loadTable($tableId, $option){
	
	global $database;
	
	require_once("components/$option/mosform_table.class.php");	
	
	$oTable = new mosForm_Table( $database );

	$oTable->load($tableId);	
	
	return $oTable;
		
}


/** 
 * write out the table view
 * @param int table id
 * @param string component name
 * @param string column to order results by
 * @param array contains ordering state - array(column=>direction)
 */
 
function writeTable($tableId, $option, $orderBy, $aOrder){
	
	//TODO : mosforms : 0.4 : when you change the display number and then reorder the rows the display number reverts back to the table default - look at the mainframe->userstate code that filters the elements for eg on how to do this
	 
	global $database, $mainframe;
		
	$oTable = loadTable($tableId, $option);	
	
	if($oTable->canPublish()){
		
		$oConn = new mosForm_Connection( $database );

		$ok = $oConn->load($oTable->connection_id);	
		
		$aTable = mosObjectToArray($oTable);
		
		$mosformDb = $oConn->loadTableConnectionDB();
				
		$table = $oTable->db_table_name;
	
		$totalSql = "select count(*) from $table";
		
		$aData = $_REQUEST; //QUERY: this was POST data only - will doing this mess stuff up!?
		
		$aData['limitstart'] = mosGetParam($_REQUEST, 'limitstart', 0);
		
		$aData['pagelimit'] = mosGetParam($_REQUEST, 'pagelimit', $oTable->rows_per_page);
		
		$aOrder = 	$_SESSION['aOrder'];
	
		$lists = array();
		
		if($oTable->id == '0'){
			
			echo "No table found for this id";
			
			exit;
		}
		
		$aDataToIgnore = array("ids", "option", "act", "tableid", "Itemid" , "limitstart", "pagelimit", "limit", "orderdir", "orderby", "sessioncookie", "mosadmin", "webfxtab_configPane", "webfxtab_content-pane", "PHPSESSID");
		
		$i = 0;

		foreach($aData as $key=>$val){
			
			if (!in_array($key, $aDataToIgnore)) {
				
				if(is_array($val)){
						
					$filterType = $val['type'];
					
					$filterVal = $val['value'];
					
					$filterExactMatch = $val['match']; 
				
					$aFilter[$key] = $val;
					
					if($filterVal != ""){
						
						if($filterType == 'field'){
							
							$cond = " $key like '%$filterVal%' ";
							
						}else{
							
							if($filterExactMatch == '0'){
								
								$cond = " $key like '%$filterVal%' ";
								
							}else{
							
								$cond = " $key = '$filterVal' ";
								
							}
							
						}
						
						if($i==0){
							
							$totalSql .= " where $cond"; //build the total sql query including the filters
							
						}else{
							
							$totalSql .= " and $cond" ;
							
						}
						
						$i ++;	
					}	
				}			
			}
		}
		//	echo $totalSql;
		$aNewDbInfo = switchDatabase($oTable, $option, $oConn);
		
		$mosformDb = $aNewDbInfo[0];
	
		$table = $aNewDbInfo[1];
		
		if(isset($aData['pagelimit'])){
			
			$limitLength = $aData['pagelimit'];
			
		}else{
	
			$limitLength = $oTable->rows_per_page;
		}
			
		if(isset($aData['limitstart'])){
			
			$limitStart = $aData['limitstart'];
			
		}else{
	
			$limitStart = 0;
		}		
		
		$oForm = new mosForms( $database );
	
		$oForm->load($oTable->form_id);
	echo"<!--";print_r($aFilter);echo"-->";	
		$elementData = $oTable->getElementData($mosformDb, $orderBy, $aOrder, $aFilter, $limitLength, $limitStart);
		
		$formGroupEls = $oForm->getFormGroups($oTable->form_id, true);
		
		$elementData = getForiegnKeys($elementData, $formGroupEls);
	
		$oTable->hit();
		
		$oFilters =  $oTable->getTableFilters($formGroupEls);
		
		$lists['filters'] = $oTable->makeFilters( $oFilters, $mosformDb, $table );
	
		$mosformDb->setQuery($totalSql);
		 
		$total  = $mosformDb->loadResult();
		
		$pageNav = pageNav( $total, $limitLength, $limitStart);
		
		//set the page title 
		
		$mainframe->setPageTitle( $oTable->label );
		
		mosform_html_content::writeTable( $oTable, $formGroupEls, $elementData, $option, $aOrder, $lists, $limitStart, $pageNav, $limitLength );
	
	}else{
		
		echo "Sorry this table is unpublished";
		
	}
	
 }
  
/**
* parses the form elements to create a list of drop downs for the form
* @param object origional element data
* @param object form elements
*/

function getForeginKeyDropDowns( $elementData, $formGroupEls ){
	
   	global $database;

	 $lists  = array();
	
  	foreach($formGroupEls as $el){ // go through all the elements checking for joins

		$joinConnId = $el->join_conn_id;
		
  		if($joinConnId != "0" and $joinConnId != ""){ // a join connection has been set up
 			//require_once("components/$option/mosform_parent.class.php");
  			$cn = new mosForm_Connection( $database );
  			
  			$cn->load($joinConnId);
  		
  			if (@ mysql_connect($cn->host, $cn->user, $cn->password)) {

				$joinDb = new database($cn->host, $cn->user, $cn->password, $cn->database, "");
	
				$table 	= $el->join_db_name;
				$key	= $el->join_key_column;
				$val	= $el->join_val_column;
				$col	= $el->element_name;
	
				// reapeat through all the origional data to swap the foregin key with its text equivalent
				
//				for($i=0; $i<count($elementData); $i++ ){
//					
//					
//					
//					$data = $elementData[$i];
//	
//					$DataVal = $data->$col;
//					
//				}

				$tmp = array();
					
				$sql = "select $key as value, $val as text from $table ";

				$joinDb->setQuery($sql);
				
				$tmp[] = mosHTML :: makeOption('-1' , _PLEASE_SELECT);

				$tmp = array_merge($tmp, $joinDb->loadObjectList());

				$dropdown = mosHTML :: selectList($tmp, $el->element_name, 'class="inputbox" size="1" ', 'value', 'text', $elementData[$el->element_name]);
				
				$lists[$el->element_name]['dropdown'] = $dropdown;
					
				$sql = "select $val from $table where $key = '" . $elementData[$el->element_name] . "'";
				
				$joinDb->setQuery($sql);
				
				$default = $joinDb->loadResult();
				
				$lists[$el->element_name]['default'] = $default;
			
  			}else{
  				
  				$lists[$el->element_name]['dropdown'] = "Could not make join";
  				
  				$lists[$el->element_name]['default'] = "Could not make join";
  			}
	
  		}
  			
  	}
  	return $lists;	
}
  
/** collate all the form's data and call the html to display it
 * @param int form id
 * @param array error messages
 * @param array default vaules for elements
 * @param string error message
 * @param int table id
 * @param int table row id
 */
 
function writeForm($formId, $arErrors, $data, $form_err_message, $tableId, $rowId, $editable = '0')
{	
	global $database, $mainframe;
	
	$oForm = new mosForms( $database );
	
	$oForm->load($formId);

	$groupElements = $oForm->getFormGroups( 0 );

	foreach($groupElements as $el){
		
		if($el->use_in_page_title == '1'){

			$title .= $data[$el->element_name];		
		}
	
	}

	$enctype = $oForm->getFormEncType();

	$lists = $oForm->getForeginKeyDropDowns( $data, $groups );
	
	//set the page title
	
	$mainframe->setPageTitle( $oForm->form_title . " - " . $title );
	
	if($editable){
		
		mosform_html_content::displayForm($oForm, $groupElements, $formId, $arErrors, $data, $form_err_message, $enctype, $tableId, $rowId, $lists);
		
	}else{
		
		mosform_html_content::drawViewOnlyTemplate( $oForm, $groupElements, $data, $lists );
		
	}
		
} 

/**
 * sends a receipt message to the creator (or person specified by the creator)
 * @param array post data
 * @param object form object
 */
 
function SendReceipt($_POST, $row)
{
	
	global $database;
	
	$oForm = new mosForms( $database );
	
	$message = $oForm->parseMessageForPlaceHolder($row->receipt_message);
	
	$email_to = $row->email_to;

	$email_from = $row->email_from;

	$email = $_POST[$row->receipt_email];

	$subject = "receipt";

	mosMail($email_from, $email_from, $email , $subject, $message);
} 

function check_email_address($email)
{ 
	// echo("checking email address: $email");
	// First, we check that there's one symbol, and that the lengths are right
	if (!ereg("[^@]{1,64}@[^@]{1,255}", $email)) {
		// Email invalid because wrong number of characters in one section, or wrong number of symbols.
		return false;
	} 
	// Split it into sections to make life easier
	$email_array = explode("@", $email);

	$local_array = explode(".", $email_array[0]);

	for ($i = 0; $i < sizeof($local_array); $i++) {
		if (!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[0])) {
			return false;
		} 
	} 

	if (!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) { // Check if domain is IP. If not, it should be valid domain name
		$domain_array = explode(".", $email_array[1]);

		if (sizeof($domain_array) < 2) {
			return false; // Not enough parts to domain
		} 

		for ($i = 0; $i < sizeof($domain_array); $i++) {
			if (!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) {
				return false;
			} 
		} 
	} 

	return true;
} 

function isAlphaNumeric($data)
{
	if (ereg('[^A-Za-z0-9]', $data)) {
		return false;
	} else {
		return true;
	} 
} 


?>