<?php



class mosForms extends mosFormDBTable {

	/** @var int Primary key */
	var $id=null;

	/** @var string The the forms title*/
	var $form_title=null;

	/** @var bol determines if the form records posted data into a database table */
	var $record_in_database = 0;

	/** @var string */
	var $form_introtext=null;

	/** @var string */

	var $form_errmessage=null;

    var $created = null;

    var $created_by = null;

    var $created_by_alias = null;

    var $modified = null;

    var $modified_by = null;

    var $checked_out = null;

    var $checked_out_time = null;

	var $align = null;

	var $width = null;

	var $form_subject="";

	var $form_submit_message="";

	var $form_submit_jumppage=null;

	var $email_to=null;

	var $email_from=null;

	var $receipt_email=null;
	
	var $receipt_message=null;

	var $reset_button = 0;
	/** @var string */
	var $reset_button_label = null;
	/** @var string */
	var $submit_button_label = null;
	
	/**@var bol publish state of form  - not implemented in 0.4a!*/
	var $state = 0;
	
	/** @var int foreign key to table id*/
	var $table_id = null;
	
	/** @var string pattempalte to use when showing form */
	var $form_template   = null;
	
	/** @var string pattemplate to use when showing view only version of form */
	var $view_only_template = null;
	
	/* not used in database (need to be prefixed with "_")*/
	/** @var array form's group elements*/
	var $_elements = null;
	
	/** @var bol in admin (true) or front end (false)*/
	var $_admin = false;

	/** @var array list of reserved words that mosforms uses - elements can't have these names*/
	var $_reservedWords = array("act", "option", "form_id", "Submit", "ul_max_file_size", "ul_file_types", "ul_directory", "tableid", 'rowid', 'Itemid', 'mosform');
	
	/** @var array allowed file extensions*/
	var $_aDefaultFileTypes = array('.gif', '.jpg', '.png', '.bmp', '.doc', '.xls', 'ppt', '.swf', '.pdf', '.dcr');

	/**

	* @param database A database connector object

	*/

	function mosForms( &$db ) {

		$this->mosDBTable( '#__mosform_forms', 'id', $db );

	}

	/**  
	 * sets the instances admin state
	 * @param bol admin state
	 */
	 
	function setAdmin($bol){
		$this->_admin = $bol;
	}
	
	/**
	 * creates the necessary code to write out the form either in admin or in
	 * front end
	 * @return array of paramenters to pass to html.php code 
	 */
	 
	function getForm(){
		
	}

	/** 
	 * attempts to find the form's table id by parsign through table objects to
	 * see if they link to this form - bit of a hack shouldn't really be called
	 * at all
	 * @return int table id
	 */
	function findAndUpdateTableId(){
		
		global $database;
		
		$sql = "select id from #__mosform_tables where form_id = '$this->id'";
		
		$database->setQuery( $sql );
		
		$this->table_id = $database->loadResult();
		
		$this->store(true);
		
	}
	
	
	function getFormData($formId){
		
		global $database;
	
		$row = new mosForms( $database);
		
		$row->load($formId);
	
	
		if ($formId == '') {
			
			echo("Error getting form_id to send email!");
	
			exit;
		} 
	
	
		return $row;
	} 


/**
 * gets each element in the form along with its group info
 * @param int form id
 * @param boolean are we using a table view
 */
 
	function getFormGroups( $tableView = 'false' )
	{
		global $database, $my; 
		
		$sql = "SELECT * FROM #__mosform_formgroup
	
		LEFT JOIN #__mosform_groups 
	
		ON #__mosform_formgroup.group_id = #__mosform_groups.id
	
		LEFT JOIN #__mosform_elements  
	
		ON #__mosform_groups.id = #__mosform_elements.group_id 
	
		WHERE #__mosform_formgroup.form_id = '$this->id' " .
				
		" AND #__mosform_elements.state = '1' ";
		
		if($tableView){
			
			$sql .= " and show_in_table_summary = '1' ";
			
		}
	
		$sql .= "ORDER BY #__mosform_formgroup.ordering,  #__mosform_formgroup.group_id, #__mosform_elements.ordering";
	//echo str_replace("#_", "mos", $sql ) . "<br />";
		$database->setQuery($sql);
	
		$groups = $database->loadObjectList();
	
		echo $database->getErrorMsg();
	
		$this->_elements = $groups;
		
		return $groups;
	} 
	
	/**
	 * gets the form's groups
	 * @return array of group ids
	 */
	function getGroups(){
	
		global $database;
		
		$database->setQuery("select group_id from #__mosform_formgroups where form_id = '$this->id'");
		
		return $database->loadResultArray();
			
	}

	/** this checks to see if the form has a file upload element
	* and returns the correct
	* encoding type for the form
	* @param int form id 
	* @param object forms elements
	* @return string form encoding type
	*/
	
	function getFormEncType( )
	{
		foreach($this->_elements as $element) {
	
			if ($element->elementtype_id == '8') {
				
				return "multipart/form-data";
				
			} 
			
		} 
	
		return "application/x-www-form-urlencoded";
		//return "";
	} 


	/**
	* parses the form elements to create a list of drop downs for the form
	* @param object origional element data
	* @param object form elements
	*/
	
	function getForeginKeyDropDowns( $elementData, $option ){
		
	   	global $database, $option;
	
		 $lists  = array();
		
	  	foreach($this->_elements as $el){ // go through all the elements checking for joins
			
	  		if($el->elementtype_id == '12'){ // a join type has been created
	  		
	  			$joinConnId = $el->join_conn_id;
	  			
				if($this->_admin){
					
					require_once("../components/$option/mosform_parent.class.php");
				
				}else{
					
					require_once("components/$option/mosform_parent.class.php");
					
				}	  			
	 			
	  			$cn = new mosForm_Connection( $database );
	  			
	  			$cn->load($joinConnId);
	  		
	  			if ($cn->testConnection()) {
	
					$joinDb = new database($cn->host, $cn->user, $cn->password, $cn->database, "");
		
					$table 	= $el->join_db_name;
					
					$key	= $el->join_key_column;
					
					$val	= $el->join_val_column;
					
					$col	= $el->element_name;
		
					$tmp = array();
						
					$sql = "select distinct($key) as value, $val as text from $table order by $val asc ";
	//echo $sql;
					$joinDb->setQuery($sql);
					
					$tmp[] = mosHTML :: makeOption('-1' , _PLEASE_SELECT);
	
					$tmp = array_merge($tmp, $joinDb->loadObjectList());
					
					//convert text to html encoded text
					
					for($c = 0;$c<count($tmp);$c++){
						
						$tmp[$c]->text = htmlspecialchars($tmp[$c]->text);
						
					}
	
					$dropdown = mosHTML :: selectList($tmp, $el->element_name, 'class="inputbox" size="1" ', 'value', 'text', $elementData[$el->element_name]);
					
					$lists[$el->element_name]['dropdown'] = $dropdown;
						
					$sql = "select $val from $table where $key = '" . $elementData[$el->element_name] . "'";
					
					$joinDb->setQuery($sql);
					
					$default = $joinDb->loadResult();
					
					$lists[$el->element_name]['default'] = $default;
				
	  			}else{
	  				
	  				$lists[$el->element_name]['dropdown'] = "Could not make join";
	  				
	  				$lists[$el->element_name]['default'] = "Could not make join";
	  			}
		
	  		}
	  			
	  	}
	  	return $lists;	
	}



	/**
	 * processes the form data and decides what action to take
	 * @param array posted form data
	 * @param int table id
	 * @param int row id
	 * @param string component name
	 * @param int menu item id
	 * @param bol processing admin (true) or frontend form (true)
	 */
	 
	function processForm($aData, $tableId, $rowId, $option,$itemId){
	
		global $mosConfig_absolute_path, $Itemid, $mosConfig_live_site;
		
		if(!isset($this->_elements)){
			
			$elements = $this->getFormGroups( 0 );
			
		}else{
			
			$elements = $this->_elements;
			
		}
			
		$fileUploadFound = $this->CheckForFileUpload();

		$arErrors = $this->ValidateForm($aData, $fileUploadFound); 
		
		$row = $this->getFormData($this->id);

		$form_err_message = $row->form_errmessage;
		
		$moveError = false;
		
		if (count($arErrors) == 0) {

			if ($fileUploadFound) {

				foreach($_FILES as $key => $aFile){ //multiple file upload code
					
					$myFileName = $aFile['name'];
					
					if($myFileName != ''){
					
						$tmpFile = $aFile['tmp_name'];
						
						$myTargetFolder = $aData[$key]['ul_directory'];
		
						$uploadFolder = addEndSlash($mosConfig_absolute_path) . $myTargetFolder . '/';
						
						if(!is_dir($uploadFolder)){
							
							mkdir($uploadFolder);
							
						}
						
						$destFile = $uploadFolder . $myFileName;
	
						$fileIncrement = $aData[$key]['ul_file_increment'];
	
						if(file_exists($destFile) and $fileIncrement){
							
							$destFile = incrementFileName($destFile, $destFile, 1);
	
							//get the filename with out the path
							
							$newFileName = explode("/", $destFile);
							
							$newFileName = end($newFileName);
							
							//update the $_FILES data to contain the new file name
							
							$_FILES[$key]['name'] = $newFileName;
											
						}
						
						if (move_uploaded_file($tmpFile, $destFile) == false) {
							
							$arErrors['ul_userfile'][] = "The file upload was unsuccessful (from $tmpFile to $destFile), please try again";
	
							$moveError = true;
						} 
						
					}
					
				}
				
				if($moveError){
	
						writeForm($this->id, $arErrors, $aData, $form_err_message, $tableId, $rowId, '1');
	
						//break; - meredth says this gives her an error
						return;					
					
				}
			} 

			if ($row->record_in_database == '1') {

				
				if (!$this->DatabaseTableExists( )) {
					
					$this->CreateFormTable();
					
				} else {
					
					$this->AmmendTable();
					
				} 
				
				$err = $this->SubmitToDatabase($aData, $tableId, $rowId, $option, $elements);
				
			} 
			
			if ($err != ""){
				
				echo $err;
				
				exit;
				
			}
			
			if(!$this->_admin){
				
				if ($row->receipt_email != "") {
					
					SendReceipt($aData, $row);
					
				} 
				
			}

			if($row->email_to != ""){
				
				if(!$this->_admin){
					
					if ($this->sendEmail($aData, $row, $fileUploadFound, $elements)) {
						
						$row->form_submit_message = $this->parseMessageForPlaceHolder($row->form_submit_message);
		
						mosform_html_content::displayThanks($row->form_title, $row->form_submit_message);
						
					} else {
						
						//if($this->_admin){
						//	mosRedirect("index2.php?option=com_mosforms&act=tables&task=viewdatabase&cid=$tableId");
						//}else{
							mosRedirect("$row->form_submit_jumppage&Itemid=$Itemid"  );
						//}
						
					} 
					
				}
				
			}else{

				if($this->_admin){

					mosRedirect("index2.php?option=com_mosforms&act=tables&task=viewdatabase&cid=$tableId", "record added/updated");

				}else{
					
					//append the jump url with the posted variables 
					
					$jumpPage = $row->form_submit_jumppage;
					
					if($jumpPage == ''){
												
						mosform_html_content::displayThanks($row->form_title, $row->form_submit_message);
						
					}else{
					
						foreach($aData as $key=>$val){
							
							if(!strstr( $jumpPage, "$key=")){
								
								if($val != ''){
									
									if($val != '-1'){
											
										if (!in_array($key, $this->_reservedWords)) {
								
											if(!isset($val["ul_max_file_size"])){ // ignores fileupload data
											
												$jumpPage .= "&" . $key . "[value]=$val";
											
												$jumpPage .= "&	" . $key . "[type]='dropdown'";
												
											}
						
										}
								
									}
										
								}
								
							}
						
						}
						
						foreach ($_POST as $key => $value) {
								
							if (!in_array($key, $this->_reservedWords)) {
						
								$value = urlencode(stripslashes($value));
							
								$_SESSION["$key"] = $value;
								
							}
						}
						
						if(!strstr( $jumpPage, "&Itemid=")){ // if the jump url contains an item id we shouldnt add the forms item id to it
								
							$jumpPage .= "&Itemid=$Itemid";
			
						}

						mosRedirect( $jumpPage, 'record updated/added' );	
						
					}
							
				}
				
			}
			
		} else {
			
			writeForm($this->id, $arErrors, $aData, $form_err_message, $tableId, $rowId, '1');
			
		} 
	}
	
	/**
	 * sends emails to all people listed in the form's email to field
	 * @param array form data
	 * @param object form data
	 * @param bol if file uploads have been found
	 * @param object form element data
	 */
	 
	function sendEmail($data, $row, $fileUploadFound, $elements)
	{
		//TODO : mosforms : 0.5 : email templates
		global $my, $mosConfig_sitename, $database, $mosConfig_absolute_path, $mosConfig_live_site, $mosConfig_lang;
	
		//TODO: mosforms : 0.5 : determine if html emails are to be used in config
	
		if($this->_admin){
			
			include_once('	components/com_mosforms/language/' . $mosConfig_lang . '.php');
			
		}else{
			
			include_once('language/' . $mosConfig_lang . '.php');
		}
		 	
		$htmlEmail = 0;
		
		$cc = null;
		
		$bcc = null;
		
		$attachment = null;
		
		$email_to = $this->parseMessageForPlaceholder($row->email_to);
	
		$email_from = $this->parseMessageForPlaceholder($row->email_from);
	
		$arDontEmailThesKeys = $this->_reservedWords;
	
		//remove raw file upload data from the email 
		foreach($_FILES as $key => $file){
	
				$arDontEmailThesKeys[] = $key;
	
		}
		
		$message = "";
		
		foreach($data as $key => $val) {
			
			if (!in_array($key, $arDontEmailThesKeys)) {
				
				$key = str_replace("_"," ",$key );//replace underscores with spaces
				
				if (is_array($val)) {
					
					$message .= $key . ' : ' . implode(',', $val) . "\n";
					
				} else {
					
					$message .= $key . ' : ' . $val . "\n";
				} 
				
			} 
			
		} 

		
		if ($fileUploadFound) {
					
			foreach($_FILES as $key=>$val){
				
				if($_FILES[$key]['name'] != ''){
				
					$myTargetFolder = $data[$key]['ul_directory'];
					
					$attachment = addEndSlash($mosConfig_live_site) . $myTargetFolder . '/' . $_FILES[$key]['name'];
					
					$message .= "file uploaded : " . $attachment . "\n";
					
					if($data[$key]['ul_email_file']){
						
						$aAttachments[] = $attachment;
						
					}
					
				}	
				
			}
			
		} 
	
		$message = _EMAIL_FROM . $mosConfig_sitename . "\r \n \r \nMessage:\r \n" . stripslashes($message);
	
		if ($row->form_subject == "") {
			
			$subject = $mosConfig_sitename . " :: Mos Form Test";
			
		} else {
			
			$subject = $row->form_subject;
		} 
		
		// Send email
		$emails = explode(',', $email_to);
	
		foreach ($emails as $email) {
		
			mosMail($email_from, $email_from, $email , $subject, $message, $htmlEmail,$cc, $bcc, $aAttachments );
	
		} 
	
		if (isset($row->form_submit_jumppage) and $row->form_submit_jumppage != "") {
			
			return false;
			
		} else {
			
			return true;
			
		} 
	} 	

	/**
	 * saves the form data to the database 
	 * @param array data to save
	 * @param int table id - this is used to allow recording of the data back to the
	 * table rather than the generic form table
	 * @param int rowid - if 0 then insert a new row - otherwise update this row id
	 * @param string component name
	 * @param array the tables columns
	 * @return string error message
	 */
	 
	function SubmitToDatabase($data, $tableId = '', $rowId = '0', $option, $elements)
	{
		global $mosConfig_live_site, $database;
		
		if($this->_admin){
			
			require_once("../components/$option/mosform_connection.class.php");
			
			require_once("../components/$option/mosform_functions.php");
		
		}else{
			
			require_once("components/$option/mosform_connection.class.php");
			
			require_once("components/$option/mosform_functions.php");
			
		}	
		
		//check if there is table data that is not posted by the form (ie if no checkboxes were selected)
		
		foreach($elements as $element){
			
			if($element->elementtype_id == '3'){
				
				$elName = preg_replace("/[^A-Za-z0-9]/", "_", $element->element_name); // replace all non alphanumeric characters with _
				
				if( !array_key_exists( $elName, $data )){
					
					$data[$element->element_name] = $element->ck_value;
					
				}
				
			} 
				
		}

		if($tableId != ''){
			
			$oTable = $this->loadTable($tableId, $option);
	
			$table = $oTable->db_table_name;
			
			$oConn = new mosForm_Connection( $database );
			
			$ok = $oConn->load($oTable->connection_id);
			
			if(!$ok){
				
				echo "Can not load database connection tableid = $tableId <br>";
				
				exit();
			}	
						
			$mosformDb = $oConn->loadTableConnectionDB();
	
			$primaryKey = $oTable->db_primary_key;
	
		}else{
		
			$mosformDb = $database;
	
			$primaryKey = 'id';
			
			$table = $mosformDb->_table_prefix . "mosform_formdata_" . $this->id;//$oTable->form_id;
				
		}
		
		$fields = "(";

		$values = "(";
		
		$$updatePairs = "";

		foreach($data as $key => $val) { // contruct the sql statements with the data passed by the form
		
			if (!in_array($key, $this->_reservedWords) and substr($key, 0, 4) != "mce_") {
			
				$key = preg_replace("/[^A-Za-z0-9]/", "_", $key); // replace all non alphanumeric characters with _
				
				$fields .= "`$key`, ";
				
				if (is_array($val)) {
					
					if(isset($_FILES[$key])){ // if the array is from a file upload we need to add the file path and name to the database
						
						$values .=  "'" . $this->addEndSlash($mosConfig_live_site)   . $val['ul_directory'] . '/' .$_FILES[$key]['name'] . "', ";
							
					}else{
					
						$val = implode(',', $val);
						
						$values .= "'" . $val . "', ";

					}
					
				} else {
				
					$values .= "'$val', ";
					
				} 
				
				$updatePairs .= "`$key` = '$val', ";
				
			} 
			
		} 
		
		$fields = substr($fields, 0, strlen($fields)-2);
		
		$values = substr($values, 0, strlen($values)-2);
		
		$updatePairs = substr($updatePairs, 0, strlen($updatePairs)-2);
		
		$fields .= ")";
		
		$values .= ")";

		if($rowId == ''){

			$sql = "insert into $table $fields VALUES $values"; 
			
		}else{
			
			$sql = "update $table set $updatePairs where $primaryKey = '$rowId'"; 
		}

		$mosformDb->setQuery($sql);
		
		if (!$mosformDb->query()) {
		
			$msg = $mosformDb->getErrorMsg() . "\n";
			
			return  $msg;
		} 

		return "";
	
	
	} 

	/**
	 * adds an forward slash to end of string if one is not already there
	 *@param string to add end slash to 
	 */
	 
	 function addEndSlash($str){
	 	if(!endsWith( $str, "/" )){

	 		$str .= "/";

	 	}
	 	return $str;	
	 }
	 
	/** takes a table id and returns a table object
	 * @param int table id
	 * @param string component name
	 * @return object table
	 */
	 
	function loadTable($tableId, $option = 'com_mosforms'){
		
		global $database;
		
		if($this->_admin){
			
			require_once("../components/$option/mosform_table.class.php");	
		
		}else{
			
			require_once("components/$option/mosform_table.class.php");	
			
		}		
		$oTable = new mosForm_Table( $database );
	
		$oTable->load($tableId);	
		
		return $oTable;
			
	}

	/**
	 * validates the forms data against the defined set of rules
	 * @param array form data
	 * @param int form id
	 * @param boolean fileupload occured in form
	 * @return array array of error messages called arErrors() [form_element_name,
	 * error message]
	 */
	 
	function ValidateForm($data, $fileUploadFound)
	{ 
		global $database;
	
		$arErrors = array();
	
		foreach($this->_elements as $element) {
	
			$element_name = $element->element_name;
	
			$element_id = $element->id;
	
			$sql = "select * from #__mosform_validations v  left join #__mosform_validation_rules vr on v.validation_rule_id = vr.id where v.element_id = '$element_id'";
	
			$database->setQuery($sql);
	
			$validation_rules = $database->loadObjectList();
	
			foreach($validation_rules as $validation_rule) {
				
				if ($element_id == $validation_rule->element_id) {
	
					$error_message = $validation_rule->message;
					
					$alpha_numeric_element_name = preg_replace("/[^A-Za-z0-9]/", "_", $element_name);
	
					$rule_id = $validation_rule->id;
					
					$rule_desc = $validation_rule->validation_rule_label;
					
					$rule_exp = $validation_rule->validation_rule_expression;
					
					$form_data = $data[$alpha_numeric_element_name]; 
	
					if(!empty($rule_exp)) {
						
						if(!ereg($rule_exp, $form_data)) {
							
							$arErrors[$alpha_numeric_element_name][] = $error_message;
							
						}
						
					} else {
						
						switch ($rule_id) {
							
							case 1: // required field

								if ($form_data == "") {
									
									$arErrors[$alpha_numeric_element_name][] = $error_message;
									
								} 
								
								break;
								
							case 2: // must be alpha numeric
							
								if (!isAlphaNumeric($form_data)) {
									
									$arErrors[$alpha_numeric_element_name][] = $error_message;
									
								} 
								
								break;
		
							case 3: // must be an email address//
							
								if (!check_email_address($form_data)) {
									
									$arErrors[$alpha_numeric_element_name][] = $error_message;
								} 
								
								break;
		
							default: ;
							
						} // switch
						
					}
					
				} 
				
			} 
			
		} 
		
		// get file upload errors
		if ($fileUploadFound) {
			
			$arErrors = $this->FileUpLoadParamsOK($_POST, $arErrors, $this->_elements);
			
		} 
	
		return $arErrors;
	} 

	/**
	 * iterates through $_FILE data to see if any files have been uploaded
	 * @return bol true if files uploaded
	 */
	 
	function CheckForFileUpload(){
	
		if (isset($_FILES) and !empty($_FILES)){
			
			foreach($_FILES as $f){
				
				if($f['name'] != ''){
					
					return true;
					
				}
				
			}
		
		}
	
		return false;
		
	} 

	/**
	 * checks that the uploaded file meets each of the settings defined for it
	 * @param array posted form data
	 * @param array current errors
	 * @param array element objects
	 */
	function FileUpLoadParamsOK($data, $arErrors, $aElements)
	{
	
		foreach($aElements as $el){
			
			if($el->elementtype_id == '8'){
				
				$elName = $el->element_name;
				
				$fileData = $_FILES[$elName];
				
				if (!$this->FileUploadFileTypeOK ($data, $elName)) {
					
					$arErrors[$elName][] = _FILE_TYPE_NOT_ALLOWED;
					
				}
			
				if (!$this->FileUploadSizeOK ($data, $elName)) {
					
					$mySize = $_FILES[$elName]['size'];

					$mySize = $mySize / 1000;
			
					$max_size = $data['ul_max_file_size'];
			
					$msg = sprintf(_FILE_TOO_LARGE, $max_size, $mySize);
					
					$arErrors[$elName][] = $msg;
				
				} 
	
			}
			
		}
	
		return $arErrors;
		
	} 
	
	/**
	 *  This   checks the uploaded file type against the csv specified in the upload
	 * element
	 * @param array posted data
	 * @param string element name
	 * @return bol true if upload file type ok 
	 */
	
	function FileUploadFileTypeOK($data, $elName)
	{

		if($_FILES[$elName]['name'] == ''){
		
			return true;
		
		}
		
		$curr_f_ext = strtolower(substr($_FILES[$elName]['name'], -4));
		
		if (isset($data[$elName]['ul_file_types']) and $data[$elName]['ul_file_types'] != "") {
		
			$ul_file_types = $data[$elName]['ul_file_types'];
	
			$ar_file_types = explode(",", $ul_file_types);
	
			foreach ($ar_file_types as $filetype) {
			
				$filetype = trim($filetype);
	
				if ($curr_f_ext == $filetype) {
				
					return true;
				} 
				
			} 
			
		} else {
			// check default file types
			foreach($this->_aDefaultFileTypes as $default_allowed_ft) {
			
				if ($curr_f_ext == $default_allowed_ft) {
				
					return true;
				} 
			} 
		} 
	
		return false;
	}

	/**
	 * This checks that thte fileupload size is not greater than that specified in
	 * the upload element
	 * @param array posted data
	 * @param string element name
	 * @return bol true if upload file type ok 
	 */ 
	
	function FileUploadSizeOK($data, $elName)
	{
			
		$mySize = $_FILES[$elName]['size'];
	
		if (isset($data[$elName]['ul_max_file_size'])) {
		
			$max_size = $data[$elName]['ul_max_file_size'];
			
			$max_size = $max_size * 1000; //convert kb to bytes
			
			if ($mySize <= $max_size) {
			
				return true;
				
			} 
			
		}
	
		return false;
		
	} 	
	
	// overloaded check function

	function check() {

		// check for valid name

		if (trim( $this->form_title ) == '') {

			$err .= "Your Form must contain a title!\n";

		}

		if (trim( $this->form_submit_jumppage ) == '' and trim( $this->form_submit_message ) == '') {

			$err .= "Either a thank you message or a jump page must be entered .\n";

		}

		if (isset($err)) {

		    $this->_error = $err;

			return false;

		}

		return true;

	}
	
	function copyRow($id, $updateOrderColumns){
		
		global $database;

		$tbl = $this->_tbl;
		$_tbl_key = $this->_tbl_key;
		//get the data to copy
		$sql = "select * from $tbl where $_tbl_key = '$id'";
		$database->setQuery( $sql );
		$item = $database->loadObjectList();
		$item = $item[0];
		//add the data to this object as long as its not the key
		foreach($item as $key=>$val){
			if($key != 	$_tbl_key){
				$this->$key = $val;
			}
		}
	//print_r($this);

		if (!$this->check()) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}
		if (!$this->store()) {
			echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
			exit();
		}
		//parse the update code to state which columns get updated
		$updatewhere = "";
		if (is_array($updateOrderColumns)) {
			foreach($updateOrderColumns as $key=>$val){
				if (substr($val,0,4) == '$row') { //here we replace the value with date created from the row
				    $val = $row->$key;
				}
					$updatewhere .= " $key = '$val' and";
				
			}
			//strip the last and from the where statement
			$updatewhere = substr($updatewhere,0,strlen($updatewhere)-3 );	    

		}

		$this->updateOrder( $updatewhere  );
	}
	
	/**
	* check to see if a table exists for a give form id
	* @param string name of table (ovewrites form_id val to test)
	* @param object database that contains the table
	* @return boolean false if no table fodund true if table found
	*/
	
	function DatabaseTableExists( $tableName='', $tableDatabase = '' )
	{
		//TODO: mosforms : 0.4 : check this function with a table prefix greater than 4 characters long
		global $database, $mosConfig_dbprefix;
		
		$form_id = $this->id;
		
		if($tableName != ''){
		
			$sql = "SHOW TABLES LIKE '$tableName'";	
		
		}else{
		
			$sql = "SHOW TABLES LIKE '" . $mosConfig_dbprefix . "mosform_formdata_" . $form_id . "'";
		
		}
		
		if($tableDatabase == ''){ // use the default mambo database if no table database specified
			
			$tableDatabase = $database;
			
		}
		
		$tableDatabase->setQuery($sql);
		
		$total = $tableDatabase->loadResult();
		
		$prefixLength = strlen($mosConfig_dbprefix);
		
		$total = substr($total, $prefixLength, strlen($total)-1);
		
		$tableName = substr($tableName, $prefixLength, strlen($tableName)-1);
		
		if ($total == "") {
			
			return false;
		
		} else {
	
			return true;
		
		} 
	
	} 
	
	/**
	* Create a talbe to store the forms' data depending upon what groups are assigned to the form
	* @param integer form if
	*/
	
	
	function CreateFormTable()
	
	{
		$form_id = $this->id;
		
		global $database, $my;
		
		$sql = "create table #__mosform_formdata_" . $form_id . "( mosform_internal_id int not null auto_increment, time_date timestamp not null" ;

		$aFormElements = $this->getFormGroups();

		$arAddedObj = array();
		
		$arAddedObj[] = "mosform_internal_id";
		
		$arAddedObj[] = "time_date";

		foreach($aFormElements as $obj) {
			
			$objname = preg_replace("/[^A-Za-z0-9]/", "_", $obj->element_name); // replace all non alphanumeric characters with _
			
			if(!in_array($objname, $arAddedObj)){ // any elements that are names the same (eg radio buttons) can not be entered twice into the database
				
				$arAddedObj[] = $objname;
				
				$objtypeid = $obj->elementtype_id;
				
				switch ($objtypeid) {
					case "2":
						$objtype = "varchar (255)";
					case "3":
						$objtype = "varchar (3)";
					case "4":
						$objtype = "varchar (3)";
					case "5":
						$objtype = "text ()";
					case "6":
						$objtype = "varchar (255)";
					case "7":
						$objtype = "";
					case "8":
						$objtype = "binary ()";
					case "9":
						$objtype = "";
					case "10":
						$objtype = "varchar (25)";
					default:
						$objtype = "varchar (255)";
				} 
				if ($objtype != "") {
					$sql .= ", $objname $objtype null ";
				} 
			}
		} 
		
	
		$sql .= ",  primary key (mosform_internal_id))";
		
		$database->setQuery($sql);
		if (!$database->query()) {
			echo $database->getErrorMsg();
			exit;
		} 
	} 


	/**
	* Alter the forms' data collection table when the forms' groups and/or
	* elements are altered
	* @param string table name (this overrides form id)
	* @param object database connection object
	*/
	
	function AmmendTable( $tableName = '', $tableDatabase = '')
	{
		$form_id = $this->id;
		
		global $database, $my, $mosConfig_dbprefix;
		
		$ammend = false;
		
		if($tableName == ''){
			
			$tableName = $mosConfig_dbprefix . "mosform_formdata_" . $form_id;	
		}
		
		if($tableDatabase == ''){
			
			$tableDatabase = $database;
			
		}
		
		$sql = "describe $tableName";
		
		$tableDatabase->setQuery($sql);
		
		$dbdescriptions = $tableDatabase->loadObjectList();
		
		foreach($dbdescriptions as $dbdescription) {
			
			$fieldname = $dbdescription->Field;
			
			$exitingfields[] = $fieldname;
			
		} 
	
		$lastfield = $fieldname;
		
		$sql = "alter table $tableName " ;
		
		if (!isset($_POST['current_groups_str'])) {
			
			// get a list of groups used by the form
			$groupsql = "SELECT  group_id FROM #__mosform_formgroup where form_id = '$form_id'";
	
			$database->setQuery($groupsql);
			
			$groups = $database->loadObjectList();
	
			echo $database->getErrorMsg();
			
			$arGroups = array();
			
			foreach($groups as $g) {
				
				$arGroups[] = $g->group_id;
				
			} 
			
		} else {
			
			$current_groups_str = $_POST['current_groups_str'];
			
			$arGroups = explode(",", $current_groups_str);
	
		} 
		$arAddedObj = array();
		
		foreach($arGroups as $group_id) {
			
			$groupsql = "select * from #__mosform_elements where group_id = '$group_id'";
			
			$database->setQuery($groupsql);
			
			$elements = $database->loadObjectList();
			
			foreach($elements as $obj) {
				
				$objname = $obj->element_name;
				
				$objname = preg_replace("/[^A-Za-z0-9]/", "_", $objname); // replace all non alphanumeric characters with _
				
				if (!in_array($objname, $exitingfields)) { // make sure that the object is not already in the table
				
					if(!in_array($objname, $arAddedObj)){ // any elements that are names the same (eg radio buttons) can not be entered twice into the database
						
						$arAddedObj[] = $objname;
						
						$objtypeid = $obj->elementtype_id;
						switch ($objtypeid) {
							case "2":
								$objtype = "varchar (255)";
							case "3":
								$objtype = "varchar (3)";
							case "4":
								$objtype = "varchar (3)";
							case "5":
								$objtype = "text ()";
							case "6":
								$objtype = "varchar (255)";
							case "7":
								$objtype = "";
							case "8":
								$objtype = "binary ()";
							case "9":
								$objtype = "";
							case "10":
								$objtype = "varchar (25)";
							default:
								$objtype = "varchar (255)";
						} 
						if ($objtype != "") {

								$ammend = true;
							
								$sql .= ", add column `$objname` $objtype null after `$lastfield`";
														
						} 
										
					}
	
				} 
				
			} 
			
		} 
	
	
		if ($ammend) {
			
			$tableDatabase->setQuery($sql);
			
			if (!$tableDatabase->query()) {
				
				echo $tableDatabase->getErrorMsg();
				
				exit;
				
			} 
			
		} 
		
	} 
	
	/**
	 * updates a form with its associated table id
	 * @param int tableid
	 */
	 
	 function updateFormWithNewTableId( $tableId ){
	 
	 	global $database;
	 	
	 	$sql = "update #__mosform_forms set table_id = '$tableId' where id = '$this->id'";
	 	
	 	$database->setQuery( $sql );
	 	
	 	$database->query();
	 		
	 }
	 
	 /**
	  * sets the variable of each of the form's group's elements to the value
	  * specified
	  * @param string variable name
	  * @param string variable value
	  * @return bol false if update error occurs
	  */
	  
	 function setElementVars($varName, $varVal){
	 	
	 		global $mosConfig_absolute_path, $option, $database;
	 		
	 		require_once($mosConfig_absolute_path . "/components/$option/mosform_elements.class.php");
	 
	 		if($this->_elements == null){
	 		
	 			$this->getFormGroups();
	 				
	 		}
	 		
	 		foreach($this->_elements as $el){
	 			
	 			$oElement = new mosform_Element( $database );
	 			
	 			$oElement->load($el->id);
	 			
	 			if(!$oElement->setVar($varName, $varVal)){
	 				
	 				return false;
	 				
	 			}
	 			
	 			$oElement->store();
	 			
	 		}
	 		
	 		return true;
	 }

}

?>