<?php


/**
 * 
 * All rights reserved
 * Mambo Open Source is Free Software
 * License: http://www.gnu.org/copyleft/gpl.html
 * 
 * @package  mos_forms
 * @Copyright (C) Rob Clayburn
 * @version $Revision: 1.12 $
 */

require_once ("../components/$option/mosform_table.class.php");

require_once("../components/$option/mosform_functions.php");

require_once("../components/$option/mosform_connection.class.php");

require_once("../components/$option/mosforms.class.php");

require_once("../components/$option/mosform_groups.class.php");

//TODO: mosforms : 0.5 : csv import into tables

switch ($task) {

	case "new" :
		
		editTable(0, $option, $act);

		break;

	case "edit" :

		editTable($cid, $option, $act);

		break;

	case "save" :
	
	case "go2menu" :
	
	case "go2menuitem" :
	
	case "menulink" :
	
	case "makeadmincomponent" :
	
		saveMosTable($option, $task, $act);

		break;

	case "remove" :
	
		deleteMosTable($cid, $option, $act);
		
		break;
		
	case "viewdatabase":
	
		$orderBy = mosGetParam( $_REQUEST, 'orderby', '');

		$orderDir = mosGetParam( $_REQUEST, 'orderdir', 'asc');
		
		updateOrderSession($orderBy, $orderDir);
		
		if(!isset($_SESSION['aOrder'])){
	
			$_SESSION['aOrder'] = array();
		
		}
		
		if($orderBy != ''){
			
			$_SESSION['aOrder'][$orderBy] = $orderDir;
				
		}
		
		if(is_array($cid)){$cid = $cid[0];}
		
		$mosFormAct = mosGetParam( $_REQUEST, 'mosformact', '');
		
		$objs = getTableAndMosFormDb( $cid );
		//print_r($objs);
		if($mosFormAct == 'delete'){
			
			$ids = mosGetParam( $_POST, 'ids', array());
			
			deleteMosTableRows($ids, $objs);
			
		}
		
		viewDatabase($cid, $option, $orderBy, $_SESSION['aOrder'], $mosFormAct, $objs);	
		
		break;
	
	case "copy":
	
		copyTable($cid, $option, $act);
		
		break;
		
	case "showlinkedelements":
	
		showLinkedElements( $cid ) ;
		
		break;
			
	default :

		displayMosTables($option, $act);

		break;
}

/**
 * loads table and associated connection object
 * @param int table id
 * @return array (table object, connection object, mosformdb object)
 */
 
function getTableAndMosFormDb( $tableId ){
	
	global $database;
	
	$returnArray = array();

	$oTable = new mosForm_Table( $database );

	$oTable->load($tableId);	

	$oConn = new mosForm_Connection( $database );
	
	$ok = $oConn->load($oTable->connection_id);	
	
	$mosformDb = $oConn->loadTableConnectionDB();
	
	$returnArray['oTable'] = $oTable;
	$returnArray['oConn'] = $oConn;
	$returnArray['mosformDb'] = $mosformDb; 
	return $returnArray;
	
}

/**
 * deletes rows from the table spec'd in table 
 * @param array ids to delete
 * @param array objects created from function getTableAndMosFormDb
 */
 
function deleteMosTableRows($ids, $objs){
	
	if(!$objs['mosformDb']){
		
		echo "unable to connect to database<br />";
		exit;	
	}
	$table = $objs['oTable']->db_table_name;
	
	$key = $objs['oTable']->db_primary_key;

	foreach($ids as $id){
		
		$id = urldecode($id);
		
		$sql = "delete from $table where $key = '$id'";
		
		$objs['mosformDb']->setQuery( $sql );
	 
		if(!$objs['mosformDb']->query()){
			
			echo $objs['mosformDb']->getErrorMsg();
		
		}		
			
	}
	
}

/**
 * copys a table
 * @param array of table ids to delete
 * @param string component name
  * @param string component current action
 */
 
 function copyTable($cid, $option, $act){
 	
 	global $database;

	if (is_array($cid)) {

		foreach ($cid as $id) {

			$row = new mosForm_Table($database);	
		
			$ar = array("id"=>'$row->id');
		
			$row->copyRow( $id, $ar	);
		

		}
	} else {

		$row = new mosForm_Table($database);	
	
		$ar = array("id"=>'$row->id');
	
		$row->copyRow( $cid, $ar	);

	}

	displayMosTables($option, $act);
	
 }
 
/**
 * shows a view of the database data
 * @param int table id
 * @param string component name
 * @param string column to order results by
 * @param array contains ordering state - array(column=>direction)
 * @param string action applied to table
 * @param array objects created from function getTableAndMosFormDb
 */
 
 function viewDatabase($tableId, $option, $orderBy, $aOrder, $mosFormAct, $objs){

	//TODO : mosforms : 0.5 : spec column as "ordering" - at which point you can use the traditional mambo order buttons to reorder the data

	global $database;
	
 	if( is_array( $tableId ) ){$tableId = $tableId[0];}

	$oTable = $objs['oTable'];

	$aTable = mosObjectToArray($oTable);
	
	$oConn = $objs['oConn'];

	$mosformDb = $objs['mosformDb'];
	
	if( !$mosformDb ){
		
		echo "unable to connect to database<br />";
		
		exit;	
	}
	
	$table = $oTable->db_table_name;
	
	$totalSql = "select count(*) from $table ";
	
	$aData = $_POST;
	
	$aData['limitstart'] = mosGetParam($_REQUEST, 'limitstart', $_SESSION['limitstart']);
	
	$_SESSION['limitstart'] = $aData['limitstart']; // set this to a session var so that when we edit a record we go back to the correct page
	
	$limitStart = $aData['limitstart'];
	
	$aData['pagelimit'] = mosGetParam($_REQUEST, 'pagelimit', 10);
	
	$limitLength = $aData['pagelimit'];
	
	$aOrder = 	$_SESSION['aOrder'];

	$lists = array();
	
	if( $oTable->id == '0' ){
		
		echo "No table found for this id";
		
		exit;
		
	}
	
	$aDataToIgnore = array( "ids", "option", "act", "tableid", "Itemid" , "limitstart", "pagelimit", "limit", "orderdir", "orderby", "task", "cid", "boxchecked", "mosformact" );
	
	$i = 0;
	
	foreach( $aData as $key=>$val ){
		
		if ( !in_array( $key, $aDataToIgnore ) ) {
			
			if(is_array($val)){
					
				$filterType = $val['type'];
				
				$filterVal = $val['value'];
				
				$filterExactMatch = $val['match']; 
			
				$aFilter[$key] = $val;
				
				if($filterVal != ""){
					
					if($filterType == 'field' ){
						
						$cond = " $key like '%$filterVal%' ";
						
					}else{
						
						if($filterExactMatch == '0'){
							
							$cond = " $key like '%$filterVal%' ";
							
						}else{
							
							$cond = " $key = '$filterVal' ";
								
						}
						
					}
					
					if($i==0){
						
						$totalSql .= " where $cond"; //build the total sql query including the filters
						
					}else{
						
						$totalSql .= " and $cond" ;
						
					}
					$i ++;	
				}	
			}			
		}
	}
	//echo $totalSql;
	
	$mosformDb->setQuery( $totalSql );
	 
	$total  = $mosformDb->loadResult();
	
	if( $limitStart > $total ){
		
		$limitStart = 0;
		
	}	
	
	$aNewDbInfo = switchDatabase( $oTable, $option, $oConn );
	
	$mosformDb = $aNewDbInfo[0];

	$table = $aNewDbInfo[1];

	$oForm = new mosForms( $database );
	
	$oForm->load( $oTable->form_id );
	
	$elementData = $oTable->getElementData( $mosformDb, $orderBy, $aOrder, $aFilter, $limitLength, $limitStart );
	
	$formGroupEls = $oForm->getFormGroups( true );
	
	$elementData = getForiegnKeys( $elementData, $formGroupEls );
	
	$oFilters = $oTable->getTableFilters( $formGroupEls );

	$lists['filters'] = $oTable->makeFilters( $oFilters, $mosformDb, $table );
	
	$pageNav = pageNav( $total, $limitLength, $limitStart);
	
	html_table_content::writeTable( $oTable, $formGroupEls, $elementData, $option, $aOrder, $lists, $limitStart, $pageNav, $limitLength, $orderBy, $mosFormAct );

 }
 
 
 
 
/**
 * deletes an array of tables 
 * @param array of table ids to delete
 * @param string component name
 * @param string component current action
 */

function deleteMosTable($cid, $option, $act) {

	global $database;

	if (is_array($cid)) {

		foreach ($cid as $id) {

			$database->setQuery("delete from #__mosform_tables where id = '$id'");

			$database->query();

		}
		
	} else {

		$database->setQuery("delete from #__mosform_tables where id = '$cid'");

		$database->query();

	}

	displayMosTables($option, $act);

}

/**
  * Create a psudo component in the admin menu
  * @param int table id to create admin link for
  * @param string component name
  */
  
function adminMenuLink($id, $option) {

	global $database;

	$name = mosGetParam($_POST, 'admin_link_name', '');

	$sql = "insert into #__components "."(name, admin_menu_link, admin_menu_alt, `option`, admin_menu_img)"." values "."('$name', 'option=com_mosform_app&id=$id', '$name', 'com_mosform_app', 'js/ThemeOffice/component.png')";

	$database->setQuery($sql);

	$database->query();
	$msg .= $database->getErrorMsg();

	$msg = " Admin component, $name,  successfully created";

	mosRedirect("index2.php?option=$option&act=tables&task=edit&id=".$id, $msg);
}

/**
 * Link the table item to a menu
 *  @param int table id to create link for
  * @param string component name
 */
 
//function menuLink($id, $option, $act, $linkact = 'viewtable&tableid=') {
//
//	global $database;
//
//	$menu = mosGetParam($_POST, 'menuselect', '');
//	$link = mosGetParam($_POST, 'link_name', '');
//
//	$row = new mosMenu($database);
//	$row->menutype = $menu;
//	$row->name = $link;
//	$row->type = 'url';
//	$row->published = 1;
//	$row->link = "index.php?option=$option&act=".$linkact.$id;
//	$row->ordering = 9999;
//	
//
//
//	if (!$row->check()) {
//		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
//		exit ();
//	}
//
//	if (!$row->store()) {
//		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";
//		exit ();
//	}
//
//	$row->checkin();
//
//	$row->updateOrder("menutype='$row->menutype' ");
//
//	$msg = $link.' (Link - Static Content) in menu: '.$menu.' successfully created';
//
//	mosRedirect("index2.php?option=$option&act=$act&task=edit&cid=".$id, $msg);
//}

/**
 * Save the table information to the database
 * @param string component name
 * @param string component current task
 * @param string component current action
 */

function saveMosTable($option, $task, $act) {
	 	
	global $database;

	$menu 		= mosGetParam($_POST, 'menu', 'mainmenu');
	
	$menuid 	= mosGetParam($_POST, 'menuid', 0);
	
	$tableName 	= mosGetParam($_POST, 'db_table_name', '' );
	
	$id 		= mosGetParam($_POST, 'id', 0);
	
	$mosformid 	= mosGetParam($_POST, 'mosformid', '');	//if this is passed then a form is trying to create a table

	$primaryKey = mosGetParam($_POST, 'db_primary_key', '');

	$oTable 	= new mosForm_Table($database);
	
	$oForm 		= new mosForms( $database );
	
	if($primaryKey == ''){
		
		if( $oForm->DatabaseTableExists( $tableName ) ){
			
			$primaryKey = $oTable->getPrimaryKey( $tableName );
			
			if($primaryKey != ""){
				
				$_POST['db_primary_key'] = $primaryKey;
				
			}else{
				
				echo "<script> alert('" . _NO_PRIMARY_KEY . "');</script>\n";
				
			}
		
		}
		
	}else{
		
		$oTable->load($_POST['id']);
		
		$oTable->updatePrimaryKey( $primaryKey, $_POST['auto_inc'] );
		
	}
	
	if (!$oTable->bind($_POST, 'elements,admin')) {
	
		echo "<script> alert('BIND: ".$oTable->getError()."'); window.history.go(-1); </script>\n";

		exit ();
	}

	if (!$oTable->store()) {
	
		echo "<script> alert('STORE: ".$oTable->getError()."'); window.history.go(-1); </script>\n";

		exit ();
	}

	if ($id == 0) {

		$_POST['id'] = $database->insertid();		
		
		if($mosformid == ''){

			$formId = createLinkedForm($option, $_POST);
			
			$groupId = createLinkedGroup($option, $formId, $_POST);
	
			createFormGroup($option, $formId, $groupId);
	
			createLinkedElements($option, $groupId, $_POST);
			
			createElementValidation($option, $groupId, $_POST);	
	
		}else{

			//update the existing form with the table id
			
			$formId = $mosformid;
			
			$oForm->load( $formId );
			
			$oForm->updateFormWithNewTableId( $_POST['id'] );
			
			if($oForm->setElementVars('show_in_table_summary', '1')){
			
				echo "set var ok";
				
			}else{
				
				echo "set var not ok";
				
			}
				
		}
		
		//set the tables form id
		
		updateTableWithNewFormId($_POST['id'], $formId);	

	}
	
	$oTable->load($oTable->id); // load in all the tables data - even if it wasnt in the post data
	
	$oTable->makeSafeTableColumns(); // this was only run on a new table - but I've put it here so that if you upload a new table you can ensure that its columns are fixed

	switch ($task) {

		case 'go2menu' :
			mosRedirect("index2.php?option=com_menus&menutype=".$menu);
			break;

		case 'go2menuitem' :
			mosRedirect("index2.php?option=com_menus&menutype=".$menu."&task=edit&hidemainmenu=1&id=".$menuid);
			break;

		case 'menulink' :
		
			$oTable->menuLink( $option, $act, 'viewtable', 'tableid='.$oTable->id);
			
			if ($id == 0) {
		
				showLinkedElements( $row->id );
			}else{
		
				mosRedirect("index2.php?option=$option&act=$act&task=edit&cid=".$id, $msg);
		
			}
		
			break;

		case 'makeadmincomponent' :
		
			adminMenuLink($row->id, $option);
		
			break;

//		case 'showlinkedelements' :
//			
//			showLinkedElements( $row->id );
//			break;

		default :
		
			if ($id == 0) {
		
				showLinkedElements( $row->id );
		
			}else{
		
				displayMosTables($option, $act);
		
			}
		
			break;

	}

}

/**
 * add element validations for each element type (eg columns with int values
 * should be only numerical)
 * @param string component name
 * @param int group id that contains all the elements
 * @param array data 
 */
 
function createElementValidation($option, $groupId, $_POST){
	//TODO : mosforms : 0.5 : add element validations for each element type (eg columns with int values should be only numerical)
}

/** 
 * this summarises what has automatically been created and allows the user to
 * navigate to any of the automatically created forms/groups/elements 
 * @param  int table id
 * @param int group id
 */

function showLinkedElements( $tableId ) { //$formId, $groupId
	//TODO: mosforms : 0.4 : this is not working - it was working b4 so must be something dumb I've done
	if(is_array($tableId)){ $tableId = $tableId[0];}
	
	global $database;
	
	$oTable = new mosForm_Table( $database );
	
	$oTable->load($tableId);
	
	$formId = $oTable->form_id;
	
	$oForm = new mosForms( $database );
	
	$oForm->load($formId);
	
	$formGroupEls = $oForm->getFormGroups( false );

	html_table_content :: showTableDetail($oForm, $formGroupEls);
	
	//TODO : mosforms : 0.5 : allow editing of element summary
	/*	write a list like:
	 * 	element_name,	 elemenent_label [field], show in table [checkbox], show
	 * in details, [checkbox]
	 * 
	 * for each element and submit button to globally update
	 */ 
}

/**
 * updates the table record to point to the newly created form
 * @params int table id
 * @params int form id
 */

function updateTableWithNewFormId($tableId, $formId){
	
	global $database;
	
	$row = new mosForm_Table($database);
	
	$row->load( $tableId );
	
	$aData['form_id'] = $formId;

	if (!$row->bind($aData)) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";

		exit ();
	}

	if (!$row->store()) {
		echo "<script> alert('".$row->getError()."'); window.history.go(-1); </script>\n";

		exit ();
	}
}

/**
 * when saving a table that links to a database for the first time we
 * need to create all the elements based on the database table fields and their
 * column type
 * @param string component name
 * @param int group id
 * @param array newly created table data
 */

function createLinkedElements($option, $groupId, $aTableData) {

	global $database, $my;

	require_once ("components/".$option."/admin.mosforms.elements.php");

	require_once ("../components/".$option."/mosform_connection.class.php");

	$cn = new mosForm_Connection($database);

	$cn->load($aTableData['connection_id']);

	$mosformDb = new database($cn->host, $cn->user, $cn->password, $cn->database, "");

	$fields = $mosformDb->getTableFields(array ($aTableData['db_table_name']));
	$fields = $fields[$aTableData['db_table_name']];

	foreach ($fields as $label => $type) {
		//echo "$key <br>";

		$oElement = new mosForm_Element($database);

		$aData['element_label'] = $label;

		switch ($type) {
			
			case "int" :
			case "tinyint" :
			case "varchar" :
				$element_type_id = '2';
				break;
			case "text" :
			case "tinytext" :
			case "mediumtext" :
			case "longtext" :
				$element_type_id = '5';
				break;
			case "datetime" :
			case "date" :
			case "time" :
			case "timestamp" :
				$element_type_id = '11';
				break;
			default :
				$element_type_id = '2';
				break;
				break;
		}
		
		$aData['elementtype_id'] = $element_type_id;

		$aData['group_id'] = $groupId;

		$aData['element_name'] = $label;

		$aData['created'] = mosFormatDate(date('%Y-%m-%d %H:%M:%S'), '%Y-%m-%d %H:%M:%S', - $mosConfig_offset);

		$aData['created_by'] = $my->id;

		$aData['created_by_alias'] = $my->username;
		
		$aData['state'] = '1';
		
		$aData['show_in_table_summary'] = '1';
		
		$aData['element_width'] = '30';
		
		$aData['element_field_width'] = '30';
		
		$aData['element_height'] = '10';
		
		$aData['maxlength'] = '255';

		saveMosFormElement($option, $aData);
	}

}

/**
 * when saving a table that links to a database for the first time we
 * need to link together the created form and the created group
 * @param string component name
 * @param int form id
 * @param int group id
 */

function createFormGroup($option, $formId, $groupId) {

	global $database, $my;

	require_once ("components/".$option."/admin.mosforms.forms.php");

	saveMosFormFormGroup($option, $formId, $groupId, 1);

}

/**
 * when saving a table that links to a database for the first time we need to
 * create a group that houses all the table elements
 * @param string component name
 * @param int group's form id 
 * @param array table data
 */
 
function createLinkedGroup($option, $formId, $tableData) {

	global $database, $my;

	require_once ("components/".$option."/admin.mosforms.groups.php");

	$aData['group_name'] =  $tableData['label'];

	/** @var string */

	$aData['group_title'] =  $tableData['label'];

	$aData['created'] = mosFormatDate(date('%Y-%m-%d %H:%M:%S'), '%Y-%m-%d %H:%M:%S', - $mosConfig_offset);

	$aData['created_by'] = $my->id;

	$aData['created_by_alias'] = $my->username;

	$groupId = saveMosFormGroup($aData);

	return $groupId;
}

/**
 * when saving a table that links to a database for the first time we
 * automatically create a form to allow the update/creation of that tables
 * records
 * @param string component name
 * @param array newly created table data
 */

function createLinkedForm($option, $tableData) {

	global $database, $my;

	require_once ("components/".$option."/admin.mosforms.forms.php");

	$aData['form_title'] = $tableData['label'];

	$aData['record_in_database'] = '1';

	$aData['created'] = mosFormatDate(date('%Y-%m-%d %H:%M:%S'), '%Y-%m-%d %H:%M:%S', - $mosConfig_offset);

	$aData['created_by'] = $my->id;

	$aData['created_by_alias'] = $my->username;

	// @TODO : mosforms : 0.5 : create a overall mosforms params admin page which sets the default settings for all forms, from which these settings below can be populated
	$aData['align'] = 'left';

	$aData['width'] = '100%';

	$aData['form_subject'] = $tableData['label'];

	$aData['form_submit_jumppage'] = 'index.php?option=com_mosforms&act=viewtable&tableid=' . $tableData['id'];

	$aData['email_to'] = '';

	$aData['email_from'] = $mosConfig_mailfrom;

	$aData['receipt_email'] = '';

	$aData['receipt_message'] = '';

	$aData['reset_button'] = 0;
	
	$aData['reset_button_label'] = _CMN_CANCEL;
	
	$aData['submit_button_label'] = _CMN_SAVE;
	
	$aData['table_id'] = $tableData['id'];

	$form_id = saveMosForm($aData);

	return $form_id;

}

/**
 * edit or add a table
 * @param int id of the table to edit
 * @param string component name
 * @param string current action
 */

function editTable($id, $option, $act) {
	
	global $database, $my, $mosConfig_lang, $mosConfig_dbprefix, $mosConfig_offset;

	require_once ("../components/".$option."/mosform_connection.class.php");

	include_once ('language/'.$mosConfig_lang.'.php');

	if (is_array($id)) {
		
		$id = $id[0];
		
	}

	$mosformid = mosGetParam($_GET, 'mosformid', ''); //  this only appears if you are automatically creating the table from an existing for - which has no table associated with it
	
	$row = new mosForm_Table($database);

	$row->load($id);

	$tabs = new mosTabs(1);

	if ($id == 0) {
		
		if($mosformid == ''){ 

			$row->publish_up = date('Y-m-d', time() + $mosConfig_offset * 60 * 60);
	
			//create form drop down menu
	
			$database->setQuery("select id as value, form_title as text from #__mosform_forms");
	
			$forms[] = mosHTML :: makeOption('-1', _CHOOSE_NO_FORM);
	
			$forms = array_merge($forms, $database->loadObjectList());
	
			$javascript = "onchange=\"document.adminForm.connection_id.selectedIndex = 0;"."changeDynaList( 'db_table_name', connectiontables, 0, 0, 0);\""; // ok for when form or table 
	
			$lists['current_forms'] = mosHTML :: selectList($forms, 'form_id', 'class="inputbox" size="1" '.$javascript, 'value', 'text', 0);
	
			//create database connection drop down
			
			$oConn = new mosForm_Connection( $database );
					
			$realCnns = $oConn->getConnections();
			 
			$javascript = "onchange=\"changeDynaList( 'db_table_name', connectiontables, document.adminForm.connection_id.options[document.adminForm.connection_id.selectedIndex].value, 0, 0);\"";
	
			$lists['connections'] = $oConn->getConnectionsDd( $realCnns, $javascript , 'connection_id', '');
	
			// get a list of tables from each connection
	
			$connectionTables = $oConn->getConnectionTables( $realCnns );

			//$javascript = "onchange=\"document.adminForm.form_id.selectedIndex = 0;\"";
			$javascript ='';
			
			$lists['tablename'] = 	'<select name="db_table_name" id="tablename" class="inputbox" size="1" >
									<option value="" selected="selected">' . _CHOOSE_NO_TABLE .'</option>
									</select>';
				
			// get list of links to this item
			
		}else{
			
			// set the connection to conn (id = 1)
			
			$oConn = new mosForm_Connection( $database );
			
			$oConn->load( 1 );
			
			$lists['connections'] = $oConn->description . "<input type=\"hidden\" value=\"1\" id=\"connection_id\" name=\"connection_id\" />";
			
			//set the table to the mosform table
			
			$thisTable = $mosConfig_dbprefix. "mosform_formdata_" . $mosformid;
			
			$lists['tablename'] = $thisTable .  "<input type=\"hidden\" value=\"$thisTable\" id=\"tablename\" name=\"db_table_name\" />";
			
		}

	} else { //if record already exists then you can't change the form or table it points to 

		if ($row->connection_id != "-1") {

			$sql = "select description from #__mosform_connections where id = '$row->connection_id'";

			$database->setQuery($sql);

			$lists['connections'] = $database->loadResult();

			$lists['tablename'] = $row->db_table_name;
			
		} else {
			
			$lists['connections'] = "no database";
			
			$lists['tablename'] = "no table";
		}

		$sql = "select form_title from #__mosform_forms where id = '$row->form_id'";

		$database->setQuery($sql);

		$lists['current_forms'] = $database->loadResult();
	}
	
	if (trim($row->publish_down) == '0000-00-00 00:00:00') {
		
		$row->publish_down = 'Never';
	}

	$and = "\n AND link like 'index.php?option=com_mosforms' and params like '%act=viewtable%' and params like '%tableid=".$row->id."%'";

	$menus = mosAdminMenus :: Links2Menu('components', $and);
	
	// build list of users

	$active = (intval($row->created_by) ? intval($row->created_by) : $my->id);
	
	$lists['created_by'] = mosAdminMenus :: UserSelect('created_by', $active);

	$query = 'SELECT id AS value, name AS text FROM #__groups ORDER BY id';
	
	$database->setQuery( $query );
	
	$groups = $database->loadObjectList();
		
	$lists['allow_view_details'] = mosHTML::selectList( $groups, 'allow_view_details', 'class="inputbox" size="3"', 'value', 'text', intval( $row->allow_view_details ) );
	
	$lists['allow_edit_details'] = mosHTML::selectList( $groups, 'allow_edit_details', 'class="inputbox" size="3"', 'value', 'text', intval( $row->allow_edit_details ) );
	
	$lists['allow_add'] = mosHTML::selectList( $groups, 'allow_add', 'class="inputbox" size="3"', 'value', 'text', intval( $row->allow_add ) );
	
	$lists['allow_delete'] = mosHTML::selectList( $groups, 'allow_delete', 'class="inputbox" size="3"', 'value', 'text', intval( $row->allow_delete ) );	

	$lists['menuselect'] = mosAdminMenus :: MenuSelect();
	
	//get the table templates
	
	$templates =  mosReadDirectory("../components/$option/tmpl/table");
	
		foreach ($templates as $file) {

				$oTemplates[] = mosHTML::makeOption($file);

		} 
	
	$lists['tableTemplates'] = mosHTML::selectList($oTemplates, 'table_template', 'class="inputbox"','value','text',$row->table_template);

	// make the filter action drop down
	
	$filterActions[] = mosHTML :: makeOption('onchange', _ON_CHANGE);
	
	$filterActions[] = mosHTML :: makeOption('submitform', _SUBMIT_FORM);
		
	$lists['filter_action'] = mosHTML :: selectList($filterActions, 'filter_action', 'class="inputbox" size="1" ', 'value', 'text', $row->filter_action);
	
	//make the order by drop down 
	
	$orderDir[] = mosHTML :: makeOption('ASC', _ASCENDING);
	
	$orderDir[] = mosHTML :: makeOption('DESC', _DESCENDING);
	
	$lists['order_dir'] = mosHTML :: selectList($orderDir, 'order_dir', 'class="inputbox" size="1" ', 'value', 'text', $row->order_dir);
	
	html_table_content :: editTable($row, $lists, $tabs, $connectionTables, & $menus, $option, $act, $mosformid);

}



/**
 * show summary of exiting tables
 * @param string component name
 * @param string current action
 */

function displayMosTables($option, $act) {
	//TODO : mosforms : 0.5 : button to allow you to mirror the table's current form/group/elements in the database table - this will be the only way you can delete fields from the database table
	global $database, $mainframe, $mosConfig_offset;
	// get the total number of records
	$database->setQuery("SELECT count(*) FROM #__mosform_tables");

	$total = $database->loadResult();

	echo $database->getErrorMsg();

	$limit = intval(mosGetParam($_POST, 'limit', 10));

	$limitstart = intval(mosGetParam($_POST, 'limitstart', 0));

	$sql = "select * from #__mosform_tables LIMIT $limitstart,$limit";

	$database->setQuery($sql);

	require_once ($GLOBALS['mosConfig_absolute_path'].'/administrator/includes/pageNavigation.php');

	$pageNav = new mosPageNav($total, $limitstart, $limit);

	$rows = $database->loadObjectList();

	if ($database->getErrorNum()) {

		echo $database->stderr();

		return false;
	}
	
	// TODO : mosforms : 0.5 : link to export script to export data as cvs, sql;
	html_table_content :: showAllTables($rows, $pageNav, $option, $act);

}

