<?
####################################
#     Function CreateThumbIM       #
#----------------------------------#
#       Created Ronald Smit        #
#  http://mamboserver.homedns.org  #
#----------------------------------#
# Creates thumb with ImageMagick   #
####################################
function CreateThumbIM($in, $out, $size)
	{
	$cmd = $IM_path."convert -resize $size $in $out";
	@exec($cmd);
	}
####################################
#   Function CreateThumbNETPBM     #
#----------------------------------#
#       Created Ronald Smit        #
#  http://mamboserver.homedns.org  #
#----------------------------------#
#    Creates thumb with NETPBM     #
####################################
function CreateThumbNETPBM($file,$desfile,$maxsize,$origname,$quality) 
	{ 
	global $NETPBM_path; 
	if($NETPBM_path) 
		{ 
		if(!is_dir($NETPBM_path))
			{ 
			echo "NetPbm path not correct";
			die; 
			} 
		} 
		if (eregi("\.png", $origname))
			{ 
			$cmd = $NETPBM_path . "pngtopnm $file | " . $NETPBM_path . "pnmscale -xysize $maxsize $maxsize | " . $NETPBM_path . "pnmtopng > $desfile" ; 
			}
		else if (eregi("\.(jpg|jpeg)", $origname))
			{ 
			$cmd = $NETPBM_path . "jpegtopnm $file | " . $NETPBM_path . "pnmscale -xysize $maxsize $maxsize | " . $NETPBM_path . "ppmtojpeg -quality=$quality > $desfile" ;
			}
		else if (eregi("\.gif", $origname))
			{ 
			$cmd = $NETPBM_path . "giftopnm $file | " . $NETPBM_path . "pnmscale -xysize $maxsize $maxsize | " . $NETPBM_path . "ppmquant 256 | " . $NETPBM_path . "ppmtogif > $desfile" ; 
			}//end if.. 
	@exec($cmd); 
	}
####################################
#       Function checkAdmin        #
#----------------------------------#
#       Created Arthur Konze       #
#    http://www.mamboportal.com    #
#----------------------------------#
# Checks whether logged in user is #
# admin or not!					   #
####################################

function checkAdmin($database, $db, $dbprefix, $cook, $admin)
	{
  	global $CurrUID;
  	/* Get the visitor's UserType */
  	$utype = "";
  	if ($cook<>"")
		{
    	$cryptSessionID=md5($cook);
    	$queryg = "SELECT usertype, userid FROM mos_session WHERE session_ID='$cryptSessionID'";
    	$resultg = $database->openConnectionWithReturn($queryg);
    	while ($rowg = mysql_fetch_object($resultg))
			{
      		$utype = $rowg->usertype;
      		$CurrUID = $rowg->userid;
    		}
	    if ($admin) 
			{
	      	if ($utype=="administrator" or $utype=="superadministrator")
				{
	        	return true;
	      		}
			else
				{
	        	return false;
	      		}
	     	} 
		else 
			{
	      	if ($utype=="user" or $utype=="editor")
				{
	        	return true;
	      		}
			else 
				{
	        	return false;
	      		}
			}
		}
	}

####################################
#     Function CreateThumbGD2      #
#----------------------------------#
#       Created Ronald Smit        #
#  http://mamboserver.homedns.org  #
####################################

function CreateThumbGD2($ext, $img_source, $img_dest, $img_quality, $size_limit, $imagemethod = 'gd2')
{
//debugbreak();
//$imagemethod = 'gd2';

if (!file_exists($img_source))
	{
	return(1); //file not found return 1
		}

 //load the original image and put its height/width in $img_info
 $img_info = GetImageSize($img_source);

 //$img_info ARRAY KEY
 //0 = width
 //1 = height
 //2 = image type
 //3 = hight and width string
 $orig_height = $img_info[1]; //source height from $img_info
 $orig_width = $img_info[0]; //source width from $img_info
 $type = $img_info[2];

$newheight = $size_limit;
$newwidth = $size_limit;

// debugbreak();
	
   if ($im = ImageCreateFromJPEG($img_source)) {
      if ($newheight && ($orig_width < $orig_height)) {
         $newwidth = ($newheight / $orig_height) * $orig_width;
      } else {
         $newheight = ($newwidth / $orig_width) * $orig_height;
		}
      if ($imagemethod == "gd2") {
         $im2 = ImageCreateTrueColor($newwidth,$newheight);
      } else {
         $im2 = ImageCreate($newwidth,$newheight);
		}
      if ($imagemethod == "gd2") {
          ImageCopyResampled($im2,$im,0,0,0,0,$newwidth,$newheight,$orig_width,$orig_height);
      } else {
          ImageCopyResized($im2,$im,0,0,0,0,$newwidth,$newheight,$orig_width,$orig_height);
      }

      if (ImageJpeg($im2, $img_dest, $img_quality)) {
          return(2);
 	}
 	}
   return(3);
}

function getThumb($id)//id van gallery_id
	{
	global $database,$imagepath,$mosConfig_live_site;
	$database->setQuery("SELECT * FROM #__rsgallery as a, #__rsgalleryfiles as b WHERE a.id = b.gallery_id AND b.gallery_id = '$id'");
	$rows = $database->loadObjectList();
	if (!$rows)
		{
		$t_path = "No pics";
		}
	else
		{
		foreach ($rows as $row)
			{
			$t_path = "<img height=\"50\" src=\"".$mosConfig_live_site.$imagepath."thumbs/".$row->name."\" alt=\"\" border=\"1\">";
			}
		}
	return $t_path;
	}

function getNumber($id)
	{
	global $database;
	$database->setQuery("SELECT count(*) FROM #__rsgalleryfiles WHERE gallery_id = '$id'");
	$count = $database->loadResult();
	return $count;
	}

function getCurrentDate()
	{
	$now = getdate(); 
	$datetime = $now['year']."-".$now['mon']."-".$now['mday']." ".$now['hours'].":".$now['minutes'].":".$now['seconds']; 
	echo $datetime;
	}
	
function getCatname($id)
	{
	global $database;
	$database->setQuery("SELECT catname FROM #__rsgallery WHERE id = '$id'");
	$catname = $database->loadResult();
	echo $catname;
	}

function showCategories()
	{
	global $database;
	$database->setQuery("SELECT * FROM #__rsgallery ORDER BY ordering ASC");
	$rows = $database->loadObjectList();
	echo "<option value=\"xx\" SELECTED>- Select category -</option>";
	foreach ($rows as $row)
		{
		echo "<option value=\"$row->id\">$row->catname</option>";
		}
	}
function getFileName($id)
	{
	global $database;
	$database->setQuery("SELECT name FROM #__rsgalleryfiles WHERE id = '$id'");
	$filename = $database->loadResult();
	return $filename;
	}

function regenerateAllThumbs($catid = NULL)
	{
    // re-do all thumbnail pics for selected category(s) or all pics in directory
    global $database, $mosConfig_absolute_path, $imagepath, $conversiontype, $size, $JPEGquality,$IM_path;

    // dmcd to do:

	// 1. put back in GD1 thumbnail call
	// 2. check for database query error
	// 3. if there are a lot of pics, this can take a while, so may need to
	//    reset php max execution timeout so it does not terminate prematurely

    // if manual thumb creation has been chosen, then no resizing will occur
    if($conversiontype == 0) return;
    
    // $catid == 0  all categories
	// $catid == NULL all pic files found in gallery subdirectory
	// $catid == 1..  all pic files for that particular category

	if(isset($catid) && $catid == 0)
		$database->setQuery("SELECT name FROM #__rsgalleryfiles");
	elseif($catid != NULL)
		$database->setQuery("SELECT name FROM #__rsgalleryfiles WHERE gallery_id='$catid'");
		
	if($catid != NULL){
		$files = loadObjectList('name');
		
	// if there is no thumbs subdirectory, then no thumbs can be generated
        if(!(file_exists($mosConfig_absolute_path.$imagepath."thumbs"))) return;
        $pics = mosReadDirectory($mosConfig_absolute_path.$imagepath);
        $maxsize    = $size;
        $quality    = $JPEGquality;
        foreach($pics as $pic)
			{
            // check to see if we want to do this pic
			if($catid != NULL && !array_key_exists($files, $pic)) continue;

            // go regenerate the thumbs
            $file_in = $mosConfig_absolute_path.$imagepath.$pic;
            $file_out = $mosConfig_absolute_path.$imagepath."thumbs/".$pic;
            if(is_dir($file_in)) continue;
            // delete the existing thumb if present
            if(file_exists($file_out)) unlink($file_out);
            switch ($conversiontype)
				{
				//ImageMagick
				case 1:
					$cmd = $IM_path."convert -resize $size $file_in $file_out";
					@exec($cmd);
					break;
				//NETPBM
				case 2:
					CreateThumbNETPBM($file_in,$file_out,$maxsize,$pic,$quality);
					break;
				//GD1
				case 3:
					CreateThumbGD2($file_in, $file_out, $quality, $maxsize, 'gd1');
					break;
				//GD2
				case 4:
					CreateThumbGD2($file_in, $file_out, $quality, $maxsize);
					break;
				}
			}
		}
	}

function getGalleryId($id)
	{
	global $database;
	$database->setQuery("SELECT gallery_id FROM #__rsgalleryfiles WHERE id = '$id'");
	$gallery_id = $database->loadResult();
	return $gallery_id;
	}

function addHit($id)
	{
	global $database;
	//Get hits from DB
	$database->setQuery("SELECT hits FROM #__rsgalleryfiles WHERE id = '$id'");
	$hits = $database->loadResult();
	$hits++;
	$database->setQuery("UPDATE #__rsgalleryfiles SET hits = '$hits' WHERE id = '$id'");
	if ($database->query())
		{
		return(1);//OK
		}
	else
		{
		return(0);//Not OK
		}
	}

function addCatHit($hid)
	{
	global $database;
	//Get hits from DB
	$database->setQuery("SELECT hits FROM #__rsgallery WHERE id = '$hid'");
	$hits = $database->loadResult();
	$hits++;
	$database->setQuery("UPDATE #__rsgallery SET hits = '$hits' WHERE id = '$hid'");
	if ($database->query())
		{
		return(1);//OK
		}
	else
		{
		return(0);//Not OK
		}
	}

function showRating($id)
	{
	global $database,$mosConfig_live_site;
	$database->setQuery("SELECT * FROM #__rsgalleryfiles WHERE id = '$id'");
	$values = array("No rating","Very bad","Bad","OK","Good","Very good");
	$rows = $database->loadObjectList();
	$images = "";
	foreach ($rows as $row)
		{
		$average = $row->rating/$row->votes;
		$average1 = round($average);
		for ($t = 1; $t <= $average1; $t++)
			{
			$images .= "<img src=\"$mosConfig_live_site/images/M_images/rating_star.png\">&nbsp;";
			}
		}
		return $images;
		//return $values[$average1]." (".$average.")";
	}
	
function showEXIF($imagefile)
	{
	//echo "EXIF information for <strong>$imagefile</strong> will be shown here";
	if(!function_exists('exif_read_data'))
		{
		echo "PHP not compiled with EXIF-support!";
		}
	else
		{
		$exif = exif_read_data($imagefile, 0, true);
		?>
		<table width="100%" border="0" cellspacing="1" cellpadding="0">
		<tr bgcolor="#483D8B">
			<td><strong><font color="#FFFFFF">&nbsp;Section</font></strong></td>
			<td><strong><font color="#FFFFFF">&nbsp;Name</font></strong></td>
			<td><strong><font color="#FFFFFF">&nbsp;Value</font></strong></td>
		</tr>
		<?
		foreach ($exif as $key => $section)
			{
			foreach ($section as $name => $val)
				{
				?>
				<tr>
					<td><? echo $key;?></td>
					<td><strong><? echo $name;?></strong></td>
					<td><em><? echo $val;?></em></td>
				</tr>
				<?
				}
			}
			?>
			</table>
			<?
		}
	}

function ShowRandom()
	{
	global $database,$imagepath,$mosConfig_live_site;
	//Load all id's in array
	$database->setQuery("SELECT id FROM #__rsgalleryfiles");
	$imid = $database->loadResultArray();
	//select 3 random id-s
	if (count($imid)>3)
		{
		$img_id = array_rand($imid, 3);
		$image_tag = "";
		for ($j = 0;$j < count($img_id);$j++)
			{
			$x = $img_id[$j];
			$database->setQuery("SELECT * FROM #__rsgalleryfiles WHERE id = '$imid[$x]'");
			$rows = $database->loadObjectList();
			$thumbs = "thumbs";//Too lazy to rewrite $image_tag
			foreach($rows as $row)
				{
				$l_start = $row->ordering - 1;
				$image_tag .= "<td><a href=\"$mosConfig_live_site/index.php?option=com_rsgallery&page=inline&id=$row->id&catid=$row->gallery_id&limitstart=$l_start\"><img src=\"$mosConfig_live_site$imagepath$thumbs/$row->name\" alt=\"$row->descr\" border=\"1\" width=\"100\"></a></td>";
				}
			}
		return $image_tag;
		}
	}
	
function TableHeaderTop()
	{
	global $mosConfig_live_site;
	?>
	<table width="90%" border="0" align="center" cellpadding="0" cellspacing="0">
    <tr>
		<td width="10" height="10"><img src="<? echo $mosConfig_live_site;?>/components/com_rsgallery/images/top_left_corner.gif" width="10" height="10" /></td>
		<td background="<? echo $mosConfig_live_site;?>/components/com_rsgallery/images/top_line.gif"></td>
		<td width="10" height="10"><img src="<? echo $mosConfig_live_site;?>/components/com_rsgallery/images/top_right_corner.gif" width="10" height="10" /></td>
	</tr>
    <tr>
		<td background="<? echo $mosConfig_live_site;?>/components/com_rsgallery/images/left_line.gif"></td>
		<td align="center">
	<?
	}
	
function TableHeaderBottom()
	{
	global $mosConfig_live_site;
	?>  
		</td>
		<td background="<? echo $mosConfig_live_site;?>/components/com_rsgallery/images/right_line.gif"></td>
    </tr>
    <tr>
		<td width="10" height="10" background="<? echo $mosConfig_live_site;?>/components/com_rsgallery/images/bottom_left_corner.gif"></td>
		<td background="<? echo $mosConfig_live_site;?>/components/com_rsgallery/images/bottom_line.gif"></td>
		<td width="10" height="10" background="<? echo $mosConfig_live_site;?>/components/com_rsgallery/images/bottom_right_corner.gif"></td>
    </tr>
  </table>
	<?
	}
	
function SpaceToUnderscore($text)
	{
	$text = str_replace(" ", "_",$text);
	$text = explode(".", $text);
	$text[0] = substr($text[0], 0, 30);
	$text = implode(".",$text);
	return $text;
	}
	
function getPerm($path)
	{
	global $mosConfig_absolute_path;
	$decperms = fileperms($path);
	$octalperms = sprintf("%o",$decperms);
	$perms=(substr($octalperms,1));
	if ($perms !== "0777")
		{
		echo "<font color=\"#FF0000\"><strong>Not writable</strong></font>. Please CHMOD <strong>$mosConfig_absolute_path/uploadfiles</strong> to 0777";
		}
	else
		{
		echo "<strong><font color=\"#008000\">Writable</font></strong>";
		}
	}
	
function checkLogin($my_id)
	{
	global $mosConfig_absolute_path, $acl;
	//Check the login type
	$aro_group = $acl->getAroGroup( $my_id );
	$group = $aro_group->name;
	$group_id = $aro_group->group_id;
	switch ($group)
		{
		case "Super Administrator":
			return 1;//Super Administrator
			break;
		case "Administrator":
			return 2;//Administrator
			break;
		case "Editor":
			return 3;
			break;
		default:
			return 0;//Geen geldige status
			break;
		}
	}
?>
