<?php
//
// Copyright (C) 2005 Jan de Graaff
// All rights reserved.
//
// This program uses parts of the original Simpleboard Application
// 0.7.0b written by Josh Levine; http://www.joshlevine.net
//
// This source file is part of the SimpleBoard Component, a Mambo 4.5
// custom Component By Jan de Graaff - http://tsmf.jigsnet.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// Please note that the GPL states that any headers in files and
// Copyright notices as well as credits in headers, source files
// and output (screens, prints, etc.) can not be removed.
// You can extend them with your own credits, though...
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html.
//

/**
* @package com_simpleboard
* @version: 1.0
* @author: progster
* @since 2005-07-02
**/

// ################################################################
// MOS Intruder Alerts
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
// ################################################################

class sbMail {
	/**
	* function to send mails (uses mosmail in mambo 4.5.1 and later, falls back to phpmail if mosmail doesn't exist
	* 
	* @param string $fromMail
	* @param string $fromName
	* @param string $toMail
	* @param string $subject
	* @param string $body
	* 			message to be send
	*/
	function send($fromMail,$fromName,$toMail,$subject,$body) {
		if (function_exists(mosMail)) 
			mosMail($fromMail,$fromName,$toMail,$subject,$body);
		else {
			$headers = "MIME-Version: 1.0\r\n";
            $headers .= "Content-Type: text/plain;". _ISO . "\r\n";
            $headers .= "From: $fromName <$fromMail>\r\n";
			$headers .= "Reply-To: $fromName <$fromMail>\r\n";
			$headers .= "X-Priority: 3\r\n"; 
			$headers .= "X-MSMail-Priority: Low\r\n";
			$headers .= "X-Mailer: Mambo Open Source 4.5\r\n";
			mail($toMail,$subject,$body,$headers);
		}
	}
	
}
?>