<?php
//
// Copyright (C) 2003 Jan de Graaff
// All rights reserved.
//
// This program uses parts of the original Simpleboard Application
// 0.7.0b written by Josh Levine; http://www.joshlevine.net
//
// This source file is part of the SimpleBoard Component, a Mambo 4.5
// custom Component By Jan de Graaff - http://tsmf.jigsnet.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// Please note that the GPL states that any headers in files and
// Copyright notices as well as credits in headers, source files
// and output (screens, prints, etc.) can not be removed.
// You can extend them with your own credits, though...
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html.
//
// Dont allow direct linking


require_once("$sbp/sb_helpers.php");

function fileUploadError($msg) {
  global $fileLocation, $message, $rc;
  unlink($fileLocation);
  $rc = 0;
  $message = str_replace("[file]","",$message);
  
  sbAlert("$msg\n" ._FILE_NOT_UPLOADED );
}

$filename = split("\.", $_FILES['attachfile']['name']);
$newFileName = $_FILES['attachfile']['name'];
$rc = 1; //reset return code

// Enforce it is a new file
if (file_exists("$sbp/uploaded/files/$newFileName") || eregi("[^0-9a-zA-Z_]", $fileName)) {
  $newFileName = md5(microtime()) . "." . $fileExt ;
}



// Move it to the proper location
if ($rc) {
  move_uploaded_file($_FILES['attachfile']['tmp_name'], $sbp."/uploaded/files/$newFileName");
  @chmod ("$sbp/uploaded/files/$newFileName", 0777);

  //Filename + proper path
  $fileLocation= "$sbp/uploaded/files/$newFileName";

  // some transaltions for readability
  // numExtensions= people tend to upload malicious files using mutliple extensions like: virus.txt.vbs; 
  // we'll want to have the last extension to validate against..
  $numExtensions=(count($filename))-1;
  $fileSize=$_FILES['attachfile']['size'];
  $fileName=$filename[0];
  $fileExt=$filename[$numExtensions];

  // check for empty file
  if (empty($_FILES['attachfile']['name'])) {
   fileUploadError(_FILE_ERROR_EMPTY);
  }
}

// Check for allowed file types
if ($rc) {
  $allowedArray= explode (',',strtolower($sbConfig['fileTypes']));
  if( ! in_array($fileExt,$allowedArray ) ) {
     fileUploadError(_FILE_ERROR_TYPE . " " . $sbConfig['fileTypes']);
  }
}

// Check file name characteristics
if ($rc) {
   if (eregi("[^0-9a-zA-Z_]", $fileName)) {
     fileUploadError(_FILE_ERROR_NAME);
   }
}

// check file size
if ($rc) {
   $maxFileSize = $sbConfig['fileSize']*1024;
   if ( $fileSize > $maxFileSize) {
     fileUploadError(_FILE_ERROR_SIZE . " (" . $sbConfig['fileSize'] . "kb)");
   }
}


// Insert file code into message
if ($rc) {
  $code='[file name='.$newFileName.' size='.$fileSize.']'.$sbs.'/uploaded/files/'.$newFileName.'[/file]';

  if ( preg_match("/\[file\]/si", $message) ) {
    $message = str_replace("[file]",$code,$message);
  } else {
     $message=$message.' '.$code;
  }
}
?>
