<?php
/**
* Xaneon Extensions 2.0 for Mambo 4.5.2
* @copyright (c) 2004-2005 Xaneon Development (dev.xaneon.com)
* @license XPL http://dev.xaneon.com/xpl/
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

// If we're using PHP 4.x, load a compatibility/backport layer so that
// our script has access to most of the constants and functions defined
// in PHP as of versions 4.3.10 and 5.0.
if (version_compare( phpversion(), '5.0' ) === -1) {
  @include_once( dirname( __FILE__ ) . '/xaneon.compat.php' );
}

// Set the PHP include path so that our script can easily include files
// from the current (administrator/com_xxx/includes/) directory.
xclSetIncludePath();

function xclSetIncludePath( $path = null ) {
  if (is_null( $path )) $path = dirname( __FILE__ );
  ini_set( 'include_path', $path .
    PATH_SEPARATOR . ini_get( 'include_path' ) );
}

function xclCastObjectList( &$rows, $class ) {
  // This is likely quite inefficient, but seemingly the only
  // alternative at the moment.
  $objs = array();
  foreach ($rows as $row) {
    $data =& get_object_vars( $row );
    $obj = new $class( $GLOBALS['database'] );
    foreach ($data as $name => $value)
      $obj->$name = $value;
    $objs[] = $obj;
  }
  return $objs;
}

class xclDBTable extends mosDBTable {

  function xclDBTable( $table, $key, &$db, $id = null ) {
    $this->mosDBTable( $table, $key, $db );
    $this->load( $id );
  }

  function check() {
    global $my;
    $vars =& get_object_vars($this);
    $now = date( 'Y-m-d H:i:s' );
    $user = (!empty( $my->id ) ? $my->id : 0);

    if ($this->_tbl_key == 'id' && empty( $this->id ))
      $this->id = null;
    if (array_key_exists( 'created', $vars ) && empty( $this->created )) {
      $this->created = $now;
      $this->created_by = $user;
    }
    if (array_key_exists( 'modified', $vars )) {
      $this->modified = $now;
      $this->modified_by = $user;
    }
    return true;
  }

  // Mambo's database class functions are unsatisfactory at least
  // in that it seems quite impossible to store NULL values:
  function store() {  
    $isUpdate = false;
    $vars =& get_object_vars( $this );
    if (empty( $vars[$this->_tbl_key] )) {
      $query = "INSERT INTO $this->_tbl (%s) VALUES (%s)";
    }
    else {
      $isUpdate = true;
      $query = "UPDATE {$this->_tbl} SET %s WHERE" .
        " {$this->_tbl_key} = '" .
          $this->_db->getEscaped( $vars[$this->_tbl_key] ) . "'";
    }
    $data = array();
    foreach ($vars as $field => $value) {
      if ($field[0] == '_'
          || ($isUpdate && $field == $this->_tbl_key)  
          || is_array( $value ) || is_object( $value ))
        continue;
      if ($value === null) {
        $value = 'NULL';
      }
      else if ($value === '') {
        $value = "''";
      }
      else {
        $value = "'" . $this->_db->getEscaped( $value ) . "'";
      }
      $data["$field"] = $value;
    }
    if (!$isUpdate) {
      $query = sprintf( $query,
        implode( ', ', array_keys( $data ) ),
        implode( ', ', array_values( $data ) ) );
    }
    else {
      $stmts = array();
      foreach ($data as $field => $value)  
        $stmts[] = $field . ' = ' . $value;
      $query = sprintf( $query, implode( ', ', $stmts ) );
    }
    $this->_db->setQuery( $query );
    return $this->_db->query();
  }
}

?>