<?php
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' ); 
/**
* @version $Id: ps_product_category.php,v 1.14 2005/02/09 17:14:41 soeren_nb Exp $
* @package mambo-phpShop
* Contains code from PHPShop(tm):
* 	@copyright (C) 2000 - 2004 Edikon Corporation (www.edikon.com)
*	Community: www.phpshop.org, forums.phpshop.org
* Conversion to Mambo and the rest:
* 	@copyright (C) 2004-2005 Soeren Eberhardt
*
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* mambo-phpShop is Free Software.
* mambo-phpShop comes with absolute no warranty.
*
* www.mambo-phpshop.net
*/


/****************************************************************************
*
* CLASS DESCRIPTION
*                   
* ps_product_category
*************************************************************************/
class ps_product_category {
  var $classname = "ps_product_category";
  
  /**************************************************************************
  ** name: validate_add()
  ** created by:
  ** description:
  ** parameters:
  ** returns:
  ***************************************************************************/
  function validate_add(&$d) {
    
    if (!$d["category_name"]) {
      $d["error"] = "ERROR:  You must enter a name for the category.";
      return False;	
    }
    else {
      return True;    
    }
  }
    
  /**************************************************************************
  ** name: validate_delete()
  ** created by:
  ** description:
  ** parameters:
  ** returns:
  ***************************************************************************/
  function validate_delete(&$d) {

    $db = new ps_DB;

    if (!$d["category_id"]) {
      $d["error"] = "ERROR:  Please select a category to delete.";
      return False;
    }

    // Check for children
    $q  = "SELECT * FROM #__pshop_category_xref where category_parent_id='";
    $q .= $d["category_id"] . "'";
    $db->setQuery($q);   $db->query();
    if ($db->next_record()) {
      $d["error"]  = "ERROR: This category has children. ";
      $d["error"] .= "Please delete children first.";
      return False;
    }
/*
    // Check for products assigned to this category
    $q  = "SELECT * from #__pshop_product_category_xref where category_id='";
    $q .= $d["category_id"] . "'";
    $db->setQuery($q);   $db->query();
    if ($db->next_record()) {
      $d["error"]  = "ERROR: This category has products. ";
      $d["error"] .= "Please delete the products first.";
      return False;
    }
    */
    return True;
  }

  /**************************************************************************
  ** name: validate_update()
  ** created by:
  ** description:
  ** parameters:
  ** returns:
  ***************************************************************************/
  function validate_update(&$d) {
    
    if (!$d["category_name"]) {
      $d["error"] = "ERROR:  You must enter a name for the category.";
      return False;	
    }
    elseif ($d["category_id"] == $d["category_parent_id"]) {
      $d["error"] = "ERROR:  Category parent cannot be same category.";
      return False;	
    }
    else {
      return True;
    }
  }
  
  
  /**************************************************************************
  ** name: add()
  ** created by: pablo
  ** description: creates a new category record and a category_xref record
  ** with the appropriate parent and child ids
  ** parameters:
  ** returns:
  ***************************************************************************/
  function add(&$d) {
    $ps_vendor_id = $_SESSION["ps_vendor_id"];
    $hash_secret="PHPShopIsCool";
    $db = new ps_DB;
    $timestamp = time();
	    
    if ($this->validate_add($d)) {
      $category_id = md5(uniqid($hash_secret));
      
      foreach ($d as $key => $value) {
          if (!is_array($value))
            $d[$key] = addslashes($value);
      }
      // Let's find out the last category in
      // the level of the new category
      $q = "SELECT MAX(list_order) AS list_order FROM #__pshop_category_xref,#__pshop_category ";
      $q .= "WHERE category_parent_id='".$d["parent_category_id"]."' ";
      $q .= "AND category_child_id=category_id ";
      $db->query( $q );
      $db->next_record();
      
      $list_order = intval($db->f("list_order"))+1;
      
      $q = "INSERT into #__pshop_category (category_id, vendor_id, category_name, ";
      $q .= "category_publish, category_description, category_browsepage, products_per_row, ";
      $q .= "category_flypage, cdate, mdate, list_order) ";
      $q .= "VALUES ('";
      $q .= $category_id . "','";
      $q .= $ps_vendor_id . "','";
      $q .= $d["category_name"] . "','";
      if ($d["category_publish"] != "Y") {
        $d["category_publish"] = "N";
      }
      $q .= $d["category_publish"] . "','";
      $q .= $d["category_description"] . "','";
      $q .= $d["category_browsepage"] . "','";
      $q .= $d["products_per_row"] . "','";
      $q .= $d["category_flypage"] . "','";
      $q .= $timestamp . "','";
      $q .= $timestamp . "', '";
      $q .= $list_order . "')";
      $db->setQuery($q);
      $db->query();
  
      
      $q = "INSERT into #__pshop_category_xref ";
      $q .= "(category_parent_id, category_child_id) ";
      $q .= "VALUES ('";
      $q .= $d["parent_category_id"] . "','";
      $q .= $category_id . "')";
      $db->setQuery($q);
      $db->query();
  
      return $category_id;
    }
    else {
      return False;
    }

  }

  /**************************************************************************
  ** name: update()
  ** created by: pablo
  ** description: updates category information
  ** parameters:
  ** returns:
  ***************************************************************************/
  function update(&$d) {
    $ps_vendor_id = $_SESSION["ps_vendor_id"];
    
    $db = new ps_DB;
	
    $timestamp = time();
    
    foreach ($d as $key => $value) {
      if (!is_array($value))
        $d[$key] = addslashes($value);
    }
    if ($this->validate_update($d)) {
      $q = "update #__pshop_category SET ";
      $q .= "category_id='" . $d["category_id"];
      $q .= "',category_name='" . $d["category_name"];
      if (!isset($d["category_publish"])) {
        $d["category_publish"] = "N";
      }
      $q .= "',category_publish='" . $d["category_publish"];
      $q .= "',category_description='" . $d["category_description"];
      $q .= "',category_browsepage='" . $d["category_browsepage"];
      $q .= "',products_per_row='" . $d["products_per_row"];
      $q .= "',category_flypage='" . $d["category_flypage"];
      $q .= "', mdate='$timestamp";
      $q .= "', list_order='" . $d["list_order"]."'";
      $q .= " WHERE category_id='" . $d["category_id"] . "' ";
      $q .= "AND vendor_id='$ps_vendor_id' ";
      $db->setQuery($q);
      $db->query();

      /*
      ** update #__pshop_category x-reference table with parent-child relationship
      */
      $q = "UPDATE #__pshop_category_xref SET ";
      $q .= "category_parent_id='" . $d["category_parent_id"];
      $q .= "' WHERE category_child_id='" . $d["category_id"] . "'";
      $db->setQuery($q);
      $db->query();
      
      /* Re-Order the category table IF the list_order has been changed */
      if( intval($d['list_order']) != intval($d['currentpos'])) {
        $dbu = new ps_DB;
        
        /* Moved UP in the list order */
        if( intval($d['list_order']) < intval($d['currentpos']) ) {
        
          $q = "SELECT category_id FROM #__pshop_category_xref,#__pshop_category ";
          $q .= "WHERE category_parent_id='".$d["category_parent_id"]."' ";
          $q .= "AND category_child_id=category_id ";
          $q .= "AND category_id <> '" . $d["category_id"] . "' ";
          $q .= "AND list_order >= '" . intval($d["list_order"]) . "'";
          $db->query( $q );
          
          while( $db->next_record() ) {
            $dbu->query("UPDATE #__pshop_category SET list_order=list_order+1 WHERE category_id='".$db->f("category_id")."'");
          }
        }
        /* Moved DOWN in the list order */
        else {
        
          $q = "SELECT category_id FROM #__pshop_category_xref,#__pshop_category ";
          $q .= "WHERE category_parent_id='".$d["category_parent_id"]."' ";
          $q .= "AND category_child_id=category_id ";
          $q .= "AND category_id <> '" . $d["category_id"] . "' ";
          $q .= "AND list_order > '" . intval($d["currentpos"]) . "'";
          $q .= "AND list_order <= '" . intval($d["list_order"]) . "'";
          $db->query( $q );
          
          while( $db->next_record() ) {
            $dbu->query("UPDATE #__pshop_category SET list_order=list_order-1 WHERE category_id='".$db->f("category_id")."'");
          }
        
        }
      } /* END Re-Ordering */
      
      // Problem: When the parent id has changed, the category is 
      // in a new level. We now need to change the list order value
      // of the category to the value: recent MAXIMUM + 1
      if( $d["category_parent_id"] != $d["current_parent_id"] ) {
        // Let's find out the last category in
        // the new level of the category
        $q = "SELECT MAX(list_order) AS list_order FROM #__pshop_category_xref,#__pshop_category ";
        $q .= "WHERE category_parent_id='".$d["category_parent_id"]."' ";
        $q .= "AND category_child_id=category_id ";
        $q .= "AND category_id <> '".$d["category_id"]."'";
        $db->query( $q );
        $db->next_record();
        
        $q = "UPDATE #__pshop_category SET list_order=".$db->f("list_order")."+1 WHERE category_id='".$d["category_id"]."'";
        $db->query( $q );
      }
      return True;
    }
    else {
      return False;	
    }
  }

  /**************************************************************************
  ** name: delete()
  ** created by: pablo
  ** description: Should delete a category and and categories under it.
  ** parameters: 
  ** returns:
  ***************************************************************************/
  function delete(&$d) {
    global $ps_product;
    $db =& new ps_DB;
    $dbc =& new ps_DB;
    
    if (!$this->validate_delete($d)) {
      return False;
    }
    // Delete all products from that category
    // We must filter out those products that are in more than one category!
    
    // Case 1: Products are assigned to more than on category
    // so let's only delete the __pshop_product_category_xref entry
    $q = "CREATE TEMPORARY TABLE `#__tmp_prod` AS 
            (SELECT * FROM `#__pshop_product_category_xref` 
            WHERE `category_id`='".$d['category_id']."');";
    $db->query( $q );
    $q = "SELECT #__pshop_product_category_xref.product_id 
          FROM `#__pshop_product_category_xref`, `#__tmp_prod` 
          WHERE #__pshop_product_category_xref.product_id=#__tmp_prod.product_id 
            AND #__pshop_product_category_xref.category_id!='".$d['category_id']."';";
    $db->query( $q );
    if( $db->num_rows() > 0 ) { 
      $i = 0;
      $q = "DELETE FROM #__pshop_product_category_xref WHERE product_id IN (";
      while( $db->next_record() ) {
        $q .= "'".$db->f("product_id")."'";
        if( $i++ < $db->num_rows()-1 )
          $q .= ",";
      }
      $q .= ") AND category_id='".$d['category_id']."'";
      $db->query( $q );
    }
    else {
      // Case 2: Products are assigned to this category only
      $q = "SELECT product_id FROM `#__pshop_product_category_xref` WHERE `category_id`='".$d['category_id']."';";
      $db->query ( $q );
      while( $db->next_record() ) {
        $d['product_id'] = $db->f("product_id");
        $ps_product->delete( $d );
      }
    }
    
    $q = "DELETE FROM #__pshop_category WHERE category_id='" . $d["category_id"] . "'";
    $db->setQuery($q);   $db->query();

    $q  = "DELETE FROM #__pshop_category_xref ";
    $q .= "WHERE category_child_id='" . $d["category_id"] . "'";
    $db->setQuery($q);   $db->query();

    return True;
  }


  /**************************************************************************
  ** name: traverse_tree_down()
  ** created by:
  ** description: It goes through the category table and establishes
  **              the category tree based on the parent-child relationships
  **              defnied in the category_xref table.
  **              This is VERY recursive...
  **
  ** parameters:
  ** returns:
  ***************************************************************************/
  function traverse_tree_down($class="",$category_id="0", $level="0") {
    static $ibg = 0;
    global $sess, $mosConfig_live_site, $PHPSHOP_LANG;
    $ps_vendor_id = $_SESSION["ps_vendor_id"];
    $db = new ps_DB;
    $class = "maintext";
    
    $level++;

    $q = "SELECT * FROM #__pshop_category,#__pshop_category_xref ";
    $q .= "WHERE #__pshop_category_xref.category_parent_id='";
    $q .= $category_id . "' AND ";
    $q .= "#__pshop_category.category_id=#__pshop_category_xref.category_child_id ";
    $q .= "AND #__pshop_category.vendor_id='$ps_vendor_id' ";
    $q .= "ORDER BY list_order asc ";
    $db->setQuery($q);   
    $db->query();
    
    while ($db->next_record()) {
      $product_count = $this->product_count($db->f("category_child_id"));
      if ($level % 2)
          $bgcolor=SEARCH_COLOR_1;
      else
          $bgcolor=SEARCH_COLOR_2;
      $ibg++;
      echo "<tr bgcolor=\"$bgcolor\">\n";
      echo "<td><input style=\"display:none;\" id=\"cb$ibg\" name=\"cb[]\" value=\"".$db->f("category_id")."\" type=\"checkbox\" />&nbsp;$ibg</td><td>";
      for ($i=0; $i<$level; $i++) {
        echo "&nbsp;&nbsp;&nbsp;";
      }
      echo "&#095&#095;|$level|&nbsp;";
      echo "<a href=\"" ;   
      echo $_SERVER['PHP_SELF'] . "?option=com_phpshop&page=product.product_category_form&category_id=" . $db->f("category_child_id"). "&category_parent_id=" . $db->f("category_parent_id");
      echo "\">";
      echo $db->f("category_name") . "</a></td>\n";
      echo "<td>&nbsp;&nbsp;" . $db->f("category_description");
      echo "</td>\n<td>".$product_count ." ". $PHPSHOP_LANG->_PHPSHOP_PRODUCTS_LBL."&nbsp;<a href=\"";
      echo $_SERVER['PHP_SELF'] . "?page=product.product_list&category_id=" . $db->f("category_child_id")."&option=com_phpshop";
      echo "\">[ ".$PHPSHOP_LANG->_PHPSHOP_SHOW." ]</a>\n</td>\n";
      //echo "<td>". $db->f("list_order")."</td>";
      echo "<td>";
      if ($db->f("category_publish")=='N') { 
          echo "<img src=\"". $mosConfig_live_site ."/administrator/images/publish_x.png\" border=\"0\" />";
      } 
      else { 
          echo "<img src=\"". $mosConfig_live_site ."/administrator/images/tick.png\" border=\"0\" />\n";
      } 
      echo "<td width=\"5%\"><div align=\"center\">\n";
      echo mShop_orderUpIcon( $db->row, $db->num_rows(), $ibg ) . "\n&nbsp;" . mShop_orderDownIcon( $db->row, $db->num_rows(), $ibg );
      echo "</div></td>\n";
      echo "<td width=\"5%\">";
      echo "<a class=\"toolbar\" href=\"".$_SERVER['PHP_SELF']."?option=com_phpshop&page=".$_REQUEST['page'] ."&func= productCategoryDelete&category_id=". $db->f("category_id") ."\"";
      echo " onclick=\"return confirm('". $PHPSHOP_LANG->_PHPSHOP_DELETE_MSG ."');\" onmouseout=\"MM_swapImgRestore();\"  onmouseover=\"MM_swapImage('Delete$ibg','','". IMAGEURL ."ps_image/delete_f2.gif',1);\">";
      echo "<img src=\"". IMAGEURL ."ps_image/delete.gif\" alt=\"Delete this record\" name=\"delete$ibg\" align=\"middle\" border=\"0\" /></a></td>\n";
      $this->traverse_tree_down($class, $db->f("category_child_id"), $level);
    }    
  }
  

  /**************************************************************************
  ** name: get_product_count()
  ** created by:
  ** description: Calculates and returns number of products in given category
  **
  ** parameters:
  ** returns:
  ***************************************************************************/  
  
  function product_count($category_id) {
    $ps_vendor_id = $_SESSION["ps_vendor_id"];
    
    $db = new ps_DB;
    
    $count  = "SELECT count(*) as num_rows from #__pshop_product,#__pshop_product_category_xref, #__pshop_category WHERE ";
    $q  = "#__pshop_product.vendor_id = '$ps_vendor_id' ";
    $q .= "AND #__pshop_product_category_xref.category_id='$category_id' "; 
    $q .= "AND #__pshop_category.category_id=#__pshop_product_category_xref.category_id ";
    $q .= "AND #__pshop_product.product_id=#__pshop_product_category_xref.product_id ";
    $q .= "AND #__pshop_product.product_parent_id='' ";
    $q .= "ORDER BY product_publish DESC,product_name ";
    $count .= $q;  
    $db->setQuery($count); $db->query();
    $db->next_record();
    return $db->f("num_rows");
  }
  
  /**************************************************************************
  ** name: traverse_tree_up()
  ** created by:
  ** description: It goes through the category table and establishes
  **              the category tree based on the parent-child relationships
  **              defnied in the category_xref table.
  **              This is VERY recursive...
  ** parameters:
  ** returns:
  ***************************************************************************/
  function traverse_tree_up($category_id, $level=0) {
    $ps_vendor_id = $_SESSION["ps_vendor_id"];
    $db = new ps_DB;
    
    $level++;
    $q = "SELECT #__pshop_category.category_name,category_child_id,category_parent_id FROM #__pshop_category, #__pshop_category_xref ";
    $q .= "WHERE #__pshop_category_xref.category_child_id=' ";
    $q .= "$category_id' AND ";
    $q .= "#__pshop_category.category_id=#__pshop_category_xref.category_parent_id ";
    $q .= "AND #__pshop_category.vendor_id = $ps_vendor_id ";
    $db->setQuery($q);   $db->query();
    while ($db->next_record()) {
      if ($level == 1) {
	echo "<option selected=\"selected\" value=\"" . $db->f("category_child_id");
      }
      else {
	echo "<option value=\"" . $db->f("category_child_id");
      }
      echo "\">" . $db->f("category_name") . "</option>";

      $this->traverse_tree_up($db->f("category_parent_id"), $level);
    }    
  }

  /***************************************************************************
  ** name: list_category()
  ** created by: pablo
  ** description: list all categories and has the category with the given
  **              product_id preselected.
  ** parameters:
  ** returns:
  ***************************************************************************/
  function list_category($product_id="",$category_id="",$name = "category_id") {
    $db = new ps_DB;
    global $PHPSHOP_LANG;


    echo "<select class=\"inputbox\" name=$name>\n";

    if ($product_id and !$category_id) {
      $q = "SELECT category_id from #__pshop_product_category_xref WHERE product_id='$product_id'";
      $db->setQuery($q);   $db->query();
      $db->next_record();
      if (!$db->f("category_id")) {
        echo "<option value=\"0\">".$PHPSHOP_LANG->_PHPSHOP_SELECT."</option>\n";
      }
      $this->list_tree($db->f("category_id"));
    } 
    elseif ($category_id) {
      echo "<option value=\"0\">".$PHPSHOP_LANG->_PHPSHOP_SELECT."</option>\n";
      $this->list_tree($category_id);
    } 
    else {
      echo "<option value=\"0\">".$PHPSHOP_LANG->_PHPSHOP_SELECT."</option>\n";
      $this->list_tree();
    }
    
    echo "</select>\n";
    
    return True;
  }
 

  /***************************************************************************
  ** name: list_parents()
  ** created by:
  ** description:
  ** parameters:
  ** returns:
  ***************************************************************************/
  function list_parents($category_id) {
    $db = new ps_DB;
    global $PHPSHOP_LANG;

    echo "<select class=\"inputbox\" name=$name>\n";
    echo "<option value=\"0\">".$PHPSHOP_LANG->_PHPSHOP_SELECT."</option>\n";
    $this->traverse_tree_up($category_id);
    echo "</select>\n";    
  }
  
  /**************************************************************************
  ** name: print_child_list()
  ** created by: soeren
  ** description: creates a bulleted of the childen of this category if they 
  **              exist
  ** parameters: category_id
  ** returns:
  ***************************************************************************/
  function print_child_list($category_id) {
    echo $this->get_child_list($category_id);
  }
  
  /**************************************************************************
  ** name: get_child_list()
  ** created by: pablo
  ** description: creates a bulleted of the childen of this category if they 
  **              exist
  ** parameters: category_id
  ** returns:
  ***************************************************************************/
  function get_child_list($category_id) {
    global $sess, $PHP_SELF, $modulename;
    $ps_vendor_id = $_SESSION["ps_vendor_id"];
    $db = new ps_DB;

    $q = "SELECT category_child_id,category_name FROM #__pshop_category,#__pshop_category_xref ";
    $q .= "WHERE #__pshop_category_xref.category_parent_id='$category_id' ";
    $q .= "AND #__pshop_category.category_id=#__pshop_category_xref.category_child_id ";
    $q .= "AND #__pshop_category.vendor_id='$ps_vendor_id' ";
    $q .= "AND #__pshop_category.category_publish='Y' ";
    $q .= "ORDER BY #__pshop_category.list_order, #__pshop_category.category_name ASC";
    $db->setQuery($q);   $db->query();
    $html = "";
    while($db->next_record()) {
      $html .= "<ul>&nbsp;&nbsp;<a href=\"";
      $html .= $sess->url($PHP_SELF . "?page=shop.browse&root=$category_id&category_id=".$db->f("category_child_id"));
      $html .= "\"><img src=\"images/M_images/indent1.png\" border=\"0\" />&nbsp;&nbsp;";
      $html .= $db->f("category_name");
      $html .= "</a></ul>";      
    }
    return $html;

  }

  /**************************************************************************
  ** name: print_subcategory()
  ** created by:
  ** description:
  ** parameters:
  ** returns:
  ***************************************************************************/
  function print_subcategory($category_id) {
    global $sess;
    $ps_vendor_id = $_SESSION["ps_vendor_id"];
    
    $db = new ps_DB;

    $q = "SELECT category_child_id,category_name FROM #__pshop_category,#__pshop_category_xref ";
    $q .= "WHERE #__pshop_category_xref.category_parent_id='$category_id' ";
    $q .= "AND #__pshop_category.category_id=#__pshop_category_xref.category_child_id ";
    //$q .= "AND #__pshop_category.vendor_id='$ps_vendor_id' ";
    $q .= "AND #__pshop_category.category_publish='Y' ";
    $q .= "ORDER BY #__pshop_category.list_order, #__pshop_category.category_name ASC";
    $db->setQuery($q);   
    $db->query();
    echo "<ul>";
    while($db->next_record()) {
        echo "<li><a href=\"";
        $sess->purl(URL . "index.php?page=shop.browse&root=$category_id&category_id=" .$db->f("category_child_id"));
        echo "\">&nbsp;".$db->f("category_name")."</a></li>";
    }
    echo "</ul>";

  }


  /**************************************************************************
  ** name: list_all()
  ** created by:
  ** description:
  ** parameters:
  ** returns:
  ***************************************************************************/
  function list_all($name, $category_id, $selected_categories=Array(), $size=1, $toplevel=true, $multiple=false) {

    $db = new ps_DB;

    $q  = "SELECT category_parent_id FROM #__pshop_category_xref ";
    if( $category_id )
      $q .= "WHERE category_child_id='$category_id'";
    $db->setQuery($q);   $db->query();
    $db->next_record();
    $category_id=$db->f("category_parent_id");
    $multiple = $multiple ? "multiple=\"multiple\"" : "";
    
    echo "<select class=\"inputbox\" size=\"$size\" $multiple name=\"$name\">\n";
    if( $toplevel ) {
      echo "<option value=\"0\">Default-Top Level</option>\n";
    }
    $this->list_tree($category_id, '0', '0', $selected_categories);
    echo "</select>\n";
  }
  
  /**************************************************************************
  ** name: list_level()
  ** created by: soeren
  ** description: lists all categories from the defined level
  ** parameters:
  ** returns:
  ***************************************************************************/
  function list_level( $category_parent_id, $category_id='0', $list_order=0 ) {

    $db = new ps_DB;
    if (!$category_id) {
      return _CMN_NEW_ITEM_LAST;
    }
    else {
        
      $q  = "SELECT list_order,category_name,category_child_id FROM #__pshop_category, #__pshop_category_xref ";
      $q .= "WHERE category_parent_id='$category_parent_id' ";
      $q .= "AND category_child_id=category_id ";
      $q .= "ORDER BY list_order ASC";
      $db->query( $q );
      
      $html = "<select class=\"inputbox\" name=\"list_order\">\n";
      while( $db->next_record() ) {
        if( $list_order == $db->f("list_order") )
          $selected = "selected=\"selected\"";
        else
          $selected = "";
        $html .= "<option value=\"".$db->f("list_order")."\" $selected>"
              .$db->f("list_order").". ".$db->f("category_name")
              ."</option>\n";
      }
      $html .= "</select>\n";
      return $html;
    }
  }
  
  /**************************************************************************
  ** name: list_tree()
  ** created by:
  ** description: Creates OPTIONS fields for a select
  ** parameters:
  ** returns:
  ***************************************************************************/
  function list_tree($category_id="", $cid='0', $level='0', $selected_categories=Array() ) {
  
    $ps_vendor_id = $_SESSION["ps_vendor_id"];
    $db = new ps_DB;
    
    $level++;

    $q = "SELECT category_child_id,category_name FROM #__pshop_category,#__pshop_category_xref ";
    $q .= "WHERE #__pshop_category_xref.category_parent_id='$cid' ";
    $q .= "AND #__pshop_category.category_id=#__pshop_category_xref.category_child_id ";
    $q .= "AND #__pshop_category.vendor_id ='$ps_vendor_id' ";
    $q .= "ORDER BY #__pshop_category.list_order, #__pshop_category.category_name ASC";
    $db->setQuery($q);   $db->query();

    while ($db->next_record()) {
      $child_id = $db->f("category_child_id");
      if ($child_id != $cid) {
        $selected = ($child_id == $category_id) ? "selected=\"selected\"" : "";
        if( $selected == "" && $selected_categories[$child_id] == "1") {
          $selected = "selected=\"selected\"";
        }
        echo "<option $selected value=\"$child_id\">\n";
      }
      for ($i=0;$i<$level;$i++) {
        echo "&#151";
      }
      echo "|$level|";
      echo "&nbsp;" . $db->f("category_name") . "</option>";
      $this->list_tree($category_id, $child_id, $level, $selected_categories);
    }    
  }
 
  /**************************************************************************
  ** name: get_name()
  ** created by: jep
  ** description: Returns the category name.
  ** parameters:
  ** returns:
  ***************************************************************************/
  function get_name($product_id) {
    $db = new ps_DB;

    $q = "SELECT category_name FROM #__pshop_category,#__pshop_product_category_xref ";
    $q .= "WHERE product_id='$product_id' ";
    $q .= "AND #__pshop_category.category_id = #__pshop_product_category_xref.category_id ";
    $db->setQuery($q);   $db->query();

    $db->next_record();

    return $db->f("category_name");
  }


  /**************************************************************************
  ** name: get_description()
  ** created by: soern
  ** description: Returns the category description.
  ** parameters:
  ** returns:
  ***************************************************************************/
  function get_description($category_id) {
    $db = new ps_DB;

    $q = "SELECT category_description FROM #__pshop_category ";
    $q .= "WHERE category_id='$category_id' ";
    $db->setQuery($q);   $db->query();

    $db->next_record();

    return $db->f("category_description");
  }
  
  /**************************************************************************
  ** name: has_childs()
  ** created by: soern
  ** description: Returns true if the category has childs
  ** parameters: category_id
  ** returns: true if the category has childs; false, if not
  ***************************************************************************/
  function has_childs($category_id) {
      $db = new ps_DB;
  
      $q = "SELECT category_child_id FROM #__pshop_category_xref ";
      $q .= "WHERE category_parent_id='$category_id' ";
      $db->setQuery($q);   $db->query();
  
      if ($db->num_rows() > 0)
        return true;
      else
        return false;
  }
  
  function navigation_list($category_id) {
    echo $this->get_navigation_list($category_id);
  }
  /* 
  Creates navigation list of categories
  */
  function get_navigation_list($category_id) {
    global $sess, $PHP_SELF, $mosConfig_live_site;
    $db = new ps_DB;
    $dbt = new ps_DB;
    static $i=0;
    static $html = "";
    $q = "SELECT category_name,category_parent_id FROM #__pshop_category, #__pshop_category_xref WHERE ";
    $q .= "#__pshop_category_xref.category_child_id='$category_id' ";
    $q .= "AND #__pshop_category.category_id='$category_id'";
    $db->setQuery($q);   $db->query();
    $db->next_record();
    if ($db->f("category_parent_id")) {
      $link = "<a href=\"";
      $link .= $sess->url($PHP_SELF . "?page=shop.browse&category_id=$category_id");
      $link .= "\">";
      $link .= $db->f("category_name");
      $link .= "</a>";
      $category_list[$i++] = "&nbsp;<img src=\"$mosConfig_live_site/images/M_images/indent1.png\" width=\"9\" height=\"9\" alt=\"\" />&nbsp;" . $link;
      $this->navigation_list($db->f("category_parent_id"));
    }
    else {
      $link = "<a href=\"";
      $link .= $sess->url($PHP_SELF . "?page=shop.browse&category_id=$category_id");
      $link .= "\">";
      $link .= $db->f("category_name");
      $link .= "</a>";
      $category_list[$i++] = $link;
      
    }
    $html = "";
    while (list($key, $value) = each($category_list)) {
        $html .= $value;
    }

    return $html; 
  }
  /**************************************************************************
  ** name: reorder()
  ** created by: soern
  ** description: Changes the category List Order
  ** parameters: category_id
  ** returns: true if the category has childs; false, if not
  ***************************************************************************/
  function reorder( &$d ) {
      $cb = mosGetParam( $_POST, 'cb', array(0) );
      
      $db = new ps_DB;
      switch( $d["task"] ) {
        case "orderup":
          $q = "SELECT list_order,category_parent_id FROM #__pshop_category,#__pshop_category_xref ";
          $q .= "WHERE category_id='".$cb[0]."' ";
          $q .= "AND category_child_id='".$cb[0]."' ";
          $db->query($q);
          $db->next_record();
          $currentpos = $db->f("list_order");
          $category_parent_id = $db->f("category_parent_id");
          
          // Get the (former) predecessor and update it
          $q = "SELECT list_order,#__pshop_category.category_id FROM #__pshop_category, #__pshop_category_xref ";
          $q .= "WHERE #__pshop_category_xref.category_parent_id='$category_parent_id' ";
          $q .= "AND #__pshop_category_xref.category_child_id=#__pshop_category.category_id ";
          $q .= "AND list_order='". intval($currentpos - 1) . "'";
          $db->query($q);
          $db->next_record();
          $pred = $db->f("category_id");
          
          // Update the category and decrease the list_order
          $q = "UPDATE #__pshop_category ";
          $q .= "SET list_order=list_order-1 ";
          $q .= "WHERE category_id='".$cb[0]."'";
          $db->query($q);

          $q = "UPDATE #__pshop_category ";
          $q .= "SET list_order=list_order+1 ";
          $q .= "WHERE category_id='$pred'";
          $db->query($q);
          
          break;
          
        case "orderdown":
          $q = "SELECT list_order,category_parent_id FROM #__pshop_category,#__pshop_category_xref ";
          $q .= "WHERE category_id='".$cb[0]."' ";
          $q .= "AND category_child_id='".$cb[0]."' ";
          $db->query($q);
          $db->next_record();
          $currentpos = $db->f("list_order");
          $category_parent_id = $db->f("category_parent_id");
          
          // Get the (former) successor and update it
          $q = "SELECT list_order,#__pshop_category.category_id FROM #__pshop_category, #__pshop_category_xref ";
          $q .= "WHERE #__pshop_category_xref.category_parent_id='$category_parent_id' ";
          $q .= "AND #__pshop_category_xref.category_child_id=#__pshop_category.category_id ";
          $q .= "AND list_order='". intval($currentpos + 1) . "'";
          $db->query($q);
          $db->next_record();
          $succ = $db->f("category_id");
          
          $q = "UPDATE #__pshop_category ";
          $q .= "SET list_order=list_order+1 ";
          $q .= "WHERE category_id='".$cb[0]."' ";
          $db->query($q);
          
          $q = "UPDATE #__pshop_category ";
          $q .= "SET list_order=list_order-1 ";
          $q .= "WHERE category_id='$succ'";
          $db->query($q);
          
          break;
      }

  }

}
?>
