<?php
//
// MambelFish integration, Manel Zaera, manelzaera@yahoo.es, 27-12-2004
//

class mosForm_Table extends mosFormDBTable {
	/** @var int Primary key */
	var $id=null;
	
	/** @var string The menu title for the Section (a short name)*/
	var $label = null;
	
	/** @var string The text that goes at the start of the table view page*/
	var $introduction = null;
	
	/** @var int The form id that the table references (Foregin Key)*/
	var $form_id = null;

	/** @var int foreign key to connections table */
	var $connection_id = null;
	
	/** @var string if database selected rather than form: this is the database's table name*/
	var $db_table_name = null;
	
	/** @var string name of table's primay key column */
	var $db_primary_key = null;
	
	/** @var bol is the primary key autoincrementing */
	var $auto_inc = 0;

	/** @var bol allow user to add records to table*/
	var $allow_add = null;
	
	/** @var bol allow user to delete records to table*/
	var $allow_delete = null;
	
	/** @var bol allow user to view in depth version of records*/
	var $allow_view_details = null;
	
	/** @var int allow users to view and edit the details of a record */
	var $allow_edit_details = null;
	
	/** @var int	 published*/
	var $state = 1;
	
	/** @var date date created */
	var $created = null;
	
	/** @var int */
	var $created_by = null;
	
	/** @var string */
	var $created_by_alias = null;
	
	/** @var date date modified */
	var $modified = null;
	
	/** @var int */
	var $modified_by = null;
	
	/** @var int */
	var $checked_out = null;
	
	/** @var date */
	var $checked_out_time = null;
	
	/** @var date */
	var $publish_up = null;
	
	/** @var date */
	var $publish_down = null;
	
	/** @var int the access level the user has to be to view the table*/
	var $access = null;
	
	/** @var int the number of times the table has been viewed*/
	var $hits = null;
	
	/** @var int the default number of rows to show per pages*/
	var $rows_per_page = 10;

	/** @var string table template */
	var $table_template = null;
	
	/** @var string column to order by */
	var $order_by = null;
	
	/** @var string order by direction */
	var $order_dir = null;
	
	/** @var string defines how filters work either onchange or submit button to trigger filter form*/
	var $filter_action = null; 
	
	/** @var object the tables connection object */
	var $_oConn = null;
	
	
	/**
	* @param database A database connector object
	*/
	
	function mosForm_Table( &$db ) {	
			
		$this->mosDBTable( '#__mosform_tables', 'id', $db );
		
	}
	
	
	/**
	 * function get the tables connection object
	 * @return object connection
	 */
	function getThisConnection(){
		
		if(isset($this->_oConn)){
			
			return $this->_oConn;
			
		}else{
	
			global $database;
		
			$connId = $this->connection_id;
		
			$oConn = new mosForm_Connection( $database );
		
			$oConn->load($connId);
		
			$this->_oConn = $oConn;	
	
			return $this->_oConn;
			
		}
		
	}
	
	// overloaded check function
	function check() {
		
		return true;
		
	}
	
	
	/**
	 * gets the data associated with the table
	 * @param object database
	 * @param string column to order results by
	 * @param array contains ordering state - array(column=>direction)
	 * @param array filter data
	 * @param int number of records to return
	 * @param int record number to start at
	 * @return object element data
	 * 
	 */
	
	 function getElementData($mosformDb, $orderBy, $aOrder, $aFilters = array(), $limitLength ='', $limitStart =''){
	
		global $database;
		
		$sql = "select * from $this->db_table_name";	
	
		//filter the rows based on posted form data
		
		$i = 0;
		
		if(is_array($aFilters)){
			
			foreach($aFilters as $key=>$val){
				
				$filterType = $val['type'];
				
				$filterVal = $val['value'];
				
				$filterExactMatch = $val['match']; 
				
				if($filterVal != ""){
					
					if($filterType == 'field'){
						
						$cond = " $key like '%$filterVal%' ";
						
					}else{
						
						if($filterExactMatch == '0'){
							
							$cond = " $key like '%$filterVal%' ";
							
						}else{
							
							$cond = " $key = '$filterVal' ";
								
						}
						
					}
					
					if($i==0){
						
						$sql .= " where $cond";
						
					}else{
						
						$sql .= " and $cond" ;
						
					}
					
					$i ++;
				
				}
			
			}
	
		}

		if($orderBy != ""){
		
			$sql .= " order by $orderBy " . $aOrder[$orderBy];
			
			$sql .= " " . $this->order_dir;
		
		}else{
			
			if($this->order_by != ""){
				
				$sql .= " order by $orderBy " . $this->order_by;
				
				$sql .= " " . $this->order_dir;
				
			}
			
		}
		
		
		//set the limit data//
		
		if($limitLength <> ''){
			
			if($limitStart >= '0' ){
	
				$sql .= " limit $limitStart, $limitLength";
			}
			
		}
		
		echo "<!--" . str_replace("#_", "mos", $sql ) . "-->";

		$mosformDb->setQuery($sql);	
		
		return $mosformDb->loadObjectList();
		
	 }
	 
	  /**
	 * gets all filters based on the tableid
	 * @param object form group elements -generated from the function
	 * 'getFormGroups'
	 * @param array of objects, each element in the table
	 * @return object filter elements
	 */ 
	 
	function getTableFilters($formGroupEls){
		
		$oFilters = array();
	
		foreach($formGroupEls as $el){
			
			if($el->filter_type <> '' and $el->can_filter = '1'){

				$oFilters[] = $el;
			}
			
		}
		
		return $oFilters;
	}
	
	/**
	 * creates an array of htnml code for each filter
	 * @param array of elements used as filters
	 * @param object database 
	 * @param string table name
	 * @return array of html code for each filter
	 */
	 
	function makeFilters( $oFilters, $mosformDb, $table ){
		
		global $database;
		
		$aFilters = array();

		foreach($oFilters as $oFilter){
			
			$js = ""; 
			
			$elName = $oFilter->element_name;
			
			$elLabel = $oFilter->element_label;
			
			$elExactMatch = $oFilter->filter_exact_match;
			
			$v = $elName . "[value]";
			
			$t = $elName . "[type]";
			
			$e = $elName . "[match]";
			
			$default = $aFilter[$elName]['value'];
			
			$aThisFilter = array();
					
			if($oFilter->filter_type == "dropdown"){
				
				if( $oFilter->elementtype_id == '12'){
			
					$joinTable 	= $oFilter->join_db_name;
					
					$joinKey	= $oFilter->join_key_column;
					
					$joinVal	= $oFilter->join_val_column;
					
					$sql = "select distinct( $joinTable.$joinVal ) as elText, $table.$elName as elVal 
							from $table
							left join $joinTable 
							on $joinTable.$joinKey = $table.$elName
							 where trim($table.$elName) <> '' 
							order by $table.$elName asc";
					
				}else{
					
					$sql = "select distinct( $elName ) as elText, $elName as elVal  from $table where  trim($elName) <> '' order by $elName asc";
					
				}

				$mosformDb->setQuery($sql);
	
				$oDistinctData = $mosformDb->loadObjectList();
	
				$obj = new stdClass;
				
				$obj->elVal  = "";
				
				$obj->elText = _PLEASE_SELECT;
				
				$aThisFilter[] = $obj;
				
				$aThisFilter = array_merge( $aThisFilter, $oDistinctData );
				
				if($oTable->filter_action != 'submitform'){
				
					$js = ' onchange="submitMosformTable(\'filter\');"';
					
				}
				
				$aFilters[$elLabel] = mosHTML::selectList($aThisFilter , $v, 'class="inputbox" size="1" ' . $js , "elVal", 'elText', $default);
				
			}else{
				
				if($oTable->filter_action != 'submitform'){
				
					$js = "onchange=\"submitMosformTable('filter');";
					
				}
		
				$aFilters[$elLabel] = "<input type='field' name='$v' value='$default' $js \" />";		
				
			}
			
			$aFilters[$elLabel] .= "\n<input type='hidden' name='$t' value='$oFilter->filter_type' />\n";
			
			$aFilters[$elLabel] .= "\n<input type='hidden' name='$e' value='$elExactMatch' />\n";	
				
		}
		
		return $aFilters;
		
	}
	
	/**
	 * replaces the table column names with a safer name - ie removes white
	 * space and none alpha numeric characters
	 */
	 
	function makeSafeTableColumns(){
		
		global $database;
		
//		$connId = $this->connection_id;
//		
//		$oConn = new mosForm_Connection( $database );
//		
//		$oConn->load($connId);

		$oConn = $this->getThisConnection();
		
		$mosFormDatabase = $oConn->loadTableConnectionDB();
		
		$sql = "describe $this->db_table_name";
		
		$mosFormDatabase->setQuery( $sql );
		
		$origColNames = $mosFormDatabase->loadObjectList();
		
		foreach($origColNames as $origColName){
			
			$colName = $origColName->Field;
			
			$type = $origColName->Type;
			
			$newColName = preg_replace("/[^A-Za-z0-9]/", "_", $colName);
			
			if($colName != $newColName){
				
				$sql = "ALTER TABLE $this->db_table_name CHANGE `$colName` `$newColName` $type";
						
				$mosFormDatabase->setQuery($sql);
			
				if(!$mosFormDatabase->query()){
				
					echo "error for $sql <br>";
				
				}
			
			}		

		}	
		
	}
	
	/**
	 * get the tables primary key and if the primary key is auto increment
	 * @return mixed if ok returns array (key, extra, type, name) otherwise
	 * returns false
	 */
	 
	 function getPrimaryKeyAndExtra(){

		$oConn = $this->getThisConnection();
		
		$mosFormDatabase = $oConn->loadTableConnectionDB();
		
		$sql = "describe $this->db_table_name";
		
		$mosFormDatabase->setQuery( $sql );
		
		$origColNames = $mosFormDatabase->loadObjectList();
		
		foreach($origColNames as $origColName){
			
			$colName = $origColName->Field;
			
			$key = $origColName->Key;
			
			$extra = $origColName->Extra;
			
			$type = $origColName->Type;
			
			if($key == "PRI"){
				
				return array("key"=>$key, "extra"=>$extra, "type"=>$type, "colname"=>$colName);
				
			}	

		}	
		
		return false;
		
	 }
	 
	 /**
	  * adds a primary key to the database table
	  * @param string the column name to make into the primary key
	  * @param bol is the column an auto incrementing number
	  * @param string column type definition (eg varchar(255))
	  */
	  
	 function updatePrimaryKey( $fieldName, $autoIncrement, $type = 'int(11)' ){
	 	
	 	$oConn = $this->getThisConnection();
	 	
	 	$mosFormDatabase = $oConn->loadTableConnectionDB();
	 	
	 	$aPriKey = $this->getPrimaryKeyAndExtra();
	 	
	 	if(!$aPriKey){ // no primary key set so we should set it 
	 	
	 		$this->_addKey($fieldName, $autoIncrement, $mosFormDatabase, $type);
	 	
	 	}else{ // primary key already exists so we should drop it
	 		
	 		if($fieldName !=  $aPriKey['colname'] ){
	 			
	 			$this->_dropKey($aPriKey, $mosFormDatabase);
	 			
	 			$this->_addKey($fieldName, $autoIncrement, $mosFormDatabase, $aPriKey['type']);
		 		
	 		}		
	 		
	 	}
	 	
	 }
	 
	 /**
	  * internal function: add a key to the table
	  * @param string primary key column name
	  * @param bol is the column auto incrementing 
	  * @param object mosform database object
	  * @param string the primary keys column type 
	  */
	  
	 function _addKey($fieldName, $autoIncrement, $mosFormDatabase, $type = "INT(11)"){
	 	
 		$sql = "ALTER TABLE $this->db_table_name ADD PRIMARY KEY ($fieldName)"; //add a primary key
 		
 		$mosFormDatabase->setQuery($sql);
 		
 		$mosFormDatabase->query();	 	
	 	
	 	if($autoIncrement){
	 		
	 		$sql = "ALTER TABLE $this->db_table_name CHANGE $fieldName $fieldName " . $type .  "NOT NULL AUTO_INCREMENT"; //add the autoinc
	 		
	 		$mosFormDatabase->setQuery($sql);
	 		
	 		$mosFormDatabase->query();
		 	
	 	}	 	
	 }
	 
	 /**
	  * internal function: drop the table's key
	  * @param array existing key data
	  * @param object mosform database object
	  */
	  
	 function _dropKey($aPriKey, $mosFormDatabase){
	 	
	 	$sql = "ALTER TABLE $this->db_table_name CHANGE " . $aPriKey['key'] . $aPriKey['type'] . " NOT NULL"; //removes the autoinc
 		
 		$mosFormDatabase->setQuery($sql);
 		
 		$mosFormDatabase->query();
 		
 		$sql = "ALTER TABLE $this->db_table_name DROP PRIMARK KEY"; //drops the primary key
 		
 		$mosFormDatabase->setQuery($sql);
 		
 		$mosFormDatabase->query();	 
	 	
	 }
	 
}
?>
