<?php

/**
 * 
 * All rights reserved
 * Mambo Open Source is Free Software
 * License: http://www.gnu.org/copyleft/gpl.html
 * 
 * @package  mos_forms
 * @Copyright (C) Rob Clayburn
 * @version $Revision: 1.3 $
 */
 
 /**
  * php code to manipulate validations
  */
 
 require_once("../components/" . $option . "/mosform_validation.class.php");
//TODO: mosforms : 0.5 : state if the validation is server or client side
switch ($task) {
	case "new":

		addElementValidation($cid[0], $option);

		break;

	case "save":

		saveMosFormValidation($option, $act);

		break;

	case "remove":

		deleteElementValidation( $cid, $option, $act );
		
	case "edit":
	
		addElementValidation( $cid[0], $option );

		break;		

	default:

		viewElementValidation( $option );

		break;
} 
		
/**
* Add an element verification
* @param integer validation id
* @param string component name
*/
function addElementValidation($validation_id = 0, $option)
{
	global $database, $my;	
	
	$row = new mosForm_Validation($database);

	$row->load($validation_id); 
	
	// fail if checked out not by 'me'
	//if ($row->checked_out && $row->checked_out <> $my->id) {
	//	mosRedirect("index2.php?option=$option&scope=$row->scope&mosmsg=This form Validation is currently being edited by another administrator");
	//} 
	// if you are editing a Validation then $Validation_id will be set, thus you can check it out to avoid other people editing it at the same time. //
	if ($validation_id) {
		
		$row->checkout($my->id); // $my->id is the id of the current user //
		
	} 

	$sql = "select id as value, validation_rule_label as text from #__mosform_validation_rules";
	
	$database->setQuery($sql);
	
	$validationrules = $database->loadObjectList();
	
	echo $database->getErrorMsg();
	
	$validationrulelist = mosHTML::selectList($validationrules, 'validation_rule_id', "class=\"inputbox\"  size=\"1\" ", 'value', 'text', $row->validation_rule_id);
	
	$sql = "select id as value, element_name as text from #__mosform_elements";
	
	$database->setQuery($sql);
	
	$elements = $database->loadObjectList();

	echo $database->getErrorMsg() . "\n";
		
	$element_list = mosHTML::selectList($elements, 'element_id', "class=\"inputbox\"  size=\"1\"", 'value', 'text', $row->element_id);

	html_validation_content::AddElementValidation($validationrulelist, $option, $validation_id, $element_list, $row);
	
} 	

/**
* Save an element validation
* @param string component name
*/

function saveMosFormValidation($option){

	global $database;
	
	$row = new mosForm_Validation($database);

	if (!$row->bind($_POST)) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 
	
	if (!$row->store()) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	viewElementValidation($option);
} 

/**
* delete an element verification
* @param integer verification id
* @param string component name
* @param string action
*/

function deleteElementValidation($cid, $option, $act){

	global $database;

	if (is_array($cid)) {

		foreach ($cid as $id) {
			
			$sql = "delete from #__mosform_validations where id = '$id'";
			
			$database->setQuery($sql);
			
			if (!$database->query()) {
		
				echo $database->getErrorMsg() . "\n";
		
			} 

		} 
		
	} 

	mosRedirect("index2.php?option=$option&act=$act");

} 

/**
* View element validataions
* @param string component name
*/

function viewElementValidation($option){

	require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
	
	global $database, $mosConfig_list_limit, $mainframe	; 

	$sql = "SELECT * from #__mosform_validations as v
	LEFT JOIN #__mosform_validation_rules as r
	on v.validation_rule_id = r.id 
	LEFT JOIN #__mosform_elements as e
	ON v.element_id = e.id
	";
				
	$database->setQuery($sql);
	
	$validations = $database->loadObjectList();
	
	echo $database->getErrorMsg();
	
	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
	
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}{validations}limitstart", 'limitstart', 0 );
	
	$sql = "select count(*) from #__mosform_validations";
	
	$database->setQuery($sql);
	
	$total = $database->loadResult();
	
	$pageNav = new mosPageNav($total, $limitstart, $limit);

	html_validation_content::ShowAllValidations($validations, $option, $pageNav);
} 	