<?php 

/**
 * Sections admin event handler
 * All rights reserved
 * Mambo Open Source is Free Software
 * Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
 * 
 * @package  MosForms
 * @Copyright (C) Rob Clayburn
 * @version $Revision: 1.2 $
 * 
 * Special thanks to Matthijs Wensveen for the extra work getting reg
 * expressions working :D
 */

require_once("../components/" . $option . "/mosform_validation_rule.class.php");

switch ($task) {
	case "new":
		addValidationRule($cid[0], $option);
		break;

	case "save":
		saveValidationRule($option, $act);
		break;

	case "remove":
		deleteValidationRule($cid, $option, $act);
		break;
		
	case "edit":
		addValidationRule($cid[0], $option);
		break;		

	default:
		viewValidationRules($option);
		break;
} 
		
		
/**
* Add a validation rule
* @param integer validationrule id
* @param string component name
*/

function addValidationRule($id = 0, $option) {
	global $database, $my;	

	$row = new mosForm_Validation_rule($database);

	$row->load($id);

	/* checkout not supported by table	 
	if ($id) {
		$row->checkout($my->id); // $my->id is the id of the current user //
	}
	*/
	
	html_validationrules_content::AddValidationRule($option, $id, $row);
} 

/**
* Save a validation rule
* @param string component name
*/
function saveValidationRule($option){

	global $database;
	
	$row = new mosForm_Validation_rule($database);
	
	if (!$row->bind($_POST)) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 
	
	if (!$row->store()) {
		echo "<script> alert('" . $row->getError() . "'); window.history.go(-1); </script>\n";

		exit();
	} 

	viewValidationRules($option);
} 

/**
* delete a validation rule
* @param integer verification id
* @param string component name
* @param string action
*/
function deleteValidationRule($cid, $option, $act){

	global $database;

	if (is_array($cid)) {

		foreach ($cid as $id) {
			
			$sql = "delete from #__mosform_validation_rules where id = '$id'";
			
			$database->setQuery($sql);
			
			if (!$database->query()) {
		
				echo $database->getErrorMsg() . "\n";
		
			} 

		} 
		
	} 

	mosRedirect("index2.php?option=$option&act=$act");
}

/**
* View validation rules
* @param string component name
*/
function viewValidationRules($option) {

	require_once( $GLOBALS['mosConfig_absolute_path'] . '/administrator/includes/pageNavigation.php' );
	
	global $database, $mosConfig_list_limit, $mainframe	; 

	$sql = "SELECT * FROM #__mosform_validation_rules";
	
	$database->setQuery($sql);
	$validation_rules = $database->loadObjectList();
	//print_r($validation_rules);
	echo $database->getErrorMsg();
	
	//echo $sql;
	$limit = $mainframe->getUserStateFromRequest( "viewlistlimit", 'limit', $mosConfig_list_limit );
	
	$limitstart = $mainframe->getUserStateFromRequest( "view{$option}{validation_rules}limitstart", 'limitstart', 0 );
	
	$sql = "select count(*) from #__mosform_validation_rules";
	
	$database->setQuery($sql);
	
	$total = $database->loadResult();
	
	$pageNav = new mosPageNav($total, $limitstart, $limit);

	html_validationrules_content::ShowAllValidationRules($validation_rules, $option, $pageNav);
} 