<?php
/**
* Xaneon Extensions 2.0 for Mambo 4.5.2
* @copyright (c) 2004-2005 Xaneon Development (dev.xaneon.com)
* @license XPL http://dev.xaneon.com/xpl/
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

// The Resolver handles incoming requests.

class xeSEFResolver extends xeObject {
  var $automapper = null;
  var $input = null;
  var $output = null;
  var $params = null;
  var $status = null;

  function xeSEFResolver( &$db, &$config, &$site ) {
    $this->xeObject( $db, $config, $site );
    $this->params = array();
    $this->log = array();
    $this->status = 200;
  }

  function setAutoMapper( &$object ) {
    $this->automapper =& $object;
  }

  function getOutput() {
    return $this->output;
  }

  function getStatus() {
    return $this->status;
  }

  function getQueryString() {
    if (is_array( $this->params ) && count( $this->params ) > 0) {
      $result = array();
      foreach ($this->params as $param => $value)
        $result[] = $param . '=' . $value;
      return implode( '&', $result );
    }
    return '';
  }

  function loadCaches() {
    // TODO: PHP serialization?
    //require_once( $sefAdminPath . '/cache.aliases.php' );
    //require_once( $sefAdminPath . '/cache.rules.php' );
  }

  function parse( $url ) {
    // URL NORMALIZATION
    if (strpos( $url, '?' ) !== false) {
      $split = explode( '?', $url, 2 );
      $this->output = $split[0];
      if (count( $split ) > 1) {
        parse_str( $split[1], $this->params );
      }
    }
    else {
      $this->output = $url;
    }
  }

  function resolve( $url ) {
    $input = $this->site->getRelativeURL( $url );

    if ($this->debug) {
      $this->log( '--- Initializing SEF resolver: ' . get_class( $this ) );
      $this->log( "'$url' => '$input' (relative site URL)" );
    }

    $resolved = $this->input( $input );

    if (!$resolved || $this->status >= 400) {
      if (!empty( $this->config->validate_level )) {
        // 3PD and site admins can use the following to check for error
        // 404 in, for example, modules or the site template.
        if (!defined( '_XE_404_NOTFOUND' ))
          define( '_XE_404_NOTFOUND', 1 );
        if (!$this->debug) {
          $this->error404( $input );
        }
        else {
          $this->log( '--- Error: 404 Not Found' );
        }
      }
      return;
    }
    else if (sefIsExternalURL( $this->output )) {
      // External address; clean up output buffers and send an HTTP redirect.
      if (!$this->debug) {
        while (@ob_end_clean());
        if ($this->status != 200 && !headers_sent())
          header( 'HTTP/1.1 301 Moved Permanently' );
        die( mosRedirect( $this->output ) );
      }
      else {
        $this->log( '--- Redirecting to: ' . $this->output );
      }
    }
    else if (sefIsMamboURL( $this->output )) {
      if ($this->debug) {
        $params = $this->getQueryString();
        $this->log( '--- Internal URL: ' . $this->output . ($params ? '?' . $params : '') );
      }
      $this->activate();
      return true;
    }

  }

  function input( $input, $params = null ) {
    $this->input = $input;
    $this->parse( $this->input );

    if ($this->debug) {
      $msg = "--- Resolving: '$this->input'";
      //if ($this->input != $this->output);
      $this->log( $msg );
    }

    // Check whether Search Engine Friendly URLs have been enabled in Mambo's
    // Global Configuration. This setting is found under the SEO tab.
    if (!empty( $GLOBALS['mosConfig_sef'] ) && sefIsMamboSEF( $this->output )) {
      // TODO: write code to preserve any extra URL parameters.
      $url = '/' . sefRewriteFromMamboSEF( $this->output );
      $this->parse( $url );
      if ($this->debug) $this->log( "'$this->input' => '$url' (Mambo SEF)" );
      $this->input = $url;
    }

    // MAMBO URL
    if (sefIsMamboURL( $this->output )) {
      if ($this->debug)
        $this->log( "'$this->output' is an internal Mambo URL" );
      if (($result = $this->resolveMamboURL()))
        return $result;
    }

    // ALIAS LOOKUP
    if (($alias = $this->lookupIncoming( $this->output )) != null) {
      if ($this->debug)
        $this->log( "'$this->output' => '$alias->internal' (incoming alias lookup)" );
      if (($result = $this->resolveAlias( $alias ))) {
        if (!sefIsExternalURL( $this->output ))
          $this->parse( '/' . $this->output );
        return $result;
      }
    }
    else if ($this->debug) {
      $this->log( "'$this->output' not matched by incoming alias lookup" );
    }

    // WEBSITE ROOT
    if ($this->output == '/') {
      if ($this->debug)
        $this->log( "'$this->output' is the root URL for the site" );
      return true;
    }

    // COMPONENT LOOKUP
    if (($component = $this->lookupComponent( $this->output )) != null) {
      if ($this->debug)
        $this->log( "'$this->output' is a component URL ($component->component)" );
      if (($result = $this->resolveComponent( $component ))) {
        $this->parse( $this->output );
        return $result;
      }
    }
    else if ($this->debug) {
      $this->log( "'$this->output' not matched by component alias lookup" );
    }

    // If we've reached the end of the rewriting process without a result,
    // we need to let the caller know in order to do URL Validation.

    if ($this->debug)
      $this->log( "'$this->output' was NOT resolved" );

    if (!empty( $this->config->record_invalid_urls )) {
      if ($this->debug)
        $this->log( "'$this->output' recorded as invalid URL" );
      mosSEFAlias::recordHit( $this->site->id, $this->output, false );
    }

    return false;
  }

  function mapContent( $url ) {
    if (is_object( $this->automapper ))
      return $this->automapper->map( $url );
    return null;
  }

  function lookupIncoming( $lookup ) {
    return mosSEFAlias::lookupIncoming( $this->site->id, $lookup );
  }

  function lookupOutgoing( $lookup ) {
    return mosSEFAlias::lookupOutgoing( $this->site->id, $lookup );
  }

  function lookupComponent( $lookup ) {
    return mosSEFComponent::lookupByURL( $this->site->id, $lookup );
  }

  function resolveAlias( &$alias ) {
    if (strlen( $alias->internal ) > 0
        && !empty( $alias->published ) && !empty( $alias->valid )) {

      $this->output = $alias->internal;

      if (!empty( $this->config->record_hits )) {
        if ($this->debug)
          $this->log( "'$alias->external' hit count increased (record hits enabled)" );
        $alias->hit();
      }

    }
    else {

      if ($this->debug) {
        $errors = array();
        if (strlen( $alias->internal ) == 0)
          $errors[] = "no internal URL";
        if (empty( $alias->valid ))
          $errors[] = "invalid";
        if (empty( $alias->published ))
          $errors[] = "not published";
        $this->log( "'$alias->external' fails URL validation (" .
          implode( ', ', $errors ) . ')' );
      }

      $this->status = 404;

      if (!empty( $this->config->record_hits )
          || !empty( $this->config->record_invalid_urls )) {
        if ($this->debug)
          $this->log( "'$alias->external' hit count increased (record hits or record invalid enabled)" );
        $alias->hit();
      }

    }

    return true;
  }

  function resolveComponent( $c ) {
    $component = str_replace( 'com_', '', $c->component );
    $params = substr( $this->output, strlen( '/' . $c->alias . '/' ) );
    $this->output = '/index.php?option=com_' . $component .
      '&Itemid=' . $c->menu_id;

    if ($params) {
      xeLoadSEFExtension( $component );
      $class = 'sef_' . $component;
      if (!empty( $this->config->use_sef_ext ) && class_exists( $class )
          && is_callable( array($class, 'revert') )) {
        $pos = substr_count( $c->alias, '/' );
        $url_array = array_merge(
          array('component'),
          explode( '/', $c->alias ),
          explode( '/', $params )
        );
        if (($url = call_user_func( array($class, 'revert'), $url_array, 0 )) != '')
          $this->output .= ($url[0] != '&' ? '&' . $url : $url);
      }
      else {
        $this->output .= '&' . str_replace( '/', '&', str_replace( ',', '=', $params ) );
      }
    }

    return true;
  }

  function resolveMamboURL() {
    // Special case for calls to just index.php
    if ($this->input == '/index.php'
        && !empty( $this->config->use_canonical_urls )) {
      $this->output = $this->site->getSiteURL() . '/';
      $params = $this->getQueryString();
      $this->output .= ($params ? '?' . $params : '');
      $this->status = 301; // Permanent redirect
      if ($this->debug)
        $this->log( "'/index.php' => '$this->output' (enforce canonical URLs)" );
      return true;
    }

    if (array_key_exists( 'option', $this->params )) {
      $option = $this->params['option'];
      if ($option == 'com_content') {
        if ($this->debug)
          $this->log( "'$this->input' is a Mambo content URL" );
        return $this->resolveContentURL();
      }
      else {
        if ($this->debug)
          $this->log( "'$this->input' is a Mambo component URL ($option)" );
        // TODO: URL Validation in lockdown mode.
        return true;
      }
    }

    // If we got here, we're probably dealing with some special URL
    // such as registration etc.
    return true;
  }

  function resolveContentURL() {
    $params =& $this->params;

    if (array_key_exists( 'task', $params )
        && ($params['task'] == 'new' || $params['task'] == 'edit')) {
      if ($this->debug)
        $this->log( "'$this->output' is a Mambo content editing URL, no further action" );
      return true;
    }

    // TODO: take into account any non-Mambo URL parameters in the content URL.
    // This will require reconstructing the internal URL from predefined set of params.

    // Strip preceding slash and do a reverse alias lookup
    $url = substr( $this->input, 1 );
    $alias = $this->lookupOutgoing( $url );

    if ($alias != null) {
      if ($this->debug) {
        $url = ($alias->external ? $alias->external : $alias->internal);
        $this->log( "'$this->input' => '$url' (reverse alias lookup)" );
      }

      if (!empty( $alias->valid ) && $alias->external != ''
          && !empty( $this->config->use_canonical_urls )) {
        $this->output = $this->site->getSiteURL();
        $this->output .= $alias->external;
        $this->status = 301; // Permanent redirect
        if ($this->debug)
          $this->log( "'$this->input' => '$this->output' (enforcing canonical URLs)" );
        return true;
      }

      if (!empty( $this->config->record_hits )) {
        if ($this->debug)
          $this->log( "'$this->input' hit count increased (record hits enabled)" );
        $alias->hit();
      }

      if (empty( $alias->valid )) {
        if ($this->debug)
          $this->log( "'$this->input' fails URL validation (marked as invalid)" );
        $this->status = 404;
        return true;
      }

    }
    else if (!empty( $this->config->use_automap )) {

      $alias = $this->mapContent( $url );
      if (is_object( $alias ) && $alias->external != ''
          && !(empty( $alias->valid ) || empty( $alias->published ))) {
        if ($this->debug)
          $this->log( "'$this->input' => '$alias->external' (automapping)" );

        if (!empty( $this->config->use_automap_redirect )) {
          $this->output = $this->site->getSiteURL();
          $this->output .= $alias->external;
          return true;
        }

      }
      else if ($this->debug) {
        $this->log( "'$this->input' failed automapping but was recorded" );
      }

    }
    else if (!empty( $this->config->record_unmapped_urls )) {

      mosSEFAlias::recordHit( $this->site->id, $this->input, true );
      // TODO: URL Validation in lockdown mode.

      if ($this->debug)
        $this->log( "'$this->input' recorded as undefined URL" );

    }

    return true;
  }

  function activate() {
    global $REQUEST_URI, $QUERY_STRING;
    $url = $this->output;
    $queryStr = $this->getQueryString();
    $urlInfo = explode( '?', $url, 2 );
    $url = $urlInfo[0];
    if (count( $urlInfo ) > 1) {
      $queryStr = (!$queryStr ? $urlInfo[1] :
        $urlInfo[1] . "&" . $queryStr);
    }
    $request = $this->site->base_url . ($url[0] != '/' ? '/' : '') . $url;
    if ($queryStr) $request .= '?' . $queryStr;
    $_SERVER["REQUEST_URI"] = $REQUEST_URI = $request;
    $_SERVER["QUERY_STRING"] = $QUERY_STRING = $queryStr;
    $params = array();
    parse_str( $queryStr, $params ); // TODO: magic_quotes_gpc?
    if (count( $params ) > 0) {
      foreach ($params as $name => $value) {
        $_GET[$name] = $_REQUEST[$name] = $value;
        $GLOBALS[$name] = $value;
      }
    }
  }

  function error404( $requestURL ) {
    $errorHeader = 'HTTP/1.1 404 Not Found';
    $errorURL = $this->config->validate_404_url;
    if (!$errorURL) {
      $language = ($GLOBALS['mosConfig_lang'] != '' ?
        $GLOBALS['mosConfig_lang'] : 'english');
      @include_once( 'language/' . $language . '.php' );
      while (@ob_end_clean());
      header( $errorHeader );
      die( defined( '_NOT_EXIST' ) ? _NOT_EXIST : '404 Not Found' );
    }
    else {
      if (strpos( $errorURL, '://') === false) {
        header( $errorHeader );
        /*if (is_numeric( $errorURL )) {
          // TODO: need to get Itemid from somewhere or we'll get
          // an 'authentication required' message.
          sefSetURL( $this->site, 'index.php',
            'option=com_content&Itemid=0&task=view&id=' . $errorURL );
        }
        else {*/
          $this->output = $errorURL;
          $this->activate();
        //}
      }
      else {
        // Prevent infinite recursion; trust that the URL the user entered as
        // the error page is indeed valid and that Mambo will accept it.
        // TODO: multisites support.
        if ($errorURL != $GLOBALS['mosConfig_live_site'] . $requestURL) {
          while (@ob_end_clean());
          die( mosRedirect( $errorURL ) );
        }
      }
    }
  }

}

?>