<?php
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' ); 
/**
* @version $Id: phpshop_parser.php,v 1.22 2005/06/20 19:56:56 soeren_nb Exp $
* @package mambo-phpShop
* @subpackage Core
* Contains code from PHPShop(tm):
* 	@copyright (C) 2000 - 2004 Edikon Corporation (www.edikon.com)
*	Community: www.phpshop.org, forums.phpshop.org
* Conversion to Mambo and the rest:
* 	@copyright (C) 2004-2005 Soeren Eberhardt
*
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* mambo-phpShop is Free Software.
* mambo-phpShop comes with absolute no warranty.
* PHPshop parser code
* www.mambo-phpshop.net
*/

/** 
* This file has nearly the same functionality as the old phpShop Parser - index.php -
*/
if( !defined( 'CLASSPATH' )) {

    global $my, $db, $perm, $ps_function, $ps_module, $ps_html, $ps_vendor_id, $vendor_image,$vendor_image_url,$mosConfig_absolute_path,
            $ps_payment_method,$ps_zone,$sess, $page, $func, $pagename, $modulename, $vars, $PHPSHOP_LANG, $cmd, $ok, $mosConfig_lang,
            $auth, $ps_checkout,$error, $error_type, $func_perms, $func_list, $func_class, $func_method, $func_list, $dir_list, 
            $vendor_currency_display_style, $vendor_freeshipping, $mm_action_url;
    
    // load mosAbstractLanguage
    require_once($mosConfig_absolute_path. '/administrator/components/com_phpshop/mos_4.6_code.php');
    
    // the configuration file for PHPShop
    require_once( $mosConfig_absolute_path. "/administrator/components/com_phpshop/phpshop.cfg.php");
    
    // load the Language File
    if (file_exists( ADMINPATH. 'languages/'.$mosConfig_lang.'.php' ))
        require_once( ADMINPATH. 'languages/'.$mosConfig_lang.'.php' );
    else
        require_once( ADMINPATH. 'languages/english.php' );
    
    /** @global phpShopLanguage $PHPSHOP_LANG */
    $GLOBALS['PHPSHOP_LANG'] =& new phpShopLanguage();
    
    /** @global Array $product_info: Stores Product Information for re-use */
    $GLOBALS['product_info'] = Array();
    
    /** @global Array $category_info: Stores Category Information for re-use */
    $GLOBALS['category_info'] = Array();
    
    /** @global Array $category_info: Stores Vendor Information for re-use */
    $GLOBALS['vendor_info'] = Array();
    
    // load the MAIN CLASSES
    // CLASSPATH is defined in the config file
    require_once(CLASSPATH."ps_database.php");
    require_once(CLASSPATH."ps_main.php");
    require_once(CLASSPATH."ps_html.php");
    require_once(CLASSPATH."ps_session.php");
    require_once(CLASSPATH."ps_function.php");
    require_once(CLASSPATH."ps_module.php");
    require_once(CLASSPATH."ps_perm.php");
    require_once(CLASSPATH."ps_user.php");
    require_once(CLASSPATH."ps_user_address.php");
    require_once(CLASSPATH."ps_shopper_group.php");
    require_once(CLASSPATH."phpInputFilter/class.inputfilter.php");
    
    // Instantiate the DB class
    $db = new ps_DB;
    // Instantiate the permission class
    $perm = new ps_perm;
    // Instantiate the permission class
    $ps_html = new ps_html;
    // Instantiate the session class
    $sess = new ps_session;
    // Instantiate the module class
    $ps_module = new ps_module;
    // Instantiate the function class
    $ps_function = new ps_function;
    // Instantiate the ps_shopper_group class
    $ps_shopper_group = new ps_shopper_group;
        
    // Set the mosConfig_live_site to its' SSL equivalent
    if( $_SERVER['SERVER_PORT'] == 443 || strstr( "checkout.", $page )) {
      $GLOBALS['mosConfig_live_site'] = str_replace("http://", "https://", $GLOBALS['mosConfig_live_site']);
      $mm_action_url = SECUREURL;
    }
    else {
      $mm_action_url = URL;
    }
    
    // Enable Mambo Debug Mode when Shop Debug is on
    if( DEBUG == "1" ) {
        $GLOBALS['mosConfig_debug'] = 1;
        $database->_debug = 1;
    }
    
    // IMPORTANT! mambo-phpShop needs this session
    // to keep the Cart contents
    if (!defined('_PSHOP_ADMIN')) {
    
      // Set Mambo's Cookies for the SSL Domain as well
      // This makes it possible to use Shared SSL
      $sess->prepare_SSL_Session();
      
      if( empty($_SESSION)) {
       //Session not yet started!";
          session_name( 'phpshop' );
          session_start();
          if( !empty($_SESSION) && !empty($_COOKIE['phpshop'])) {
            echo DEBUG ? '<div style="border: green 2px solid;padding: 3px;margin: 2px;"><strong>Shop Debug:</strong> A Session called <i>phpShop</i> was successfully started!</div>' : '';
          }
      }
      else
          echo DEBUG ? '<div style="border: orange 2px dotted;padding: 3px;margin: 2px;"><strong>Shop Debug:</strong> A Session had already been started...you seem to be using SMF, phpBB or another Sesson based Software.</div>' : '';
      if( empty($_COOKIE['phpshop'] )) {
        setCookie( 'phpshop', md5(uniqid('phpshop')) );
        echo DEBUG ? '<div style="border: red 2px dotted;padding: 3px;margin: 2px;"><strong>Shop Debug:</strong> A phpShop Cookie had to be set (there was none - does your Browser keep the Cookie?) although a Session already has been started! If you see this message on each page load, your browser doesn\'t accept Cookies from this site.</div>' : '';
      }
      
    }
    // the global file for PHPShop
    require_once( ADMINPATH . 'global.php' );
    
    $curreny_display =& vendor_currency_display_style( $vendor_currency_display_style );
    /** load Currency Display Class **/
     require_once( CLASSPATH.'class_currency_display.php' );
    /** @superglobal CurrencyDisplay $CURRENCY_DISPLAY */
    $GLOBALS['CURRENCY_DISPLAY'] =& new CurrencyDisplay($curreny_display["id"], $curreny_display["symbol"], $curreny_display["nbdecimal"], $curreny_display["sdecimal"], $curreny_display["thousands"], $curreny_display["positive"], $curreny_display["negative"]);
    
    // some input validation for limitstart
    if (!empty($_REQUEST['limitstart'])) {
      if (is_string($_REQUEST['limitstart']) and $_REQUEST['limitstart'] == (string)(int) $_REQUEST['limitstart']) {
          $_SESSION['limitstart'] = $_REQUEST['limitstart'];
       }
       else die('Please provide a valid value for limitstart');
    }
    else
      $_SESSION['limitstart'] = 0;
      
    $mosConfig_list_limit = isset( $mosConfig_list_limit ) ? $mosConfig_list_limit : SEARCH_ROWS;
    
    $_SESSION['session_userstate']['limitstart'] = $limit = mosgetparam($_REQUEST, 'limit', $mosConfig_list_limit);
    $_SESSION['session_userstate']['limitstart'] = $limitstart = mosgetparam($_REQUEST, 'limitstart', 0);
    $_SESSION['session_userstate']['keyword'] = $keyword = urldecode(mosgetparam($_REQUEST, 'keyword', ''));
    $_SESSION['session_userstate']['category_id'] = $category_id = mosgetparam($_REQUEST, 'category_id', 0);
    $_SESSION['session_userstate']['product_id'] = $product_id = mosgetparam($_REQUEST, 'product_id', 0);
    
    $user_id = mosgetparam($_REQUEST, 'user_id', 0);
    $user_info_id = mosgetparam($_REQUEST, 'user_info_id', 0);
    $page = mosgetparam($_REQUEST, 'page', "");
    $func = mosgetparam($_REQUEST, 'func', "");
    
    // basic SQL inject detection
    $my_insecure_array = array('keyword' => $keyword,
                    'category_id' => $category_id,
                    'product_id' => $product_id,
                    'user_id' => $user_id,
                    'user_info_id' => $user_info_id,
                    'page' => $page,
                    'func' => $func);
                    
    while(list($key,$value)=each($my_insecure_array)) {
        if (stristr($value,'FROM ') ||
            stristr($value,'UPDATE ') ||
            stristr($value,'WHERE ') ||
            stristr($value,'ALTER ')  ||
            stristr($value,'SELECT ')  ||
            stristr($value,'SHUTDOWN ') ||
            stristr($value,'CREATE ') ||
            stristr($value,'DROP ') ||
            stristr($value,'DELETE FROM') ||
            stristr($value,'script') ||
            stristr($value,'<>') ||
            //stristr($value,'=') ||
            stristr($value,'SET ')) 
                die('Please provide a permitted value for '.$key);
    }
    
    $vars = $_REQUEST;
    
    // Register the cart
    if (empty($_SESSION["cart"])) {
        $cart = array();
        $cart["idx"] = 0;
        $_SESSION["cart"] = $cart ;
    } 
    else {
     if( ( @$_SESSION['auth']['user_id'] != @$my->id ) && empty( $my->id ) ) {
        session_name( 'phpshop' );
        session_destroy();
        $cart = array();
        $cart["idx"] = 0;
        $_SESSION["cart"] = $cart ;
     }
     else {
        $cart = $_SESSION["cart"];
      }
    }
    
    /**************************************************
    ** Register the auth array for user authentication
    **************************************************/
    unset ($auth);
    
    $auth = array();
    
    $shopper_group = $ps_shopper_group->get_shoppergroup_by_id( $my->id );
    
    if (!empty($my->id)) { // user has already logged in
      
        $auth["user_id"]   = $my->id;
        $auth["username"] = $my->username;
        
        if ($perm->is_registered_customer($my->id)) {
        
            $q = "SELECT perms,first_name,last_name,country,zip FROM #__users WHERE id='".$my->id."'";
            $db->query($q);
            $db->next_record();
        
            switch ($db->f("perms")) {
                case "admin": 
                    $auth["perms"]  = "admin";
                    break;
                case "storeadmin":
                    $auth["perms"]  = "storeadmin";
                    break;
                case "shopper":
                    $auth["perms"]  = "shopper";
                    break;
                case "demo":
                    $auth["perms"]  = "demo";
                    break;
            }
            $auth["first_name"] = $db->f("first_name");
            $auth["last_name"] = $db->f("last_name");
            $auth["country"] = $db->f("country");
            $auth["zip"] = $db->f("zip");
            
            if (stristr($my->usertype,"Administrator"))
              $auth["perms"]  = "admin";
            elseif (stristr($my->usertype,"Manager")) 
              $auth["perms"]  = "storeadmin";
            $auth["shopper_group_id"] = $shopper_group["shopper_group_id"];
            $auth["shopper_group_discount"] = $shopper_group["shopper_group_discount"];
            $auth["show_price_including_tax"] = $shopper_group["show_price_including_tax"];
            $auth["default_shopper_group"] = $shopper_group["default_shopper_group"];
            $auth["is_registered_customer"] = true;
        }
        
        // user is no registered customer
        else {
            if (stristr($my->usertype,"Administrator"))
              $auth["perms"]  = "admin";
            elseif (stristr($my->usertype,"Manager")) 
              $auth["perms"]  = "storeadmin";
            else
              $auth["perms"]  = "shopper"; // DEFAULT
            $auth["shopper_group_id"] = 0;
            $auth["shopper_group_discount"] = $shopper_group["shopper_group_discount"];
            $auth["show_price_including_tax"] = $shopper_group["show_price_including_tax"];
            $auth["default_shopper_group"] = 1;
            $auth["is_registered_customer"] = false;
         }
        
      } // user is not logged in
      else { 
      
        $auth["user_id"] = 0;
        $auth["username"] = "demo";
        $auth["perms"]  = "";
        $auth["first_name"] = "guest";
        $auth["last_name"] = "";
        $auth["shopper_group_id"] = 0;
        $auth["shopper_group_discount"] = $shopper_group["shopper_group_discount"];
        $auth["show_price_including_tax"] = $shopper_group["show_price_including_tax"];
        $auth["default_shopper_group"] = 1;
        $auth["is_registered_customer"] = false;
      }
      
      // register $auth into SESSION
      $_SESSION["auth"] = $auth;
    
    
    /**********************************************
    ** Get Function Permissions
    ** defines _CAN_RUN_FUNC if function is registered 
    ** and user has permission to run it
    ** Displays error if function is not registered
    ************************************************/
    if (!empty($func)) {
    
        $func_list = $ps_function->get_function($func);
        if ($func_list) {
            if ($perm->check($func_list["perms"])) {
                define( "_CAN_RUN_FUNC", "1");
            $func_perms = $func_list[ 'perms' ];
            $func_class = $func_list[ 'class' ];
            $func_method = $func_list[ 'method' ];      
        }
        else {
            $error_type = $PHPSHOP_LANG->_PHPSHOP_PAGE_403;
            $error = $PHPSHOP_LANG->_PHPSHOP_FUNC_NO_EXEC . $func;
            $page = ERRORPAGE;          
            define( '_CANNOT_RUN_FUNC', '1');
        }
      }
      else {
        $error_type = $PHPSHOP_LANG->_PHPSHOP_FUNC_NOT_REG;
        $error = $func . $PHPSHOP_LANG->_PHPSHOP_FUNC_ISNO_REG ;
        $page = ERRORPAGE;    
        define( '_CANNOT_RUN_FUNC', '0');
      }
    }
    /**********************************************
    ** Get Page/Directory Permissions
    ** Displays error if directory is not registered, 
    ** user has no permission to view it , or file doesn't exist
    ************************************************/
    
    if (empty($page)) {// default page
      if (defined('_PSHOP_ADMIN'))
        $page = "store.index";
      else
        $page = HOMEPAGE;
    
    }
    
    // "shop.browse" => module: shop, page: browse
    $my_page= explode ( '.', $page );
    $modulename = $my_page[0];
    $pagename = $my_page[1];
    
    $ok = false;
    $dir_list = $ps_module->get_dir($modulename);
    
    if ($dir_list) {
        if ($perm->check($dir_list[ 'perms' ])) {
            if (!file_exists(PAGEPATH.$modulename.".".$pagename.".php")) {
                $error_type = $PHPSHOP_LANG->_PHPSHOP_PAGE_404_1;
                $error = $PHPSHOP_LANG->_PHPSHOP_PAGE_404_2 ."<br />";
                $error .= $modulename.".".$pagename.".php";
                $page = ERRORPAGE;
                      define ( '_DONT_VIEW_PAGE', '1');
            }
        }
        else {
            $error = $PHPSHOP_LANG->_PHPSHOP_MOD_NO_AUTH;
            $page = ERRORPAGE;
            define ( '_DONT_VIEW_PAGE', '2');
        }
        // Load MODULE-specific CLASS-FILES
        include_class ( $modulename );
    }
    else {
        $error_type = $PHPSHOP_LANG->_PHPSHOP_MOD_NOT_REG;
        $error = $modulename . $PHPSHOP_LANG->_PHPSHOP_MOD_ISNO_REG;
        $page = ERRORPAGE;
        define ( '_DONT_VIEW_PAGE', '3');
    }
    
    if (defined( '_CAN_RUN_FUNC' )) {
    
        $q = "SELECT #__pshop_module.module_name,#__pshop_function.function_class"; 
        $q .= " FROM #__pshop_module,#__pshop_function WHERE ";
        $q .= "#__pshop_module.module_id=#__pshop_function.module_id AND ";
        $q .= "#__pshop_function.function_method='$func_method' AND ";
        $q .= "#__pshop_function.function_class='$func_class'";
        $db->setQuery($q);
        $db->query();
        $db->next_record();
        // Load class definition file
        require_once( CLASSPATH.$db->f("function_class").".php" );
        
        // create an object
        $string = "\$" . $func_class . " = new " . $func_class . ";";
        eval( $string );
      
        // RUN THE FUNCTION
        $cmd = "\$ok = \$" . $func_class . "->" . $func_method . "(\$vars);";
        eval( $cmd );
     
        if ($ok == false) {
            $no_last = 1;
            if( $_SESSION['last_page'] != HOMEPAGE )
                $page = $_SESSION['last_page'];
            $my_page= explode ( '.', $page );
            $modulename = $my_page[0];
            $pagename = $my_page[1];
            $_REQUEST['keyword']= $_SESSION['session_userstate']['keyword'];
            $_REQUEST['category_id']= $_SESSION['session_userstate']['category_id'];
            $_REQUEST['product_id']=$product_id = $_SESSION['session_userstate']['product_id'];
            $_REQUEST['limitstart']=$limitstart = $_SESSION['session_userstate']['limitstart'];
            $_REQUEST['limit']= $limit = @$_SESSION['session_userstate']['limit'];
        }
        
        if (!empty($vars["error"]))
            $error = $vars["error"];
        
        if (!empty($error))
            echo "<script>alert('".mysql_escape_string($error)."');</script>";
    }
    else {
        $no_last = 0;
        //$error="";
      }
      
    if ($ok == true && empty($error) && !defined('_DONT_VIEW_PAGE'))
      $_SESSION['last_page'] = $page;
    
}
?>
