<?php
   if (!defined('_VALID_MOS')) {
      die('Bezporedni dostp jest zabroniony!');
   }
   if (!$acl->acl_check(
     'administration', 'edit', 'users', $my->usertype,
     'components', 'all'
   )) {
      mosRedirect('index2.php', _NOT_AUTH);
   }
   require_once $mainframe->getPath('admin_html');
   require_once $mainframe->getPath('class');
   switch ($task) {
      case 'save':
         doSave($option);
         break;
      case 'cancel':
         doCancel($option);
         break;
      case 'new':
         doEdit(0, $option);
         break;
      case 'edit':
         doEdit($id, $option);
         break;
      case 'remove':
         doRemove($id, $option);
         break;
      default:
         doDefault($option);
   }
   function doSave($option) {
      global $database;
      $row = new mosLotto($database);
      if ($row->bind ($_POST) && $row->store()) {
         mosRedirect('index2.php?option=' . urlencode($option));
      } else {
         echo 'Error: ' . htmlspecialchars($row->getError());
      }
   }
   function doCancel($option) {
      global $database;
      mosRedirect('index2.php?option=' . urlencode($option));
   }
   function doEdit($id, $option) {
      global $database;
      $row = new mosLotto($database);
      $row->load($id);
      HTML_lotto::doEdit($row, $option);
   }
   function doRemove($id, $option) {
      global $database;
      $database->setQuery('DELETE FROM #__lotto WHERE id = ' .
        (int)$id);
      $database->query();
      mosRedirect('index2.php?option=' . urlencode($option));
   }
   function doDefault($option) {
      global $mainframe, $database;
      $database->setQuery('SELECT COUNT(*) FROM #__lotto');
      $cnt=$database->loadResult();
      require_once 'includes/pageNavigation.php';
      $nav = new mosPageNav($cnt, 0, 10);
      $database->setQuery(sprintf('SELECT * FROM #__lotto LIMIT %d,%d', 
        $nav->limitstart, $nav->limit));
      $rows = $database->loadObjectList();
      HTML_lotto::doDefault($rows, $nav, $option);
   }
   ?>