<?php
// MambelFish - Mambos Babelfish
// Copyright (C) 2003-2005 Think Network GmbH
// All rights reserved.  The mambel fish project is a extention hack and
// component for the Mambo Open Server. It enables Mambo OS to handle multi
// lingual sites especially in all dynamic contents which are stored in the
// database.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html
// --------------------------------------------------------------------------------
// $Id: uninstall.mambelfish.php,v 1.3 2005/03/16 13:45:34 akede Exp $
//
// Don't allow direct linking
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

function com_uninstall()
{
	global $_VERSION;
	
	// Patching the core
	$patchPath = dirname(__FILE__) ."/patch";
	$patchPath .= '/'. $_VERSION->RELEASE .'.'. substr( $_VERSION->DEV_LEVEL, 0, 1);
	if( file_exists( $patchPath ) ) {
		$success = patchFiles( $patchPath );
	} else {
		$success = false;
	}
	@unlink( $mosConfig_absolute_path .'/includes/js/ThemeOffice/mambelfish.png' );

	echo "<strong>MambelFish was uninstalled successfully.</strong></p>";
}

/** This function corrects the patched files and restores the originals
 * The path will be scaned for .php which will be backuped & replaced
 * - If the original file couldn't be found for backup this is no problem
 * - If the new file couldn't replace the old one an error occurs and the function
 *   returns false
 * - subdirectories will be patched recursivly
 *
 * @param	string	path to the directory of the files
 * @return	boolean	success for all files & directories
 */
function patchFiles( $patchPath, $subPath="" ) {
	global $mosConfig_absolute_path;
	$success = true;
	
	$filesindir = mosReadDirectory( "$patchPath/$subPath" ,"");
	foreach ($filesindir as $filename) {
		$filePath = ($subPath!="" ? "$subPath/" : "") .$filename;
		if( is_dir( "$patchPath/$filePath" ) ) {
			$success = patchFiles( $patchPath, $filePath );
		} else {
			if( strpos( $filename, '.bak' ) === false ) {
				continue;
			} else {
				$filename = substr( $filename, 0, strlen( $filename )-4);
				$success = @copy( "$patchPath/$filePath", "$mosConfig_absolute_path/$filename");			//Replace
			}
		}

		if( !$success ) break;
	}
	return $success;
}
?>