<?php
// MambelFish - Mambos Babelfish
// Copyright (C) 2003-2005 Think Network GmbH
// All rights reserved.  The mambel fish project is a extention hack and
// component for the Mambo Open Server. It enables Mambo OS to handle multi
// lingual sites especially in all dynamic contents which are stored in the
// database.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html
// --------------------------------------------------------------------------------
// $Id: mambelfish.html.php,v 1.5 2005/03/16 13:45:34 akede Exp $
//
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/**
* Mambel fish frontend component
* @package mambelfish.classes
* @copyright 2003-2005 Think Network GmbH
* @license http://www.gnu.org/copyleft/gpl.html GNU Public License
* @version 1.0, 2003-10-16 $Revision: 1.5 $
* @author Alex Kempkens <akede@users.sourceforge.net>
*/

/**
* Utility class for writing the HTML code of the site map
*/
class HTML_mambelfish {
/* @var mambelFishManager	Reference to my Manager for config and so on */
	var $_mambelFishManager=null;

	/** Default constructor
	 */
	function HTML_mambelfish ($mambelFishManager) {
		$this->_mambelFishManager = $mambelFishManager;
	}
	
	/**
	 * Displays a language selector - the style is configured
	 *
	 * @param	sitemapManager	Reference to my manager
	 */
	function showLanguages($mambelFishManager) {
		global $mosConfig_live_site, $mosConfig_absolute_path, $mosConfig_lang, $iso_client_lang, $Itemid;
		$htmlMambelFish = new HTML_mambelfish($mambelFishManager);
		
		$htmlMambelFish->_header();
		$langActive = $mambelFishManager->getActiveLanguages();
		if( !isset( $langActive ) ) {
			// No active languages => nothing to show :-(
			return;
		}
		$outString = '';
		// check for spacer and fallback
		if( $mambelFishManager->getCfg( 'textSpacer' ) ) $mbfSpacer = '&nbsp;' . $mambelFishManager->getCfg( 'textSpacer' ) . '&nbsp;'; else $mbfSpacer = '&nbsp;|&nbsp;';
		// check for mode (horizontal/vertical) and define output [new by mic]
		if( $GLOBALS['mbf_dir'] == 'vertical' || $mambelFishManager->getCfg( 'frontendMode' ) == 'vlist' || $mambelFishManager->getCfg( 'frontendMode' ) == 'vimage' ){
			$mbf_space = '';
			$mbf_nl = '<br />';
			$mbfSpacer = '';
		}else{
			$mbf_space = '&nbsp;';
			$mbf_nl = '';
		}
		// end mic
		
		switch( $mambelFishManager->getCfg( 'frontendMode' ) ) {

			case 'vlist':
			case 'hlist':
					foreach( $langActive as $language )
					{
						$href = HTML_mambelfish::_createHRef ($language->iso);
						if( $outString != '' ) $outString .= $mbfSpacer; // changed by mic
						$outString .= '<a href="' .$href. '">' .$language->name. '</a>';
						$outString .= $mbf_nl; // new by mic
					}
				break;
				
			case 'vimage':
			case 'himage':
					foreach( $langActive as $language )
					{
						$href = HTML_mambelfish::_createHRef ($language->iso);
						if( $outString != '' ) $outString .= $mbf_nl;
						
						if( isset($language->image) && $language->image!="" ) {  
							$langImg = '/images/' .$language->image;
						} else {
							$langImg = '/components/com_mambelfish/images/flags/' .$language->iso .".gif";
						}

						if( file_exists( $mosConfig_absolute_path . $langImg ) ) {
							$outString .= '<a href="' .$href. '"><img src="' .$mosConfig_live_site . $langImg. '" alt="' .$language->name. '" border="0"></a>';
						} else {
							$outString .= '<a href="' .$href. '">' .$language->name. '</a>';
						}
					}
				break;
				
			default:
				if ( count($langActive)>0 ) {
					foreach( $langActive as $language )
					{
						$langOptions[] = mosHTML::makeOption( $language->iso, $language->name );
					}
				}
				$href = HTML_mambelfish::_createHRef (null);
				$langlist = mosHTML::selectList( $langOptions, 'lang', 'class="inputbox" size="1" onchange="document.location.replace(\'' .$href.'&lang=\' +this.value);"', 'value', 'text', $iso_client_lang );
				$outString = $langlist;
				break;
		}
		echo $outString;
		$htmlMambelFish->_footer();
	}

	/**
	 * internal function to generate a new href link
	 * @param	string	iso_code of the wanted language
	 * @return	string	new href string
	 */
	function _createHRef( $iso ) {
		$href= "index.php";
		$vars = explode( "&", $_SERVER['QUERY_STRING'] );
		if( count($vars) > 0 && $_SERVER['QUERY_STRING']) {
			$hrefVars = "";
			foreach ($vars as $var) {
				if( eregi('=', $var ) ) {
					list($key, $value) = explode( "=", $var);
					if( $key != "lang" ) {
						if( $hrefVars != "" ) $hrefVars .= "&";
						$hrefVars .= "$key=$value";
					}
				}
			}
		}
		
		if( $iso != null ) {
			if( $hrefVars != "" ) $hrefVars .= "&";
			$hrefVars .= "lang=$iso";
		}
		
		if( $hrefVars != "" ) {
			$href .= "?$hrefVars";
		}
		return sefRelToAbs( $href );
	}

	/**
	 * Function to write the header
	 */
	function _header() {
	}
	
	/** 
	
	/**
	 * Function to write the footer
	 */
	function _footer() {
	?>
<!--Mambel fish <?php echo MambelFishManager::getVersion();?>-->
<!-- &copy; 2003 Think Network, released under the GPL. -->
<!-- More information: at http://mamboforge.net/projects/mambelfish -->
	<?php
	}
}	
?>
