<?php
// MambelFish - Mambos Babelfish
// Copyright (C) 2003-2005 Think Network GmbH
// All rights reserved.  The mambel fish project is a extention hack and
// component for the Mambo Open Server. It enables Mambo OS to handle multi
// lingual sites especially in all dynamic contents which are stored in the
// database.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html
// --------------------------------------------------------------------------------
// $Id: admin.mambelfish.html.php,v 1.4 2005/03/16 13:45:34 akede Exp $
//
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );
$adminPath = dirname( __FILE__);

$short_loc = substr( $mosConfig_locale, 0, 2);
if( file_exists( $adminPath . '/mambelfish.help.inc_' . $short_loc . '.php' ) ){
        require_once( $adminPath . '/mambelfish.help.inc_' . $short_loc . '.php' );
}else require_once( "$adminPath/mambelfish.help.inc.php" );

class HTML_mambelfish {

	function showWelcome() {
		HTML_mambelfish_help::showWelcome();
  }		
	
	
	function showDinnermenu() {
		HTML_mambelfish_help::showDinnermenu();
  }

	function showPostInstall() {
		HTML_mambelfish_help::showPostInstall();
  }

	function showInformation( $fileCode='TN' ) {
		global $act, $task, $option, $mosConfig_absolute_path, $mosConfig_live_site;
		HTML_mambelfish::_header()
		?>
    <td align="left" valign="top">
		<h2>PREAMBLE</h2>
		The MambelFish is a add on component for Mambo Open Source.<br />
		Mambo Open Source is developed and licend by:<br />
		Miro International Pty Ltd. 251 2000 - 2004 All rights reserved.<br />
		&nbsp;<br />
		Mambo Open Source is Free Software released under the GNU/GPL License.<br />
		All trademarks and copyrights within this software are owned 
		by their respective owners.<br />
		&nbsp;<br />
		Within this license the "product" refers to the name "Mambel Fish".<br />
		Also the term "Mambel Fish - Mambos babel fish" must not be used by any derived software.
		</td>
		<?php HTML_mambelfish::_sideMenu();?>
	</tr>
	<tr>
      <td align="left" valign="top">
			<?php
			switch ( $fileCode ) {
				case "changelog":
					?>
					<h2>Changelog</h2>
					<?php
					echo nl2br(file_get_contents(dirname( __FILE__) ."/documentation/Changelog"));
					break;
				
				case "developer":
					?>
					<h2>Developers manual</h2>
					<?php
					echo nl2br(file_get_contents(dirname( __FILE__) ."/documentation/HowTo_make_a_CMT_multilingual.txt"));
					break;
				
				case "license":
					?>
					<h2>Think Network Open Source License</h2>
					<?php
					echo nl2br(file_get_contents(dirname( __FILE__) ."/documentation/TNLICENSE"));
					break;
				
				case "gpllicense":
					?>
					<h2>GNU General Public License</h2>
					<?php
					echo nl2br(file_get_contents(dirname( __FILE__) ."/documentation/LICENSE"));
					break;
				
				case "readme":
				default:
					?>
					<h2>Read ME</h2>
					<?php
					echo nl2br(file_get_contents(dirname( __FILE__) ."/documentation/ReadMe"));
					break;
			}
			?>
			</td>
		<?php
		HTML_mambelfish::_footer($act, $option);
  }		
	

	function showComponentConfiguration( $mambelfishManager, $languageList ) {
		global $act, $task, $option, $database, $mosConfig_lang, $mosConfig_live_site;
		HTML_mambelfish::_MamboHeader();
		?>
	  <table cellpadding="4" cellspacing="0" border="0" width="100%">
	  <tr>
	    <td width="100%" class="sectionname">
				<img src="<?php echo $mosConfig_live_site;?>/components/com_mambelfish/images/mambelfish.png" alt="" width="200" height="58" border="0"><br />
	    </td>
	  </table>
	  
	  <table cellpadding="3" cellspacing="0" border="0" width="100%">
	  <tr>
	    <td width="100%">
		<?php
		$tabs = new mosTabs(0);
		$tabs->startPane( 'component' );
		$tabs->startTab( _MAMBELFISH_ADMIN_LANGUAGES, 'Language-page' );
		?>
	  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
	    <tr>
	      <td width="30%" align="left" valign="top"><strong><?php echo _MAMBELFISH_ADMIN_DEFAULT_LANGUAGE;?></strong></td>
	      <td align="left" valign="top"><strong style="color: red;"><?php echo $mosConfig_lang . '</strong> ( ' . _MAMBELFISH_ADMIN_DEFAULT_LANGUAGE_HELP . ' )'; ?></td>
	    </tr>
	    <tr>
	      <td width="30%" align="left" valign="top"><strong><?php echo _MAMBELFISH_ADMIN_LANGUAGE;?></strong></td>
	      <td><?php echo _MAMBELFISH_ADMIN_LANGUAGE_HELP;?></td>
	    <tr>
	      <td align="center" valign="top" colspan="2">
				  <table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
				    <tr>
					<th class="title" width="20%" align="left">
						<?php echo _MAMBELFISH_ADMIN_TITLE_NAME;?>
						&nbsp;
				    	<?php
				    	$tip = _MBF_TT_TITLE_NAME;
						echo mosToolTip( $tip );
				    	?>
					</th>
				    <th width="5%" align="left"><?php echo _MAMBELFISH_ADMIN_TITLE_ACTIVE;?></th>
				    <th width="10%" nowrap="nowrap" align="left">
				    	<?php echo _MAMBELFISH_ADMIN_TITLE_ISO;?>
				    	&nbsp;
				    	<?php
				    	$tip = _MBF_TT_TITLE_ISO;
						echo mosToolTip( $tip );
				    	?>
				    </th>
				    <th width="15%" nowrap="nowrap" align="left"><?php echo _MAMBELFISH_ADMIN_TITLE_MAMBO;?></th>
				    <th width="30%" nowrap="nowrap" align="left">
				    	<?php echo _MAMBELFISH_ADMIN_TITLE_IMAGE; ?>
				    	&nbsp;
				    	<?php
				    	$tip = _MBF_TT_IMAGES_DIR;
						echo mosToolTip( $tip );
				    	?>
				    </th>
				    <th nowrap="nowrap" align="left">
				    	<?php echo _MAMBELFISH_ADMIN_TITLE_ORDER;?>
				    	&nbsp;
				    	<?php
				    	$tip = _MBF_TT_TITLE_ORDER;
						echo mosToolTip( $tip );
				    	?>
				    </th>
				    </tr>
				    <?php
							$k=0;
							$i=0;
							reset($languageList);
				foreach ($languageList as $language ) { ?>
					<tr class="<?php echo 'row' . $k; ?>">
				      <td>
				        <input type="hidden" name="frmLanguageID[]" value="<?php echo $language->id; ?>" />
				        	<input type="text" name="frmLanguageName[]" value="<?php echo $language->name; ?>" size="30" maxlength="100" />
							</td>
				      	<td align="center"><input type="checkbox" name="frmLanguageActive[]"<?php echo $language->active==1 ? ' checked' : ''; ?> value="<?php echo $language->id; ?>" /></td>
				      <td><input type="text" name="frmLanguageISO[]" value="<?php echo $language->iso; ?>" size="10" maxlength="10" /></td>
				      	<td><input type="text" name="frmLanguageMambo[]" value="<?php echo $language->mambo; ?>" size="20" maxlength="20" /></td>
				      	<td><input type="text" name="frmLanguageImage[]" value="<?php echo $language->image; ?>" size="50" maxlength="100" /></td>
				      <td><input type="text" name="frmLanguageOrder[]" value="<?php echo $language->ordering; ?>" size="5" maxlength="5" /></td>
								<?php
								$k = 1 - $k;
								$i++;
							}
						?>
						</tr>
					</table>
			  </td>
	    </tr>
	  </table>

		<?php
		$tabs->endTab();
	  $tabs->startTab( _MAMBELFISH_ADMIN_FRONTEND, 'Frontend-page' ); ?>
	  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
	    <tr>
	      <td class="sectionname" colspan="3"><h3><?php echo _MAMBELFISH_ADMIN_SHOWIF;?></h3></td>
	    </tr>
	    <tr align="center" valign="middle">
	      <td width="30%" align="left" valign="top"><strong><?php echo _MAMBELFISH_ADMIN_NOTRANSLATION;?></strong></td>
	      <td width="20%" align="left" valign="top">
	      <?php
	        $options[] = mosHTML::makeOption( '0', _MAMBELFISH_ADMIN_ORIGINAL_CONTENT );
	        $options[] = mosHTML::makeOption( '1', _MAMBELFISH_ADMIN_PLACEHOLDER );
	        $options[] = mosHTML::makeOption( '2', _MAMBELFISH_ADMIN_ORIGINAL_WITH_INFO ); // activated mic
	        $frmField = mosHTML::selectList( $options, 'frmTranslationMode', 'class="inputbox" size="1"', 'value', 'text', $mambelfishManager->getCfg( 'noTranslation' ) );
	        echo $frmField;
	      ?>
			  </td>
		  <td align="left" valign="top"><?php echo _MAMBELFISH_ADMIN_NOTRANSLATION_HELP;?></td>
	    </tr>
	    <tr align="center" valign="middle">
	      <td width="30%" align="left" valign="top"><strong><?php echo _MAMBELFISH_ADMIN_PLACEHOLDER;?></strong></td>
	      <td width="20%" align="left" valign="top">
	      <input type="text" name="frmTranslationDefaultText" size="75" value="<?php echo $mambelfishManager->getCfg('defaultText');?>" />
		  </td>
		  <td align="left">
		  	<?php
			$tip = _MBF_TT_TRANS_DEFAULT;
			echo mosToolTip( $tip );
			?>
		  </td>
	    </tr>
	    <tr align="center" valign="middle">
	      <td width="30%" align="left" valign="top"><strong><?php echo _MAMBELFISH_ADMIN_FRONTEND_VIEW;?></strong></td>
	      <td width="20%" align="left" valign="top">
	      <?php
					$options = array();
	        $options[] = mosHTML::makeOption( '', _MAMBELFISH_ADMIN_FRONTEND_COMBO );
	        $options[] = mosHTML::makeOption( 'hlist', _MAMBELFISH_ADMIN_FRONTEND_LIST );
	        $options[] = mosHTML::makeOption( 'vlist', _MAMBELFISH_ADMIN_FRONTEND_VLIST ); // new mic
	        $options[] = mosHTML::makeOption( 'himage', _MAMBELFISH_ADMIN_FRONTEND_IMAGE );
	        $options[] = mosHTML::makeOption( 'vimage', _MAMBELFISH_ADMIN_FRONTEND_VIMAGE ); // new mic
	        $frmField = mosHTML::selectList( $options, 'frmFrontendMode', 'class="inputbox" size="1"', 'value', 'text', $mambelfishManager->getCfg( 'frontendMode' ) );
	        echo $frmField;
	      ?>
			  </td>
		  <td align="left">
		  	<?php
			$tip = _MAMBELFISH_ADMIN_FRONTEND_HELP;
			echo mosToolTip( $tip );
			?>
		  </td>
	    </tr>
	     <td width="30%" align="left" valign="top"><strong><?php echo _MBF_SPACER; ?></strong></td>
	      <td width="20%" align="left" valign="top">
	      	<input type="text" name="frmTextSpacer" size="5" value="<?php echo $mambelfishManager->getCfg( 'textSpacer' );?>" />
		  </td>
		  <td align="left">
		  	<?php
			$tip = _MBF_TT_SPACER;
			echo mosToolTip( $tip );
			?>
		  </td>
	    </tr>
	  </table>
		<?php
		$tabs->endTab();
		$tabs->endPane();
		?>
	</td></tr>
	</table>
		<?php
		HTML_mambelfish::_MamboFooter($act, $option);
  }

	function showElementOverview( $mambelfishManager, $option, $search, $pageNav ) {
		global $my, $act, $task, $database, $mosConfig_live_site;
		HTML_mambelfish::_MamboHeader();
	?>
  <table cellpadding="4" cellspacing="0" border="0" width="100%">
  <tr>
    <td width="100%" class="sectionname">
			<img src="<?php echo $mosConfig_live_site;?>/components/com_mambelfish/images/mambelfish.png" alt="" width="200" height="58" border="0"><br />
    </td>
    <td nowrap>Display #</td>
    <td> <?php echo $pageNav->writeLimitBox(); ?> </td>
    <td>Search:</td>
    <td> <input type="text" name="search" value="<?php echo $search;?>" class="inputbox" onChange="document.adminForm.submit();" />
    </td>
  </tr>
  </tr>
  </table>
	
  <table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
    <tr>
      <th width="20" nowrap>&nbsp;</th>
      <th class="title" width="35%" align="left"><?php echo _MAMBELFISH_ADMIN_TITLE_NAME;?></th>
      <th width="15%" align="left"><?php echo _MAMBELFISH_ADMIN_TITLE_AUTHOR;?></th>
      <th width="15%" nowrap="nowrap" align="left"><?php echo _MAMBELFISH_ADMIN_TITLE_VERSION;?></th>
      <th nowrap="nowrap" align="left"><?php echo _MAMBELFISH_ADMIN_TITLE_DESCRIPTION;?></th>
    </tr>
    <?php
			$elements = $mambelfishManager->getContentElements();
			$k=0;
			$i=0;
			foreach (array_values($elements) as $element ) {
				$key = $element->referenceInformation['tablename'];
				?>
    <tr class="<?php echo "row$k"; ?>">
      <td width="20">
        <?php		if ($element->checked_out && $element->checked_out != $my->id) { ?>
        &nbsp;
        <?php		} else { ?>
        <input type="checkbox" id="cb<?php echo $i;?>" name="cid[]" value="<?php echo $key; ?>" onclick="isChecked(this.checked);" />
        <?php		} ?>
      </td>
      <td>
      	<a href="#edit" onclick="return listItemTask('cb<?php echo $i;?>','edit')"><?php echo $element->Name; ?></a>
			</td>
      <td><?php echo $element->Author ? $element->Author : '&nbsp;'; ?></td>
      <td><?php echo $element->Version ? $element->Version : '&nbsp;'; ?></td>
      <td><?php echo $element->Description ? $element->Description : '&nbsp;'; ?></td>
				<?php
				$k = 1 - $k;
				$i++;
			}
		?>
		</tr>
    <tr>
      <th align="center" colspan="10"> <?php echo $pageNav->writePagesLinks(); ?></th>
    </tr>
    <tr>
      <td align="center" colspan="10"> <?php echo $pageNav->writePagesCounter(); ?></td>
    </tr>
	</table>
	<?php
		HTML_mambelfish::_MamboFooter($act, $option);
	}

	function showElementConfiguration( $mambelfishManager, $id ) {
		global $my, $act, $task, $database, $option, $mosConfig_live_site;
		HTML_mambelfish::_MamboHeader();
		$contentElement = $mambelfishManager->getContentElement( $id );
	?>
  <table cellpadding="4" cellspacing="0" border="0" width="100%">
  <tr>
    <td width="100%" class="sectionname">
			<img src="<?php echo $mosConfig_live_site;?>/components/com_mambelfish/images/mambelfish.png" alt="" width="200" height="58" border="0"><br />
    </td>
  </table>
	  <table cellpadding="3" cellspacing="0" border="0" width="100%">
	  <tr>
	    <td width="100%">
		<?php
		$tabs = new mosTabs(0);
		$tabs->startPane("contentelements");
		$tabs->startTab(_MAMBELFISH_ADMIN_ELEMENT_CONFIG,"ElementConfig-page");
		?>
	  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
	    <tr>
	      <td class="sectionname" colspan="3"><h3><?php echo _MAMBELFISH_ADMIN_COMMONINFORMATION;?></h3></td>
	    </tr>
	    <tr align="center" valign="middle">
	      <td width="30%" align="left" valign="top"><strong><?php echo _MAMBELFISH_ADMIN_TITLE_NAME;?></strong></td>
	      <td width="20%" align="left" valign="top"><?php echo $contentElement->Name;?></td>
			  <td align="left"></td>
	    </tr>
	    <tr align="center" valign="middle">
	      <td width="30%" align="left" valign="top"><strong><?php echo _MAMBELFISH_ADMIN_TITLE_AUTHOR;?></strong></td>
	      <td width="20%" align="left" valign="top"><?php echo $contentElement->Author;?></td>
			  <td align="left"></td>
	    </tr>
	    <tr align="center" valign="middle">
	      <td width="30%" align="left" valign="top"><strong><?php echo _MAMBELFISH_ADMIN_TITLE_VERSION;?></strong></td>
	      <td width="20%" align="left" valign="top"><?php echo $contentElement->Version;?></td>
			  <td align="left"></td>
	    </tr>
	    <tr align="center" valign="middle">
	      <td width="30%" align="left" valign="top"><strong><?php echo _MAMBELFISH_ADMIN_TITLE_DESCRIPTION;?></strong></td>
	      <td width="20%" align="left" valign="top"><?php echo $contentElement->Description;?></td>
			  <td align="left"></td>
	    </tr>
	  </table>
	  	<?php
	  	$tabs->endTab();
		$tabs->startTab(_MAMBELFISH_ADMIN_ELEMENT_REFERENCE,"ElementReference-page");

		$contentTable = $contentElement->getTable();
		?>
	  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
	    <tr>
	      <td class="sectionname" colspan="2"><h3><?php echo _MAMBELFISH_ADMIN_DATABASEINFORMATION;?></h3></td>
	    </tr>
	    <tr align="center" valign="middle">
	      <td width="15%" align="left" valign="top"><strong><?php echo _MAMBELFISH_ADMIN_DATABASETABLE;?></strong><br /><?php echo _MAMBELFISH_ADMIN_DATABASETABLE_HELP;?></td>
	      <td width="60%" align="left" valign="top"><?php echo $contentTable->Name;?></td>
	    </tr>
	    <tr align="center" valign="middle">
	      <td width="15%" align="left" valign="top"><strong><?php echo _MAMBELFISH_ADMIN_DATABASEFIELDS;?></strong><br /><?php echo _MAMBELFISH_ADMIN_DATABASEFIELDS_HELP;?></td>
	      <td width="60%" align="left" valign="top">
			  <table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
				<tr>
					<th><?php echo _MAMBELFISH_ADMIN_DBFIELDNAME;?></th>
					<th><?php echo _MAMBELFISH_ADMIN_DBFIELDTYPE;?></th>
					<th><?php echo _MAMBELFISH_ADMIN_DBFIELDLABLE;?></th>
					<th><?php echo _MAMBELFISH_ADMIN_TRANSLATE;?></th>
				</tr>
				<?php
				$k=0;
				foreach( $contentTable->Fields as $tableField ) {
					?>
			  <tr class="<?php echo "row$k"; ?>">
					<td><?php echo $tableField->Name ? $tableField->Name : "&nbsp;";?></td>
					<td><?php echo $tableField->Type ? $tableField->Type : "&nbsp;";?></td>
					<td><?php echo $tableField->Lable ? $tableField->Lable : "&nbsp;";?></td>
					<td><?php echo $tableField->Translate ? _CMN_YES : _CMN_NO;?></td>
				</tr>
					<?php
					$k=1-$k;
				}
				?>
				</table>
				<?php 
				?>
				</td>
	    </tr>
	  </table>
	  	<?php
	  	$tabs->endTab();
		$tabs->startTab(_MAMBELFISH_ADMIN_ELEMENT_SAMPLES,"ElementSamples-page");
		$contentTable = $contentElement->getTable();
		?>
	  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
	    <tr>
	      <td class="sectionname"><h3><?php echo _MAMBELFISH_ADMIN_ELEMENT_SAMPLES;?></h3></td>
	    </tr>
	    <tr align="center" valign="middle">
	      <td width="100%" align="center" valign="top">
			  <table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
				<tr>
				<?php
				$sqlFields = "";
				foreach( $contentTable->Fields as $tableField ) {
					if( $sqlFields!='' ) $sqlFields .= ',';
					$sqlFields .= '`' .$tableField->Name. '`';
					?>
					<th nowrap><?php echo $tableField->Lable;?></th>
					<?php
				}
				?>
				</tr>
				<?php
				$k=0;
				$sql = "SELECT $sqlFields"
					. "\nFROM #__" .$contentTable->Name
					. "\nORDER BY id limit 0,10";
				$database->setQuery( $sql	);
				$rows = $database->loadObjectList();
				foreach ($rows as $row) {
					?>
			  <tr class="<?php echo "row$k"; ?>">
				<?php
				foreach( $contentTable->Fields as $tableField ) {
					$fieldName = $tableField->Name;
					$fieldValue = $row->$fieldName;
					if( $tableField->Type='htmltext' ) {
						$fieldValue = htmlspecialchars( $fieldValue );
					}
					
					if( $fieldValue=='' ) $fieldValue="&nbsp;";
					if( strlen($fieldValue) > 97 ) {
						$fieldValue = substr( $fieldValue, 0, 100) . '...';
					}
					
					?>
					<td valign="top"><?php echo $fieldValue;?></td>
					<?php
				}
				?>
				</tr>
					<?php
					$k=1-$k;
				}
				?>
				</table>
				<?php 
				?>
				</td>
	    </tr>
	  </table>
	<?php
	  	$tabs->endTab();
		$tabs->endPane();
		?>
	</td></tr>
	</table>
		<?php
		HTML_mambelfish::_MamboFooter($act, $option);
	}


	function showTranslationOverview( $rows, $search, $pageNav, $langlist, $clist, $catid ) {
		global $my, $act, $task, $database, $option, $mosConfig_live_site;
		HTML_mambelfish::_MamboHeader();
	?>
  <table cellpadding="4" cellspacing="0" border="0" width="100%">
  <tr>
    <td width="100%" class="sectionname">
			<img src="<?php echo $mosConfig_live_site;?>/components/com_mambelfish/images/mambelfish.png" alt="" width="200" height="58" border="0"><br />
    </td>
    <td nowrap><?php echo _MAMBELFISH_ADMIN_TITLE_DISPLAY;?>:</td>
    <td> <?php echo $pageNav->writeLimitBox(); ?> </td>
    <td nowrap><?php echo _MAMBELFISH_ADMIN_TITLE_LANGUAGE;?>:</td>
    <td width="right"><?php echo $langlist;?></td>
    <td nowrap><?php echo _MAMBELFISH_ADMIN_TITLE_CONTENTELEMENTS;?>:</td>
    <td width="right"><?php echo $clist;?></td>
  </tr>
  </table>
	
	<?php
	if( !isset($catid) || $catid == "" ) {
		?>
		<p><?php echo _MAMBELFISH_NOELEMENT_SELECTED;?></p>
		<?php
	}
	else {
		?>
  <table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist">
    <tr>
      <th width="20"><input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count($rows); ?>);" /></th>
      <th class="title" width="20%" align="left"  nowrap="nowrap"><?php echo _MAMBELFISH_ADMIN_TITLE_TITLE;?></th>
      <th width="10%" align="left" nowrap="nowrap"><?php echo _MAMBELFISH_ADMIN_TITLE_LANGUAGE;?></th>
      <th width="20%" align="left" nowrap="nowrap"><?php echo _MAMBELFISH_ADMIN_TITLE_TRANSLATION;?></th>
      <th width="15%" align="left" nowrap="nowrap"><?php echo _MAMBELFISH_ADMIN_TITLE_DATECHANGED;?></th>
      <th width="15%" nowrap="nowrap" align="center"><?php echo _MAMBELFISH_ADMIN_TITLE_STATE;?></th>
      <th nowrap="nowrap" align="center" nowrap="nowrap"><?php echo _MAMBELFISH_ADMIN_TITLE_PUBLISHED;?></th>
    </tr>
    <?php
			$k=0;
			$i=0;
			foreach ($rows as $row ) {
				?>
    <tr class="<?php echo "row$k"; ?>">
      <td width="20">
        <?php		if ($row->checked_out && $row->checked_out != $my->id) { ?>
        &nbsp;
        <?php		} else { ?>
        <input type="checkbox" id="cb<?php echo $i;?>" name="cid[]" value="<?php echo $row->id; ?>|<?php echo $row->language_id; ?>" onclick="isChecked(this.checked);" />
        <?php		} ?>
      </td>
      <td>
      	<a href="#edit" onclick="return listItemTask('cb<?php echo $i;?>','edit')"><?php echo $row->title; ?></a>
			</td>
      <td nowrap><?php echo $row->language ? $row->language : _MAMBELFISH_NOTRANSLATIONYET; ?></td>
      <td><?php echo $row->titleTranslation ? $row->titleTranslation : '&nbsp;'; ?></td>
      <td><?php echo $row->lastchanged ? strftime($row->lastchanged, _DATE_FORMAT_LC) : '&nbsp;'; ?></td>
				<?php
				switch( $row->state ) {
					case 1:
						$img = 'status_g.png';
						break;
					case 0:
						$img = 'status_y.png';
						break;
					case -1:
					default:
						$img = 'status_r.png';
						break;
				}
				?>
      <td align="center"><img src="components/com_mambelfish/images/<?php echo $img;?>" width="12" height="12" border="0" alt="" /></td>
				<?php
				if (isset($row->published) && $row->published) {
					$img = 'publish_g.png';
				} else {
					$img = 'publish_x.png';
				}
				
				$href='';
				if( $row->state>=0 ) {
					$href = '<a href="javascript: void(0);" ';
					$href .= 'onClick="return listItemTask(\'cb' .$i. '\',\'' .($row->published ? 'unpublish' : 'publish'). '\')">';
					$href .= '<img src="images/' .$img. '" width="12" height="12" border="0" alt="" />';
					$href .= '</a>';
				}
				else {
					$href = '<img src="images/' .$img. '" width="12" height="12" border="0" alt="" />';
				}
				?>
      <td align="center"><?php echo $href;?></td>
				<?php
				$k = 1 - $k;
				$i++;
			}
		?>
    <tr>
      <th align="center" colspan="10"> <?php echo $pageNav->writePagesLinks(); ?></th>
    </tr>
    <tr>
      <td align="center" colspan="10"> <?php echo $pageNav->writePagesCounter(); ?></td>
    </tr>
	</table>
<br />
<table cellspacing="0" cellpadding="4" border="0" align="center">
  <tr align="center">
    <td> <img src="components/com_mambelfish/images/status_g.png" width="12" height="12" border=0 alt="<?php echo _MAMBELFISH_STATE_OK;?>" />
    </td>
    <td> <?php echo _MAMBELFISH_TRANSLATION_UPTODATE;?> |</td>
    <td> <img src="components/com_mambelfish/images/status_y.png" width="12" height="12" border=0 alt="<?php echo _MAMBELFISH_STATE_CHANGED;?>" />
    </td>
    <td> <?php echo _MAMBELFISH_TRANSLATION_INCOMPLETE;?> |</td>
    <td> <img src="components/com_mambelfish/images/status_r.png" width="12" height="12" border=0 alt="<?php echo _MAMBELFISH_STATE_NOTEXISTING;?>" />
    </td>
    <td> <?php echo _MAMBELFISH_TRANSLATION_NOT_EXISTING;?></td>
  </tr>
  <tr align="center">
    <td> <img src="images/publish_g.png" width="12" height="12" border=0 alt="Translation visible" />
    </td>
    <td> <?php echo _MAMBELFISH_TRANSLATION_PUBLISHED;?> |</td>
    <td> <img src="images/publish_x.png" width="12" height="12" border=0 alt="Finished" />
    </td>
    <td> <?php echo _MAMBELFISH_TRANSLATION_NOT_PUBLISHED;?> </td>
    <td> &nbsp;
    </td>
    <td> <?php echo _MAMBELFISH_STATE_TOGGLE;?> </td>
  </tr>
</table>
		<?php
		}
		HTML_mambelfish::_MamboFooter($act, $option);
	}

	/**
	* @return void
	* @param object $actContentObject
	* @param array $langlist
	* @param string $catid
	* @desc Shows the dialog for the content translation
	*/
	function showTranslation( $actContentObject, $langlist, $catid ) {
		global $my, $act, $task, $database, $option, $select_language_id, $mosConfig_live_site;
		$elementTable = $actContentObject->getTable();
		
		HTML_mambelfish::_MamboHeader();
		
		$editorFields=null;
	?>
  <table cellpadding="4" cellspacing="0" border="0" width="100%">
  <tr>
    <td width="100%" class="sectionname">
			<img src="<?php echo $mosConfig_live_site;?>/components/com_mambelfish/images/mambelfish.png" alt="" width="200" height="58" border="0"><br />
    </td>
  </table>
    <table cellpadding="3" cellspacing="0" border="0" width="100%">
	  <tr>
	    <td width="100%">
		<?php
		$tabs = new mosTabs(0);
		$tabs->startPane("translation");
		$tabs->startTab(_MAMBELFISH_TRANSLATION,"Translation-page");
		?>
	  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
			<tr><td valign="top">
			  <table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm" align="center">
		    <tr align="center" valign="middle">
		      <th width="10%" align="left" valign="top"><?php echo _MAMBELFISH_ADMIN_DBFIELDLABLE;?></th>
		      <th width="45%" align="left" valign="top"><?php echo _MAMBELFISH_ORIGINAL;?></th>
		      <th width="45%" align="left" valign="top" colspan="2"><?php echo _MAMBELFISH_TRANSLATION;?></th>
		    </tr>
				<?php
				$k=1;
				for( $i=0; $i<count($elementTable->Fields); $i++ ) {
					$field =& $elementTable->Fields[$i];
					$originalValue = $field->originalValue;
					
					if( $field->Translate ) {
						$translationContent = $field->translationContent;
						mosMakeHtmlSafe( $translationContent );
				?>
		    <tr align="center" valign="middle" "class="<?php echo "row$k"; ?>">
		      <td align="left" valign="top"><?php echo $field->Lable;?></td>
		      <td align="left" valign="top"><?php echo $field->originalValue;?></td>
		      <td align="left" valign="top">
					  <input type="hidden" name="id_<?php echo $field->Name;?>" value="<?php echo $translationContent->id;?>" />
						<?php
						if( strtolower($field->Type)=='text' || strtolower($field->Type)=='titletext' ) {
							?>
						  <input type="hidden" name="origValue_<?php echo $field->Name;?>" value="<?php echo htmlspecialchars($field->originalValue, ENT_QUOTES);?>" />
							<input class="inputbox" type="text" name="refField_<?php echo $field->Name;?>" size="60" maxlength="100" value="<?php echo $translationContent->value; ?>" />
							
							<?php
						} else if( strtolower($field->Type)=='textarea' ) {
							?>
						  <input type="hidden" name="origValue_<?php echo $field->Name;?>" value="<?php echo htmlspecialchars($field->originalValue, ENT_QUOTES);?>" />
							<textarea name="refField_<?php echo $field->Name;?>" rows="15" cols="30"><?php echo $translationContent->value; ?></textarea>
							<?php
						} else if( strtolower($field->Type)=='htmltext' ) {
							?>
						  <input type="hidden" name="origValue_<?php echo $field->Name;?>" value="<?php echo htmlspecialchars($field->originalValue, ENT_QUOTES);?>" />
							<?php
								$editorFields[] = array( "editor_".$field->Name, "refField_".$field->Name );
								// parameters : areaname, content, hidden field, width, height, rows, cols
								editorArea( "editor_".$field->Name,  $translationContent->value , "refField_".$field->Name, 500, 200, '70', '15' ) ;
							}
						?>
					</td>
					<td valign="top">
					<?php if( strtolower($field->Type)!='htmltext' ) {?>
						<a class="toolbar" onclick="document.adminForm.refField_<?php echo $field->Name;?>.value = document.adminForm.origValue_<?php echo $field->Name;?>.value;" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('copy_<?php echo $field->Name;?>','','images/move_f2.png',1);"><img src="images/move.png" alt="<?php echo _MAMBELFISH_COPY;?>" border="0" name="copy_<?php echo $field->Name;?>" align="middle" /></a>&nbsp;
						<a class="toolbar" onclick="document.adminForm.refField_<?php echo $field->Name;?>.value = '';" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('clear_<?php echo $field->Name;?>','','images/delete_f2.png',1);"><img src="images/delete.png" alt="<?php echo _MAMBELFISH_CLEAR;?>" border="0" name="clear_<?php echo $field->Name;?>" align="middle" /></a>
					<?php } else {?>
					<!--
						<a class="toolbar" onclick="editor_setHTML('refField_<?php echo $field->Name;?>', document.adminForm.origValue_<?php echo $field->Name;?>.value); document.adminForm.refField_<?php echo $field->Name;?>.value = document.adminForm.origValue_<?php echo $field->Name;?>.value;" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('copy_<?php echo $field->Name;?>','','images/move_f2.png',1);"><img src="images/move.png" alt="<?php echo _MAMBELFISH_COPY;?>" border="0" name="copy_<?php echo $field->Name;?>" align="middle" /></a>&nbsp;
						<a class="toolbar" onclick="editor_setHTML('refField_<?php echo $field->Name;?>', ''); document.adminForm.refField_<?php echo $field->Name;?>.value = '';" onmouseout="MM_swapImgRestore();"  onmouseover="MM_swapImage('clear_<?php echo $field->Name;?>','','images/delete_f2.png',1);"><img src="images/delete.png" alt="<?php echo _MAMBELFISH_CLEAR;?>" border="0" name="clear_<?php echo $field->Name;?>" align="middle" /></a>
					-->&nbsp;
					<?php }?>
					</td>
		    </tr>
				<?php
					}
					$k=1-$k;
				}
				?>
				</table>
		</tr>
	  </table>
  	  <?php
	  	$tabs->endTab();
		$tabs->startTab(_MAMBELFISH_ITEM_INFO,"ItemInfo-page");
	  ?>
  	<table width="100%" border="0" cellpadding="4" cellspacing="2" class="adminForm">
      <tr>
        <td width="34%"><strong><?php echo _MAMBELFISH_ADMIN_TITLE_STATE;?>:</strong></td>
        <td width="50%"><?php echo $actContentObject->state > 0 ? _MAMBELFISH_STATE_OK : ($actContentObject->state < 0 ? _MAMBELFISH_STATE_NOTEXISTING : _MAMBELFISH_STATE_CHANGED);?></td>
      </tr>
      <tr>
        <td><strong><?php echo _MAMBELFISH_ADMIN_TITLE_LANGUAGE;?>:</strong></td>
        <td><?php echo $langlist;?></td>
      </tr>
      <tr>
        <td><strong><?php echo _MAMBELFISH_ADMIN_TITLE_PUBLISHED;?>:</strong></td>
        <td><input type="checkbox" name="published" value="1" <?php echo $actContentObject->published&0x0001 ? 'checked="checked"' : ''; ?> /></td>
      </tr>
      <tr>
        <td><strong><?php echo _MAMBELFISH_ADMIN_TITLE_DATECHANGED;?>:</strong></td>
        <td><?php echo strftime($actContentObject->lastchanged, "%A, %d %B %Y %H:%M");?></td>
      </tr>
	  </table>
	  <?php
	  	$tabs->endTab();
		$tabs->endPane();
		?>
	  <input type="hidden" name="select_language_id" value="<?php echo $select_language_id;?>" />
	  <input type="hidden" name="reference_id" value="<?php echo $actContentObject->id;?>" />
	  <input type="hidden" name="reference_table" value="<?php echo $elementTable->name;?>" />
	  <input type="hidden" name="catid" value="<?php echo $catid;?>" />
	</td></tr>
	</table>
	<?php
		HTML_mambelfish::_MamboFooter($act, $option, $editorFields);
	}


  function _sideMenu() {
  	global $mosConfig_live_site;
  	?>
		<td align="left" valign="top" nowrap>
		<p><span class="contentheading">Related topics:</span><br />
		<img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" width="9" height="9" border="0">&nbsp;<a href="index2.php?option=com_mambelfish&act=dinnermenu">The dinner menu <b>(The manual)</b></a><br />
		<img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" width="9" height="9" border="0">&nbsp;<a href="index2.php?option=com_mambelfish&act=post_install">Post installation</a><br />
		<img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" width="9" height="9" border="0">&nbsp;<a href="http://mamboforge.net/projects/mambelfish" target="_blank">Official Project WebSite</a><br />
		<img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" width="9" height="9" border="0">&nbsp;<a href="http://mamboforge.net/forum/?group_id=7" target="_blank">Official Project Forum</a><br />
		<img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" width="9" height="9" border="0">&nbsp;<a href="http://mamboforge.net/tracker/?atid=109&group_id=7&func=browse" target="_blank">Bugtracker</a><br />
		</p>
		<p><span class="contentheading">Documentation & Tutorials:</span><br />
		<img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" width="9" height="9" border="0">&nbsp;<a href="index2.php?option=com_mambelfish&act=showInformation&fileCode=changelog">Changelog</a><br />
		<img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" width="9" height="9" border="0">&nbsp;<a href="index2.php?option=com_mambelfish&act=showInformation&fileCode=readme">ReadMe</a><br />
		<img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" width="9" height="9" border="0">&nbsp;<a href="index2.php?option=com_mambelfish&act=showInformation&fileCode=developer">Developers Guide</a><br />
		<img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" width="9" height="9" border="0">&nbsp;<a href="http://mamboforge.net/docman/?group_id=7" target="_blank">Project Documentation Site</a><br />
		</p>
		<p><span class="contentheading">License:</span><br />
		<img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" width="9" height="9" border="0">&nbsp;<a href="index2.php?option=com_mambelfish&act=showInformation&fileCode=license">Think Network Open Source license</a><br />
		<img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" width="9" height="9" border="0">&nbsp;<a href="index2.php?option=com_mambelfish&act=showInformation&fileCode=gpllicense">GNU General Public License</a><br />
		</p>
		<p><span class="contentheading">Additional Sites:</span><br />
		<img src="<?php echo $mosConfig_live_site;?>/images/M_images/arrow.png" alt="" width="9" height="9" border="0">&nbsp;<a href="http://www.mamboserver.com" target="_blank">Mambo Open Server</a><br />
		</p>
		</td>
  	<?php
  }

		
  function _header() {
  	global $mosConfig_live_site;
	?>
	    <script language="javascript" type="text/javascript">
	    function submitbutton(pressbutton) {
	      var form = document.adminForm;
	      if (pressbutton == 'cancel') {
	        submitform( pressbutton );
	        return;
	      } else {
	        submitform( pressbutton );
	      }
	    }
	    </script>
    <form action="index2.php" method="post" name="adminForm">
	<table width="90%" border="0" cellpadding="2" cellspacing="2" class="adminheading">
	<tr><th width="100%" class="sectionname" align="left" colspan="2">
		<img src="<?php echo $mosConfig_live_site;?>/components/com_mambelfish/images/mambelfish.png" alt="" width="200" height="58" border="0">
		Mambos babel fish
	</th></tr>
	</table>
	<table width="90%" border="0" cellpadding="2" cellspacing="2" class="adminform">
	<?php
  }
  
	function _footer($act, $option) {
	?>
		<td align="left" valign="bottom">
		<span class="smallgrey"><strong>Credits:</strong></span><br />
		<span class="smallgrey">To all the people of the MambelFish community!<br />
		Special thank's for testing, good suggestions & translations to:<br />
		Bernhard, Michael, Luc, Olivier, Robin, Rune</span><br />
		
		&nbsp;<br />
		<span class="smallgrey"><strong>Contact:</strong></span><br />
		<a href="mailto:MambelFish@ThinkNetwork.com" class="smallgrey"><span class="smallgrey">MambelFish@ThinkNetwork.com</span></a><br />
		&nbsp;<br />
		<span class="smallgrey"><strong>Version:</strong></span><br />
		<span class="smallgrey"><?php echo MambelFishManager::getVersion();?></span><br />
		&nbsp;<br />
		<span class="smallgrey"><strong>Copyright:</strong></span><br />
		<span class="smallgrey">&copy; 2003-2005 </span><a href="http://www.ThinkNetwork.com" target="_blank" class="smallgrey"><span class="smallgrey">Think Network GmbH</span></a><br />
		<a href="index2.php?option=com_mambelfish&act=license" class="smallgrey"><span class="smallgrey">Open Source License.</span></a>
		</td>
    </tr>
  </table>

	  <input type="hidden" name="task" value="" />
	  <input type="hidden" name="act" value="<?php echo $act; ?>" />
	  <input type="hidden" name="option" value="<?php echo $option; ?>" />
    </form>
	<?php
	}

  function _MamboHeader() {
	?>
    <form action="index2.php" method="post" name="adminForm">
    <div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>
	<table width="100%" border="0">
	<?php
  }

	function _MamboFooter($act, $option, $editorFields=null) {
	?>
	  <input type="hidden" name="boxchecked" value="0" />
	  <input type="hidden" name="task" value="" />
	  <input type="hidden" name="act" value="<?php echo $act; ?>" />
	  <input type="hidden" name="option" value="<?php echo $option; ?>" />
    </form>
	<script  type="text/javascript" src="<?php echo $mosConfig_live_site;?>/includes/js/overlib_mini.js"></script>
    <script language="javascript" type="text/javascript">
    function submitbutton(pressbutton) {
      var form = document.adminForm;
			<?
			if( isset($editorFields) && is_array($editorFields) ) {
				foreach ($editorFields as $editor) {
						// Where editor[0] = your areaname and editor[1] = the field name
						getEditorContents( $editor[0], $editor[1]) ;
				}
			}
			?>
      if (pressbutton == 'cancel') {
        submitform( pressbutton );
        return;
      } else {
        submitform( pressbutton );
      }
    }
    </script>
    <table width="100%" border="0">
	<tr>
		<td align="right" valign="top" width="33%">
		<span class="smallgrey"><strong>Contact:</strong></span><br />
		<a href="mailto:MambelFish@ThinkNetwork.com" class="smallgrey"><span class="smallgrey">MambelFish@ThinkNetwork.com</span></a>
		</td>
		<td align="center" valign="top" width="33%">
			<span class="smallgrey"><strong>Version:</strong></span><br />
			<span class="smallgrey"><?php echo MambelFishManager::getVersion();?></span><br />
		</td>
		<td align="left" valign="top" width="33%">
			<span class="smallgrey"><strong>Copyright:</strong></span><br />
			<span class="smallgrey">&copy; 2003-2005 </span><a href="http://www.ThinkNetwork.com" target="_blank" class="smallgrey"><span class="smallgrey">Think Network</span></a>&nbsp;-&nbsp;<a href="index2.php?option=com_mambelfish&act=license" class="smallgrey"><span class="smallgrey">Open Source License.</span></a>
		</td>
    </tr>
	</table>
	</div>
	<?php
	}
}
?>