<?php 
/**
* @version $Id: notify.php,v 1.7 2005/06/22 19:50:38 soeren_nb Exp $
* @package mambo-phpShop
* @subpackage Payment
* @copyright (C) 2004-2005 Soeren Eberhardt
*
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* mambo-phpShop is Free Software.
* mambo-phpShop comes with absolute no warranty.
*
* www.mambo-phpshop.net
*
* PayPal IPN Handler
*/
$messages = Array();
function debug_msg( $msg ) {
    global $messages;
    if( PAYPAL_DEBUG == "1" ) {
        if( !defined( "_DEBUG_HEADER")  ) {
            echo "<h2>PayPal Notify.php Debug OUTPUT</h2>";
            define( "_DEBUG_HEADER", "1" );
        }
        $messages[] = "<pre>$msg</pre>";
        echo end( $messages );
    }
}

if ($_POST) {
    header("Status: 200 OK");
    define('_VALID_MOS', '1');
    global $mosConfig_absolute_path, $mosConfig_live_site, $mosConfig_lang, $database,
    $mosConfig_mailfrom, $mosConfig_fromname;
    
    /*** access Mambo's configuration file ***/
        $my_path = dirname(__FILE__);
        
        if( file_exists($my_path."/../../../configuration.php")) {
            require_once($my_path."/../../../configuration.php");
        }
        elseif( file_exists($my_path."/../../configuration.php")){
            require_once($my_path."/../../configuration.php");
        }
        elseif( file_exists($my_path."/configuration.php")){
            require_once( $my_path."/configuration.php" );
        }
        else
            die( "Mambo Configuration File not found!" );
        if( file_exists ($mosConfig_absolute_path. '/includes/database.php'))
            require_once($mosConfig_absolute_path. '/includes/database.php');
        else   
            require_once($mosConfig_absolute_path. '/classes/database.php');
            
        require_once($mosConfig_absolute_path. '/administrator/components/com_phpshop/mos_4.6_code.php');
        
        $database = new database( $mosConfig_host, $mosConfig_user, $mosConfig_password, $mosConfig_db, $mosConfig_dbprefix );
        
        // load Mambo Language File
        if (file_exists( $mosConfig_absolute_path. '/language/'.$mosConfig_lang.'.php' ))
          require_once( $mosConfig_absolute_path. '/language/'.$mosConfig_lang.'.php' );
        else
          require_once( $mosConfig_absolute_path. '/language/english.php' );
    /*** END of Mambo config ***/
    
    
    /*** mambo-phpShop part ***/        
        require_once($mosConfig_absolute_path.'/administrator/components/com_phpshop/phpshop.cfg.php');
        
        require_once( $mosConfig_absolute_path . '/includes/phpmailer/class.phpmailer.php');
        $mail = new mosPHPMailer();
        $mail->PluginDir = $mosConfig_absolute_path . '/includes/phpmailer/';
        $mail->SetLanguage("en", $mosConfig_absolute_path . '/includes/phpmailer/language/');
              
        /* load the mambo-phpShop Language File */
        if (file_exists( ADMINPATH. 'languages/'.$mosConfig_lang.'.php' ))
          require_once( ADMINPATH. 'languages/'.$mosConfig_lang.'.php' );
        else
          require_once( ADMINPATH. 'languages/english.php' );
        
        /* Load the PayPal Configuration File */ 
        require_once( CLASSPATH. 'payment/ps_paypal.cfg.php' );
        
        /* Load the mambo-phpShop database class */
        require_once( CLASSPATH. 'ps_database.php' );
        
    /*** END mambo-phpShop part ***/
    
    debug_msg( "1. Finished Initialization of the notify.php script" );

    $post_msg = "";
    foreach ($_POST as $ipnkey => $ipnval) {
        $post_msg .= "$ipnkey=$ipnval&amp;";
    }
    debug_msg( "2. Received this POST: $post_msg" );

    $post_msg = "";
    /**
    * Read post from PayPal system and create reply
    * starting with: 'cmd=_notify-validate'...
    * then repeating all values sent: that's our VALIDATION.
    **/
    $workstring = 'cmd=_notify-validate'; // Notify validate
    $i = 1;
    foreach ($_POST as $ipnkey => $ipnval) {
        if (get_magic_quotes_gpc())
            // Fix issue with magic quotes
            $ipnval = stripslashes ($ipnval);
            
        if (!eregi("^[_0-9a-z-]{1,30}$",$ipnkey)  || !strcasecmp ($ipnkey, 'cmd'))  { 
            // ^ Antidote to potential variable injection and poisoning
            unset ($ipnkey); 
            unset ($ipnval); 
        } 
        // Eliminate the above
        // Remove empty keys (not values)
        if (@$ipnkey != '') { 
          //unset ($_POST); // Destroy the original ipn post array, sniff...
          $workstring.='&'.@$ipnkey.'='.urlencode(@$ipnval); 
        }
        $post_msg .= "key ".$i++.": $ipnkey, value: $ipnval<br />";
    } // Notify string
    
    
    $paypal_receiver_email = PAYPAL_EMAIL;
    $item_name = trim(stripslashes($_POST['item_name']));
    $item_number = trim(stripslashes($_POST['item_number']));
    $payment_status = trim(stripslashes($_POST['payment_status']));
    $payment_gross = trim(stripslashes($_POST['payment_gross']));
    $txn_id = trim(stripslashes($_POST['txn_id']));
    $receiver_email = trim(stripslashes($_POST['receiver_email']));
    $payer_email = trim(stripslashes($_POST['payer_email']));
    $payment_date = trim(stripslashes($_POST['payment_date']));
    $invoice =  trim(stripslashes($_POST['invoice']));
    $quantity = trim(stripslashes($_POST['quantity']));
    $pending_reason = trim(stripslashes($_POST['pending_reason']));
    $payment_method = trim(stripslashes($_POST['payment_method']));
    $first_name = trim(stripslashes($_POST['first_name']));
    $last_name = trim(stripslashes($_POST['last_name']));
    $address_street = trim(stripslashes($_POST['address_street']));
    $address_city = trim(stripslashes($_POST['address_city']));
    $address_state = trim(stripslashes($_POST['address_state']));
    $address_zipcode = trim(stripslashes($_POST['address_zip']));
    $address_country = trim(stripslashes($_POST['address_country']));
    $payer_email = trim(stripslashes($_POST['payer_email']));
    $address_status = trim(stripslashes($_POST['address_status']));
    $payer_status = trim(stripslashes($_POST['payer_status']));
    $notify_version = trim(stripslashes($_POST['notify_version'])); 
    $verify_sign = trim(stripslashes($_POST['verify_sign'])); 
    $business = trim(stripslashes($_POST['business'])); 
    $custom = trim(stripslashes($_POST['custom'])); 
    $txn_type = trim(stripslashes($_POST['txn_type'])); 
    
    /*
    if($paypal_receiver_email != "$receiver_email"){
        $error_message .= "Error code 501. Possible fraud. Error with receiver_email. receiver_email = $receiver_email\n";
        $error++;
    }  
    */
    if( PAYPAL_DEBUG != "1" ) {
    
        $paypal_iplist = gethostbynamel('www.paypal.com');
        
        $paypal_sandbox_hostname = 'ipn.sandbox.paypal.com';
        $remote_hostname = gethostbyaddr( $_SERVER['REMOTE_ADDR'] );
        
        $valid_ip = false;
        
        if( $paypal_sandbox_hostname == $remote_hostname ) {
            $valid_ip = true;
            $hostname = "www.sandbox.paypal.com";
        }
        else {
            $ips = "";
            foreach( $paypal_iplist as $ip ) {
                $ips .= "$ip,";
                $parts = explode( ".", $ip );
                $first_three = $parts[0].".".$parts[1].".".$parts[2];
                if( preg_match("/^$first_three/", $_SERVER['REMOTE_ADDR']) ) {
                    $valid_ip = true;
                    $hostname = "www.paypal.com";
                }
            }
        }
        
        if( !$valid_ip ) {
            debug_msg( "Error code 506. Possible fraud. Error with REMOTE IP ADDRESS = ".$_SERVER['REMOTE_ADDR'].". 
                        The remote address of the script posting to this notify script does not match a valid PayPal ip address\n" );
            $mail->From = $mosConfig_mailfrom;
            $mail->FromName = $mosConfig_fromname;
            $mail->AddAddress(PAYPAL_EMAIL);
            $mail->Subject = "PayPal IPN Transaction on your site: Possible fraud";
            $mail->Body = "Error code 506. Possible fraud. Error with REMOTE IP ADDRESS = ".$_SERVER['REMOTE_ADDR'].". 
                        The remote address of the script posting to this notify script does not match a valid PayPal ip address\n
            These are the valid IP Addresses: $ips
            
            The Order ID received was: $invoice";
            $mail->Send();
            exit();
        }
    }
    /**--------------------------------------------
    * Create message to post back to PayPal...
    * Open a socket to the PayPal server...
    *--------------------------------------------*/
    // To Debug this script, just visit www.eliteweaver.co.uk/testing/ipntest.php
    if(@PAYPAL_DEBUG=="1") {
        $uri = "/testing/ipntest.php";
        $hostname = "www.eliteweaver.co.uk";
        
    }
    // regular mode: Post to paypal.com
    else {
        $uri = "/cgi-bin/webscr";
    }   
    $header = "POST $uri HTTP/1.0\r\n";
    $header.= "User-Agent: PHP/".phpversion()."\r\n";
    $header.= "Referer: ".$_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'].@$_SERVER['QUERY_STRING']."\r\n";
    $header.= "Server: ".$_SERVER['SERVER_SOFTWARE']."\r\n";
    $header.= "Host: ".$hostname.":80\r\n";
    $header.= "Content-Type: application/x-www-form-urlencoded\r\n";
    $header.= "Content-Length: ".strlen($workstring)."\r\n";
    $header.= "Accept: */*\r\n\r\n";
    
    $fp = fsockopen ( $hostname, 80, $errno, $errstr, 30);
    
    debug_msg( "3. Connecting to: $hostname"."$uri
                Using these http Headers: 
                
                $header
                
                and this String:
                
                $workstring");
    //----------------------------------------------------------------------
    // Check HTTP connection made to PayPal OK, If not, print an error msg
    //----------------------------------------------------------------------
    if (!$fp) {
        $error_description = "$errstr ($errno)
        Status: FAILED";
        
        debug_msg( "4. Connection failed: $error_description" );
        
        $res = "FAILED";
        
        $mail->From = $mosConfig_mailfrom;
        $mail->FromName = $mosConfig_fromname;
        $mail->AddAddress(PAYPAL_EMAIL);
        $mail->Subject = "PayPal IPN Fatal Error on your Site";
        $mail->Body = "Hello,
        A fatal error occured while processing a paypal transaction.
        ----------------------------------
        Hostname: $hostname
        URI: $uri
        $error_description";
        $mail->Send();
    }
    
    //--------------------------------------------------------
    // If connected OK, write the posted values back, then...
    //--------------------------------------------------------
    else {
      
      debug_msg( "4. Connection successful. Now posting to $hostname"."$uri" );
      
      fwrite($fp, $header . $workstring);
      
      while (!feof($fp)) {
           $res .= fgets ($fp, 1024);
      }
      fclose ($fp);
    
      $error_description = "Response from $hostname: " . $res."\n";
      
      debug_msg( "5. $error_description ");
      
      // Get the Order Details from the database      
      $qv = "SELECT order_id, order_number, user_id FROM #__pshop_orders ";
      $qv .= "WHERE order_number='".$invoice."'";
      $dbbt = new ps_DB;
      $dbbt->query($qv);
      $dbbt->next_record();
      $order_id = $dbbt->f("order_id");
     
      $d['order_id'] = $order_id;
      
      // remove post headers if present.
      $res = preg_replace("'Content-type: text/plain'si","",$res);
      
      //-------------------------------------------
      // ...read the results of the verification...
      // If VERIFIED = continue to process the TX...
      //-------------------------------------------
        if (eregi ( "VERIFIED", $res)) {
            //----------------------------------------------------------------------
            // If the payment_status is Completed... Get the password for the product
            // from the DB and email it to the customer.
            //----------------------------------------------------------------------
            if (eregi ("Completed", $payment_status) || eregi ("Pending", $payment_status)) {
                 
                if (empty($order_id)) {
                    $mail->From = $mosConfig_mailfrom;
                    $mail->FromName = $mosConfig_fromname;
                    $mail->AddAddress(PAYPAL_EMAIL);
                    $mail->Subject = "PayPal IPN Transaction on your site: Order ID not found";
                    $mail->Body = "The right order_id wasn't found during a PayPal transaction on your website.
                    The Order ID received was: $invoice";
                    $mail->Send();
                }
                
                // UPDATE THE ORDER STATUS to 'Completed'
                if(eregi ("Completed", $payment_status)) {
                    $d['order_status'] = PAYPAL_VERIFIED_STATUS;                    
                }
                // UPDATE THE ORDER STATUS to 'Pending'
                elseif(eregi ("Pending", $payment_status)) {
                    $d['order_status'] = PAYPAL_PENDING_STATUS;
                }
                require_once ( CLASSPATH . 'ps_order.php' );
                $ps_order= new ps_order;
                $ps_order->order_status_update($d);
                $mail->From = $mosConfig_mailfrom;
                $mail->FromName = $mosConfig_fromname;
                $mail->AddAddress(PAYPAL_EMAIL);
                $mail->Subject = "PayPal IPN txn on your site";
                $mail->Body = "Hello,\n\n;"
                $mail->Body .= "a PayPal transaction for you has been made on your website!\n";
                $mail->Body .= "-----------------------------------------------------------\n";
                $mail->Body .= "Transaction ID: $txn_id\n";
                $mail->Body .= "Payer Email: $payer_email\n";
                $mail->Body .= "Order ID: $order_id\n";
                $mail->Body .= "Payment Status: $payment_status (If 'Pending': Order Status won't be updated!)\n";
                $mail->Body .= "Order Status: ".$d['order_status'];
                $mail->Send();
            }
            else { 
                //----------------------------------------------------------------------
                // If the payment_status is not Completed... do nothing but mail
                //----------------------------------------------------------------------
                // UPDATE THE ORDER STATUS to 'INVALID'
                $d['order_status'] = PAYPAL_INVALID_STATUS;
                
                require_once ( CLASSPATH . 'ps_order.php' );
                $ps_order= new ps_order;
                $ps_order->order_status_update($d);
                
                $mail->From = $mosConfig_mailfrom;
                $mail->FromName = $mosConfig_fromname;
                $mail->AddAddress(PAYPAL_EMAIL);
                $mail->Subject = "PayPal IPN Transaction on your site";
                $mail->Body = "Hello,
                a Failed PayPal Transaction on $mosConfig_live_site requires your attention.
                -----------------------------------------------------------
                Order ID: ".$d['order_id']."
                User ID: ".$dbbt->f("user_id")."
                Payment Status: $payment_status 
                
                $error_description";
                $mail->Send();
                
            }
        }
        //----------------------------------------------------------------
        // ..If UNVerified - It's 'Suspicious' and needs investigating!
        // Send an email to yourself so you investigate it.
        //----------------------------------------------------------------
        elseif (eregi ("INVALID", $res)) {
                $mail->From = $mosConfig_mailfrom;
                $mail->FromName = $mosConfig_fromname;
                $mail->AddAddress(PAYPAL_EMAIL);
                $mail->Subject = "Invalid PayPal IPN Transaction on your site";
                $mail->Body = "Hello,\n\n";
                $mail->Body .= "An Invalid PayPal Transaction requires your attention.\n";
                $mail->Body .= "-----------------------------------------------------------\n";
                $mail->Body .= "REMOTE IP ADDRESS: ".$_SERVER['REMOTE_ADDR']."\n";
                $mail->Body .= "REMOTE HOST NAME: $remote_hostname\n";
                $mail->Body .= "Order ID: ".$d['order_id']."\n";
                $mail->Body .= "User ID: ".$dbbt->f("user_id")."\n";
                $mail->Body .= $error_description;
                $mail->Send();

        }
        else {
                $mail->From = $mosConfig_mailfrom;
                $mail->FromName = $mosConfig_fromname;
                $mail->AddAddress(PAYPAL_EMAIL);
                $mail->Subject = "PayPal IPN Transaction on your Site";
                $mail->Body = "Hello,
                An error occured while processing a paypal transaction.
                ----------------------------------
                    $error_description";
                $mail->Send();
        }
    }
}
?>
