<?php
/**
* Xaneon Extensions 2.0 for Mambo 4.5.2
* @copyright (c) 2004-2005 Xaneon Development (dev.xaneon.com)
* @license XPL http://dev.xaneon.com/xpl/
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

// Third-party developers can use the following flag to test whether
// Xaneon Extensions is installed and activated.
if (defined( '_XE' )) return;
define( '_XE', 1 );
define( '_XE_VERSION', '2.0.0-beta2' );

// Check whether Extensions is enabled. The following is a very
// efficient way to check for this: we simply test that Extensions's
// SEF cache file exists and that it's of a non-zero size. If one of
// these conditions is not satisfied, Extensions is disabled.

$sefAdminPath = $mosConfig_absolute_path . '/administrator/components/com_sef';
$sefConfigFile = $sefAdminPath . '/cache.config.php';

$sefEnabled = (file_exists( $sefConfigFile ) && filesize( $sefConfigFile ) > 0);
if ($sefEnabled && $_SERVER['REQUEST_METHOD'] == 'POST' && !empty( $_POST['option'] ))
  $sefEnabled = !($_POST['option'] == 'login' || $_POST['option'] == 'login' || $_POST['option'] == 'com_phpshop');

if (!$sefEnabled) {

  // Check whether Search Engine Friendly URLs have been enabled in Mambo's
  // Global Configuration. This setting is found under the SEO tab.
  if (!empty( $mosConfig_sef )) {

    // Mambo's SEF option is enabled but Extensions is disabled; revert
    // to using Mambo's standard SEF URLs (e.g. /content/view/1/2/)
    require_once( $mosConfig_absolute_path . '/includes/sef.php' );

  }
  else {

    // Mambo's SEF option is turned off; revert to Mambo's original-style
    // URLs (e.g. index.php?option=content&task=view&id=1&Itemid=2)
    // We define a dummy sefRelToAbs that actually doesn't do anything.
    function sefRelToAbs( $string ) { return $string;  }

  }

  return; // Skip the rest of this file.
}

unset( $sefEnabled ); // Obviously, we're on.

// Mambo's SEF option and Extensions are both enabled; we're good to
// go! Include all necessary code for Extensions to handle incoming
// URL requests.

// Let's connect to the database. Unfortunately, the following is not the
// most efficient way of doing this, as Mambo's index.php will later reopen
// the very same connection; however, this method is AFAIK currently the only
// way for SEF add-ons like XE to function without modifying the core.
if (!isset( $database ) || !is_object( $database )) {
  $database =& new database( $mosConfig_host,
    $mosConfig_user, $mosConfig_password,
    $mosConfig_db, $mosConfig_dbprefix );
}

require_once( $sefAdminPath . '/sef.class.php' );

$sefConfig =& new mosSEFConfig( $database, false );
//$sefConfig->debug = '1';
if (!empty( $sefConfig->debug_for_ip )) {
  if ($sefConfig->debug_for_ip == $_SERVER['REMOTE_ADDR'])
    $sefConfig->debug = '1';
}

// Include any XE 3rd-party extensions. This interface is still
// experimental and subject to change, but this will allow an easy
// way of overriding most of XE's, and some of Mambo's, functionality.
if (!empty( $sefConfig->use_core_ext )) {

  $sefExtPath = $sefAdminPath . '/extensions';
  $sefExtPattern = '^core\\.[\\w\\d]+\\.php$';
  foreach (mosReadDirectory( $sefExtPath, $sefExtPattern  ) as $sefExtFile)
    @include_once( $sefExtPath . '/' . $sefExtFile );
  unset( $sefExtFile, $sefExtPath, $sefExtPattern );

}

// Load core functions *after* any core extensions in order to allow
// for 3PD to override pretty much all our functionality:
require_once( 'sef.functions.php' );

if (!empty( $sefConfig->use_multisite )) {
  $sefSite =& mosSEFSite::lookup(
    $_SERVER['HTTP_HOST'], $_SERVER['REQUEST_URI'] );
}

if (!isset( $sefSite )) {
  $sefSite =& mosSEFSite::getDefault();
  // For any undefined site aliases (wildcard DNS?), redirect browser
  // to the default site
  //if (!empty( $sefConfig->use_canonical_sites )) {
    /*if (strpos( $mosConfig_live_site, '://' . $_SERVER['HTTP_HOST'] ) === false) {
      die( 'Host=' . $_SERVER['HTTP_HOST'] );
      header();
    }*/
  //}
}

// Enforce site-wide security rules and policies.
if (!empty( $sefConfig->enable_security )) {
  define( '_XE_SECURITY', 1 );
  // TODO: security won't be implemented until beta3 or beta4.
  $sefSecurityHandler =& xeLoadSecurityHandler( $database, $sefConfig, $sefSite );
  unset( $sefClassName, $sefSecurity );
}

// Override Mambo configuration globals from the site configuration
if (!empty( $sefConfig->use_multisite ) && !$sefSite->isDefault()) {
  include( 'configuration.php' );
  $sefSite->overrideGlobals();
}

// Display offline page and end processing if the site is offline
if (!empty( $mosConfig_offline )) {
  die( include( 'offline.php' ) );
}

if (!empty( $sefConfig->enable_sef ) || 1) {
  define( '_XE_SEF', 1 );

  $sefResolver =& xeLoadSEFResolver( $database, $sefConfig, $sefSite );

  if (!empty( $sefConfig->use_automap )) {
    $sefAutoMapper =& xeLoadSEFAutoMapper(
      $database, $sefConfig, $sefSite );
    $sefResolver->setAutoMapper( $sefAutoMapper );
  }

  // TODO: recursive handling per configuration directives.
  $sefURL = $_SERVER['REQUEST_URI'];
  if (1) {
    $sefResolver->resolve( $sefURL );
  }

  if (!empty( $sefConfig->debug )) {
    //@print_r( $_GET );
    foreach ($sefResolver->getLog() as $sefLog)
      @print_r( $sefLog . '<br />' );
    unset( $sefLog );
  }

  unset( $sefClassName, $sefResolver, $sefAutoMapper, $sefURL );

}

// If XE (com_sef) is called directly from the frontend (can't think of a
// reason why somebody would do this), let's show a short product blurb in
// place of the pathway. This is AFAIK pretty much the only thing we can do
// in the frontend since sef.php was require_once'd already at the beginning
// of Mambo's index.php and thus won't get a chance to be called again when
// mosMainBody() is invoked in the template. C'est la vie.
if (!empty( $option ) && $option == 'com_sef') {

  function sefHandleFrontendRequest( $s ) {
    $pattern = '#(<span class="pathway">).*(</span>)#';
    $text = 'SEF powered by Xaneon Extensions ' . _XE_VERSION . ' for Mambo';
    $link = 'http://dev.xaneon.com/';
    $banner = '<a href="' . $link . '" target="_blank">' . $text . '</a>';
    return preg_replace( $pattern, '\\1' . $banner . '\\2', $s );
  }
  ob_start( 'sefHandleFrontendRequest' );
  return;

}

?>