<?php
/**
* Xaneon Extensions 2.0 for Mambo 4.5.2
* @copyright (c) 2004-2005 Xaneon Development (dev.xaneon.com)
* @license XPL http://dev.xaneon.com/xpl/
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

function xclLoadComponentAPI( $component ) {
}

class xclBackendAdmin {

  function xclBackendAdmin( &$config, &$tables, &$classes ) {
    error_reporting( E_ALL );

    $this->config =& $config;
    $this->tables =& $tables;
    $this->classes =& $classes;

    $this->mainframe =& $GLOBALS['mainframe'];
    $this->db =& $GLOBALS['database'];
    $this->option = mosGetParam( $_REQUEST, 'option', $GLOBALS['option'] );
    $this->method = strtolower( $_SERVER['REQUEST_METHOD'] );
    $this->act = trim( mosGetParam( $_REQUEST, 'act', null ) );
    $this->task = trim( mosGetParam( $_REQUEST, 'task', null ) );
    $this->taskParam = null;
    if (strpos( $this->task, ',' ) !== false)
      list($this->task, $this->taskParam) = explode( ',', $this->task, 2 );
    $this->cid = mosGetParam( $_REQUEST, 'cid', array( 0 ) );
    if (!is_array( $this->cid )) $this->cid = array ( 0 );

    $mamboPath = $GLOBALS['mosConfig_absolute_path'];
    $mamboSite = $GLOBALS['mosConfig_live_site'];
    $backendPath = "$mamboPath/administrator/components/{$this->option}";
    $frontendPath = "$mamboPath/components/{$this->option}";
    $imagePath = "$mamboSite/administrator/components/{$this->option}/images";
    $basePath = ($mamboPath == $_SERVER['DOCUMENT_ROOT'] ?
      '' : substr( $mamboPath, strlen( $_SERVER['DOCUMENT_ROOT'] ) ));
    $this->mamboPath = $mamboPath;
    $this->mamboSite = $mamboSite;

    require_once( $this->mainframe->getPath( 'class' ) );
    require_once( 'xaneon.config.php' );
    require_once( 'xaneon.langs.php' );

    xclLoadLanguageConstants();

    $xmlFile = $backendPath . '/' .
      str_replace( 'com_', '', $this->option ) . '.xml';
    $this->xml =& new xclPackageInfo( $xmlFile );
    if (is_object( $this->xml ) && $this->xml->isAvailable()) {
      $this->version = $this->xml->getElementText( '/mosinstall/version' );
    }

    require_once( 'Savant2.php' );
    $tpl =& new Savant2();
    $tpl->assign( 'option', $this->option );
    $tpl->assign( 'act', $this->act );
    $tpl->assign( 'task', $this->task );
    $tpl->addPath( 'template', $backendPath . '/admin/' );
    $tpl->loadPlugin( 'dateformat', array( 'format' => '%Y-%m-%d H:i:s' ) );
    $tpl->loadPlugin( 'image', array( 'imageDir' => $basePath . "/administrator/components/{$this->option}/images/" ) );
    $tpl->loadPlugin( 'mambo', array() );
    $tpl->loadFilter( 'trimwhitespace' );
    $this->tpl =& $tpl;

    $tpl->assign( 'aboutLink', "index2.php?option={$this->option}&act=about" );
  }

  function include_file( $name ) {
    require_once( "xaneon.$name.php" );
  }

  function output() {
    $this->header();
    $func1 = 'do_' . $this->act . '_' . $this->task;
    $func2 = 'do_' . $this->act;
    if (method_exists( $this, $func1 )) {
      $result = $this->$func1();
    }
    else if (method_exists( $this, $func2 )) {
      $result = $this->$func2();
    }
    else {
      $result = $this->request();
    }
    $this->footer();
    return $result;
  }

  function redirect( $msg = '' ) {
    $url = xclGetViewURL( $this->option, $this->act );
    //var_dump($_POST); return die($url);
    return die( mosRedirect( $url, $msg ) );
  }

  function update( $field = 'published', $value, $checkin = true ) {
    $table = $this->tables[$this->act];
    $cid =& $this->cid;

    global $my;
    if (!is_array( $cid ) || count( $cid ) < 1) {
      exit;
    }
    $cids = implode( ',', $cid );
    $query = "UPDATE $table SET $field = '$value'" .
      "\nWHERE id IN ($cids)";
    if ($checkin)
      $query .= " AND (checked_out = 0 OR checked_out = '{$my->id}')";
    $this->db->setQuery( $query );
    return $this->db->query();
  }

  function request() {
    if (method_exists( $this, 'do_about' )) {
      return $this->do_about();
    }
    else {
      echo( "Not implemented yet ('{$this->act}', '{$this->task}')." );
    }
  }

  function dump() {
    // Dump ourselves, BUT temporarily unset XML object or Apache will
    // crash and burn.
    $xml =& $this->xml;
    $this->xml = null;
    var_dump( $this );
    $this->xml =& $xml;
  }

  function header() {
    $this->tpl->assign( 'version', $this->version );
    if (!empty( $this->config->backend_sidebar )) {
      $query = "SELECT * FROM #__components AS c" .
        "\nWHERE c.option = '{$this->option}' AND c.parent != '0'" .
        "\nORDER BY c.ordering ASC";
      $this->db->setQuery( $query );
      $this->tpl->assign( 'menu', $this->db->loadObjectList() );
    ?>
    <table width="100%" cellspacing="0" cellpadding="3" border="0">
    <tr>
      <td align="left" valign="top" width="160">
        <?php $this->display( 'sidebar' ); ?>
      </td>
      <td align="left" valign="top" width="100%">
    <?php
    } // if !backend_sidebar
  }

  function footer() {
    if (!empty( $this->config->backend_sidebar )) {
    ?>
      </td>
    </tr>
    </table>
    <?php
    } // if !backend_sidebar
  }

  function do_about() {
    $info =& $this->xml;
    if (!is_object( $info ) || !$info->isAvailable()) {
      // TODO
    }

    $elements = array(
      'name', 'productName', 'creationDate', 'version', 'mamboVersion',
      'author', 'authorName', 'authorEmail', 'authorUrl',
      'productPicture', 'productUrl', 'setupUrl', 'trackerUrl',
      'copyright', 'license', 'licenseText',
      'description', 'warning', 'credits',
    );
    foreach ($elements as $element) {
      $text = $info->getElementText( '/mosinstall/' . $element );
      // This is probably (well, hopefully!) unnecessary, but make sure we
      // pass on the text using UNIX line-endings only. The following takes
      // into account both Windows and Mac EOL characters:
      if (!empty( $text ))
        $text = str_replace( "\r", "\n", str_replace( "\r\n", "\n", $text ) );
      $this->tpl->assign( $element, $text );
    }

    $this->display( 'about' );
  }

  function do_config() {
    $row = $this->config; // copy
    mosMakeHtmlSafe( $row, ENT_QUOTES );
    $this->tpl->assign( 'id', null );
    $this->tpl->assign( 'data', $row );
    if (method_exists( $this, 'config' ))
      $this->config( $row );
    $this->display( 'form' );
  }

  function do_config_save() {
    if (!is_null( $this->config )) {
      foreach ($_POST as $field => $value) {
        if ($field[0] != '_' && $field != 'option' && $field != 'act'
            && $field != 'task' && $field != 'id') {
          if (isset( $this->config->$field )) {
            $this->config->$field = $value;
          }
        }
      }
      $this->config->store( true );
    }
    return $this->redirect( _T( 'CONFIGURATION_UPDATED' ) );
  }

  function display( $template ) {
    //if (isset($templateFile) && file_exists( "$templatePath/$templateFile" )) {
    return $this->tpl->display( $template . '.tpl.php' );
  }

  /*function assign( $varName, &$varValue ) {
    return $this->tpl->assign( $varName, $varValue );
  }*/

  function _default( $allowed = null ) {
    $task = ($this->task ? $this->task : 'view');
    if (is_array( $allowed ) && !in_array( $task, $allowed ))
      return null;
    switch ($this->task) {
      case 'new':
      case 'edit':
        return $this->form();
      case 'save':
        //die( HTML_sef::errorGoBack( $row->getError() ) );
        $className = $this->classes[$this->act];
        $id = (!empty( $_POST['id'] ) ? $_POST['id'] : null);
        $row =& new $className( $this->db, $id );
        if (!is_null( $row )) {
          if (!$row->save( $_POST, null )) {
            die( $row->getError() );
          }
        }
        return $this->redirect();
      case 'remove':
        if (array_key_exists( $this->act, $this->tables )) {
          xclRemove( $this->option, $this->db, $this->cid,  
            str_replace( '#__', '', $this->tables[$this->act] ) );
        }
        return $this->redirect();
      case 'cancel':
        return $this->redirect();
      case 'view':
      default:
        $this->tpl->assign( "rowTemplate", "view_{$this->act}.tpl.php" );
        $this->tpl->assign( $this->view() );
        $this->display( 'view' );
    }
  }  

  function form() {
    $id = ($this->task == 'new' ? '0' : $this->cid[0]);
    $className = $this->classes[$this->act];
    $row =& new $className( $this->db, $id );
    mosMakeHtmlSafe( $row, ENT_QUOTES );
    $this->tpl->assign( 'id', $id );
    $this->tpl->assign( 'data', $row );
    $func = 'form_' . $this->act;
    if (method_exists( $this, $func ))
      $this->$func( $row );
    $this->display( 'form' );
  }

  function view() {
    include_once( $GLOBALS['mosConfig_absolute_path'] .
      '/administrator/includes/pageNavigation.php' );

    $view =& new stdClass();
    $view->title = null;
    $view->icon = null;

    $view->limit = $this->mainframe->getUserStateFromRequest(
      "viewlistlimit", "limit", $GLOBALS['mosConfig_list_limit'] );
    $view->limitstart = $this->mainframe->getUserStateFromRequest(
      "view{$this->option}limitstart", "limitstart", 0 );
    $view->wheres = array();
    $view->orderBy = array();

    $view->className = $this->classes[$this->act];
    $view->table = null;
    if (!is_null( $this->tables )) {
      if (is_array( $this->tables )) {
        if (array_key_exists( $this->act, $this->tables ))
          $view->table = $this->tables[$this->act];
      }
      else {
        $view->table = $this->tables;
      }
    }

    $func = 'view_' . $this->act;
    if (method_exists( $this, $func ))
      $this->$func( $view );

    if (is_null( $view->table )) {
      $total = ($view->rowCount ? $view->rowCount : 0);
      $view->pageNav =& new mosPageNav(
        $total, $view->limitstart, $view->limit  );
    }
    else {
      $query = "SELECT COUNT(*) FROM {$view->table}";
      if (count( $view->wheres ) > 0) $query .= " WHERE " . implode( " AND ", $view->wheres );
      if (count( $view->orderBy ) > 0) $query .= " ORDER BY " . implode( ", ", $view->orderBy );
      $this->db->setQuery( $query );
      $total = $this->db->loadResult();

      $view->pageNav =& new mosPageNav(
        $total, $view->limitstart, $view->limit  );
      $query = "SELECT * FROM {$view->table}";
      if (count( $view->wheres ) > 0) $query .= "\nWHERE " . implode( " AND ", $view->wheres );
      if (count( $view->orderBy ) > 0) $query .= "\nORDER BY " . implode( ", ", $view->orderBy );
      $query .= "\nLIMIT {$view->pageNav->limitstart}, {$view->pageNav->limit}";
      $this->db->setQuery( $query );

      $rows = $this->db->loadObjectList();
      if ($this->db->getErrorNum()) {
        return array( "error" => $this->db->stderr() );
      }

      // This is inefficient but seemingly the only alternative at the moment.
      $objs = array();
      foreach ($rows as $row) {
        $data =& get_object_vars( $row );
        $className = $view->className;
        $obj = new $className( $this->db );
        foreach ($data as $name => $value)
          $obj->$name = $value;
        $objs[] = $obj;
      }
      $view->rows =& $objs;
      $view->rowCount = count( $objs );
    }

    return $view;
  }
}

function xclErrorGoBack( $msg ) {
?>
  <script language="JavaScript">alert('<?php echo( $msg ); ?>'); window.history.go(-1);</script>
<?php
}

function xclGetViewURL( $option, $act = '' ) {
  $url = "index2.php?option=$option";
  if ($act) $url .= "&act=$act";
  $limit = intval( mosGetParam( $_REQUEST, "limit", $GLOBALS['mosConfig_list_limit'] ) );
  $limitstart = intval( mosGetParam( $_REQUEST, "limitstart", 0 ) );
  $url .= "&limit=$limit&limitstart=$limitstart";
  return $url;
}

function xclPublish( $option, &$database, &$cid, $table, $fieldName = "published", $publish = 1 ) {
  if (!is_array( $cid ) || count( $cid ) < 1) {
    $action = ($publish ? "publish" : "unpublish");
    die( xclErrorGoBack( "Select an item or items to $action." ) );
  }

  if (count( $cid )) {
    $cids = implode( ',', $cid );
    $database->setQuery( "UPDATE #__$table SET $fieldName = '$publish' WHERE id IN ($cids)" );
    if (!$database->query()) {
      die( xclErrorGoBack( $database->getErrorMsg() ) );
    }
  }
}

function xclRemove( $option, &$database, &$cid, $table ) {
  if (!is_array( $cid ) || count( $cid ) < 1) {
    die( xclErrorGoBack( "Select an item or items to delete." ) );
  }

  if (count( $cid )) {
    $cids = implode( ',', $cid );
    $database->setQuery( "DELETE FROM #__$table WHERE id IN ($cids)" );
    if (!$database->query()) {
      die( xclErrorGoBack( $database->getErrorMsg() ) );
    }
  }
}

class xclHTML {

  function xclHTML( $section, $name, $html ) {
    $this->name = $name;
    $this->title = _T( strtoupper( $section . '_' . $name ) );
    $this->html = $html;
    $this->help = _T( strtoupper( 'HELP_' . $section . '_' . $name ) );
  }

  function br() {
    return '<br />';
  }

  function label( $tpl, $section, $name, $params = null ) {
    $html = "$title";
    return new xclHTML( $section, $name, $html );
  }

  function textbox( $tpl, $section, $name, $width = 50, $params = null ) {
    $value = (is_object( $tpl ) ? $tpl->data->$name : strval( $tpl ));
    $html = '<input type="text"';
    $html .= ' name="' . $name . '"';
    //$html .= ' value="' . htmlspecialchars( $value ) . '"';
    $html .= ' value="' . $value . '"';
    $html .= ' class="text_area"';
    $html .= ' ' . (!is_string( $width ) ? 'size="' . $width . '"' :
      'style="width:' . $width . '"');
    $html .= ($params ? ' ' . $params : '') . ' />';
    return new xclHTML( $section, $name, $html );
  }

  function textarea( $tpl, $section, $name, $rows = 2, $cols = 50, $params = null ) {
    $value = (is_object( $tpl ) ? $tpl->data->$name : strval( $tpl ));
    $html = '<textarea name="' . $name . '"';
    $html .= ' rows="' . $rows . '" cols="' . $cols . '"';
    $html .= ' class="text_area"';
    $html .= ($params ? ' ' . $params : '') . '>';
    //$html .= htmlspecialchars( $value ) . '</textarea>';
    $html .= $value . '</textarea>';
    return new xclHTML( $section, $name, $html );
  }

  function checkbox( $tpl, $section, $name, $val = '1', $params = null ) {
    $value = (is_object( $tpl ) ? $tpl->data->$name : strval( $tpl ));
    $html = '<input type="checkbox"';
    $html .= ' name="' . $name . '"';
    $html .= ' value="' . $val . '"';
    if ($value == $val)
      $html .= ' checked="1"';
    $html .= ' class="text_area"';
    $html .= ($params ? ' ' . $params : '') . ' />';
    $title = _T( strtoupper( $section . '_' . $name ) );
    $html .= '&nbsp;' . $title . '&nbsp;';
    return new xclHTML( $section, $name, $html );
  }

  function select( $tpl, $section, $name, $values, $params = null ) {
    $value = (is_object( $tpl ) ? $tpl->data->$name : strval( $tpl ));
    $html = '<select name="' . $name . '" class="inputbox" size="1"' .
      ($params ? ' ' . $params : '') . '>';
    foreach ($values as $key => $text) {
      $selected = (strval( $key ) === $value);
      $selected = ($selected ? ' selected="1"' : '');
      //$html .= '<option value="' . htmlspecialchars( $key ) . '"' .
      //  $selected . '>' . $text . '</option>';
      $html .= '<option value="' . $key . '"' .
        $selected . '>' . $text . '</option>';
    }
    $html .= '</select>';
    return new xclHTML( $section, $name, $html );
  }

  function yesNoSelect( $tpl, $section, $name, $showGlobal = false, $params = null ) {
    $values = array();
    if ($showGlobal) $values[null] = 'Use Global';
    $values['0'] = _CMN_NO;
    $values['1'] = _CMN_YES;
    return xclHTML::select( $tpl, $section, $name, $values, $params );
  }

  function yesNoRadio( $tpl, $section, $name, $showGlobal = false, $params = null ) {
    trigger_error( 'TODO: xclHTML::yesNoRadio not implemented yet.', E_USER_WARNING );
  }

  function rangeSelect( $tpl, $section, $name, $start, $end, $showGlobal = false, $params = null ) {
    $values = array();
    if ($showGlobal) $values[null] = 'Use Global';
    for ($i = $start; $i <= $end; $i++)
      $values[$i] = $i;
    return xclHTML::select( $tpl, $section, $name, $values, $params );
  }
}

?>