/**
 * MambelFish - Mambos Babelfish
 * Copyright (C) 2003 Think Network GmbH
 * All rights reserved.  The mambel fish project is a extention hack and
 * component for the Mambo Open Server. It enables Mambo OS to handle multi
 * lingual sites especially in all dynamic contents which are stored in the
 * database.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
 *
 * The "GNU General Public License" (GPL) is available at
 * http: *www.gnu.org/copyleft/gpl.html
 * --------------------------------------------------------------------------------
 * $Id: mambelfish.sql,v 1.1 2004/12/09 23:48:59 akede Exp $
 *
 **/

/** SQL Script to create the structure and main information of MambelFish **/
#
# Tabellenstruktur fr Tabelle `mos_mbf_content`
#

DROP TABLE IF EXISTS `mos_mbf_content`;
CREATE TABLE `mos_mbf_content` (
  `id` int(10) unsigned NOT NULL auto_increment,
  `language_id` int(11) NOT NULL default '0',
  `reference_id` int(11) NOT NULL default '0',
  `reference_table` varchar(100) NOT NULL default '',
  `reference_field` varchar(100) NOT NULL default '',
  `value` mediumtext NOT NULL,
  `original_value` mediumtext,
  `modified` datetime NOT NULL default '0000-00-00 00:00:00',
  `modified_by` int(11) unsigned NOT NULL default '0',
  `published` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Tabellenstruktur fr Tabelle `mos_mbf_language`
#

DROP TABLE IF EXISTS `mos_mbf_language`;
CREATE TABLE `mos_mbf_language` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `active` tinyint(1) NOT NULL default '0',
  `iso` CHAR(10),
  `mambo` varchar(20) NOT NULL default '',
  `image` varchar(100) NULL,
  `ordering` int(11) NOT NULL default 0,
  PRIMARY KEY  (`id`)
) TYPE=MyISAM;

#
# Daten fr Tabelle `mos_mbf_language`
#

INSERT INTO `mos_mbf_language` VALUES (1, 'English', 1, 'en', 'english', '', 0);
