<?php
// MambelFish - Mambos Babelfish
// Copyright (C) 2003-2005 Think Network GmbH
// All rights reserved.  The mambel fish project is a extention hack and
// component for the Mambo Open Server. It enables Mambo OS to handle multi
// lingual sites especially in all dynamic contents which are stored in the
// database.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html
// --------------------------------------------------------------------------------
// $Id: mambelfish.class.php,v 1.6 2005/03/16 19:02:51 akede Exp $
//

// Don't allow direct linking
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

// XML library
global $mosConfig_absolute_path;
require_once( $mosConfig_absolute_path . "/includes/domit/xml_domit_lite_include.php" );

/**
 * The MambelFishManager controls all important configuration and information
 * of the content elements. These information might be cached in the session
 * settings if necessary in furture.
 *
 * @package mambelfish
 * @copyright 2003-2005 Think Network GmbH
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 * @version 1.0, 2003-10-16 $Revision: 1.6 $
 * @author Alex Kempkens <mambelfish@thinknetwork.com>
*/
class MambelFishManager {
	/** Array of all known content elements and the reference to the XML file */
	var $_contentElements;
	
	/** Path to the administration dir of the component */
	var $_adminPath='';
	
	/** string Content type which can use default values */
	var $DEFAULT_CONTENTTYPE="content";
	
	/** @var config Configuration of the map */
	var $_config=null;

	/** Standard constructor */
	function MambelFishManager($adminPath=null) {
		global $mosConfig_absolute_path, $mosConfig_admin_path;
		if( $adminPath===null ) {
			$adminPath = dirname( __FILE__ );
		}
		$this->_adminPath = $adminPath;
		
		$this->_loadConfiguration( $adminPath );
		//$this->_loadContentElements( $adminPath );
	}
	
	/** Loading of component configuration
	*/
	function _loadConfiguration() {
		$this->_config = new stdClass();
		require( "$this->_adminPath/config.mambelfish.php" );
		$this->_config->noTranslation = $mambelfish_noTranslation;
		$this->_config->defaultText = $mambelfish_defaultText;
		$this->_config->frontendMode = $mambelfish_frontendMode;
		$this->_config->textSpacer = $mambelfish_textSpacer;
	}

	/**
	 * Saving of the file based configurations
	 */
	function saveConfiguration () {
		global $option;
		
		$configfile = "$this->_adminPath/config.mambelfish.php";
		@chmod ($configfile, 0766);
		$permission = is_writable($configfile);
		if (!$permission) {
			$mosmsg = _MBF_CONFIG_WRITE_ERROR;
			return false;
		}
		
		$config = "<?php\n";
		$config .= "\$mambelfish_noTranslation = " .$this->_config->noTranslation. ";			// What to show when no translation available\n";
		$config .= "\$mambelfish_defaultText = \"" .$this->_config->defaultText. "\";		// Standard text if no translation - only for certain content elements!\n";
		$config .= "\$mambelfish_frontendMode = \"" .$this->_config->frontendMode. "\";			// How to show the languages\n";
		$config .= "\$mambelfish_textSpacer = \"" .$this->_config->textSpacer. "\";			// Spacer for display text in horizontal mode\n";
		$config .= "?>";
		
		if ($fp = fopen("$configfile", "w")) {
			fputs($fp, $config, strlen($config));
			fclose ($fp);
		}
		$this->_loadConfiguration( $this->_adminPath );
		
		return true;
	}
		
	/** Loading of related XML files
	*/
	function _loadContentElements() {
		// Try to find the XML file
		$filesindir = mosReadDirectory($this->_adminPath ."/contentelements" ,".xml");
		if(count($filesindir) > 0)
		{
			foreach($filesindir as $file)
			{
				$xmlDoc =& new DOMIT_Lite_Document();
				$xmlDoc->resolveErrors( true );
				if ($xmlDoc->loadXML( $this->_adminPath . "/contentelements/" . $file, false, true )) {
					$element = &$xmlDoc->documentElement;
					if ($element->getTagName() == 'mambelfish') {
						if ( $element->getAttribute('type')=='contentelement' ) {
							$nameElements =& $element->getElementsByTagName('name', 1);
							$nameElement =& $nameElements->item(0);
							$name = strtolower( trim($nameElement->getText()) );
							$contentElement =& new ContentElement( $xmlDoc );
							$this->_contentElements[$contentElement->getTableName()] =& $contentElement;
						}
					}
				}
			}
		}
	}

	function getContentElements() {
		if( !isset( $this->_contentElements ) ) {
			$this->_loadContentElements();
		}
		return $this->_contentElements;
	}
	
	/** gives you one content element
	 * @param	key 	of the element
	*/
	function getContentElement( $key ) {
		if( !isset($this->_contentElements) ) {
			$this->_loadContentElements();
		}

		$element = null;
		if( array_key_exists( strtolower($key), $this->_contentElements ) ) {
			$element = $this->_contentElements[ strtolower($key) ];
		}
		return $element;
	}
	
	/**
	* @param string The name of the variable (from configuration.php)
	* @return mixed The value of the configuration variable or null if not found
	*/
	function getCfg( $varname ) {
		if (isset( $this->_config->$varname )) {
			return $this->_config->$varname;
		} else {
			return null;
		}
	}
	
	/**
	* @param string The name of the variable (from configuration.php)
	* @param mixed The value of the configuration variable
	*/
	function setCfg( $varname, $newValue ) {
		if (isset( $this->_config->$varname )) {
			$this->_config->$varname = get_magic_quotes_gpc() ? stripslashes($newValue) : $newValue;
		}
	}
	
	/** Creates an array with all the active languages for the MambelFish
	 *
	 * @return	Array of languages
	 */
	function getActiveLanguages() {
		global $database;
		$langActive=null;
		
		$database->setQuery( 'SELECT * FROM #__mbf_language WHERE active=1 order by ordering' );
		$rows = $database->loadObjectList('id');
		if( $rows ) {
			foreach ($rows as $row) {
				$lang = new mbfLanguage($database);
				$lang->bind($row);
				
				$langActive[] = $lang;
			}
		}
		
		return $langActive;
	}
	
	/** Retrieves the language ID from the given language name
	 *
	 * @param	string	Mambo language name (normally $mosConfig_lang
	 * @return	int 	Database id of this language
	 */
	function getLanguageID( $mamboLangName="" ) {
		global $database;
		$langID = -1;
		if ($mamboLangName != "" ) {
			$database->setQuery( "SELECT id FROM #__mbf_language WHERE active=1 and mambo = '$mamboLangName'order by ordering" );
			$langID = $database->loadResult();
		}
		return $langID;
	}
	
	
	/** Delivers the actual version of the component
	*/
	function getVersion() {
		return "V1.5 (2005-03-16)";
	}
}

/**
 * Content element class based on the xml file
 *
 * @package mambelfish
 * @copyright 2003-2005 Think Network GmbH
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 * @version 1.0, 2003-10-16 $Revision: 1.6 $
 * @author Alex Kempkens <mambelfish@thinknetwork.com>
 */
class ContentElement extends StdClass {
	var $_xmlFile;
	var $checked_out=false;
	var $Name='';
	var $Author='';
	var $Version='';
	var $Description='';
	
	var $referenceInformation;
	
	/** Standard constructor, which loads already standard information
	 * for easy and direct access
	*/
	function ContentElement ( $xmlDoc ) {
		$this->_xmlFile = $xmlDoc;
		
		if( isset($this->_xmlFile) ) {
			$valueElement = $this->_xmlFile->getElementsByPath('name', 1);
			$this->Name = trim($valueElement->getText());
			
			$valueElement = $this->_xmlFile->getElementsByPath('author', 1);
			$this->Author = trim($valueElement->getText());
			
			$valueElement = $this->_xmlFile->getElementsByPath('version', 1);
			$this->Version = trim($valueElement->getText());
			
			$valueElement = $this->_xmlFile->getElementsByPath('description', 1);
			$this->Description = trim($valueElement->getText());
		}
	}
	
	/** Type of reference
	*/
	function getReferenceType() {
		if( !isset($this->referenceInformation["type"]) && isset($this->_xmlFile) ) {
			$tableElement = $this->_xmlFile->getElementsByPath('reference', 1);
			$tableName = trim($tableElement->getAttribute( 'type' ));
			$this->referenceInformation["type"] = $tableName;
		}
		
		return $this->referenceInformation["type"];
	}

	/** Name of the refering table
	*/
	function getTableName() {
		if( !isset($this->referenceInformation["tablename"]) && isset($this->_xmlFile) ) {
			$tableElement = $this->_xmlFile->getElementsByPath('reference/table', 1);
			$tableName = trim($tableElement->getAttribute( 'name' ));
			$this->referenceInformation["tablename"] = $tableName;
		}
		
		return $this->referenceInformation["tablename"];
	}

	/** Array of the field elements in the table
	*/
	function getTable() {
		if( !isset($this->referenceInformation["table"]) && isset($this->_xmlFile) ) {
			$tableElement = $this->_xmlFile->getElementsByPath('reference/table', 1);
			
			$this->referenceInformation["table"] = new ContentElementTable( $tableElement );
		}
		
		return $this->referenceInformation["table"];
	}
	
	/** Generating the sql statement to retrieve the information
	 * from the database
	 */
	function createContentSQL( $idLanguage=-1, $contentid=null, $limitStart=-1, $maxRows=-1 ) {
		$sqlFields=null;
		$where=null;
		$order=null;
		$join=null;
		$contentTable = $this->getTable();
		foreach( $contentTable->Fields as $tableField ) {
			// Based on the types we might want to have special names ;-)
			switch ($tableField->Type) {
				case "referenceid":
					if( strtolower($tableField->Name) != "id" ) {
						$sqlFields[] = 'c.' .$tableField->Name. ' as id';
					}
					$join[] = 'c.' .$tableField->Name. '=mbfc.reference_id';
					break;
				case "titletext":
					if( strtolower($tableField->Name) != "title" ) {
						$sqlFields[] = 'c.' .$tableField->Name. ' as title';
					}
					$join[] = "mbfc.reference_field='" .$tableField->Name. "'";
					$order[] = 'c.' .$tableField->Name;
					break;
				case "modified_date":
					if( strtolower($tableField->Name) != "modified_date" ) {
						$sqlFields[] = 'c.' .$tableField->Name. ' as modified_date';
					}
					break;
				case "checked_out_by":
					if( strtolower($tableField->Name) != "check_out" ) {
						$sqlFields[] = 'c.' .$tableField->Name. ' as check_out';
					}
					break;
			}

			// I want to have each field with his original name in the select
			// so the special fields will be only addon's!
			// Reason: To grap the data later it's more easy to refer to the original names of the XML file
			$sqlFields[] = 'c.' .$tableField->Name. '';
		}
		
		$sqlFields[] = "mbfc.id as mbfc_id";
		$sqlFields[] = "mbfc.value as titleTranslation";
		$sqlFields[] = "mbfc.modified as lastchanged";
		$sqlFields[] = 'mbfc.published as published';
		$sqlFields[] = 'mbfc.language_id';
		$sqlFields[] = 'mbfl.name as language';
		$join[] = "mbfc.reference_table='$contentTable->Name'";
		if( isset($contentid) && $contentid!=-1 ) {
			$where[] = 'c.id=' .$contentid;
		}
		if( isset($idLanguage) && $idLanguage!=-1 ) {
			if( $idLanguage==NULL ) {
				$where[] = "mbfc.language_id IS NULL";
			} else {
				$join[] = "mbfc.language_id=$idLanguage";
			}
		}

		if( $contentTable->Filter != '' ) {
			$where[] = $contentTable->Filter;
		}
		
		
		$sql = "SELECT " .implode( ', ', $sqlFields )
			. "\nFROM #__" .$contentTable->Name. ' as c'
			. "\nLEFT JOIN #__mbf_content as mbfc ON " .implode( ' AND ', $join )
			. "\nLEFT JOIN #__mbf_language as mbfl ON mbfc.language_id=mbfl.id"
			. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
			. (count( $order ) ? "\nORDER BY " . implode( ', ', $order ) : "");
		
		if( $limitStart!=-1 ) {
			$sql .= "\nLIMIT $limitStart, $maxRows";
		}
//echo "sql = >$sql<<br />";
		
		return $sql;
	}

	/** Generating the sql statement to count the information
	 */
	function countContentSQL($idLanguage=-1) {
		$contentTable = $this->getTable();
		$join=null;
		$where=null;
		$order=null;
		$group=null;
		
		foreach( $contentTable->Fields as $tableField ) {
			// Based on the types we might want to have special names ;-)
			if ( $tableField->Type == "referenceid" ) {
					$join[] = 'c.' .$tableField->Name. '=mbfc.reference_id';
					$group[] = 'c.' .$tableField->Name;
					$group[] = "mbfc.language_id";
			}
		}

		$sqlFields[] = "c.*, mbfc.language_id";
		$join[] = "mbfc.reference_table='$contentTable->Name'";
		if( isset($idLanguage) && $idLanguage!=-1 ) {
			if( $idLanguage=='NULL' ) {
				$where[] = "mbfc.language_id IS NULL";
			} else {
				$join[] = "mbfc.language_id=$idLanguage";
			}
		}
		
		if( $contentTable->Filter != '' ) {
			$where[] = $contentTable->Filter;
		}
		
		$sql = "SELECT " .implode( ', ', $sqlFields )
			. "\nFROM #__" .$contentTable->Name. ' as c'
			. "\nLEFT JOIN #__mbf_content as mbfc ON " .implode( ' AND ', $join )
			. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
			. (count( $group ) ? "\nGROUP BY " . implode( ', ', $group ) : "")
			. (count( $order ) ? "\nORDER BY " . implode( ', ', $order ) : "");

		return $sql;
	}
}

/**
 * Description of a content element table.
 *
 * @package mambelfish
 * @copyright 2003-2005 Think Network GmbH
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 * @version 1.0, 2003-10-16 $Revision: 1.6 $
 * @author Alex Kempkens <mambelfish@thinknetwork.com>
 */
class ContentElementTable {
	var $Name;
	var $Fields;
	var $Filter;
	
	/** Standard constructor
	*/
	function ContentElementTable( $tableElement ) {
		$this->Name = trim( $tableElement->getAttribute( 'name' ) );
		
		$tableFields = $tableElement->getElementsByTagName( 'field' );
		$tableFields = $tableFields->toArray();
		$this->Fields = null;
		foreach( $tableFields as $tablefieldElement ) {
			$this->Fields[] = new ContentElementTablefield( $tablefieldElement );
		}

		$filterElement = $tableElement->getElementsByPath('filter', 1);
		if( $filterElement ) {
			$this->Filter = $filterElement->getText();
		}
	}
	
	/** Retrieves one field based on the name
	 * @param	string	Fieldname
	 * @return	object	field
	 */
	function getField( $name ) {
		$ret_field = null;
		foreach( $this->Fields  as $field ) {
			if ($field->Name == $name ) {
				$ret_field = $field;
				break;
			}
		}
				
		return $ret_field;	
	}
}

/**
 * Description of a table field
 *
 * @package mambelfish
 * @copyright 2003-2005 Think Network GmbH
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 * @version 1.0, 2003-10-16 $Revision: 1.6 $
 * @author Alex Kempkens <mambelfish@thinknetwork.com>
 */
class ContentElementTablefield {
	var $Type='';
	var $Name='';
	var $Lable='';
	var $Translate=false;
	var $Option='';
	
	/** originalValue value of the corresponding content table */
	var $originalValue;

	/** translationContent reference to the actual translation db object */
	var $translationContent;

	/** changed Flag that says if a field is changed or not */
	var $changed=false;
	
	/**
	
	/** Standard constructur
	*/
	function ContentElementTablefield( $tablefieldElement ) {
		$this->Type = trim( $tablefieldElement->getAttribute( 'type' ) );
		$this->Name = trim( $tablefieldElement->getAttribute( 'name' ) );
		$this->Lable = trim( $tablefieldElement->getText() );
		$this->Translate = trim( $tablefieldElement->getAttribute( 'translate' ) );
		$this->Option = trim( $tablefieldElement->getAttribute( 'option' ) );
	}
}

/**
 * Representation of one content with his translation.
 * The object includes information from the original object and
 * the refering translation. Based on that information it is
 * able to handle all necessary interactions with the tranlsation.
 * Each instance of this object represents only one translation in
 * on specified language, but it handles all the fields within the
 * ContentElement.
 *
 * @package mambelfish
 * @copyright 2003-2005 Think Network GmbH
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 * @version 1.0, 2003-10-16 $Revision: 1.6 $
 * @author Alex Kempkens <mambelfish@thinknetwork.com>
 */
class ContentObject {
	/** _contentElement Reference to the ContentElement definition of the instance */
	var $_contentElement;
	
	/** id ID of the based content */
	var $id;
	
	/** checked_out User who checked out this content if any */
	var $checked_out;
	
	/** title Title of the object; used from the field configured as titletext */
	var $title;
	
	/** titleTranslation the actual translation of the title */
	var $titleTranslation;
	
	/** language_id language for the translation */
	var $language_id;
	
	/** language Language name of the content */
	var $language;
	
	/** lastchanged Date when the translation was last modified */
	var $lastchanged;
	
	/** modified_date Date of the last modification of the content - if existing */
	var $modified_date;
	
	/** state State of the translation
	 * -1 := for at least one field of the content the translation is missing
	 *  0 := the translation exists but the original content was changed
	 *  1 := the translation is valid
	 */
	var $state=-1;
	
	/** published Flag if the translation is published or not */
	var $published=false;

	/** Standard constructor
	 *
	 * @param	languageID		ID of the associated language
	 * @param	elementTable	Reference to the ContentElementTable object
	 */
	function ContentObject( $languageID,& $contentElement, $id=-1 ) {
		global $database;
		
		if($id>0) $this->id = $id;
		$this->language_id = $languageID;
		$lang = new mbfLanguage($database);
		$lang->load( $languageID );
		$this->language = $lang->name;
		$this->_contentElement = $contentElement;
	}
	
	/** Loads the information based on a certain content ID
	 */
	function loadFromContentID( $id=null ) {
		global $database;
		if( $id!=null ) {
			$database->setQuery( $this->_contentElement->createContentSQL( $this->language_id, $id ) );
			$row=null;
			$database->loadObject( $row );
			$this->id = $id;
			$this->readFromRow( $row );
		}
	}
	
	/** Reads the information from the values of the form
	 * The content element will be loaded first and then the values of the override
	 * what is actually in the element
	 * 
	 * @param	array	The values which should be bound to the object
	 * @param	string	The field prefix
	 * @param	string	An optional field 
	 */
	function bind( $formArray, $prefix="", $suffix="", $tryBind=true ) {
		global $my, $database;
		if( $tryBind ) {
			mosBindArrayToObject( $formArray, $this );
		}
		if( $this->published=="" ) $this->published=0;

		// Go thru all the fields of the element and try to copy the content values
		$elementTable =& $this->_contentElement->getTable();
		
		for( $i=0; $i<count($elementTable->Fields); $i++ ) {
			$field =& $elementTable->Fields[$i];
			$fieldName=$field->Name;
			if( isset($formArray[$prefix ."refField_". $fieldName .$suffix]) ) {
				$translationValue = $formArray[$prefix ."refField_". $fieldName .$suffix];
				$originalValue = $formArray[$prefix ."origValue_". $fieldName .$suffix];
				$fieldContent = new mbfContent($database);
				mosBindArrayToObject( $formArray, $fieldContent );
				$fieldContent->id=$formArray[$prefix . "id_" .$fieldName .$suffix];
				$fieldContent->reference_id = (intval($formArray[$prefix . "reference_id" .$suffix]) > 0) ? intval($formArray[$prefix . "reference_id" .$suffix]) : $this->id;
				$fieldContent->language_id = $this->language_id;
				$fieldContent->reference_table= $database->getEscaped( $elementTable->Name );
				$fieldContent->reference_field= $database->getEscaped( $fieldName );
				$fieldContent->value = (get_magic_quotes_gpc()) ? stripslashes( $translationValue ) : $translationValue;
				$fieldContent->original_value = (get_magic_quotes_gpc()) ? stripslashes( $originalValue ) : $originalValue;
				$fieldContent->modified = date( "Y-m-d H:i:s" );
				$fieldContent->modified_by = $my->id;
				$fieldContent->published=$this->published;
				$field->translationContent = $fieldContent;
			}
		}
	}
	
	/** Reads the information out of an existing mosDBTable object into the contentObject.
	 *
	 * @param	object	instance of an mosDBTable object
	 */
	function updateMLContent( &$dbObject ) {
		global $database;
		if( $dbObject === null ) return;
		
		if( $this->published=="" ) $this->published=0;
		
		// retriev the original untranslated object for references
		$origObject = $dbObject;
		$key = $dbObject->get( '_tbl_key' );
		$database->setQuery( "SELECT * FROM " .$dbObject->get('_tbl'). " WHERE " .$key. "='" .$dbObject->$key. "'" );
		$database->loadObject( $origObject, false );
						
		// Go thru all the fields of the element and try to copy the content values
		$elementTable =& $this->_contentElement->getTable();
		
		for( $i=0; $i<count($elementTable->Fields); $i++ ) {
			$field =& $elementTable->Fields[$i];
			$fieldName=$field->Name;
			if( isset($dbObject->$fieldName) && $field->Translate ) {

				
				$translationValue = $dbObject->$fieldName;
				$fieldContent =& $field->translationContent;
				
				$fieldContent->value = $translationValue;
				$dbObject->$fieldName = $origObject->$fieldName;
				$fieldContent->original_value = $origObject->$fieldName;

				$fieldContent->modified = date( "Y-m-d H:i:s" );
				$fieldContent->modified_by = $my->id;
			}
		}
	}
	
	/** Reads some of the information from the overview row
	 */
	function readFromRow( $row ) {
		$this->id = $row->id;
		$this->title = $row->title;
		$this->titleTranslation = $row->titleTranslation;
		if( !isset($this->language_id) || $this->language_id == -1 ) {
			$this->language_id = $row->language_id;
			$this->language = $row->language;
		}
		$this->lastchanged = $row->lastchanged;
		$this->published = $row->published;
		if( isset($row->modified_date) ) $this->modified_date = $row->modified_date;
		if( isset($row->checked_out) ) $this->checked_out = $row->checked_out;
		
		// Go thru all the fields of the element and try to copy the content values
		$elementTable =& $this->_contentElement->getTable();
		$fieldContent = new mbfContent($database);
		for( $i=0; $i<count($elementTable->Fields); $i++ ) {
			$field =& $elementTable->Fields[$i];
			$fieldName = $field->Name;
			if( isset($row->$fieldName) ) {
				$field->originalValue = $row->$fieldName;
			}
		}
		
		
		$this->_loadContent();
	}
	
	/** Reads all translation information from the database
	 *
	 */
	function _loadContent() {
		global $database;
		
		$elementTable = $this->getTable();
		$sql = "select * "
				."\n  from #__mbf_content"
				."\n where reference_id=" .$this->id
				."\n   and reference_table='" .$elementTable->Name. "'";
		if( isset($this->language_id) && $this->language_id!="" ) {
			$sql .= "\n   and language_id=" .$this->language_id;
		}
		
//echo "load sql=>$sql<<br />";
		$database->setQuery( $sql );
		$rows = $database->loadObjectList();
		echo $database->getErrorMsg();
		
		$translationFields=null;
		if( count($rows) > 0 ) {
			foreach( $rows as $row ) {
				$fieldContent = new mbfContent($database);
				if( !$fieldContent->bind( $row ) ) {
					echo $fieldContent->getError();
				}
				$translationFields[$fieldContent->reference_field] = $fieldContent;
			}
		}
				
		// Check fields and their state
		for( $i=0; $i<count($elementTable->Fields); $i++ ) {
			$field =& $elementTable->Fields[$i];
			if( isset($translationFields[$field->Name]) ) {
				$fieldContent = $translationFields[$field->Name];
			} else {
				$fieldContent = null;
			}

			if( $field->Translate && isset($fieldContent) ) {
				if( $field->originalValue != $fieldContent->original_value ) {
					$this->state=0;
					$field->changed=true;
				} else {
					$this->state= $this->state==-1 ? 1 : $this->state;
					$field->changed=false;
				}
			}
			elseif ($field->Translate) {
				$fieldContent = new mbfContent($database);
				$fieldContent->reference_id = $this->id;
				$fieldContent->reference_table = $elementTable->Name;
				$fieldContent->reference_field = $field->Name;
				$fieldContent->language_id = $this->language_id;
				$fieldContent->original_value = $field->originalValue;
				$this->state= $this->state!=-1 ? 0 : $this->state;
				$field->changed=true;
			}
			$field->translationContent = $fieldContent;
		}
	}
	
	/** Returns the content element fields which are text and can be translated
	 *
	 * @param	boolean	onle translateable fields?
	 * @return	array	of fieldnames
	 */
	function getTextFields( $translation = true ) {
		$elementTable =& $this->_contentElement->getTable();
		$textFields = null;
		
		for( $i=0; $i<count($elementTable->Fields); $i++ ) {
			$field =& $elementTable->Fields[$i];
			$fieldType = $field->Type;
			if( $field->Translate == $translation && ($fieldType=="htmltext" || $fieldType=="text") ) {
				$textFields[] = $field->Name;
			}
		}
		
		return $textFields;
	}
	
	/** Sets all fields of this content object to a certain published state
	*/
	function setPublished( $published ) {
		$elementTable =& $this->_contentElement->getTable();
		for( $i=0; $i<count($elementTable->Fields); $i++ ) {
			$field =& $elementTable->Fields[$i];
			$fieldContent =& $field->translationContent;
			$fieldContent->published = $published;
		}
	}
	
	/** Updates the reference id of all included fields. This
	 * Happens e.g when the reference object was created new
	 *
	 * @param	referenceID		new reference id
	 */
	function updateReferenceID( $referenceID ) {
		if( intval($referenceID) <= 0 ) return;
		
		$elementTable =& $this->_contentElement->getTable();
		for( $i=0; $i<count($elementTable->Fields); $i++ ) {
			$field =& $elementTable->Fields[$i];
			$fieldContent =& $field->translationContent;
			$fieldContent->reference_id = $referenceID;
		}
	}
	
	/** Stores all fields of the content element
	 */
	function store() {
		$elementTable =& $this->_contentElement->getTable();
		for( $i=0; $i<count($elementTable->Fields); $i++ ) {
			$field =& $elementTable->Fields[$i];
			$fieldContent =& $field->translationContent;
			
			if( $field->Translate ) {
				if( isset($fieldContent->reference_id) ) {
					if ( isset($fieldContent->value) && $fieldContent->value!='' ) {
						$fieldContent->store();
					} else {
						$fieldContent->delete();
					}
				}
			}
		}
	}
	
	/** Checkouts all fields of this content element
	*/
	function checkout( $who, $oid=null ) {
		$elementTable =& $this->_contentElement->getTable();
		for( $i=0; $i<count($elementTable->Fields); $i++ ) {
			$field =& $elementTable->Fields[$i];
			$fieldContent =& $field->translationContent;
			
			if( $field->Translate ) {
				if( isset($fieldContent->reference_id) ) {
					$fieldContent->checkout( $who, $oid );
					echo $fieldContent->getError();
				}
			}
		}
	}
	
	/** Checkouts all fields of this content element
	*/
	function checkin( $oid=null ) {
		$elementTable =& $this->_contentElement->getTable();
		for( $i=0; $i<count($elementTable->Fields); $i++ ) {
			$field =& $elementTable->Fields[$i];
			$fieldContent =& $field->translationContent;
			
			if( $field->Translate ) {
				if( isset($fieldContent->reference_id) ) {
					$fieldContent->checkin( $oid );
					echo $fieldContent->getError();
				}
			}
		}
	}
	
	/** Delets all translations (fields) of this content element
	*/
	function delete( $oid=null ) {
		$elementTable =& $this->_contentElement->getTable();
		for( $i=0; $i<count($elementTable->Fields); $i++ ) {
			$field =& $elementTable->Fields[$i];
			$fieldContent =& $field->translationContent;
			if( $field->Translate ) {
				if( isset($fieldContent->reference_id) ) {
					if( !$fieldContent->delete( $oid ) ) {
						echo $fieldContent->getError() ."<br />";
					}
				}
			}
		}
	}	
	/** Returns the content element table this content is based on
	 */
	function getTable() {
		return $this->_contentElement->getTable();
	}
}

/**
 * Multi lingual Database connector class
 *
 * This extention of the standard database class converts the output of the query automatically
 * with the actual selected language in the web site.
 *
 * @copyright 2003-2005 Think Network GmbH
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 * @version 1.0, 2003-10-16 $Revision: 1.6 $
 * @author Alex Kempkens <mambelfish@thinknetwork.com>
 * @package mambelfish
*/
class mlDatabase extends database {

	
	/**
	* This global function loads the first row of a query into an object
	*
	* If an object is passed to this function, the returned row is bound to the existing elements of <var>object</var>.
	* If <var>object</var> has a value of null, then all of the returned query fields returned in the object.
	* @param string The SQL query
	* @param object The address of variable
	*/
	function loadObject( &$object, $translate=true, $language=null ) {
		global $mosConfig_lang;
		if( $language===null) $language = $mosConfig_lang;

		$result = parent::loadObject( $object );
		if( $translate ) {
			$object = MambelFish::translate( $object, $this->_getTableName(), $mosConfig_lang );
		}
		return $result;
	}

	/**
	* Load a list of database objects
	* @param string The field name of a primary key
	* @return array If <var>key</var> is empty as sequential list of returned TRANSLATED records.
	* If <var>key</var> is not empty then the returned array is indexed by the value
	* the database key.  Returns <var>null</var> if the query fails.
	*/
	function loadObjectList( $key='', $translate=true, $language=null ) {
		global $mosConfig_lang;
		if( $language===null) $language = $mosConfig_lang;
		
		$result = parent::loadObjectList( $key );
		if( $translate ) {
			return MambelFish::translateList( $result, $this->_getTableName(), $language );
		} else {
			return $result;
		}
	}

	/**
	* Overwritten method to loads the first field of the first row returned by the query.
	*
	* @return The value returned in the query or null if the query failed.
	*/
	function loadResult( $translate=true, $language=null ) {
		$result=null;
		$ret=null;
		$this->loadObject( $result, $translate, $language );
		if( $result != null ) {
			$fields = get_object_vars( $result );
			$field = each($fields);
			$ret = $field[1];
		}
		return $ret;
	}
	
	/**
	* Overwritten update function to enable storage of translated information.
	* Based on the configuration in the content elements the automatic storage of
	* information is activated or not. It is important that this upgraded method will ensure
	* that all information will be written into the translation table. Only in the case that the
	* default language is choosen the information will be updated directly within the original tables.
	* To make sure that all other information will be written into the tables as expected the
	* statements will be manipulated as needed.
	* 
	* @param	string	table name
	* @param	object	instance with information to store
	* @param	string	primary key name of table
	* @param	boolean	update fields with null or not
	* @param	boolean	passthru without storing information in a translation table
	*/
	function updateObject( $table, &$object, $keyName, $updateNulls=true, $passthru=false ) {
		global $mosConfig_lang, $mosConfig_defaultLang, $_MAMBELFISH_MANAGER;
		
		// if the currect language is the site default language the translations will not be updated!
		$passthru = $mosConfig_lang == $mosConfig_defaultLang;
		
		if( !$passthru && isset($_MAMBELFISH_MANAGER)) {
			$actContentObject=null;
			if( isset($table) && $table!="" ) {
				$tableName = ereg_replace( '^#__', '', $table);
				$contentElement = $_MAMBELFISH_MANAGER->getContentElement( $tableName );
				if( isset( $contentElement ) ) {
					$actContentObject = new ContentObject( $_MAMBELFISH_MANAGER->getLanguageID($mosConfig_lang), $contentElement );
					if( isset( $object->$keyName ) ) {
						$actContentObject->loadFromContentID( $object->$keyName );
						$actContentObject->updateMLContent( $object );
						if( isset( $object->state ) ) {
							$actContentObject->published = ($object->state == 1) ? true : false;
						} else if ( isset( $object->published ) ) {
							$actContentObject->published = ($object->published == 1) ? true : false;
						}
						$actContentObject->store();
					}
				}
			}
			return parent::updateObject( $table, $object, $keyName, $updateNulls );
			
		} else {
			return parent::updateObject( $table, $object, $keyName, $updateNulls );
		}
	}
	
	/** Internal function to determit the table name from an sql query
	 *
	 * @return	string	table name
	 */
	function _getTableName() {
		global $mosConfig_dbprefix;

		$posFrom = strpos( strtoupper($this->_sql), 'FROM ') + 5; // after 'FROM '
		$posWhere = strpos( strtoupper($this->_sql), 'WHERE ');
		$table = substr( $this->_sql, $posFrom, $posWhere - $posFrom);
		if( strpos( $table, ' ' ) !== false ) {
			$table = substr( $table, 0, strpos( $table, ' ' ) );
		}
		$table = ereg_replace( $mosConfig_dbprefix, '', $table);
		$table = ereg_replace( "\n", "", $table) ;
		
		return $table;
	}
	
	
}




/**
 * Database class for handling the mambe fish contents
 *
 * @package mambelfish
 * @copyright 2003-2005 Think Network GmbH
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 * @version 1.0, 2003-10-16 $Revision: 1.6 $
 * @author Alex Kempkens <mambelfish@thinknetwork.com>
 */
class mbfContent extends mosDBTable {
/** @var int Primary ke */
	var $id=null;
/** @var int Reference id for the language */
	var $language_id=null;
/** @var int Reference id for the original content */
	var $reference_id=null;
/** @var int Reference table of the original content */
	var $reference_table=null;
/** @var int Reference field of the original content */
	var $reference_field=null;
/** @var string translated value*/
	var $value=null;
/** @var string original value for equals check*/
	var $original_value=null;
/** @var int user that checked out the mbfContent*/
//	var $checked_out=null;					// not yet supported
/** @var datetime time when the checkout was done*/
//	var $checked_out_time=null;			// not yet supported
/** @var date Date of last modification*/
	var $modified=null;
/** @var string Last translator*/
	var $modified_by=null;
/** @var boolean Flag of the translation publishing status*/
	var $published=false;

	/** Standard constructur
	*/
	function mbfContent( &$db ) {
		$this->mosDBTable( '#__mbf_content', 'id', $db );
	}
	
	/**
	 * Bind the content of the newValues to the object. Overwrite to make it possible
	 * to use also objects here
	 */
	function bind( $newValues ) {
		if (is_array( $newValues )) {
			return parent::bind( $newValues );
		} else {
			foreach (get_object_vars($this) as $k => $v) {
				if ( isset($newValues->$k) ) {
					$this->$k = $newValues->$k;
				}
			}
		}
		return true;
	}

	
	/**
	 * Validate language information
	 * Name and Mambo name are mandatory
	 * activated will automatically set to false if not set
	 */
	function check() {
		if (trim( $this->language_id ) == '') {
			$this->_error = _MAMBELFISH_DBERR_NO_LANGUAGE;
			return false;
		}
		
		return true;
	}
	
	function toString() {
		$retString = "<p>content field:<br />";
		$retString .= "id=$this->id; language_id=$this->language_id<br>";
		$retString .= "reference_id=$this->reference_id, reference_table=$this->reference_table, reference_field=$this->reference_field<br>";
		$retString .= "value=>" .htmlspecialchars($this->value). "<<br />";
		$retString .= "original_value=>" .htmlspecialchars($this->original_value). "<<br />";
		$retString .="modified=$this->modified, modified_by=$this->modified_by, published=$this->published</p>";
		
		return $retString;
	}
}
/**
 * Database class for handling the languages within the component
 *
 * @package mambelfish
 * @copyright 2003-2005 Think Network GmbH
 * @license http://www.gnu.org/copyleft/gpl.html GNU Public License
 * @version 1.0, 2003-10-16 $Revision: 1.6 $
 * @author Alex Kempkens <mambelfish@thinknetwork.com>
 */
class mbfLanguage extends mosDBTable {
/** @var int Primary key */
	var $id=null;
/** @var string The full name of the language*/
	var $name=null;
/** @var int Flag if the language is activated for this site*/
	var $active=false;
/** @var string iso name of the language*/
	var $iso=null;
/** @var string The name Mambo is using for this language*/
	var $mambo=null;
/** @var string Order of the languages within the lists*/
	var $ordering=0;
/** @var string Image reference if there is any*/
	var $image="";

	/** Standard constructur
	*/
	function mbfLanguage( &$db ) {
		$this->mosDBTable( '#__mbf_language', 'id', $db );
	}
	
	/**
	 *	Loads the language by it's iso name
	 *	@param string $iso iso name of the language
	 *	@return any result from the database operation
	 */
	function loadByMambo( $mambo=null ) {
		$k = $this->_tbl_key;
		if ($mambo === null) {
			return false;
		}
		$this->_db->setQuery( "SELECT * FROM $this->_tbl WHERE mambo='$mambo'" );
		return $this->_db->loadObject( $this );
	}
	
	/**
	 *	Loads the language by it's iso name
	 *	@param string $iso iso name of the language
	 *	@return any result from the database operation
	 */
	function loadByISO( $iso=null ) {
		$k = $this->_tbl_key;
		if ($iso === null) {
			return false;
		}
		$this->_db->setQuery( "SELECT * FROM $this->_tbl WHERE iso='$iso'" );
		return $this->_db->loadObject( $this );
	}
	
	/**
	 * Validate language information
	 * Name and Mambo name are mandatory
	 * activated will automatically set to false if not set
	 */
	function check() {
		if (trim( $this->name ) == '') {
			$this->_error = "You must enter a name.";
			return false;
		}

		if (trim( $this->mambo ) == '') {
			$this->_error = "You must enter a corresponding Mambo name.";
			return false;
		}

		// check for existing mambo name
		$this->_db->setQuery( "SELECT id FROM #__mbf_language "
			. "\nWHERE mambo='$this->mambo' AND id!='$this->id'"
		);

		$xid = intval( $this->_db->loadResult() );
		if ($xid && $xid != intval( $this->id )) {
			$this->_error = "There is a language already with that mambo name, please try again.";
			return false;
		}
		
		return true;
	}

	/**
	 * Bind the content of the newValues to the object. Overwrite to make it possible
	 * to use also objects here
	 */
	function bind( $newValues ) {
		if (is_array( $newValues )) {
			return parent::bind( $newValues );
		} else {
			foreach (get_object_vars($this) as $k => $v) {
				if ( isset($newValues->$k) ) {
					$this->$k = $newValues->$k;
				}
			}
		}
		return true;
	}
}
?>