<?php

/**
 * 
 * All rights reserved
 * Mambo Open Source is Free Software
 * License: http://www.gnu.org/copyleft/gpl.html
 * 
 * @package  mos_forms
 * @Copyright (C) Rob Clayburn
 * @version $Revision: 1.7 $
 */
 
 class mosForm_Connection extends mosFormDBTable {
 	
 	/** @var int primary key */
 	var $id = null;
 	
 	/** @var string the ip address or url of the databases host */
 	var $host = null;
 	
 	/** @var string the user name to connect to the database with */
 	var $user = null;
 	
 	/** @var string the users password */
 	var $password = null;
 	
 	/** @var string the name of the database to connect to */
 	var $database = null;
 	
 	/** @var string a description of the connection */
 	var $description = null;
 	
 	/** @var bol published state of element */
 	var $state = 0;
 	
 	/** none table vars */
 	/** @var array a list of all the database tables */
 	var $_connectionTables = null;
 	
 	/**
	* @param database A database connector object
	*/
	function mosForm_Connection( &$db ) {		
		$this->mosDBTable( '#__mosform_connections', 'id', $db );
	}
	
	/**
	 * gets object of connections
	 * @param javascript to run on change
	 */
	 
	 function getConnections(  ){
	 		
	 		global $database;
	 		
			$database->setQuery("select *, id as value, description as text from #__mosform_connections where state = '1'");
	
			$realCnns = $database->loadObjectList();
	
			echo $database->getErrorMsg();
	
			return $realCnns;

			//$javascript = "onchange=\"document.adminForm.form_id.selectedIndex = 0;"."changeDynaList( 'db_table_name', connectiontables, document.adminForm.connection_id.options[document.adminForm.connection_id.selectedIndex].value, 0, 0);\"";
	
	 }

	/**
	 * gets dropdown list of published connections
	 * @param object connections stored in database
	 * @param string javascript to run on change
	 * @param string name of connection drop down
	 * @param int default value
	 */
	 	 
	 function getConnectionsDd( $realCnns, $javascript, $name = 'connection_id', $selected ){
	
			$cnns[] = mosHTML :: makeOption('-1', _CHOOSE_NO_CONNECTION);	 
			
			$cnns = array_merge($cnns, $realCnns);	
			
			return mosHTML :: selectList($cnns, $name, 'class="inputbox" size="1" id="' . $name  . '" '.$javascript, 'value', 'text', $selected);
	 }
	 
	
		 
		 	 
	 /**
	 * queries all published connections and returns an multidimensional array
	 * of tables and fields for each connection  
	 * WARNING: this is likely to
	 * exceed php script execution time if querying a larger remote database
	 *
	 * @param object all available connections
	  */
	  
	 function getConnectionTableFields( $realCnns ){

		$connectionTableFields = array (); //$sectioncategories
		
		$connectionTableFields[-1] = array ();
		
		$connectionTableFields[-1][] = mosHTML :: makeOption('-1', _CHOOSE_FIELD);

		foreach ($realCnns as $cn) {

			$connectionTableFields[$cn->value] = array ();

			if ($cn->host and $cn->state == '1') {

				if (@ mysql_connect($cn->host, $cn->user, $cn->password)) {

					$mosformDb = new database($cn->host, $cn->user, $cn->password, $cn->database, "");

					$tables = $mosformDb->getTableList();
					
					$fields = $mosformDb->getTableFields( $tables );
	
					$connectionTableFields[$cn->value][$key] = $fields;

				}else{
					
					$connectionTableFields[$cn->value][$key] =  "unable to connection to $cn->text<br />";
					
				}
			}

		}

		return $connectionTableFields;

	}
		  	



	/**
	 * queries all published connections and returns an multidimensional array
	 * of tables for each connection
	 * @param object all available connections
	 */
	function getConnectionTables( $realCnns ){
		
		$connectionTables = array (); //$sectioncategories
		
		$connectionTables[-1] = array ();
		
		$connectionTables[-1][] = mosHTML :: makeOption('-1', _CHOOSE_TABLE);

		foreach ($realCnns as $cn) {

			$connectionTables[$cn->value] = array ();

			if ($cn->host and $cn->state == '1') {

				if (@ mysql_connect($cn->host, $cn->user, $cn->password)) {

					$mosformDb = new database($cn->host, $cn->user, $cn->password, $cn->database, "");

					$tables = $mosformDb->getTableList();

					foreach ($tables as $table) {

						$connectionTables[$cn->value][] = mosHTML :: makeOption($table, $table);
						
					}
					
				}else{
					
					$connectionTables[$cn->value][] = mosHTML :: makeOption('', "unable to connection to $cn->description");
					
				}
			}

		}
		
		return $connectionTables;

	}
	
	/**
	 * tests if you can connect to the connection
	 * @return bol true if connection made otherwise false
	 */
	 
	function testConnection(){
			
		if (@ mysql_connect($this->host, $this->user, $this->password)) {
			
			if (!mysql_select_db($this->database)) {
			
				return false;
			}	
			
			return true;
			
		}else{
			
			return false;
			
		}
	}
	
		/**
	 * load the connection associated with the table
	 * @return object database object using connection details false if connection error
	 */
	
	function loadTableConnectionDB(){

		if ($this->testConnection()) {
			
			$mosformDb = new database($this->host, $this->user, $this->password, $this->database, "");
			
			return $mosformDb;
	
		}else{
			
			return false;
			
		}	
				
	}
 }
 

 ?>