<?php 

/**
 * Sections admin event handler
 * All rights reserved
 * Mambo Open Source is Free Software
 * Released under GNU/GPL License: http://www.gnu.org/copyleft/gpl.html
 * 
 * @package  MosForms
 * @Copyright (C) Rob Clayburn
 * @version $Revision: 1.9 $
 */
 
// ensure this file is being included by a parent file

defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');

require_once($mainframe->getPath('admin_html'));

require_once ("../components/$option/mosform_parent.class.php");

html_content::writeSubMenu();

// get parameters from the URL or submitted form

$scope = mosGetParam($_REQUEST, 'scope', '');

$cid = mosGetParam($_REQUEST, 'cid', 0);

//got rid of this as the table menu link code cant pass an array
//if (!is_array($cid)) {
//	$cid = array(0);
//} 

//TODO: mosforms : 0.5 : publish packages to create custom components

switch ($act) {

	case "conn":
		
		require_once("admin.mosforms.connections.php");
		
		switch ($task) {
				
			case "new":
		
				editMosConnection(0, $option, $act);
			
				break;
				
			case "edit":
				
				editMosConnection($cid[0], $option, $act);
				
				break;
				
			case "save":
			
				saveMosConnection($option, $act);
				
				break;
				
			case "remove":
			
				deleteMosConnection($cid, $option, $act);
				
				break;	
				
			case "copy":
			
				copyMosConnection($cid, $option, $act);
				
				break;
				
			case "test":
			
				testMosConnection($cid, $option, $act);
				
			case "publish":
			
				do_publish( $cid, 1 );
				
				displayMosConnections($option, $act);
			
				break;
			
			case "unpublish":
			
				do_publish( $cid, 0 );
				
				displayMosConnections($option, $act);
			
				break;
				
			default:
					
				displayMosConnections($option, $act);
			
				break;		
		}		
	
		break;
			
	case "tables":
		
		require_once("admin.mosforms.tables.php");
	
		break;
		
	case "forms":

		require_once("admin.mosforms.forms.php");
	
		switch ($task) {
			case "new":
		
				editMosForm(0, $option);
		
				break;
		
			case "forms":
			
				if(is_array($cid)){
					
					$cid = $cid[0];
					
				}
				
				editMosForm($cid, '', $option);
		
				break;
				
			case "go2menu" :
			
			case "go2menuitem" :
			
			case "menulink" :
						
			case "groups":
			
			case "save":

				$form_id = saveMosForm($_POST);
			
				$current_groups_str = mosGetParam($_POST, 'current_groups_str', '');
				
				$record_in_database = mosGetParam($_POST, 'record_in_database', '0');
		
				if(saveMosFormFormGroup($option, $form_id, $current_groups_str, $record_in_database, $task, $act)){
				
					displayMosForm($option);
		
				}else{
					
					mosRedirect("index2.php?option=$option&amp;act=form&amp;task=forms&amp;cid=$form_id");	
				}
				
				break;
		
			case "remove":
		
				deleteMosForm($cid, $option);
		
				break;
		
			case "cancel":
		
				displayMosForm($option);
		
				break;
		
			case "menu":
		
				createMosFormMenu($cid[0]);
		
				break; 
				
			case "updatedatabase":
		
				updateMosFormDatabase($cid[0], $option);
		
				break;
				
			case "formgroups":
			
				editFormGroups($cid[0], $option);
				
				break;
				
			case "orderup":
		
				orderMosFormFormGroup($cid[0], -1, $option, $act);
		
				break;
		
			case "orderdown":
		
				orderMosFormFormGroup($cid[0], 1, $option, $act);
		
				break;
		
			//case "viewdatabase":
		
				//viewMosFormDatabase($cid[0], $option);
		
				//break;
				
			case "copy":
				copyForm( $cid, $option );
				
				break;
				
			case "showform":
			
				$tableId = mosGetParam($_REQUEST, 'tableid', '');
				
				$rowId = mosGetParam($_REQUEST, 'rowid', '');
				
				showForm($cid, $option, $rowId, $tableId);
				
				break;
		
			default:
		
				displayMosForm($option);
		
				break;
			} 
		break;

	case "groups":

		require_once("admin.mosforms.groups.php");
		
		switch ($task) {
			case "new":
		
				editMosFormGroup(0, $option);
		
				break;
		
			case "edit":
			
				if(is_array($cid)){
					$cid = $cid[0];
				}		
				editMosFormGroup($cid, '', $option);
		
				break;
		
			case "save":
		
				saveMosFormGroup( $_POST );
				
				displayMosFormGroup( $option );
				
				break;
		
			case "remove":
		
				deleteMosFormGroup($cid, $option, $act);
		
				break;
		
			case "cancel":
		
				displayMosFormGroup($option);
		
				break;
		
			default:
		
				displayMosFormGroup($option);
		
				break;
		} 		
	
		break;


	case "elements":

		require_once("admin.mosforms.elements.php");
		
		switch ($task) {
			case "new":
		
				editMosFormElement(0, $option);
		
				break;
		
			case "edit":
				if(is_array($cid)){
					$cid = $cid[0];
				}			
				editMosFormElement($cid, '', $option);
		
				break;
		
			case "save":
		
				saveMosFormElement($option, $_POST);
				
				displayMosFormElement($option);
		
				break;
		
			case "remove":
		
				deleteMosFormElement($cid, $option, $act);
		
				break;
		
			case "cancel":
		
				displayMosFormElement($option);
		
				break;
		
			case "orderup":
		
				orderMosFormElement($cid[0], -1, $option, $act);
		
				break;
		
			case "orderdown":
		
				orderMosFormElement($cid[0], 1, $option, $act);
		
				break;
		
			case "copy":
				copyElement( $cid, $option );
				
				break;
				
			case "publish":
				
				publish($cid, true);
				
				displayMosFormElement($option);
				
				break;
				
			case "unpublish":

				publish($cid, false);
				
				displayMosFormElement($option);
				
				break;				
		
			default:
		
				displayMosFormElement($option);
		
				break;
		} 		

		break;

	case "validations":

		require_once("admin.mosforms.validations.php");
	
		break;	
		
	case "validationrules":
	
		require_once("admin.mosforms.validationrules.php");
		
		break;
		
	case "processform":
	
		$tableId = mosGetParam($_REQUEST, 'tableid', '');
		
		$rowId = mosGetParam($_REQUEST, 'rowid', '');	

		$formId = mosGetParam($_REQUEST, 'form_id', '');
			
		require_once("admin.mosforms.forms.php");
		
		processForm($option, $formId, $tableId, $rowId);
		
		break;

	default:

		require_once("admin.mosforms.forms.php");

		displayMosForm($option);

		break;
} 



///**
//* check to see if a table exists for a give form id
//* @param integer form id
//* @param string name of table (ovewrites form_id val to test)
//* @return boolean false if no table fodund true if table found
//*/
//
//function DatabaseTableExists($form_id, $tableName='')
//{
//	global $database, $mosConfig_dbprefix;
//	
//	if($tableName != ''){
//	
//		$sql = "SHOW TABLES LIKE '$tableName'";	
//	
//	}else{
//	
//		$sql = "SHOW TABLES LIKE '" . $mosConfig_dbprefix . "mosform_formdata_" . $form_id . "'";
//	
//	}
//	
//	$database->setQuery($sql);
//	
//	$total = $database->loadResult();
//	
//	$prefixLength = strlen($mosConfig_dbprefix);
//	
//	$total = substr($total, $prefixLength, strlen($total)-1);
//	
//	$tableName = substr($tableName, $prefixLength, strlen($tableName)-1);
//	
//	if ($total == "") {
//		
//		return false;
//	
//	} else {
//
//		return true;
//	
//	} 
//
//} 

/**
* called when form groups saved and record in database is true. Will either call methods to create or alter existing table
* @param integer formi id
* @param string component name
* @return boolean false if not saved
*/


function updateMosFormDatabase($formId , $option)
{
	global $database;
	
	$oForm = new mosForms($database);
	
	$oForm->load($formId);
	
	$dbExisits = $oForm->DatabaseTableExists( );
	
	if (!$dbExisits) {
		
		$oForm->CreateFormTable( );
		
	} else {
		
		$oForm->AmmendTable();
	} 
	
	displayMosForm($option, _UPDATE_OK);
} 


/**
* a recursive method to return a list of all folders from a given parent directory
* @param string parent directory
* @return array child directories of parent directory
*/

function recursive_listdir($base)
{
	static $filelist = array();
	static $dirlist = array();

	if (is_dir($base)) {
		$dh = opendir($base);
		if ($dh != false) {
			while (false !== ($dir = readdir($dh))) {
				if (is_dir($base . "/" . $dir) && $dir !== '.' && $dir !== '..' && strtolower($dir) !== 'cvs') {
					$subbase = $base . "/" . $dir;
					$dirlist[] = $subbase;
					$subdirlist = recursive_listdir($subbase);
				} 
			} 
			closedir($dh);
		} 
	} 
	return $dirlist;
} 



?>