<?php

// $Id: admin.mosforms.html.php,v 1.19 2005/06/18 13:32:45 rob_clayburn Exp $
/**
 * All rights reserved Mambo Open Source is Free Software Released under GNU/GPL
 * License: http://www.gnu.org/copyleft/gpl.html
 * 
 * @package  MosForms
 * @Copyright (C) Rob Clayburn
 * @version $Revision: 1.19 $
 */

/**
 * class displaying admin forms to manage database connections
 */
class html_connection_content {
	
	/**
	 * show a list of all the connections
	 * @param array of connection objects
	 * @param object page navigation
	 * @param string component name
	 * @param string component action
	 * @param string action message
	 */

	function showallconnections($rows, $pageNav, $option, $act, $msg) {

		if(method_exists('mosCommonHTML','loadOverlib')){ // function doesnt exist in 4.5.1a
	
			mosCommonHTML :: loadOverlib();
	
		}else{
			
			echo '<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>';
			
		}

		global $mosConfig_lang;

		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		}?>
	 
		 <h1 class="sectionname"><?php echo _VIEWCONN_HEADING; ?></h1>
		 
		 <?php if($msg != ""){echo "<p><strong>$msg</strong></p>";}?> 
		 
		 <form action="index2.php" method="POST" name="adminForm"> 
	
		<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist"> 
		
			<tr>
			
				<th width="1%" class="title" > 
				
					<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $rows );?>);" />
					
				</th>
				
				<th class="title" width="1%" >&nbsp;</th>
				
				<th class="title" width="29%" align="center"><?php echo _VIEWCONN_DESCRIPTION; ?></th>
				
				<th class="title" width="25%" align="center"><?php echo _VIEWCONN_HOST; ?></th>
				
				<th class="title" width="5%" align ="center"><?php echo _PUBLISHED; ?></th>
				
				<th class="title" width="20%" ><?php echo _VIEWCONN_DATABASE; ?></th>
				
				<th class="title" width="20%" ><?php echo _TEST_CONNECTION; ?></th>
				
			</tr> 
			<?
			
		$k = 0;

		for ($i = 0, $n = count($rows); $i < $n; $i ++) {

			$row = & $rows[$i];
?> 
			<tr   class="<?php echo "row$k"; ?>">
			
				<td width="1%"> <input type="checkbox" id="cb<?php echo $i;?>" name="cid[]" value="<?php echo $row->id; ?>" onclick="isChecked(this.checked);" /></td>
				
				<td width="1%"><?php echo $row->id; ?></td>
				
				<td width="29%">
					
					<a href="#edit" onclick="return listItemTask('cb<?php echo $i;?>','edit')">
						
						<?php echo $row->description; ?>
					
					</a>
				
				</td>
				
				<td width="25%">
					
					<?php echo $row->host; ?>
				
				</td>
				
				<td>
			<?php

			if ($row->state == "1") {
				
				$img = 'publish_g.png';
				
				$alt = 'Published';
				
			} else {
				
				$img = "publish_x.png";
				
				$alt = 'Unpublished';
				
			}
			
			$times = '';
			
			if (isset ($row->publish_up)) {
				
				if ($row->publish_up == '0000-00-00 00:00:00') {
					
					$times .= "<tr><td>Start: Always</td></tr>";
					
				} else {
					
					$times .= "<tr><td>Start: $row->publish_up</td></tr>";
					
				}
				
			}
			
			if (isset ($row->publish_down)) {
				
				if ($row->publish_down == '0000-00-00 00:00:00') {
					
					$times .= "<tr><td>Finish: No Expiry</td></tr>";
					
				} else {
					
					$times .= "<tr><td>Finish: $row->publish_down</td></tr>";
					
				}
				
			}
?>
					<a href="javascript: void(0);" onMouseOver="return overlib('<table><?php echo $times; ?></table>', CAPTION, 'Publish Information', BELOW, RIGHT);" onMouseOut="return nd();" onClick="return listItemTask('cb<?php echo $i;?>','<?php echo $row->state ? "unpublish" : "publish";?>')">
					
					<img src="images/<?php echo $img;?>" width="12" height="12" border="0" alt="<?php echo $alt; ?>" />				
				
				</td>
				
				<td width="20%" >
					
					<?php echo $row->database; ?>
				
				</td>		
				
				<td width="20%" >
					
					<a href="#edit" onclick="return listItemTask('cb<?php echo $i;?>','test')">
						
						<?php echo _TEST_CONNECTION ; ?>
					
					</a>
				
				</td>						
			
			</tr> 
			<?php

			$k = 1 - $k;

		}
?> 
		</table>
		
		<?php echo $pageNav->getListFooter(); ?>
		
		<input type="hidden" name="option" value="<?php echo $option;?>" />
		
		<input type="hidden" name="boxchecked" value="0" />
		
		<input type="hidden" name="task" value="edit" />
		
		<input type="hidden" name="act" value="<?php echo $act;?>" />
	
	</form>		
	<?php

	}

	/** 
	 * edits a database connection
	 * @param object connection
	 * @param string component name
	 * @param string component action
	 */
	 
	function editConnection($row, $option, $act) {
		
		global $mosConfig_lang;
		
				if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		} ?> 
	
		<h1 class="sectionname">
			
		<?php

		echo $row->id ? _EDIT : _ADD;
		
		echo _ADD_CONNECTION_TITLE;
		
		?>
		
		</h1>
		
		<form action="index2.php" method="POST" name="adminForm"> 
		
		<table cellpadding="4" cellspacing="0" border="0" width="100%"  class="adminform"> 
		
		<tr><th colspan="2"><?php echo _DETAILS; ?></th></tr>
		
			<tr>
			
				<td><?php echo _VIEWCONN_DESCRIPTION?></td>
				
				<td><input class="inputbox" type="text" name="description" size="75" value="<?php echo $row->description; ?>" /></td>
				
			</tr>
						
			<tr>
			
				<td><?php echo _VIEWCONN_HOST?></td>
				
				<td><input class="inputbox" type="text" name="host" size="75" value="<?php echo $row->host?>" /></td>
				
			</tr>
			
			<tr>
			
				<td><?php echo _VIEWCONN_DATABASE?></td>
				
				<td><input class="inputbox" type="text" name="database" size="75" value="<?php echo $row->database?>" /></td>
				
			</tr> 
			
			<tr>
			
				<td><?php echo _ADD_CONN_USER?></td>
				
				<td><input class="inputbox" type="text" name="user" size="75" value="<?php echo $row->user; ?>" /></td>
				
			</tr>
			
			<?php if ($row->host != ""){?>
				
				<tr>
				
				<td><?php echo _ADD_CONN_CHANGE_PASSWORD?></td>
				
				<td></td>
				
			</tr>	
					
			<?php } ?>		
					
			<tr>
			
				<td><?php echo _ADD_CONN_PASSWORD?></td>
				
				<td><input class="inputbox" type="password" name="password" size="20" value="<?php echo $row->password; ?>" /></td>
				
			</tr>

			<tr>
			
				<td><?php echo _ADD_CONN_PASSWORD_CONF?></td>
				
				<td><input class="inputbox" type="password" name="passwordConf" size="20" value="<?php echo $row->password; ?>" /></td>
			
			</tr>			
			
			<tr>
				
				<td><?php echo _PUBLISHED?></td>
				
				<td>
					
					<input type="checkbox" name="state" value="1" <?php echo $row->state ? 'checked="checked"' : ''; ?> />
				
				</td>
			
			</tr>						
		
		</table>
		
		<input type="hidden" name="option" value="<?php echo $option;?>" /> 
		
		<input type="hidden" name="act" value="<?php echo $act;?>" /> 	
		
		<input type="hidden" name="task" value="save" /> 
		
		<input type="hidden" name="id" value="<?php echo $row->id;?>" /> 	

	</form>
<?php
 }
}

/**
 * class displaying admin forms to manage tables
 */

class html_table_content {

	/** 
	 * show a summary of the table's forms, groups and elements
	 * @param object form
	 * @param array element group objects
	 */

	function showTableDetail($oForm, $formGroupEls) {
		
		
		
		echo "<h1 class=\"sectionname\">"._FORM_CREATED_FROM_TABLE."</h1>";
		
		echo "<h3>"._ADDFORM_TITLE."</h3>";
		
		echo "<a href=\"index2.php?option=com_mosforms&amp;act=forms&amp;task=forms&amp;cid=$oForm->id\">".$oForm->form_title."</a><br />";
		
		echo "<h3>"._ELEMENTS."</h3>";

		echo "<table class=\"adminlist\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" >\n";
		
		echo "<tr><th class='sectiontableheader'>"._ELEMENT."</th><th class='sectiontableheader'>"._ELEMENT_LABEL."</th><th class='sectiontableheader'>"._GROUP."</th></tr>";

		$k = 1;

		foreach ($formGroupEls as $el) {
		
			$cid = $el->id;
		
			echo "<tr class='sectiontableentry$k row$k>"."<td>"."<a href=\"index2.php?option=com_mosforms&amp;act=elements&amp;task=edit&amp;cid=$cid\">$el->element_name</a>"."</td>"."<td>"."$el->element_label"."</td>"."<td>"."$el->group_name"."</td>"."</tr>";
		
			$k = 1 - $k;
		
		}
		
		echo "</table>";
	
	}

	/**
	* writes out a table view for a table!
	* @param object table
	* @param object each table element combined with its group and form data
	* @param
	* @param string component name
	* @param array ordering state info $column=>direction
	* @param array contains any lists used on the page
	* @param int page nav limit start
	* @param string html pagenav 
	* @param int number of records to show per page
	*/

	function writeTable($oTable, $formGroupEls, $elementData, $option, $aOrder, $lists, $limitStart, $pageNav, $pageLimit, $orderBy = '', $mosFormAct) {

		global $mosConfig_live_site, $Itemid, $my;
		
		if(method_exists('mosCommonHTML','loadCalendar')){

			mosCommonHTML :: loadCalendar();
			
		}
		
		if(method_exists('mosCommonHTML','loadOverlib')){
	
			mosCommonHTML :: loadOverlib();
	
		}else{
			
			echo '<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>';
			
		}
		
		?>
		
		<script type="text/javascript" src="<?php echo $mosConfig_live_site; ?>/includes/js/mambojavascript.js"></script>
		
		<script language="javascript" type="text/javascript">
		
		<!--

		function submitMosformTable(act){
		
			document.getElementById('mosformact').value = act;

			form = document.adminForm;

			form.submit();
			
			return false;
		
		}
		
		function mosformNav(limitStart){
		
			document.getElementById('limitstart').value = limitStart;
			
			form = document.adminForm;
			
			document.adminForm.submit();
			
			return false;	
		}
		
		function mosformNavLimit(pageLimit){
						
			document.getElementById('pagelimit').value = pageLimit;
			
			document.adminForm.submit();
			
		}
				
		function mosFormNavOrder(orderby, orderdir){
		
			document.getElementById('orderby').value = orderby;
			
			document.getElementById('orderdir').value = orderdir;
			
			document.adminForm.submit();
		
		}	
			
		//-->
		
		</script>
		
		<?php

		echo "<h1 class=\"sectionname\">$oTable->label</h1>";

		echo "<p>$oTable->introduction</p>";

		echo "<form action=\"index2.php\" method=\"post\"  name=\"adminForm\">";

		echo "<table class=\"adminlist\" width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" >\n<tr>";

		if ($oTable->allow_add <= $my->gid) {

			$link = ("index2.php?option=com_mosforms&amp;act=forms&amp;task=showform&amp;cid=$oTable->form_id&amp;tableid=$oTable->id&amp;rowid=");

			echo "<span class=\"pagenav\"><a href='$link'>"._ADD_RECORD."</a></span> | ";

		}

		echo "<a href='$mosConfig_live_site/administrator/components/$option/admin.mosforms.export.php?format=csv&amp;type=table&amp;cid=$oTable->id'>"._EXPORT_TO_CSV."</a><br />";

		$aCols = array ();

		echo "<br /><div style=\"text-align:left;\">";

		foreach ($lists['filters'] as $name => $filter) {

			echo "$name : $filter";

		}
		
		if($oTable->filter_action == 'submitform' and count($lists['filters']) > 0){
			
			echo '<input type="button" onclick="submitMosformTable(\'filter\')" value="filter" name="filter" />';
			
		}
		
		echo "</div>";	

		$aLinkElements = array ();

		foreach ($formGroupEls as $el) {

			$aCols[] = $el->element_name;

			if ($el->link_to_detail == '1') {

				$aLinkElements[] = "$el->element_name";

			}

			if ($el->can_order == '1') {

				$aOrder[$el->element_name] == "desc" ? $orderDir = "asc" : $orderDir = "desc";

				echo "<th class='title'><a href='javascript:mosFormNavOrder(\"$el->element_name\", \"$orderDir\")'>$el->element_label</a></th>\n";

			} else {

				echo "<th class='title'>$el->element_label</th>\n";

			}

		}

		if ($oTable->allow_delete <= $my->gid) {

			echo "<th class='sectiontableheader'>Delete</th>";

		}

		echo "</tr>\n";

		$k = 0;
		
		$tableHtml = ""; // use this to create table html - then at the end we replace the {primaryKey} text with the found 

		foreach ($elementData as $row) {	// for each table row

			$i = 0;

			$tableRowHtml .= "<tr class='sectiontableentry$k row$k'>";

			$primaryKeyVal = "";

			foreach ($aCols as $col) { // for each table column

				foreach ($row as $key => $val) { 

					$key = preg_replace("/[^A-Za-z0-9]/", "_", $key);

					if ($key == $col) {

						if ((in_array($key, $aLinkElements) || $key == $oTable->db_primary_key) and ($oTable->allow_view_details <= $my->gid || $oTable->allow_edit_details <= $my->gid)) {

							if ($key == $oTable->db_primary_key) {

								$primaryKeyVal = urlencode($val);

							}

							$nextaction = "viewtablerowdetails";

							if ($oTable->allow_edit_details <= $my->gid) {

								$nextaction = "viewform";

							}

							$link = "index2.php?option=com_mosforms&amp;act=forms&amp;task=showform&amp;cid=$oTable->form_id&amp;tableid=$oTable->id&amp;rowid={primarkKeyVal}";

							$tableRowHtml .= "<td><a href='$link'>$val</a></td>";

						} else {

							$tableRowHtml .= "<td>$val</td>";

						}

						$i ++;

					}

				}

			}

			if ($oTable->allow_delete <= $my->gid) {

				$tableRowHtml .= "<td><input type=\"checkbox\" name='ids[]' value='$primaryKeyVal'></td>";

			}
			
			$tableRowHtml = str_replace('{primarkKeyVal}',$primaryKeyVal , $tableRowHtml);
			
			$tableRowHtml .= "</tr>";

			$tableHtml .= $tableRowHtml;
			
			$k = 1 - $k;

		}
		
		echo $tableRowHtml;

		echo "</tr>\n</table>";

		echo "$pageNav";

		echo "<input type='hidden' id='orderdir' name='orderdir' value='$aOrder[$orderBy]' />\n";

		echo "<input type='hidden' id='orderby' name='orderby' value='$orderBy' />\n";

		echo "<input type='hidden' name='option' value='$option' />\n";

		echo "<input type='hidden' id='mosformact' name='mosformact' value='$mosFormAct' />\n";

		echo "<input type='hidden' name='cid' value='$oTable->id' />\n";

		echo "<input type='hidden' name='Itemid' value='$Itemid' />\n";

		echo "<input type='hidden' name='pagelimit' value='$pageLimit' />\n";

		if ($oTable->allow_delete <= $my->gid) {

			echo "<input class='button' type='button' onclick=\"submitMosformTable('delete')\" value='Delete' name='delete'/>";
		}

		echo "<input type='hidden' name='limitstart' id='limitstart' value='$limitStart' />\n";

		echo "<input type='hidden' name='pagelimit' id='pagelimit' value='$pageLimit' />\n";

		echo "<input type=\"hidden\" name=\"act\" value=\"tables\" />";

		echo "<input type=\"hidden\" name=\"task\" value=\"viewdatabase\" />";

		echo "</form>";

	}

	//TODO: mosforms: 0.5 : show published icon and allow publish/unpublish toggle 

	/**
	 * show a list of all the tables
	 * @param array of table objects
	 * @param object page navigation
	 * @param string component name
	 * @param string component action
	 */
	 
	function showAllTables($rows, $pageNav, $option, $act) {

		global $mosConfig_lang;

		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		} ?>
	 
		 <h1 class="sectionname"><?php echo _VIEWTABLE_HEADING	?></h1>
		 
		 <form action="index2.php" method="POST" name="adminForm"> 
	
		<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist"> 

			<tr>

				<th width="1%" class="title" > 

					<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $rows );?>);" />

				</th>

				<th class="title" width="1%" >&nbsp;</th>

				<th class="title" width="29%" align="center"><?php echo _TABLE_NAME; ?></th>
				
				<th class="title" width="50%" align="center"><?php echo _VIEWFORMS_VIEW_DB ;?></th>

				<th class="title" width="20%" ><?php echo _VIEW_TABLE_DETAILS; ?></th>

			</tr> 
			<?php

			$k = 0;

			for ($i = 0, $n = count($rows); $i < $n; $i ++) {

				$row = & $rows[$i]; ?> 
				
				<tr class="<?php echo "row$k"; ?>">
		
					<td width="1%"> <input type="checkbox" id="cb<?php echo $i;?>" name="cid[]" value="<?php echo $row->id; ?>" onclick="isChecked(this.checked);" /></td>
		
					<td width="1%"><?php echo $row->id; ?></td>
		
					<td width="29%"><a href="#edit" onclick="return listItemTask('cb<?php echo $i;?>','edit')"><?php echo $row->label; ?></a></td>
		
					<td width="50%">
		
						<a href="#viewdatabase" onclick="return listItemTask('cb<?php echo $i;?>','viewdatabase')"><?php echo _VIEWFORMS_VIEW_DB;?></a>
		
					</td>
					
					<td width="20%" >
						<a href="#showlinkedelements" onclick="return listItemTask('cb<?php echo $i;?>','showlinkedelements')"><?php echo _VIEW_TABLE_DETAILS;?></a>
		
					</td>			
		
				</tr> 
				
				<?php $k = 1 - $k;
	
			} ?> 
			
		</table>
		
		<?php echo $pageNav->getListFooter(); ?>
		
		<input type="hidden" name="option" value="<?php echo $option;?>" />
		
		<input type="hidden" name="boxchecked" value="0" />
		
		<input type="hidden" name="task" value="" />
		
		<input type="hidden" name="act" value="<?php echo $act;?>" />
	
	</form>		
	<?php

	}

	/**
	 * either edit an existing table or add a new one
	 * @param object table 
	 * @param array the drop down lists used on the form
	 * @param object tabs
	 * @param array connection tables
	 * @param object menus
	 * @param string component name
	 * @param string compoent action
	 * @param int form id that the table links to?
	 */

	function editTable($row, $lists, $tabs, $connectionTables, &$menus, $option, $act, $mosformid) {

		global $mosConfig_lang, $mosConfig_live_site;

		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		}
		
		if(method_exists('mosCommonHTML','loadOverlib')){
	
			mosCommonHTML :: loadOverlib();
	
		}else{
			
			echo '<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>';
			
		}

		if(method_exists('mosCommonHTML','loadCalendar')){

			mosCommonHTML :: loadCalendar();
			
		}

		mosMakeHtmlSafe($row);

		?> 
	
		<script language="javascript" type="text/javascript">
	
			<!--
			
			var connectiontables = new Array;
			
			<?php
	
			if ($row->id == '0') {
			
				$i = 0;
			
				foreach ($connectionTables as $k => $items) {
			
					foreach ($items as $v) {
			
						echo "connectiontables[".$i ++."] = new Array( '$k','".addslashes($v->value)."','".addslashes($v->text)."' );\n\t\t";
			
					}
			
				}
			
			}
			
			?>
		
			function submitbutton(pressbutton){
				
				if (pressbutton == 'cancel') {
				
					submitform( pressbutton );
				
					return;
			
				}
				
				<?php getEditorContents( 'editor1', 'introduction' ) ; ?>
			
				err = "";
				
				if(document.getElementById('label').value == ''){
			
					err = err +"<?php echo _ADDTABLE_ERR_LABEL; ?>\n";
			
				}			
			
				if(document.getElementById('connection_id')){
			
					if(document.getElementById('connection_id').value == '-1'){
			
						err = err +"<?php echo _ADDTABLE_ERR_CONNECTION; ?>\n";
			
					}
			
				}			
				
				if(document.getElementById('tablename')){
			
					if(document.getElementById('tablename').value == '' || document.getElementById('tablename').value == '-1'){
			
						err = err + "<?php echo _ADDTABLE_ERR_DATABASE; ?>\n";
			
					}	
			
				}
						
				if (err == ""){
			
					submitform( pressbutton );
			
				}else{
			
					alert (err);
			
				}
			
			}
			//-->
		
		</script>
		
		<h1 class="sectionname">
		
		<?php

		echo $row->id ? _EDIT : _ADD;
		
		echo _ADD_TABLE_TITLE

		?>
		
		</h1>
		
		<form action="index2.php" method="post" name="adminForm"> 
		
		<?php if($row->db_primary_key == ""){
			
				echo "<p class='warning'>" . _PLEASE_CREATE_PRIMARY_KEY . "</p>";
				
		}?>
		
		<table style="width:100%">
		
			<tr>
		
				<td style="width:50%" valign="top">
		
					<table cellpadding="4" cellspacing="0" border="0" width="100%"  class="adminform"> 
		
						<tr>
		
							<td><?php echo _LABEL?></td>
		
							<td><input class="inputbox" type="text" id="label" name="label" size="50" value="<?php echo $row->label?>" /></td>
		
						</tr>
		
						<tr>
		
							<td><?php echo _INTRODUCTION?></td>
		
							<td>
		
								<?php
 								
 								// parameters : areaname, content, hidden field, width, height, rows, cols
					
								editorArea('editor1', $row->introduction, 'introduction', '100%;', '200', '75', '20');
								
								?>
							
							</td>
						
						</tr> 
						
						<tr>
						
							<td><?php echo _TEMPLATE ?></td>
						
							<td><?php print_r($lists['tableTemplates']); ?></td>
						
						</tr>	
						
						<tr>
						
							<td><?php echo _ROWS_PER_PAGE ?></td>
						
							<td><input type="text" name="rows_per_page" class="inputbox" value="<?php echo $row->rows_per_page; ?>" size="3" /></td>
						
						</tr>	
						
						<tr>
						
							<td><?php echo _FILTER_TRIGGER ?></td>
						
							<td><?php echo $lists['filter_action']; ?></td>
						
						</tr>							
											
					</table>
				
				</td>
				
				<td valign="top">
					<?php

					$tabs->startPane("content-pane");
		
					$tabs->startTab(_PUBLISHING, "publish-page"); ?>
					
					<table class="adminform">
					
						<tr>
						
							<th colspan="2">
						
							<?php echo _PUBLISHING_INFO; ?>
						
							</th>
						
						</tr>
	
						<tr>
						
							<td valign="top" align="right">
						
							<?php echo _PUBLISHED; ?>:
						
							</td>
						
							<td>
						
							<input type="checkbox" name="state" value="1" <?php echo $row->state ? 'checked="checked"' : ''; ?> />
						
							</td>
						
						</tr>
	
						<tr>
	
							<td valign="top" align="right">
	
							<?php echo _AUTHOR_ALIAS; ?>:
	
							</td>
	
							<td>
	
							<input type="text" name="created_by_alias" size="30" maxlength="100" value="<?php echo $row->created_by_alias; ?>" class="text_area" />
	
							</td>
	
						</tr>
	
						<tr>
	
							<td valign="top" align="right">
	
							<?php echo _CHANGE_CREATOR; ?>:
	
							</td>
	
							<td><?php echo $lists['created_by']; ?></td>
	
						</tr>
		
						<tr>
				
							<td valign="top" align="right">
				
							<?php echo _OVERRIDE_CREATE_DATE ;?>
				
							</td>
				
							<td>
				
							<input class="text_area" type="text" name="created" id="created" size="25" maxlength="19" value="<?php echo $row->created; ?>" />
				
							<input name="reset" type="reset" class="button" onClick="return showCalendar('created', 'y-mm-dd');" value="..." />
				
							</td>
				
						</tr>
				
						<tr>
				
							<td valign="top" align="right">
				
							<?php echo _START_PUBLISHING; ?>:
				
							</td>
				
							<td>
				
							<input class="text_area" type="text" name="publish_up" id="publish_up" size="25" maxlength="19" value="<?php echo $row->publish_up; ?>" />
				
							<input type="reset" class="button" value="..." onClick="return showCalendar('publish_up', 'y-mm-dd');" />
				
							</td>
				
						</tr>
				
						<tr>
				
							<td valign="top" align="right">
				
							<?php echo _FINISH_PUBLISHING; ?>:
				
							</td>
				
							<td>
				
							<input class="text_area" type="text" name="publish_down" id="publish_down" size="25" maxlength="19" value="<?php echo $row->publish_down; ?>" />
				
							<input type="reset" class="button" value="..." onClick="return showCalendar('publish_down', 'y-mm-dd');" />
				
							</td>
				
						</tr>
			
					</table>
					
					<?php

					$tabs->endTab();
		
					$tabs->startTab(_ACCESS, "access-page"); ?>
					
						<table class="adminform">
		
							<tr>
							
								<th colspan="2">
			
									<?php echo _ACCESS; ?>
			
								</th>
			
							</tr>
							
							<tr>
		
								<td><?php echo _TABLE_VIEW_ACCESS; ?></td>
		
								<td><?php echo $lists['allow_view_details']; ?></td>
		
							</tr>
		
							<tr>
		
								<td><?php echo _TABLE_EDIT_ACCESS; ?></td>
		
								<td><?php echo $lists['allow_edit_details']; ?></td>
		
							</tr>
		
							<tr>
		
								<td><?php echo _TABLE_ADD_ACCESS; ?></td>
		
								<td><?php echo $lists['allow_add']; ?></td>
		
							</tr>
		
							<tr>
		
								<td><?php echo _TABLE_DELETE_ACCESS; ?></td>
		
								<td><?php echo $lists['allow_delete']; ?></td>
		
							</tr>
		
						</table>
					
					<?php

					$tabs->endTab();
		
					$tabs->startTab(_DATA, "tabledata-page"); ?>
					
						<table class="adminform">

							<tr>

								<th colspan="2">

									<?php echo _DATA; ?>

								</th>

							</tr>

							<tr>

								<td><?php echo _TABLE_CONNECTION; ?></td>

								<td><?php echo $lists['connections']; ?></td>

							</tr>

							<tr>

								<td><?php echo _TABLE_TABLE_NAME; ?></td>

								<td><?php echo $lists['tablename']; ?></td>

							</tr>

							<?php if($row->id <> ''){ ?>

								<tr>
								
									<td><?php echo _PRIMARY_KEY; ?>
									 
									 <a href="#" onmouseover="return overlib('<?php echo (_PRIMARY_KEY_LONG); ?>', CAPTION, '<?php echo _PRIMARY_KEY;?>', BELOW, RIGHT);" onmouseout="return nd();"><img src="<?php echo $mosConfig_live_site; ?>/includes/js/ThemeOffice/tooltip.png" border="0" /></a>
									 
									 </td>
									
									<td><input type="text" name="db_primary_key" value="<?php echo $row->db_primary_key; ?>" class="inputbox" size="30" /></td>
								
								</tr>
								
								<tr>
								
									<td><?php echo _AUTO_INCREMENT; ?></td>
									
									<td><input type="checkbox" name="auto_inc" value="1" <?php echo $row->auto_inc ? 'checked="checked"' : ''; ?> /></td>
								
								</tr>
								
							<?php } ?>	
							
							<tr>
							
								<td>
							
									<?php echo _ORDER_BY; ?>
							
								 </td>
							
								<td><input type="text" name="order_by" value="<?php echo $row->order_by; ?>" class="inputbox" size="30" /></td>
						
							</tr>	
							
							<tr>
							
								<td><?php echo _ORDER_DIRECTION; ?></td>
															
								<td><?php echo $lists['order_dir']; ?></td>
							
							</tr>								
					
						</table>
										
					<?php

					$tabs->endTab();
				
					$tabs->startTab(_LINK_TO_MENU, "linktomenu-page"); ?>
					
						<table class="adminform">
				
							<tr>
				
								<th colspan="2">
				
									<?php echo _LINK_TO_MENU; ?>
				
								</th>
				
							</tr>					
				
							<tr>
				
								<td>
				
									<?php echo _SELECT_MENU; ?>
				
								<td>
				
									<?php echo $lists['menuselect']; ?>
				
								</td>
				
							</tr>
				
							<tr>
				
								<td valign="top"><?php echo _MENU_ITEM_NAME; ?></td>
								
								<td>
							
									<input type="text" name="link_name" class="inputbox" value="" size="30" />
						
								</td>
					
							</tr>	
			
							<tr>
			
								<td colspan="2">
			
									<input name="menu_link" type="button" class="button" value="<?php echo _LINK_TO_MENU; ?>" onClick="submitbutton('menulink');" />
			
								</td>
			
							</tr>
			
							<tr>
			
								<th colspan="2">
			
								<?php echo _EXISTING_MENU_LINKS; ?>
			
								</th>
			
							</tr>
							<?php if ($menus == NULL) { ?>

								<tr>

									<td colspan="2"><?php echo _MS_NONE; ?></td>
								
								</tr>
								<?php
	
							} else {
				
									mosCommonHTML :: menuLinksContent($menus);
							}?>
							
							<tr>
							
								<td colspan="2">
							
								</td>
						
							</tr>										
						
						</table>
					
					<?php

				$tabs->endTab();
			
				$tabs->endPane(); ?>
			
				</td>
		
			</tr>
	
		</table>

		<input type="hidden" name="option" value="<?php echo $option;?>" /> 

		<input type="hidden" name="act" value="<?php echo $act;?>" /> 	

		<input type="hidden" name="task" value="save" /> 

		<input type="hidden" name="id" value="<?php echo $row->id;?>" /> 	
		
		<input type="hidden" name="mosformid" value="<?php echo $mosformid; ?>" />

	</form>
<?php

	}

}

/**
* class displaying admin forms to manage forms
*/
class html_form_content {

	/**
	* Display all available forms
	* @param array forms
	* @param object page navigation 
	* @param string component name
	* @param string message
	*/

	function showAllForms($forms, $pageNav, $option, $msg = '') {
		
		global $mosConfig_lang;
	
		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		}

		?>
	 
		 <h1 class="sectionname"><?php echo _VIEWFORMS_TITLE?></h1>
		
		<?php if($msg != ""){echo "<p><strong>$msg</strong></p>";}?> 
		
		 <form action="index2.php" method="POST" name="adminForm"> 
	
		<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist"> 
		
			<tr>
		
				<th width="1%" class="title" > 
		
					<input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $forms );?>);" />
		
				</th>
		
				<th class="title" width="1%" >&nbsp;</th>
		
				<th class="title" width="29%" align="center"><?php echo _VIEWFORMS_FORMTITLE?></th>
		
				<th class="title" width="50%" align="center"><?php echo _VIEWFORMS_EMAILTO?></th>
		
				<th class="title" width="20%" >&nbsp;</th>
		
				<th class="title" width="20%" >&nbsp;</th>
		
				<th class="title" width="20%" >&nbsp;</th>
		
			</tr> 
		
			<?php $k = 0;

		for ($i = 0, $n = count($forms); $i < $n; $i ++) {

			$row = & $forms[$i]; ?> 
			
			<tr class="<?php echo "row$k"; ?>">
			
				<td width="1%"> <input type="checkbox" id="cb<?php echo $i;?>" name="cid[]" value="<?php echo $row->id; ?>" onclick="isChecked(this.checked);" /></td>
			
				<td width="1%"><?php echo $row->id; ?></td>
			
				<td width="29%"><a href="#edit" onclick="return listItemTask('cb<?php echo $i;?>','forms')"><?php echo $row->form_title; ?></a></td>
			
				<td width="50%"><?php echo $row->email_to; ?></td>
				
				<td width="20%" align="right">
			
					<!-- <a href="#formgroups" onclick="return listItemTask('cb<?php echo $i;?>','formgroups')"><?php echo _VIEWFORMS_ASSIGN_FORMGROUP;?></a>-->
			
				</td>			
				
				<td width="20%" align="right">
			
					<?php if($row->record_in_database == '1'){ ?> 
			
						<a href="#updatedatabase" onclick="return listItemTask('cb<?php echo $i;?>','updatedatabase')"><?php echo _VIEWFORMS_UPDATE_DB;?></a> 
					<?php

					} else {
	
						echo _NA;
					} ?> 
				
				</td>
				
				<td width="20%" align="right"> 
				
					<?php

					if ($row->record_in_database == '1') {
	
						if ($row->table_id == 0) { ?>
			
							<a href="index2.php?option=<?php echo $option; ?>&amp;act=tables&amp;task=new&amp;mosformid=<?php echo $row->id; ?>"><?php echo _CREATE_TABLE_VIEW;?></a>
			
						<?php }else{?>
						
							<a href="index2.php?option=<?php echo $option; ?>&amp;act=tables&amp;task=viewdatabase&amp;cid=<?php echo $row->table_id; ?>"><?php echo _VIEWFORMS_VIEW_DB;?></a>
						
						<?php }
		
					} else {
			
						echo _NA;
					}?> 
				
				</td>
			
			</tr> 
			
			<?php $k = 1 - $k;

			} ?> 
		
		</table>
		
		<?php echo $pageNav->getListFooter(); ?>
		
		<input type="hidden" name="option" value="<?php echo $option;?>" />
		
		<input type="hidden" name="sid" value="<?php echo $row->id;?>" /> 
		
		<input type="hidden" name="task" value="" /> <input type="hidden" name="boxchecked" value="0" /> 
		
		<input type="hidden" name="act" value="forms" />

	</form><?

}

	/**
	* Edit or add a form
	* @param string component name
	* @param object form properties
	* @param object tabs
	* @param array list of html drop downs
	* @param object form menu items
	*/

	function editForms($option, & $row, $tabs, $lists, & $menus) {
		
		global $mosConfig_lang, $mosConfig_live_site;
		
		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		}
		
		mosMakeHtmlSafe($row);
		
		if(method_exists('mosCommonHTML','loadOverlib')){
	
			mosCommonHTML :: loadOverlib();
	
		}else{
			
			echo '<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>';
			
		}
		
		if(method_exists('mosCommonHTML','loadCalendar')){

			mosCommonHTML :: loadCalendar();
			
		} ?>  
		
		<script language="javascript" type="text/javascript">
		
			<!--
		
			function submitbutton(pressbutton) {
		
				var form = document.adminForm;
		
				<?php getEditorContents('form_introtext', 'form_introtext');
		
				getEditorContents('receipt_message', 'receipt_message');
		
				getEditorContents('form_submit_message', 'form_submit_message'); ?>
	
				if (pressbutton == 'cancel') {
				
					submitform( pressbutton );
			
					return;
		
				}
		
				// do field validation
		
				err = "";
		
				if (form.form_title.value == "") {
		
					err = err + "<?php echo _ADDFORM_ERR_NO_TITLE;?>\n";
		
				} 
		
				if(form.form_submit_message.value == ""){
		
					if(form.form_submit_jumppage.value == "" ){
		
						err = err + "<?php echo _ADDFORM_ERR_NO_TARGET;?>\n";
		
					}
		
				}
		
				if(form.width.value == ""){
		
					err = err + "<?php echo _ADDFORM_ERR_NO_WIDTH;?>\n";
		
				}
	
				if (err == ""){
					
					// assemble the form groups back into one field
		
					var temp = new Array;
		
					for (var i=0, n=form.current_groups.options.length; i < n; i++) {
		
						v = form.current_groups.options[i].value;
		
						temp[i] = v;
		
					}
		
					var tmpjoin =  temp.join( ',' )
		
					form.current_groups_str.value = tmpjoin;
					
					submitform( pressbutton );
		
				}else{
		
					alert (err);
		
				}
		
			}
			
			-->
			
		</script>
	
		<span class="sectionname">
		
		<?php echo $row->id ? _EDIT : _ADD;
		
		echo _ADDFORM_TITLE; ?>

		</span>
	
		<form action="index2.php" method="post" name="adminForm" onsubmit="javascript:submit_form();">

		 	<table style="width:100%;">

		 		<tr>

		 			<td style="width:50%;">

						<table cellpadding="5" cellspacing="0" border="0" width="100%" class="adminform"> 

							<tr>

								<td width="30%"><?php echo _ADDFORM_FORMTITLE;?></td>

								<td width="70%"><input class="inputbox" type="text" name="form_title" size="50" value="<?php echo $row->form_title; ?>" /></td>

							</tr> 

							<tr> 

								<td><?php echo _ADDFORM_INTROTEXT;?></td>

								<td>
									 
									<?php  editorArea( 'form_introtext',  $row->form_introtext , 'form_introtext', '100%', '200', '50', '5' ) ; ?> 
							
								</td>
						
							</tr> 
					
							<tr> 
				
								<td>
				
									<?php echo _ADDFORM_ERRORMSG;?>
				
									<a href="#" onmouseover="return overlib('<?php echo (_ADDFORM_ERRORMSG_LONG); ?>', CAPTION, '<?php echo _ADDFORM_ERRORMSG;?>', BELOW, RIGHT);" onmouseout="return nd();"><img src="<?php echo $mosConfig_live_site; ?>/includes/js/ThemeOffice/tooltip.png" border="0"></a>
				
								</td>
				
								<td>
				
									<input class="inputbox" type="text" name="form_errmessage" size="50" value="<?php echo $row->form_errmessage; ?>" />
				
								</td>
				
							</tr> 
				
							<tr> 
				
								<td>
				
									<?php echo _ADDFORM_ALIGN?>
				
								</td>
				
								<td><?php echo $lists['align']; ?></td>
				
							</tr> 
				
							<tr> 
				
								<td>	
				
									<?php echo _ADDFORM_WIDTH;?>
				
									<a href="#" onmouseover="return overlib('<?php echo (_ADDFORM_WIDTH_LONG); ?>', CAPTION, '<?php echo _ADDFORM_WIDTH;?>', BELOW, RIGHT);" onmouseout="return nd();"><img src="<?php echo $mosConfig_live_site; ?>/includes/js/ThemeOffice/tooltip.png" border="0"></a>
				
								</td>
				
								<td><input class="inputbox" type="text" name="width" size="5" value="<?php echo $row->width; ?>" /></td>
				
							</tr> 
				
							<tr> 
				
								<td><?php echo _ADDFORM_REC_IN_DB;?>(<?php echo $row->record_in_database;?>)</td>
								
								<td><input type="checkbox" name="record_in_database" value="1" <?php if($row->record_in_database == '1'){echo(" checked=\"checked\"");}?> /></td>
				
							</tr> 
				
							<tr> 
				
								<td><?php echo _ADDFORM_EMAILTO;?>
				
								<a href="#" onmouseover="return overlib('<?php echo (_ADDFORM_EMAILTO_LONG); ?>', CAPTION, '<?php echo _ADDFORM_EMAILTO;?>', BELOW, RIGHT);" onmouseout="return nd();"><img src="<?php echo $mosConfig_live_site; ?>/includes/js/ThemeOffice/tooltip.png" border="0"></a>
				
								</td>
				
								<td>
				
								<input class="inputbox" type="text" name="email_to" size="60" value="<?php echo $row->email_to; ?>" />
								
								</td>
				
							</tr>	
				
							<tr> 
				
								<td><?php echo _ADDFORM_EMAILFROM; ?>
						
								<a href="#" onmouseover="return overlib('<?php echo (_ADDFORM_EMAILFROM_LONG); ?>', CAPTION, '<?php echo _ADDFORM_EMAILFROM;?>', BELOW, RIGHT);" onmouseout="return nd();"><img src="<?php echo $mosConfig_live_site; ?>/includes/js/ThemeOffice/tooltip.png" border="0"></a>
						
								</td>
						
								<td>
						
								<input class="inputbox" type="text" name="email_from" size="60" value="<?php echo $row->email_from; ?>" />
								
								</td>
							</tr>	
						
							<tr> 
						
								<td><?php echo _ADDFORM_EMAILSUBJECT;?></td>
						
								<td><input class="inputbox" type="text" name="form_subject" size="50" value="<?php echo $row->form_subject; ?>" /></td>
						
							</tr>	
						
							<tr> 
						
								<td><?php echo _ADDFORM_THANKS_MSG;?><br />							
						
								<a href="#" onmouseover="return overlib('<?php echo (_ADDFORM_THANKS_MSG_LONG); ?>', CAPTION, '<?php echo _ADDFORM_THANKS_MSG;?>', BELOW, RIGHT);" onmouseout="return nd();"><img src="<?php echo $mosConfig_live_site; ?>/includes/js/ThemeOffice/tooltip.png" border="0"></a>
								
								</td>
						
								<td>
						
								<?php  editorArea( 'form_submit_message',  $row->form_submit_message , 'form_submit_message', '100%', '200', '50', '5' ) ; ?>
								
								</td>
							
							</tr>	
						
							<tr> 
						
								<td><?php echo _ADDFORM_PAGEJUMP;?><br />
						
								<a href="#" onmouseover="return overlib('<?php echo (_ADDFORM_PAGEJUMP_LONG); ?>', CAPTION, '<?php echo _ADDFORM_PAGEJUMP;?>', BELOW, RIGHT);" onmouseout="return nd();"><img src="<?php echo $mosConfig_live_site; ?>/includes/js/ThemeOffice/tooltip.png" border="0"></a>
						
								</td>
						
								<td><input class="inputbox" type="text" name="form_submit_jumppage" size="50" value="<?php echo $row->form_submit_jumppage; ?>" /></td>
						
							</tr>	
	
							<tr>
						
								<td><?php echo _ADDFORM_RESET?></td>
						
								<?php
								
								 if ($row->reset_button == 1) {
							
									$sel = "checked = \"checked\"";
							
								} else {
							
									$sel = "";
							
								} ?> 
							
								<td><input class="inputbox" type="checkbox" name="reset_button" value="1" <?php echo $sel?> /></td>
						
							</tr>
						
							<tr>
						
								<td><?php echo _ADDFORM_RESETLABEL?></td>
						
								<td><input type="text" class="inputbox" name="reset_button_label" size="50" value="<?php echo $row->reset_button_label;?>" /></td>
						
							</tr>
						
							<tr>
						
								<td><?php echo _ADDFORM_SUBMITLABEL?></td>
						
								<td><input type="text" class="inputbox" name="submit_button_label" size="50" value="<?php echo $row->submit_button_label;?>" /></td>
						
							</tr>
						
							<tr> 
						
								<td><?php echo _ADDFORM_RECEIPTTO; ?>
						
								<a href="#" onmouseover="return overlib('<?php echo (_ADDFORM_RECEIPTTO_LONG); ?>', CAPTION, '<?php echo _ADDFORM_RECEIPTTO;?>', BELOW, RIGHT);" onmouseout="return nd();"><img src="<?php echo $mosConfig_live_site; ?>/includes/js/ThemeOffice/tooltip.png" border="0"></a>
						
								</td>
						
								<td><?php echo $lists['email_receipt_list']; ?></td>
						
							</tr> 
						
							<tr> 
						
								<td><?php echo _ADDFORM_RECEIPTTO_EMAIL; ?></td>
							
								<td>
								
								<?php  editorArea( 'receipt_message',  $row->receipt_message , 'receipt_message', '100%', '200', '50', '5' ) ; ?>
								
								</td>
							
							</tr> 
						
						</table>
					
					</td>
				
					<td valign="top">
					
					<?php $tabs->startPane("content-pane");

					$tabs->startTab(_PUBLISHING, "publish-page"); ?>
						
						<table class="adminform">
					
						<tr>
					
							<th colspan="2"><?php echo _PUBLISHING_INFO; ?></th>
					
						</tr>
	
						<tr>
					
							<td valign="top" align="right"><?php echo _PUBLISHED; ?>:</td>
					
							<td>
							
							<input type="checkbox" name="published" value="1" <?php echo $row->state ? 'checked="checked"' : ''; ?> />
							
							</td>
						
						</tr>
	
						<tr>

							<td valign="top" align="right"><?php echo _AUTHOR_ALIAS; ?>:</td>
							
							<td>
							
							<input type="text" name="created_by_alias" size="30" maxlength="100" value="<?php echo $row->created_by_alias; ?>" class="text_area" />
							
							</td>
						
						</tr>
						
						<tr>
						
							<td valign="top" align="right"><?php echo _CHANGE_CREATOR; ?>:</td>
				
							<td><?php echo $lists['created_by']; ?> </td>
				
						</tr>
		
						<tr>
							
							<td valign="top" align="right"><?php echo _OVERRIDE_CREATE_DATE ;?></td>
							
							<td>
							
							<input class="text_area" type="text" name="created" id="created" size="25" maxlength="19" value="<?php echo $row->created; ?>" />
							
							<input name="reset" type="reset" class="button" onClick="return showCalendar('created', 'y-mm-dd');" value="...">
							
							</td>
						
						</tr>
						
						<tr>
						
							<td valign="top" align="right"><?php echo _START_PUBLISHING; ?>:</td>
						
							<td>
							
							<input class="text_area" type="text" name="publish_up" id="publish_up" size="25" maxlength="19" value="<?php echo $row->publish_up; ?>" />
						
							<input type="reset" class="button" value="..." onClick="return showCalendar('publish_up', 'y-mm-dd');">
					
							</td>
				
						</tr>
				
						<tr>
				
							<td valign="top" align="right"><?php echo _FINISH_PUBLISHING; ?>:</td>
							
							<td>
						
							<input class="text_area" type="text" name="publish_down" id="publish_down" size="25" maxlength="19" value="<?php echo $row->publish_down; ?>" />
						
							<input type="reset" class="button" value="..." onClick="return showCalendar('publish_down', 'y-mm-dd');">
						
							</td>
						
						</tr>
						
						</table>
						
						<?php $tabs->endTab();

						$tabs->startTab(_FORM_GROUPS, "formgroups-page"); ?>
						
						<table class="adminform">
						
							<tr>
							
								<th colspan="2"><?php echo _FORM_GROUPS; ?></th>
							
							</tr>
							
							<tr> 
							
								<td><?php echo _AVAILABLE_GROUPS;?></td>
							
								<td>
							
								<?php echo $lists['grouplist']; ?>
								
								<input "class="button" type="button" value="<?php echo _ADD; ?>" onClick="addSelectedToList('adminForm','groups','current_groups');delSelectedFromList('adminForm','groups');" />
							
								</td>
						
							</tr> 
						
							<tr> 
						
								<td><?php echo _CURRENT_GROUPS;?></td>
						
								<td><?php echo $lists['current_grouplist'];?></td>
						
							</tr>
						
							<tr>
						
								<td colspan="2">
						
								<input class="button" type="button" value="<?php echo _UP; ?>" onClick="moveInList('adminForm','current_groups',adminForm.current_groups.selectedIndex,-1)" />
						
								<input class="button" type="button" value="<?php echo _DOWN; ?>" onClick="moveInList('adminForm','current_groups',adminForm.current_groups.selectedIndex,+1)" />
						
								<input class="button" type="button" value="<?php echo _REMOVE; ?>" onClick="addSelectedToList( 'adminForm', 'current_groups', 'groups' );delSelectedFromList('adminForm','current_groups');" />
						
								</td>
						
							</tr> 
													
						</table>					
						
						<?php $tabs->endTab();
		
						$tabs->startTab(_TEMPLATES, "template-page"); ?>
					
							<table class="adminform">
								
								<tr>
									<td><?php echo _VIEW_ONLY_TEMPLATE; ?></td>
									
									<td><?php echo $lists['viewOnlyTemplates']; ?></td>
								
								</tr>					
								
								<tr>
									<td><?php echo _FORM_TEMPLATE; ?></td>
									
									<td><?php echo $lists['formTemplates']; ?></td>
								
								</tr>	
							
							</table>					
						
						<?php $tabs->endTab();
						
						$tabs->startTab(_LINK_TO_MENU, "menu-page"); ?>
						
							<table class="adminform">
						
								<tr>
									<td><?php echo _SELECT_MENU; ?></td>

									<td><?php echo $lists['menuselect']; ?></td>
								
								</tr>
								
								<tr>
									<td valign="top" width="90px"><?php echo _MENU_ITEM_NAME; ?></td>
									
									<td>
									
									<input type="text" name="link_name" class="inputbox" value="" size="30" />
									
									</td>
								</tr>	
								
								<tr>
								
									<td colspan="2">
								
										<input name="menu_link" type="button" class="button" value="<?php echo _LINK_TO_MENU; ?>" onClick="submitbutton('menulink');" />
								
									</td>
								
								</tr>
								
								<tr>
								
									<th colspan="2"><?php echo _EXISTING_MENU_LINKS; ?></th>

								</tr>

								<?php if ($menus == NULL) { ?>
									
									<tr>
									
										<td colspan="2"><?php echo _MS_NONE; ?></td>
									</tr>
									
									<?php } else {
			
										mosCommonHTML :: menuLinksContent($menus);
									
									}?>
								
								<tr>
							
									<td colspan="2">
							
									</td>
							
								</tr>										
						
							</table>
						
						<?php $tabs->endTab();
		
						$tabs->endPane(); ?>
					
					
					</td>
				
				</tr>
			
			</table>
			
			<input type="hidden" name="task" value=""> 
			
			<input type="hidden" name="option" value="com_mosforms" /> 
			
			<input type="hidden" name="id" value="<?php echo $row->id; ?>" /> 
			
			<input type="hidden" name="act" value="forms" /> 
			
			<input type="hidden" name="current_groups_str" value="" />
		
		</form><?php	
	
	}
}

/**
* class to display mosform validation html
*/
class html_validation_content {

	/**
	* Display the form to add or edit an element verification
	* @param array list of available rules
	* @param string component name
	* @param integer if editing a validation then this is it's id
	* @param array list of available elements to apply validations to 
	* @param object if edting a validation then this contain's the validation's info
	*/

	function AddElementValidation($validationrulelist, $option, $validation_id, $element_list, $row) {
		
		global $mosConfig_lang;
		
		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		} ?> 
	
		<h1 class="sectionname">
		
		<?php

		echo $row->id ? _EDIT : _ADD;
		
		echo _ADD_VALIDATION_TITLE; ?>
		
		</h1>
		
		<form action="index2.php" method="POST" name="adminForm"> 
		
		<table cellpadding="4" cellspacing="0" border="0" width="100%"  class="adminlist"> 
		
			<tr>
		
				<td><?php echo _ADDVALIDATION_ELEMENT_TO_APPLY_VAL_TO; ?></td>
		
				<td><?php echo $element_list; ?></td>
		
			</tr>
		
			<tr>
		
				<td><?php echo _ADDVALIDATION_VAL_TYPE; ?></td>
		
				<td><?php echo $validationrulelist; ?></td>
			
			</tr> 
			
			<tr>
			
			<td><?php echo _ADDVALIDATION_ERR_MSG; ?></td>
			
			<?php if (isset ($row->message)) {
			
					$er_msg = $row->message;
		
				} else {
					
					$er_msg = "";
				}?>
			
			<td><input class="inputbox" type="text" name="message" size="75" value="<?php echo $er_msg; ?>" /></td>
			
			</tr>
		
		</table>
		
		<input type="hidden" name="option" value="<?php echo $option; ?>" /> 
		
		<input type="hidden" name="act" value="validations" /> 
		
		<input type="hidden" name="task" value="save" /> 
		
		<input type="hidden" name="validation_id" value="<?php echo $validation_id; ?>" /> 	
		
		<input type="hidden" name="cid[]" value="<?php echo $validation_id; ?>" /> 
	
	</form>

<?}	

	/**
	* Display all available element validations
	* @param array array of validation objects
	* @param string component name
	* @param object page navigation 
	* @param array list of available elements to apply validations to 
	* @param object if edting a validation then this contain's the validation's info
	*/
	
	function ShowAllValidations($validations,$option, $pageNav){
		
		global $mosConfig_lang;
		
		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		}
		
		$n=count( $validations );
		?> 
		<h1 class="sectionname">
			<?php echo _VALIDATIONS_TITLE?>
		</h1>
		<form action="index2.php" method="POST" name="adminForm">
			<table cellpadding="4" cellspacing="0" border="0" width="100%"  class="adminlist">
				<tr> 
					<th class="title">
						<?php echo _SELECT_ALL?>
						<input type="checkbox" id="toggle" name="toggle" value="" onclick="checkAll(<?php echo count( $n );?>);" />
					</th>
					<th clss="title"><?php echo _ELEMENT?></th>
					<th class="title"><?php echo _VALIDATIONS_RULE?></th>
					<th class="title"><?php echo _VALIDATIONS_EXPRESSION?></th>
				</tr> 
				<?$k = 0;	
				
				for ($i = 0; $i < $n; $i++) { 
					$row = &$validations[$i]; 
					echo "<tr> 
						<td width=\"1%\">
							<input type=\"checkbox\" id=\"cb$i\" name=\"cid[]\" value=\"$row->id\" onclick=\"isChecked(this.checked);\" /> 
						</td>
						<td>
							<a href=\"#edit\" onclick=\"return listItemTask('cb$i','edit')\">$row->element_name</a>
						</td>
						<td>
							$row->validation_rule_label
						</td>
						<td>
							$row->validation_rule_expression
						</td>
					</tr> ";
					$k = 1 - $k;
				}?>

			</table>
			<?php echo $pageNav->getListFooter(); ?>
			<input type="hidden" name="option" value="<?php echo $option;?>" /> 
			<input type="hidden" name="boxchecked" value="0" />
			<input type="hidden" name="act" value="validations" /> 
			<input type="hidden" name="task" value="createnewvalidation" /> 
		</form>
	<?}
}


/*
* class to display mosform administration html
*/ 
class html_content {

	
	function writeSubMenu(){ 
		global $mosConfig_lang;
		
		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		}
		?>
 <a href="index2.php?option=com_mosforms&amp;act=conn"><?php echo _CONNECTIONS; ?></a>	|
 <a href="index2.php?option=com_mosforms&amp;act=tables"><?php echo _TABLES; ?></a>	|
 <a href="index2.php?option=com_mosforms&amp;act=forms"><?php echo _FORMS; ?></a>	|
 <a href="index2.php?option=com_mosforms&amp;act=groups"><?php echo _GROUPS; ?></a>	|
 <a href="index2.php?option=com_mosforms&amp;act=elements"><?php echo _ELEMENTS; ?></a>	|
 <a href="index2.php?option=com_mosforms&amp;act=validations"><?php echo _VALIDATIONS; ?></a>	|
  <a href="index2.php?option=com_mosforms&amp;act=validationrules"><?php echo _VALIDATION_RULES; ?></a>	|
 <br /><br />
<?php

	}

	/**
	* Display no data message for forms that collect data in table
	*/

	function ShowNoDataMessage() {
	
		global $mosConfig_lang;
	
		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		}
	
		echo ("<p>"._NODATA_MSG."</p>");
	}

	/**
	* Display all available element validations
	* @param array form's collected data
	* @param object page navigation 
	* @param string component name
	* @param integer form id
	*/
	
	function ViewDatabase($formdata, $pageNav, $option, $form_id) {
		
		global $mosConfig_lang, $mosConfig_absolute_path;
	
		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		} ?> 

		<h1 class="sectionname"><?php echo _VIEWDATABASE_TITLE;?></h1>
		
		<form action="index2.php" method="POST" name="adminForm">
		
		<br style="clear:both;" /> 
		
		<table cellpadding="4" cellspacing="0" border="0" width="100%"  class="adminlist"> 
		
		<?php if (is_array($formdata)) {
		
			$c = 0;
		
			$firstrow = $formdata[0];
		
			foreach ($firstrow as $key => $val) {
		
				if ($key != "time_date") {
		
					$c ++;
		
					echo ("<th  class='title' >$key</th>");
		
				}
		
			}
		
			$k = 0;
		
			foreach ($formdata as $row) {

				echo ("<tr class=\"row$k\">");
		
				foreach ($row as $key => $val) {
		
					if ($key != "time_date") {
		
						echo ("<td>$val</td>");
		
					}
		
				}
		
				echo ("</tr>");
		
				$k = 1 - $k;
		
				echo "<tr><td colspan=\"$c\"><a href=\"$mosConfig_absolute_path/administrator/components/$option/admin.mosforms.export.php?option=com_mosforms&task=export&form_id=$form_id\">"._VIEWDATABASE_EXPORT."</a></td></tr>";
			}
		} ?>
		 
		</table>
		
		<?php echo $pageNav->getListFooter(); ?>
		
		<input type="hidden" name="option" value="<?php echo $option; ?>" /> 
		
		<input type="hidden" name="act" value="forms" /> 
		
		<input type="hidden" name="task" value="viewdatabase" /> 
		
		<input type="hidden" name="cid[]" value="<?php echo $form_id; ?>" /> 
	
	</form><?php


	}

	/**
	* display all groups 
	* @param array list of group objects 
	* @param object mambo page nav  object
	* @param string component name
	* @param array number of elements attached to each group
	*/

	function showAllGroups($groups, $pageNav, $option, $arElcount) {
	
		global $mosConfig_lang;
	
		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		}?> 
	 	
	 	<h1 class="sectionname"><?php echo _VIEWGROUPS_TITLE; ?></h1>
	 	
	 	<p><?php echo _VIEWGROUPS_DESC; ?></p>
		
		<form action="index2.php" method="POST" name="adminForm"> 
	
		<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist"> 
		
			<tr> 
				
				<th class="title" width="1%"> <input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $groups );?>);" /> </th>
				
				<th class="title" width="70%" ><?php echo _VIEWGROUPS_NAME;?></th>
				
				<th class="title" width="29%"><?php echo _VIEWGROUPS_NO_ELEMENTS;?></th>
			
			</tr> 
			
			<?php $k = 0;

			for ($i = 0, $n = count($groups); $i < $n; $i ++) {

				$row = & $groups[$i]; ?>

				<tr class="<?php echo "row$k"; ?>">
					
					<td width="1%"> <input type="checkbox" id="cb<?php echo $i;?>" name="cid[]" value="<?php echo $row->id; ?>" onclick="isChecked(this.checked);" /></td>
					
					<td width="70%">
					
						<a href="#edit" onclick="return listItemTask('cb<?php echo $i;?>','edit')"><?php echo $row->group_name; ?></a>
					
					</td>
					
					<td width="29%">
					
					<?php echo $arElcount[$row->id]; ?>
					
					</td>
				
				</tr> 
				
				<?php $k = 1 - $k;
	
			} ?> 
		
		</table>
		
		<?php echo $pageNav->getListFooter(); ?>
		
		<input type="hidden" name="option" value="<?php echo $option; ?>" /> 
		
		<input type="hidden" name="sid" value="<?php echo $row->group_id; ?>" /> 
		
		<input type="hidden" name="task" value="" /> 
		
		<input type="hidden" name="boxchecked" value="0" /> 
		
		<input type="hidden" name="act" value="groups" /> 
	
	</form>
	
	<?php

	}

	/**
	* edit a group
	* @param string component name
	* @param object group properties
	* @param array list of elements
	* @param string message
	*/

	function editGroup($option, & $row, $elementslist, $msg) {
	
		global $mosConfig_lang;

		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		} ?> 
		
		<script language="javascript" type="text/javascript">
			
			<!--
		
			function submitbutton(pressbutton) {
		
				var form = document.adminForm;
		
				if (pressbutton == 'cancel') {
		
					submitform( pressbutton );
		
					return;
				}
		
				// do field validation
				if (form.group_name.value == "") {
		
					alert( "<?php echo _ADDGROUP_ERR_NONAME;?>" );
		
				} else {
		
					submitform( pressbutton );
				}
		
			}
	
			-->
	
		</script> 
		
		<table cellpadding="4" cellspacing="0" border="0" width="100%"> 
		
			<tr> 
		
				<td width="100%">
		
					<span class="sectionname">
				
					<?php echo $row->id ? _EDIT : _ADD;
					
					echo _ADDGROUP_TITLE; ?> 
					
					</span>
				
				</td>
			
			</tr> 
		
		</table>
		
		<?php if($msg != ""){echo "<p><strong>$msg</strong></p>";}?> 
		
		<form action="index2.php" method="POST" name="adminForm"> 
		
			<table cellpadding="5" cellspacing="0" border="0" width="100%" class="adminform"> 
		
				<tr>
		
					<td><?php echo _ADDGROUP_NAME; ?></td>
					
					<td><input class="inputbox" type="text" name="group_name" size="75" value="<?php echo $row->group_name; ?>" /></td>
				
				</tr> 
				
				<tr> 
				
					<td><?php echo _ADDGROUP_TITLE2; ?></td>
	
					<td><input class="inputbox" type="text" name="group_title" size="75" value="<?php echo $row->group_title; ?>" /></td>
	
				</tr> 
	
				<tr> 
	
					<td><?php echo _ADDGROUP_CSS;?></td>
	
					<td> <textarea rows="8" cols="72" name="group_css" class="inputbox"><?php echo  $row->group_css ; ?></textarea>	
					
					</td>
				
				</tr> 
			
			</table>
			
			<input type="hidden" name="task" value="" /> 
		
			<input type="hidden" name="option" value="com_mosforms" /> 
		
			<input type="hidden" name="id" value="<?php echo $row->id; ?>" /> 
		
			<input type="hidden" name="textfieldcheck" value="<?php echo $n; ?>" /> 
		
			<input type="hidden" name="act" value="groups" /> 
		
		</form>
		
		<?php }

}

/*
* class to display mosform elements html
*/
class html_element_content {

	/**
	* show all elemtns
	
	* @param array element objects
	* @param object mambo pagenav
	* @param string component name
	* @param array html lists
	* @param string search string
	*/

	function showAllElements($elements, $pageNav, $option, $lists, $search = '') {
	//todo : mosforms : 0.5 : pub/unpub buotton to mass change state
		global $mosConfig_lang, $my, $acl;

		if(method_exists('mosCommonHTML','loadOverlib')){
	
			mosCommonHTML :: loadOverlib();
	
		}else{
			
			echo '<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>';
			
		}
	
		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		} ?> 

	 	<h1 class="sectionname"><?php echo _VIEWELEMENTS_TITLE; ?></h1>
		
		<p><?php echo _VIEWELEMENTS_DESC; ?></p>
		
		<form action="index2.php" method="POST" name="adminForm"> 
			
			<table cellpadding="4" cellspacing="0" border="0" width="100%">
			
				<tr> 
			
					<td style="width:52%"><?php echo _VIEWELEMENTS_NAME . ": "; ?>
			
					<input type="text" name="filter_elementName" value="<?php echo $search;?>" class="text_area" onChange="document.adminForm.submit();" />
			
					</td>
			
					<td>
					
					<?php echo _GROUP;
		
					echo $lists['groupId']; ?>
					
					</td>					
					
					<td>
					
					<?php echo _VIEWELEMENTS_ELEMENTTYPE.": ";
					
					echo $lists['elementId']; ?>
					
					</td>

					<td width="right"> 
					
					<?php if (isset ($clist)) {
						
						echo $clist;
					} ?> 
					
					</td>
				
				</tr> 
			
			</table>
	
			<table cellpadding="4" cellspacing="0" border="0" width="100%" class="adminlist"> 
			
			<tr> 
			
				<th class="title" width="2%"> <input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $elements );?>);" /></th>
			
				<th class="title" width="25%" ><?php echo _VIEWELEMENTS_NAME; ?></th>
			
				<th class="title" width="25%" ><?php echo _VIEWELEMENTS_LABEL; ?></th>
			
				<th class="title" width="20%" ><?php echo _GROUP; ?></th>
			
				<th class="title" width="20%" ><?php echo _VIEWELEMENTS_ELEMENTTYPE; ?></th>
			
				<th class="title" width="5%"><?php echo _PUBLISHED; ?></th>
			
				<th class="title" width="3%"><?php echo _VIEWELEMENTS_ORDER; ?></th>
		
			</tr> 
			<?php $k = 0;

			for ($i = 0, $n = count($elements); $i < $n; $i ++) {
				
				$row = & $elements[$i]; ?>
				 
				<tr class="<?php echo "row$k"; ?>"> 
			
					<td width="2%">
			
						<input type="checkbox" id="cb<?php echo $i;?>" name="cid[]" value="<?php echo $row->id; ?>" onclick="isChecked(this.checked);" /> 
			
					</td>
			
					<td width="25%"> 
			
						<a href="#edit" onclick="return listItemTask('cb<?php echo $i;?>','edit')"><?php echo $row->element_name; ?></a>
			
					</td>
			
					<td width="25%"><?php echo $row->element_label; ?></td>
			
					<td width="20%"><?php echo $row->group_name; ?></td>
			
					<td width="20%"><?php echo $row->elementtype_name; ?></td>
			
					<td width="5%">
			
					<?php if ($row->state == "1") {
				
						$img = 'publish_g.png';
				
						$alt = 'Published';
				
					} else {
				
						$img = "publish_x.png";
				
						$alt = 'Unpublished';
				
					}
				
					$times = '';
				
					if (isset ($row->publish_up)) {
				
						if ($row->publish_up == '0000-00-00 00:00:00') {
				
							$times .= "<tr><td>Start: Always</td></tr>";
				
						} else {
				
							$times .= "<tr><td>Start: $row->publish_up</td></tr>";
				
						}
				
					}
				
					if (isset ($row->publish_down)) {
				
						if ($row->publish_down == '0000-00-00 00:00:00') {
				
							$times .= "<tr><td>Finish: No Expiry</td></tr>";
				
						} else {
				
							$times .= "<tr><td>Finish: $row->publish_down</td></tr>";
				
						}
				
					} ?>
					
					<a href="javascript: void(0);" onMouseOver="return overlib('<table><?php echo $times; ?></table>', CAPTION, 'Publish Information', BELOW, RIGHT);" onMouseOut="return nd();" onClick="return listItemTask('cb<?php echo $i;?>','<?php echo $row->state ? "unpublish" : "publish";?>')">
					
					<img src="images/<?php echo $img;?>" width="12" height="12" border="0" alt="<?php echo $alt; ?>" />
					
					</td>
					
					<td width="3%"> 
					
					<?php $condition = $row->group_id == @ $elements[$i -1]->group_id;
			
					echo $pageNav->orderUpIcon($i, ($condition)); 

					$condition = $row->group_id == @ $elements[$i +1]->group_id;
			
					echo $pageNav->orderDownIcon($i, $n, ($condition)); ?>

					</td>

				</tr> 

			<?php

			$k = 1 - $k;
		} ?>
		
		</table>
		
		<?php echo $pageNav->getListFooter(); ?>
		
		<input type="hidden" name="option" value="<?php echo $option;?>" /> 
		
		<input type="hidden" name="sid" value="<?php echo $row->id;?>" /> 
		
		<input type="hidden" name="task" value="" /> 
		
		<input type="hidden" name="boxchecked" value="0" /> 
		
		<input type="hidden" name="act" value="elements" /> 
	
	</form>
	
	<?php }

	/**
	* edit an element
	* @param string component name
	* @param object element properties
	* @param string html list of possible element types
	* @param string htnl list of groups
	* @param string html list of images
	* @param string html list of directories
	* @param object tabs
	* @param array image names	
	*/

	function editElement($option, & $row, $elementstypelist, $groupslist, $imagelist, $dirPath, $lists, $connectionTables, $tabs, $images) {

		global $mosConfig_lang, $mosConfig_live_site;

		if(method_exists('mosCommonHTML','loadOverlib')){
	
			mosCommonHTML :: loadOverlib();
	
		}else{
			
			echo '<div id="overDiv" style="position:absolute; visibility:hidden; z-index:10000;"></div>';
			
		}

		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		}
?> 
		<script language="javascript" type="text/javascript">

			var connectiontables = new Array;
			
			<?php

			$i = 0;
			
			if(is_array($connectionTables)){
				
				foreach ($connectionTables as $k => $items) {
					
					foreach ($items as $v) {
						
						echo "connectiontables[".$i ++."] = new Array( '$k','".addslashes($v->value)."','".addslashes($v->text)."' );\n\t\t";
					
					}
				
				}
			
			} ?>

			var folderimages = new Array;
			
			<?php
			
			$i = 0;
			
			if(is_array($images)){
				
				foreach ($images as $k=>$items) {
				
					foreach ($items as $v) {
				
						echo "folderimages[".$i++."] = new Array( '$k','".addslashes( $v->value )."','".addslashes( $v->text )."' );\n\t\t";
				
					}
				
				}
				
			}
			
			?>
			
			function submitbutton(pressbutton){

				form = document.getElementById('adminForm');
				// do field validation
				
		       if (pressbutton == 'cancel' ){
                   	submitform( pressbutton );                   
                   	return ;
           		} 
           
				if (form.element_name.value == "") {
					alert( "<?php echo _ADDELEMENT_ERR_NONAME;?>" );
				} else {
									
					submitbutton2( pressbutton );
					
					//return ;
				}
			}
	
		</script> 
		<script language="javascript" src="js/dhtml.js">
		</script> 
		<script language="javascript">
			/* global subelement counter */
			var igCounter = 0;
			/* global validation counter */
			var valCounter = 0;
	
	
	        function buildValidations(sPrefix, sTagId){
	         	<?php


		for ($ii = 0; $ii < count($lists['validations']); $ii ++) {
?>addValidation(sPrefix, sTagId, '<?php echo addslashes(str_replace("\n", "", $lists['validations'][$ii][1])); ?>', '<?php echo addslashes($lists['validations'][$ii][0]); ?>', '');
											 
					<?php

		}
?>       	
	        }
        			
			//adds a validation dropdown and error field to the element
			
			function addValidation(sPrefix, sTagId, sDropDown, sError ) {

				
	            var sDropDown = sDropDown ? sDropDown : '';
	            var sError = sError ? sError : '';


	            if(sDropDown == ''){	
	            	sDropDown = 	'<?php echo str_replace("\n", "", $lists['validationrulelist']); ?>';
	            }
           		
				var sContent = 
					'<table class="adminform" id="valcontent_' + valCounter + '">'
					+ '<tr><td colspan="2"><hr /></td></tr>'	
					+ '<tr>'
					+ '<td><?php echo _VALIDATIONS_RULE; ?></td>' 
					+'	<td>'
					+ sDropDown
					+'</td><tr>'
					+ '<tr><td><?php echo _ADDVALIDATION_ERR_MSG; ?></td>' 
					+'	<td><input class="inputbox" type="text" name="message[]"  id="' + sPrefix + 'value_'+valCounter+'" size="20" value="' + sError + '" /></td>'
					+'</tr>'
					+'<tr>'
					+	'<td colspan="2"><a href="#" onclick="deleteSubElements(\'valcontent_'+valCounter+'\');"><?php echo _DELETE; ?></a></td>'
					+ '</tr>'					
					+'</table>';					          	


				var oNewBody = document.getElementById(sPrefix+sTagId);
				var oNew = document.createElement('div');
				oNew.innerHTML = sContent;
				
				oNewBody.appendChild(oNew.firstChild , oNewBody.childNodes[0]);
				valCounter++;
		}
		
		function buildSubElements(sPrefix, sTagId) {
        	<?php

		$dd_values = split("\|", $row->dd_values);
		$dd_texts = split("\|", $row->dd_text);
		$dd_initial_selections = split("\|", $row->dd_intial_selection);
		for ($ii = 0; $ii < count($dd_values) && $ii < count($dd_texts); $ii ++) {
			if (in_array($dd_values[$ii], $dd_initial_selections)) {
?>addSubElement(sPrefix, sTagId, '<?php echo addslashes($dd_values[$ii]); ?>', '<?php echo addslashes($dd_texts[$ii]); ?>', 'checked');
						<?php

			} else {
?>addSubElement(sPrefix, sTagId, '<?php echo addslashes($dd_values[$ii]); ?>', '<?php echo addslashes($dd_texts[$ii]); ?>', '');
						<?php

			}
		}
?>
        }
					
			function addSubElement(sPrefix, sTagId, sValue, sText, sChecked) {
				//alert(sPrefix + ', ' + sTagId + ', ' + sValue + ', ' + sText + ', ' + sChecked);
				
	            var sCurValue = sValue ? sValue : '';
	            var sCurText = sText ? sText : '';
	            var sCurChecked = sChecked ? sChecked : '';
	           


				
				var sContent = 
					'<table name="contentArea" id="content_'+igCounter+'">'
					+'<tbody>'
					+'<tr>' 
					+'	<td width="20%"><?php echo _ADDELEMENT_SUBELEMENT_VALUE;?></td>'
					+'	<td width="80%"><input class="inputbox" type="text" id="' + sPrefix + 'value_'+igCounter+'" size="20" value="' + sCurValue + '" /></td>'
					+'</tr>'
					+'<tr>' 
					+'	<td width="20%"><?php echo _ADDELEMENT_SUBELEMENT_TEXT;?></td>'
					+'	<td width="80%"><input class="inputbox" type="text" id="' + sPrefix + 'text_'+igCounter+'" size="20" value="' + sCurText + '" /></td>'
					+'</tr>'
					+'<tr>'
					+'	<td><?php echo _ADDELEMENT_SELECTASDEFAULT;?></td>'
					+'	<td><input class="inputbox" type="checkbox" id="' + sPrefix + 'checked_'+igCounter+'" ' + sCurChecked + ' /></td>'
					+'</tr>'
					+'<tr>'
					+	'<td colspan="2"><a href="#" onclick="deleteSubElements(\'content_'+igCounter+'\');"><?php echo _ADDELEMENT_REMOVESUBELEMENT; ?></a><hr /></td>'
					+ '</tr>'
					+'</tbody>'
					+'</table>';
				var oNewBody = document.getElementById(sPrefix+sTagId);
				var oNew = document.createElement('div');
				oNew.innerHTML = sContent;
				//oNewBody.insertBefore(oNew.firstChild , oNewBody.childNodes[0]);
				oNewBody.appendChild(oNew.firstChild , oNewBody.childNodes[0]);
				igCounter++;
		}
		
		function deleteSubElements(sTagId){
			
        	var oNode = document.getElementById(sTagId);
        	oNode.parentNode.removeChild(oNode);
        }
        


		function submitbutton2(pressbutton) {
			
			var form = document.adminForm;
			<?php getEditorContents( 'editor1', 'element_label' ) ; ?>
           if (pressbutton == 'cancel' ||
               (form.elementtype_id.value != 3 &&
               form.elementtype_id.value != 4 &&
               form.elementtype_id.value != 6 )) {
                   submitform( pressbutton );                   
                   return;
           } 
			
			var prefix = getPrefix(form.elementtype_id.value);

			if(prefix == null) {
				return;
			}

			var i;
			var value, text; 
			var dd_values = document.getElementsByName('dd_values')[0];
			var dd_text = document.getElementsByName('dd_text')[0];
			var dd_initial_selection = document.getElementsByName('dd_intial_selection')[0];
			
			dd_values.value = ''; dd_text.value = ''; dd_initial_selection.value = '';
			for(i = 0; i < igCounter; i++) {
				value = document.getElementById(prefix + 'value_' + i);
				
				if(value == null) {
					continue;
				}
				
				text = document.getElementById(prefix + 'text_' + i);
				checked = document.getElementById(prefix + 'checked_' + i);
				
				dd_values.value += value.value.replace('|', '') + '|';
				dd_text.value += text.value.replace('|', '') + '|';
				
				if(checked.checked) {
					dd_initial_selection.value += value.value.replace('|', '') + '|';
				}
			}

			dd_values.value = dd_values.value.substr(0, dd_values.value.length-1); 			
			dd_text.value = dd_text.value.substr(0, dd_text.value.length-1); 			
			dd_initial_selection.value = dd_initial_selection.value.substr(0, dd_initial_selection.value.length-1);
			 			
			//alert(dd_values.value + ' ' + dd_text.value + ' ' + dd_initial_selection.value);
			submitform(pressbutton);
			return;
		}

		function getPrefix(s) {
			var prefix;
			switch(s) {
				case '3':
					prefix = 'chk_';
					break;
				case '4':
					prefix = 'rad_';
					break;
				case '6':
					prefix = 'drd_';
					break;
			}
			
			return prefix;
		}	
		
		function setAllHidden(a){
			
			els = document.getElementsByName("hidden");
			
			c = els.length 
			
			for(i = 0; i < c; i++) {
			
				document.adminForm.hidden[i].checked = a;	
				
			}
			
		}	
		
		function setAllDefault(t){
		
			els = document.getElementsByName("default");
			
			c = els.length 
			
			for(i = 0; i < c; i++) {
			
			els[i].value = t;
					
			}		
		}
		</script>		

		<span class="sectionname">
			<?php

		echo $row->id ? _EDIT : _ADD;
		echo _ADDELEMENT_TITLE;
?>
		</span>

		<?php

?>
		<table width="0" height="0"> 
			<tr> 
				<!-- complete hack to get the drop down element type to show the correct div --> 
				<?php

		for ($i = 1; $i <= 13; $i ++) {

			echo "<td id=\"tab$i\" width=\"0\" onclick=\"dhtml.cycleTab(this.id)\"></td>";
		}
?>
				</tr> 
		</table>
					
		<!-- end of hack--> 
		<form action="index2.php" method="POST" name="adminForm" id="adminForm"> 
		<table style="width:100%">
			<tr>
				<td style="width:50%" valign="top">
					<table cellpadding="5" cellspacing="0" border="0" width="100%" class="adminform"> 
						<tr>
							<td>
								<?php echo _ADDELEMENT_NAME;?>
								<a href="#" onmouseover="return overlib('<?php echo (_ADDELEMENT_NAME_LONG); ?>', CAPTION, '<?php echo _ADDELEMENT_NAME;?>', BELOW, RIGHT);" onmouseout="return nd();"><img src="<?php echo $mosConfig_live_site; ?>/includes/js/ThemeOffice/tooltip.png" border="0"></a>	
							</td>
							<td><input class="inputbox" type="text" name="element_name" size="75" value="<?php echo $row->element_name; ?>" /></td>
						</tr> 
						<tr> 
							<td>
								<?php echo _ELEMENT_LABEL;?>
								<a href="#" onmouseover="return overlib('<?php echo (_ELEMENT_LABEL_LONG); ?>', CAPTION, '<?php echo _ELEMENT_LABEL;?>', BELOW, RIGHT);" onmouseout="return nd();"><img src="<?php echo $mosConfig_live_site; ?>/includes/js/ThemeOffice/tooltip.png" border="0"></a>
								</td>
							<td>	
								<?php  editorArea( 'editor1',  $row->element_label , 'element_label', '100%;', '200', '75', '20' ) ; ?>
							</td>
						</tr> 
						<tr> 
							<td><?php echo _GROUP;?>:</td>
							<td><?php echo $groupslist?></td>
						</tr>
						<tr>
							<td><?php echo _ADDELEMENT_EL_TYPE;?></td>
							<td><?php echo $elementstypelist  ?></td>
						</tr> 

						
					</table>
					<div id="page1" class="pagetext"></div>  <!-- leave blank for please select --> 
					<div id="page2" class="pagetext">
						<!-- field -->
						<table cellpadding="5" cellspacing="0" border="0" width="100%" class="adminform"> 
							<?php

		// if the element is a field then the width is defined by element_width, otherwise use  element_field_width
		if ($row->id == '0') {
			$tmpWidth = '20';
		} else {
			if ($row->elementtype_id == '3') {
				$tmpWidth = $row->element_width;
			} else {
				$tmpWidth = $row->element_field_width;
			}
		}
?>
							<tr>
								<td><?php echo _ADDELEMENT_WIDTH;?></td>
								<td><input class="inputbox" type="text" name="element_field_width" size="3" value="<?php echo $tmpWidth	; ?>" /></td>
							</tr> 
							<tr> 
								<td><?php echo _ADDELEMENT_DEFAULT_VAL;?></td>
								<td><input onblur="setAllDefault(this.value);" class="inputbox" type="text" name="default" size="75" value="<?php echo $row->default; ?>" /></td>
							</tr> 
							<tr> 
								<td><?php echo _ADDELEMENT_HIDDEN?></td>
								<td><input  onchange="setAllHidden(this.checked);"  type="checkbox" name="hidden" value="1" <?php if($row->hidden == '1'){echo( "checked=\"checked\"");}?> /></td>
							</tr> 
							<tr> 
								<td><?php echo _ADDELEMENT_EVAL?></td>
								<td><input type="checkbox" name="eval" value="1" <?php if($row->eval == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr> 					
							<tr> 
								<td><?php echo _ADDELEMENT_PASSWORDFIELD;?></td>
								<td> <input type="checkbox" name="password" value="1" <?php if($row->password == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr> 
							<tr> 
								<td><?php echo _ADDELEMENT_MAXLENGTH;?></td>
								<td><input class="inputbox" type="text" name="maxlength" size="3" value="<?php echo $row->maxlength; ?>" /></td>
							</tr> 
						</table>
					</div>
					<div id="page3" class="pagetext">
					<!-- check box--> 

						<table cellpadding="5" cellspacing="0" border="0" width="100%" class="adminform"> 
							<tr>
								<td width="20%"><?php echo _ADDELEMENT_NO_BOX_SEL_VALUE;?></td>
								<td width="80%"><input class="inputbox" type="text" name="ck_value" size="20" value="<?php echo $row->ck_value; ?>" /></td>
							</tr> 
							<tr>				
								<td nowrap="true" colspan="2"><a href="#" onclick="addSubElement('chk_', 'subElementBody'); return false;" align="right"><?php echo _ADDELEMENT_ADDSUBELEMENT; ?></a></td>
							</tr>
							<tr><td id="chk_subElementBody"><br /></td></tr>
						</table>
												
						<script>buildSubElements('chk_', 'subElementBody');</script>
					</div>
					<div id="page4" class="pagetext">
						<!-- radio button-->
						<table cellpadding="5" cellspacing="0" border="0" width="100%" class="adminform"> 
							<tr>				
								<td nowrap="true" colspan="2"><a href="#" onclick="addSubElement('rad_', 'subElementBody'); return false;" align="right"><?php echo _ADDELEMENT_ADDSUBELEMENT; ?></a></td>
							</tr>
							<tr><td id="rad_subElementBody"><br /></td></tr>
						</table>
						<script>buildSubElements('rad_', 'subElementBody');</script>
					</div>
					<div id="page5" class="pagetext">
						<!-- text area--> 
						<table cellpadding="5" cellspacing="0" border="0" width="100%" class="adminform"> 
							<tr> 
								<td><?php echo _ADDELEMENT_WIDTH; ?></td>
								<td><input class="inputbox" type="text" name="element_width" size="6" value="<?php echo $row->element_width; ?>" /></td>
							</tr> 
							<tr> 
								<td><?php echo _ADDELEMENT_HEIGHT;?></td>
								<td><input class="inputbox" type="text" name="element_height" size="6" value="<?php echo $row->element_height; ?>" /></td>
							</tr>
							<tr> 
								<td><?php echo _ADDELEMENT_USE_WYSIWYG_EDITOR;?></td>
								<td>
									<input class="inputbox" type="checkbox" name="use_wysiwyg" value="1" <?php if($row->use_wysiwyg == '1'){echo(" checked='checked'");}?> />
								</td>
							</tr>							 
						</table>
					</div>
					<div id="page6" class="pagetext">
						<!--drop down--> 
						<input class="inputbox" type="hidden" name="dd_values" size="75" value="<?php echo $row->dd_values; ?>" />
						<input class="inputbox" type="hidden" name="dd_text" size="75" value="<?php echo $row->dd_text; ?>" />
						<input class="inputbox" type="hidden" name="dd_intial_selection" size="20" value="<?php echo $row->dd_intial_selection; ?>" />
						<table cellpadding="5" cellspacing="0" border="0" width="100%" class="adminform">
							<tr>
								<td><?php echo _ADDELEMENT_ALLOW_MULTISEL;?></td>
								<td><input class="inputbox" type="checkbox" name="multiple" value="1" <?php if($row->multiple == '1'){echo(" checked='checked'");}?> /></td>
							</tr> 
							<tr>				
								<td nowrap="true" colspan="2"><a href="#" onclick="addSubElement('drd_', 'subElementBody'); return false;" align="right"><?php echo _ADDELEMENT_ADDSUBELEMENT; ?></a></td>
							</tr>
							<tr><td id="drd_subElementBody"><br /></td></tr>
						</table>
						<script>buildSubElements('drd_', 'subElementBody');</script>
					</div>
					<div id="page7" class="pagetext">
						<!-- text only --> 
					</div>
					<div id="page8" class="pagetext">
						<!-- file upload --> 
						<table cellpadding="5" cellspacing="0" border="0" width="100%" class="adminform"> 
							<tr> 
								<td><?php echo _ADDELEMENT_MAX_FILESIZE;?></td>
								<td><input class="inputbox" type="text" name="ul_max_file_size" size="20" value="<?php echo $row->ul_max_file_size; ?>" /></td>
							</tr>
							<tr> 
								<td>
									<?php echo _ADDELEMENT_FILETYPES;?>
									<a href="#" onmouseover="return overlib('<?php echo (_ADDELEMENT_FILETYPES_LONG); ?>', CAPTION, '<?php echo _ADDELEMENT_FILETYPES;?>', BELOW, RIGHT);" onmouseout="return nd();"><img src="<?php echo $mosConfig_live_site; ?>/includes/js/ThemeOffice/tooltip.png" border="0"></a>	
								</td>
								<td><input class="inputbox" type="text" name="ul_file_types" size="50" value="<?php echo $row->ul_file_types; ?>" /></td>
							</tr>
							<tr> 
								<td><?php echo _ADDELEMENT_UPLOAD_DIR;?></td>
								<td><?php echo $dirPath?>
								<!--<input class="inputbox" type="text" name="ul_directory" size="20" value="<?php echo $row->ul_directory; ?>" />-->
								</td>
							</tr>
							<tr> 
								<td><?php echo _ADDELEMENT_EMAIL_UPLOADED_FILE;?></td>
								<td><input class="inputbox" type="checkbox" name="ul_email_file" value="1" <?php if($row->ul_email_file == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr>	
							<tr> 
								<td>
									<?php echo _ADDELEMENT_INCREMENTAL_UPLOAD ;?>
									<a href="#" onmouseover="return overlib('<?php echo (_ADDELEMENT_INCREMENTAL_UPLOAD_DESC); ?>', CAPTION, '<?php echo _ADDELEMENT_INCREMENTAL_UPLOAD;?>', BELOW, RIGHT);" onmouseout="return nd();"><img src="<?php echo $mosConfig_live_site; ?>/includes/js/ThemeOffice/tooltip.png" border="0"></a>
								</td>
								<td><input class="inputbox" type="checkbox" name="ul_file_increment" value="1" <?php if($row->ul_file_increment == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr>										
						</table>
					</div>
					<div id="page9" class="pagetext">
						<!-- image --> 
						<table cellpadding="5" cellspacing="0" border="0" width="100%" class="adminform"> 
							<tr>
								<td><?php echo _ADDELEMENT_IMAGE;?></td>
								<td><?php echo $lists['folders'] ;echo $lists['imagefiles']; ?>
								<img name="view_imagefiles" src="../images/M_images/blank.png" width="100" />
								</td>
							</tr> 
					<tr>
						<td><?php echo _ADDELEMENT_IMAGELINK; ?></td>
						<td><input class="inputbox" type="text" name="link_url" size="20" value="<?php echo $row->link_url; ?>" /></td>
					<tr>
					<tr>
						<td><?php echo _ADD_ELEMENT_IMAGEFLOAT; ?></td>
						<td><?php echo $lists["image_float"];?></td>
					</tr>							
						</table>
					</div>
					<div id="page10" class="pagetext">
						<!-- username -->
					</div>
					<div id="page11" class="pagetext">
						<!-- date --> 
						<table cellpadding="5" cellspacing="0" border="0" width="100%" class="adminform"> 

							<tr> 
								<td><?php echo _ADDELEMENT_DEFAULT_VAL;?></td>
								<td><input onblur="setAllDefault(this.value);" class="inputbox" type="text" name="default" size="75" value="<?php echo $row->default; ?>" /></td>
							</tr> 
							<tr> 
								<td><?php echo _ADDELEMENT_HIDDEN?></td>
								<td><input onchange="setAllHidden(this.checked);" type="checkbox" name="hidden" value="1" <?php if($row->hidden == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr> 
						</table>
					</div>
					
					<div id="page12" class="pagetext">
						<!-- foreign key drop down  -->

						<table cellpadding="5" cellspacing="0" border="0" width="100%" class="adminform"> 
							<tr>
								<td><?php echo _CONNECTION;?></td>
								<td><?php echo $lists['connections']; ?></td>
							</tr> 
							<tr> 
								<td><?php echo _TABLE;?></td>
								<td><?php echo $lists['tablename']; ?></td>
							</tr> 
							<tr> 
								<td><?php echo _ADDELEMENT_JOIN_KEY_COLUMN?></td>
								<td>
								<input class="inputbox" type="text" name="join_key_column" size="75" value="<?php echo $row->join_key_column; ?>" />
								<?php

		//echo
		//echo $lists['key_columns']; //TODO: mosforms : 0.5 : use ajax coding to retrieve table columns for these 2
?></td>
							</tr>
							<tr> 
								<td><?php echo _ADDELEMENT_JOIN_VAL_COLUMN?></td>
								<td>
								<input class="inputbox" type="text" name="join_val_column" size="75" value="<?php echo $row->join_val_column; ?>" />
								<?php

?></td>
							</tr> 					 
						</table>				
					</div>
					<div id="page13" class="pagetext">
					<!-- button  -->
						<table cellpadding="5" cellspacing="0" border="0" width="100%" class="adminform"> 
							<tr> 
								<td><?php echo _BUTTON_JAVASCRIPT;?></td>
								<td><textarea rows="8" cols="72" name="button_javascript" class="inputbox"><?php echo  $row->button_javascript ; ?></textarea></td>
							</tr> 	
						</table>			
					</div>
				</td>
				<td style="width:50%" valign="top">
					<?php

		$tabs->startPane("content-pane");
		$tabs->startTab(_PUBLISHING, "publish-page");
?>
						<table class="adminform">
							<th colspan="2">
								<?php echo _ACCESS; ?>
							</th>
							<tr>
								<td><?php echo _PUBLISHED; ?></td>
								<td><input type="checkbox" name="state" value="1" <?php if($row->state == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr>
							<tr>
								<td><?php echo _ADD_TO_PAGE_TITLE; ?></td>
								<td><input type="checkbox" name="use_in_page_title" value="1" <?php if($row->use_in_page_title == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr>	
						</table>					
					<?php

		$tabs->endTab();
		$tabs->startTab(_TABLE_SETTINGS, "table-page");
?>
						<table class="adminform">
							<th colspan="2">
								<?php echo _TABLE_SETTINGS; ?>
							</th>
							<tr>
								<td><?php echo _ADDELEMENT_SHOW_IN_TABLE; ?></td>
								<td><input type="checkbox" name="show_in_table_summary" value="1" <?php if($row->show_in_table_summary == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr>
							<tr>
								<td><?php echo _ADDELEMENT_LINK_TO_DETAIL; ?></td>
								<td><input type="checkbox" name="link_to_detail" value="1" <?php if($row->link_to_detail == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr>							
							
							<tr>
								<td><?php echo _ADDELEMENT_TABLE_ORDER; ?></td>
								<td><input type="checkbox" name="can_order" value="1" <?php if($row->can_order == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr> 
							<tr>
								<td><?php echo _ADDELEMENT_TABLE_FILTER; ?></td>
								<td><input type="checkbox" name="can_filter" value="1" <?php if($row->can_filter == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr>
							<tr>
								<td><?php echo _ADDELEMENT_TABLE_FILTER_TYPE; ?></td>
								<td>
									<label for="filter1"><?php echo _ADDELEMENT_TABLE_FILTER_NONE; ?></label>
									<input id="filter1" type="radio" name="filter_type" value="" <?php if($row->filter_type == ''){echo(" checked=\"checked\"");}?> />
									
									<label for="filter1"><?php echo _ADDELEMENT_TABLE_FILTER_FIELD; ?></label>
									<input id="filter1" type="radio" name="filter_type" value="field" <?php if($row->filter_type == 'field'){echo(" checked=\"checked\"");}?> />
									<label for="filter2"><?php echo _ADDELEMENT_TABLE_FILTER_DROPDOWN; ?></label>
									<input id="filter2" type="radio" name="filter_type" value="dropdown" <?php if($row->filter_type == 'dropdown'){echo(" checked=\"checked\"");}?> />
								</td>
							</tr>
							<tr>	
								<td><?php echo _ADDELEMENT_FILTER_EXACT_MATCH; ?></td>
								<td><input type="checkbox" name="filter_exact_match" value="1" <?php if($row->filter_exact_match == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr>				
							<!--<tr>	
								<td><?php echo _ADDELEMENT_PRIMARY_KEY; ?></td>
								<td><input type="checkbox" name="primary_key" value="1" <?php if($row->primary_key == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr>	
							<tr>	
								<td><?php echo _ADDELEMENT_AUTO_INCREMENT; ?></td>
								<td><input type="checkbox" name="auto_increment" value="1" <?php if($row->auto_increment == '1'){echo(" checked=\"checked\"");}?> /></td>
							</tr> 		-->														
						</table>	
					<?php

		$tabs->endTab();
		$tabs->startTab(_VALIDATIONS, "validations-page");
?>
						<table class="adminform" >
							<tr>
								<th colspan="2">
									<?php echo _VALIDATIONS; ?>
								</th>
							</tr>
								<tr>				
								<td nowrap="true" colspan="2"><a href="#" onclick="addValidation('val_', 'subElementBody'); return false;" ><?php echo _ADD_VALIDATION; ?></a></td>
							</tr>
													

							<tr><td colspan="2" id="val_subElementBody"><br /></td></tr>	
											
									
						</table>	
						
						<script>buildValidations('val_', 'subElementBody');</script>	
																	
					<?php

		$tabs->endTab();
		$tabs->endPane();
?>
				</td>
			</tr>
		</table>
			<input type="hidden" name="task" value=""> 
			<input type="hidden" name="option" value="com_mosforms" /> 
			<input type="hidden" name="id" value="<?php echo $row->id; ?>" /> 
			
			<input type="hidden" name="ordering" value="<?php echo $row->ordering;?>" />
			<input type="hidden" name="textfieldcheck" value="<?php echo $n; ?>" /> 
			<input type="hidden" name="act" value="elements" /> 
		</form>
		<?if($row->elementtype_id != ""){?> 
			<script language="javascript" type="text/javascript">
				<?php

		echo ("dhtml.cycleTab('tab".$row->elementtype_id."');");
?>
			</script> 
		<?}?> <?	


	}
}
/*
* class to display mosform validation rules html
*/

class html_validationrules_content {

	/**
	* Display the form to add or edit an validation rule
	* @param array list of available rules
	* @param string component name
	* @param integer if editing a validation then this is it's id
	* @param array list of available elements to apply validations to 
	* @param object if edting a validation then this contain's the validation's info
	*/
	function AddValidationRule($option, $validation_rule_id, $row) {
		global $mosConfig_lang;
		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		}
?> 
		<h1 class="sectionname">
			<?php

		echo $row->id ? _EDIT : _ADD;
		echo _ADD_VALIDATION_TITLE
?>
		</h1>
		<form action="index2.php" method="POST" name="adminForm"> 
		<table cellpadding="4" cellspacing="0" border="0" width="100%"  class="adminlist"> 
			<tr>
				<td><?php echo _VALIDATIONS_RULE?></td>
				<td><input class="inputbox" type="text" name="validation_rule_label" size="75" value="<?php echo $row->validation_rule_label; ?>" /></td>
			</tr> 
			<tr>
				<td><?php echo _VALIDATIONS_EXPRESSION?></td>
				<td><input class="inputbox" type="text" name="validation_rule_expression" size="75" value="<?php echo $row->validation_rule_expression; ?>" /></td>
			</tr>
		</table>
		<input type="hidden" name="option" value="<?php echo $option;?>" /> 
		<input type="hidden" name="act" value="validationrules" /> 
		<input type="hidden" name="task" value="save" /> 
		<input type="hidden" name="id" value="<?php echo $validation_rule_id;?>" /> 	
		<input type="hidden" name="cid[]" value="<?php echo $validation_rule_id;?>" /> 
	</form>

	<?

 }

	/**
	* Display all available validation rules
	* @param array array of validation_rule objects
	* @param string component name
	* @param object page navigation 
	*/
	function ShowAllValidationRules($validationrules, $option, $pageNav) {
		global $mosConfig_lang;
		if(file_exists('language/'.$mosConfig_lang.'.php')){
			
			include_once ('language/'.$mosConfig_lang.'.php'); 
		
		}else{
			
			include_once ('language/english.php'); 
			
		}
?> 
		<h1 class="sectionname">
			<?php echo _VALIDATION_RULES_TITLE; ?>
		</h1>
		<form action="index2.php" method="POST" name="adminForm">
			<table cellpadding="4" cellspacing="0" border="0" width="100%"  class="adminlist">
				<tr> 
					
					<th class="title">
					
						<?php echo _SELECT_ALL; ?> <input type="checkbox" name="toggle" value="" onclick="checkAll(<?php echo count( $validations );?>);" />
					
					</th>
					
					<th class="title"><?php echo _VALIDATIONS_RULE; ?></th>
					
					<th class="title"><?php echo _VALIDATIONS_EXPRESSION; ?></th>
					
				</tr> 
				<?php

		$k = 0;
		for ($i = 0, $n = count($validationrules); $i < $n; $i ++) {
			$row = & $validationrules[$i];
?> 
					<tr> 
						<td width="1%">
							<input type="checkbox" id="cb<?php echo $i;?>" name="cid[]" value="<?php echo $row->id; ?>" onclick="isChecked(this.checked);" /> 
						</td>
						<td>
							<a href="#edit" onclick="return listItemTask('cb<?php echo $i;?>','edit')"><?php echo($row->validation_rule_label);?></a>
						</td>
						<td>
							<?php echo($row->validation_rule_expression);?>
						</td>
					</tr> 
					<?php

			$k = 1 - $k;
		}
?> 
			</table>
			<?php echo $pageNav->getListFooter(); ?>
			<input type="hidden" name="option" value="<?php echo $option;?>" /> 
			<input type="hidden" name="boxchecked" value="0" />
			<input type="hidden" name="act" value="validationrules" /> 
			<input type="hidden" name="task" value="createnewvalidationrule" /> 
		</form>
	<?}	
	
}

?> 