<?php

require_once( 'Savant2/Plugin.php' );

class Savant2_Plugin_surveys extends Savant2_Plugin {
  function plugin( $funcName, $params )
  {
    switch ($funcName) {
      case "question":
        list($db, $id, $params2) = $params;
        return $this->question( $db, $id, $params2 );
      case "form":
        return $this->form( $params );
      case "pagetext":
        return $this->pagetext( $params );
      case "endpage":
        return $this->endpage( $params );
    }
  }

  function form( $url ) {
    $target = $this->survey->submit_window;
    $result = "<form action=\"$url\" target=\"$target\" method=\"post\" name=\"surveyForm\" id=\"surveyForm\">";
    return $result;
  }

  function pagetext( $page ) {
    $result = $this->survey->getPageText( $page );
    if (!$result) $result = $this->survey->description;
    return $result;
  }

  function endpage( $page ) {
    global $option, $Itemid;
    $pageCount = $this->survey->getPageCount();
    $params = array( "class" => "button" );
    $btnnext = ($this->survey->button_nextpage ? $this->survey->button_nextpage : "Continue");
    $btnsub = ($this->survey->button_submit ? $this->survey->button_submit : "Submit");
    $title = ($page < $pageCount ? $btnnext : $btnsub );
    $savant =& $this->Savant;
    $result = "";
    if ($this->method == "post") {
      foreach ($_POST as $field => $values) {
        $questionID = ($field[0] == 'q' ? substr($field, 1) : '');
        if (is_numeric( $questionID ) && (is_array( $values ) || trim( $values ) != '')) {
          if (!is_array( $values )) $values = array( $values );
          foreach ($values as $value) {
            $value = stripslashes( $value ); // TODO: hmm... but without this we got \\\' all over the place
            $result .= $savant->splugin( "input", "hidden", $field . "[]", $value );
          }
        }
      }
    }
    $result .= $savant->splugin( "input", "hidden", "option", $option );
    $result .= $savant->splugin( "input", "hidden", "Itemid", $Itemid );
    $result .= $savant->splugin( "input", "hidden", "survey_id", $this->survey->id );
    $result .= $savant->splugin( "input", "hidden", "page", ($page + 1) );
    $result .= $savant->splugin( "input", "submit", null, $title, $params );
    return $result;
  }

  // $this->plugin( "surveys", "question", array($db, $question->id, array()) );
  function question( &$db, $id, $params = array() ) {
    $savant =& $this->Savant;
    $row =& new mosSurveyQuestion( $db );
    $row->load( $id );
    if (isset( $row->id ) && $row->id != 0) {
      if (!is_array( $params ))
        $params = array();
      $name = "q$row->id";
      switch ($row->type) {
        case "pagebreak":
          break;
        case "static":
          break;
        case "select":
        case "multiple":
          $choices = $row->getChoices();
          if (!$row->default_answer)
            $choices = array_merge(array(''), $choices);
          echo "<select name=\"$name\"" . ($row->type == "multiple" ? " multiple=\"1\"" : "") . ">";
          echo $savant->plugin( "options", $choices, $row->default_answer, null, true );
          echo "</select>";
          break;
        case "radio":
          $choices = $row->getChoices();
          $result = $savant->splugin( "radios", $name, $choices, $row->default_answer, null, "<br />", null, true );
          $result = str_replace( '" />', '" />&nbsp;', $result );
          echo $result;
          break;
        case "checkbox":
          $choices = $row->getChoices();
          foreach ($choices as $choice) {
            echo $savant->plugin( "checkbox", $name . "[]", $choice, $row->default_answer, null );
            echo "&nbsp;$choice<br />";
          }
          break;
        case "textarea":
          if (!isset( $params["wrap"] )) $params["wrap"] = "virtual";
          echo $savant->plugin( "textarea", $name, $row->default_answer, 3, 40, $params );
          break;
        case "text":
        default:
          echo $savant->plugin( "input", "text", $name, $row->default_answer );
          break;
      }
    }
    else {
      var_dump( $row ); // DEBUG
    }
  }

}

?>