<?php
//
// Copyright (C) 2003 Jan de Graaff
// All rights reserved.
//
// This program uses parts of the original Simpleboard Application
// 0.7.0b written by Josh Levine; http://www.joshlevine.net
//
// This source file is part of the SimpleBoard Component, a Mambo 4.5
// custom Component By Jan de Graaff - http://tsmf.jigsnet.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// Please note that the GPL states that any headers in files and
// Copyright notices as well as credits in headers, source files
// and output (screens, prints, etc.) can not be removed.
// You can extend them with your own credits, though...
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
//
// The "GNU General Public License" (GPL) is available at
// http://www.gnu.org/copyleft/gpl.html.
//
// Dont allow direct linking

require_once("$sbp/sb_helpers.php");

function imageUploadError($msg) {
  global $imageLocation, $message, $rc;
  unlink($imageLocation);
  $rc = 0;
  $message = str_replace("[img]","",$message);
  
  sbAlert("$msg\n" ._IMAGE_NOT_UPLOADED);
}

$rc = 1; //reset return code

$filename= split("\.", $_FILES['attachimage']['name']);

$newFileName=$_FILES['attachimage']['name'];

//Enforce it is a new file
if (file_exists($sbp."/uploaded/images/$newFileName") || eregi("[^0-9a-zA-Z_]", $imageName) ) {
   $numExtensions=(count($filename))-1;
   $fileExt=$filename[$numExtensions];
   $newFileName = md5(microtime()) . "." . $fileExt;
}

if ($rc){
   //move it to the proper location
   move_uploaded_file($_FILES['attachimage']['tmp_name'], $sbp."/uploaded/images/$newFileName");
   @chmod ($sbp."/uploaded/images/$newFileName", 0777);

   //Filename + proper path
   $imageLocation=$sbp."/uploaded/images/$newFileName";

   //some transaltions for readability
   //numExtensions= people tend to upload malicious files using mutliple extensions like: virus.txt.vbs; we'll want to have the last extension to validate against..
   $numExtensions=(count($filename))-1;
   $imageSize=$_FILES['attachimage']['size'];
   $imageName=$filename[0];
   $imageExt=$filename[$numExtensions];
}

// Check for empty file
if ($rc){
   if (empty($_FILES['attachimage']['name'])) {
     imageUploadError(_IMAGE_ERROR_EMPTY);
   }
}

// Check for allowed file type (jpeg, gif, png)
if ($rc){
   if (!($imgtype = check_image_type($imageExt))){
      imageUploadError(_IMAGE_ERROR_TYPE);
   }
}
   
// Check file name characteristics
if ($rc){
   if (eregi("[^0-9a-zA-Z_]", $imageName)) {
      imageUploadError(_IMAGE_ERROR_NAME);
   }
}

// Check filesize
if ($rc) {
   $maxImgSize=$sbConfig['imageSize']*1024;
   if ($imageSize > $maxImgSize) {
      imageUploadError(_IMAGE_ERROR_SIZE . " (" . $sbConfig['imageSize'] . "kb)");
   }
}

list($width, $height) = @getimagesize($imageLocation);

// Check image width
if ($rc){
   if ( $width > $sbConfig['imageWidth']){
      imageUploadError(_IMAGE_ERROR_WIDTH . " (" . $sbConfig['imageWidth'] . " pixels");
   }
}

// Check image height
if ($rc){
   if ( $height > $sbConfig['imageHeight']){
      imageUploadError(_IMAGE_ERROR_HEIGHT . " (" . $sbConfig['imageHeight'] . " pixels");
   }
}

if ($rc) {
   // echo '<span class="contentheading">'._IMAGE_UPLOADED."...</span>";
   if ($width<'100') {
      $code='[img]'.$sbs.'/uploaded/images/'.$newFileName.'[/img]';
   }else{
      $code='[img size='.$width.']'.$sbs.'/uploaded/images/'.$newFileName.'[/img]';
   }
   if ( preg_match("/\[img\]/si", $message) ) {
      $message=str_replace("[img]",$code,$message);
   } else {
      $message=$message.' '.$code;
   }
}
?>