<?php
defined('_VALID_MOS') or die('Direct Access to this location is not allowed.'); 
/**
* @version $Id: standard_shipping.php,v 1.7 2005/02/09 17:14:41 soeren_nb Exp $
* @package mambo-phpShop
* @subpackage Shipping
*
* Conversion to Mambo and the rest:
* 	@copyright (C) 2004-2005 Soeren Eberhardt
*
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* mambo-phpShop is Free Software.
* mambo-phpShop comes with absolute no warranty.
*
* www.mambo-phpshop.net
*/
class standard_shipping {

	var $classname = "standard_shipping";
	
    /**************************************************************************
   * name: get_rates()
   * created by: Ekkehard Domning
   * description: returns a html list with selectable rates
   * parameters: $ratename : The name of the select form element
   *             $d[]: Array with search criteria
   *             "country", "zip", "weight"
   * returns:
   **************************************************************************/
  function list_rates( &$d ) {
    global $PHPSHOP_LANG, $CURRENCY_DISPLAY;
    $auth = $_SESSION["auth"];
    
    $dbc = new ps_DB; // Carriers
    $dbr = new ps_DB; // Rates

    $html = "<table width=\"100%\">\n<tr class=\"sectiontableheader\"><th>&nbsp;</th>";
    $html .= "<th>" . $PHPSHOP_LANG->_PHPSHOP_INFO_MSG_CARRIER . "</th><th>";
    $html .= $PHPSHOP_LANG->_PHPSHOP_INFO_MSG_SHIPPING_METHOD . "</th><th>";
    $html .= $PHPSHOP_LANG->_PHPSHOP_INFO_MSG_SHIPPING_PRICE . "</th></tr>\n";
    $selected = False;
    
    $q = "SELECT shipping_carrier_id,shipping_carrier_name FROM #__pshop_shipping_carrier ORDER BY shipping_carrier_list_order ASC";
    $dbc->query($q);
    $i = 0;
  
    while ($dbc->next_record()) {
        $q = "SELECT shipping_rate_id,shipping_rate_name,shipping_rate_value,shipping_rate_package_fee FROM #__pshop_shipping_rate WHERE ";
        $q .= "shipping_rate_carrier_id='" . $dbc->f("shipping_carrier_id") . "' AND ";
        $q .= "(shipping_rate_country LIKE '%" . $auth["country"] . "%' OR ";
        $q .= "shipping_rate_country = '') AND ";
        if (is_numeric($auth["zip"])) {
            $q .= "shipping_rate_zip_start <= '" . $auth["zip"] . "' AND ";
            $q .= "shipping_rate_zip_end >= '" . $auth["zip"] . "' AND ";
        }
        $q .= "shipping_rate_weight_start <= '" . $d["weight"] . "' AND ";
        $q .= "shipping_rate_weight_end >= '" . $d["weight"] . "'";
        $q .= " ORDER BY shipping_rate_list_order ASC,  shipping_rate_name";
        $dbr->query($q);
        while($dbr->next_record()) {

          if ($i++ % 2)
            $class="sectiontableentry1";
          else
            $class="sectiontableentry2";
          
          $total_shipping_handling = $dbr->f("shipping_rate_value") + $dbr->f("shipping_rate_package_fee");
          $show_shipping_handling = $CURRENCY_DISPLAY->getFullValue($total_shipping_handling);
          
          $html .= "<tr class=\"$class\">";
          $html .= "<td>
          <input type=\"radio\" name=\"shipping_rate_id\" value=\""
        // THE ORDER OF THOSE VALUES IS IMPORTANT:
        // carrier_name|rate_name|totalshippingcosts|rate_id
          . urlencode($dbc->f("shipping_carrier_name")."|".$dbr->f("shipping_rate_name")."|".$total_shipping_handling."|".$dbr->f("shipping_rate_id"))."\" ";
          if (!$selected) {
            $selected = True;
            $html .= "checked=\"checked\"";
          }
          $html .= " /></td>";
          $html .= "<td>" . $dbc->f("shipping_carrier_name") . "</td>";
          $html .= "<td>" . $dbr->f("shipping_rate_name") . "</td>";
          
          $html .= "<td>" . $show_shipping_handling . "</td></tr>\n";
        }
    }
    $html .= "</table>\n";
    echo ($html);
    return True;
  }
  /**************************************************************************
   * name: get_rate()
   * created by: soeren
   * description: returns the money to payfor from the given rate id
   * parameters: $rate_id : The id of therate
   * returns: a decimal value
   **************************************************************************/
  function get_rate( &$d ) {

	$details = explode("|", urldecode($_REQUEST['shipping_rate_id']) );
	$rate_id = $details[3];
	
    $dbr = new ps_DB; // Rates
    $q = "SELECT shipping_rate_value,shipping_rate_package_fee FROM #__pshop_shipping_rate WHERE ";
    $q .= "shipping_rate_id='$rate_id'";
    $dbr->query($q);
    if ($dbr->next_record()) {
      $total_rate = $dbr->f("shipping_rate_value") + $dbr->f("shipping_rate_package_fee");
      return $total_rate;
    }
    else
      return 0;
  }
  /**************************************************************************
   * name: get_rate_details()
   * created by: Ekkehard Domning
   * description: returns the money to payfor from the given rate id
   * parameters: $rate_id : The id of therate
   * returns: several values in an array
   **************************************************************************/
  function get_rate_details( &$d ) {

    $rvalue["pure_rate"] = 0;
    $rvalue["pack_rate"] = 0;
    $rvalue["total_rate"] = 0;
    $rvalue["vat_rate"] = 0;
    $rvalue["vat_value"] = 0;
    $rvalue["rate_curr"] = 0;
	
	$details = explode("|", urldecode($d['shipping_rate_id']) );
	$rate_id = $details[3];
	
    $dbr = new ps_DB; // Rates
    $q = "SELECT * FROM #__pshop_shipping_rate WHERE ";
    $q .= "shipping_rate_id='$rate_id'";
    $dbr->query($q);
    if ($dbr->next_record()) {
      $rvalue["name"] = $dbr->f("shipping_rate_name");
      $rvalue["pure_rate"] = $dbr->f("shipping_rate_value");
      $rvalue["pack_rate"] = $dbr->f("shipping_rate_package_fee");
      $rvalue["total_rate"] = $dbr->f("shipping_rate_value") + $dbr->f("shipping_rate_package_fee");
      $rvalue["vat_id"] = $dbr->f("shipping_rate_vat_id");
      if (TAX_MODE == '1') {
        $dbv = new ps_DB;
        $q = "SELECT * FROM #__pshop_tax_rate WHERE tax_rate_id ='".$dbr->f("shipping_rate_vat_id")."'";
        $dbv->query($q);
        if ($dbv->next_record()) {
          $rvalue["vat_rate"] = $dbv->f("tax_rate");
          $rvalue["vat_value"] = ($rvalue["total_rate"]*$rvalue["vat_rate"]) / (100 + $rvalue["vat_rate"]);
        }
      }
      $dbc = new ps_DB;
      $q = "SELECT * FROM #__pshop_shipping_carrier WHERE shipping_carrier_id ='".$dbr->f("shipping_rate_carrier_id")."'";
      $dbc->query($q);
      if ($dbc->next_record()) {
        $rvalue["carrier"] = $dbc->f("shipping_carrier_name");
      }

      $q = "SELECT * FROM #__pshop_currency WHERE currency_id ='".$dbr->f("shipping_rate_currency_id")."'";
      $dbc->query($q);
      if ($dbc->next_record()) {
        $rvalue["rate_curr"] = $dbc->f("currency_code");
      }
    }
    return $rvalue;
  }
  
  /**************************************************************************
   * name: validate()
   * created by: Ekkehard Domning
   * description: Validate a Rate
   * parameters: $rate_id : The id of therate
   * returns: several values in an array
   **************************************************************************/
  function validate( &$d ) {
     global $PHPSHOP_LANG;
     $cart = $_SESSION['cart'];
     $auth = $_SESSION['auth'];
     
     $dbp = new ps_DB; // Product
     $d['shipping_rate_id'] = mosGetParam( $_REQUEST, 'shipping_rate_id' );
     $d['ship_to_info_id'] = mosGetParam( $_REQUEST, 'ship_to_info_id' );
     
	 $details = explode("|", urldecode($d['shipping_rate_id']) );
	 $rate_id = $details[3];
     
     $totalweight = 0;
     for($i = 0; $i < $cart["idx"]; $i++) {
        $q = "SELECT product_weight FROM #__pshop_product WHERE product_id='";
        $q .= $cart[$i]["product_id"] . "'";
        $dbp->query($q);
        if ($dbp->next_record()) {
          if ($cart[$i]["quantity"] == "0"){
             $d["error"] = $PHPSHOP_LANG->_PHPSHOP_CHECKOUT_ERR_EMPTY_CART;
             return False;
          }
          $totalweight += $cart[$i]["quantity"] * $dbp->f("product_weight");
        } else {
          $d["error"] = $PHPSHOP_LANG->_PHPSHOP_CHECKOUT_ERR_EMPTY_CART;
          return False;
        }
     }
     $q  = "SELECT country,zip FROM #__users WHERE user_info_id = '".$d["ship_to_info_id"]."'";
     $dbu = new ps_DB; //DB User
     $dbu->query($q);
     if (!$dbu->next_record()) {
          $q  = "SELECT country,zip FROM #__pshop_user_info WHERE user_info_id = '". $d["ship_to_info_id"] . "'";
          $dbu = new ps_DB; //DB User
          $dbu->query($q);
          if (!$dbu->next_record()) {
            /*$d["error"] = $PHPSHOP_LANG->_PHPSHOP_CHECKOUT_ERR_SHIPTO_NOT_FOUND;
            return False;*/
          }
          
    }
    $zip = $dbu->f("zip");
    $country = $dbu->f("country");
    
    if (empty($zip)) {
        $q  = "SELECT country,zip FROM #__users WHERE id ='".$auth['user_id']."'";
        $dbu = new ps_DB; //DB User
        $dbu->query($q);
        $dbu->next_record();
        $zip = $dbu->f("zip");
    }

     $q  = "SELECT * FROM #__pshop_shipping_rate WHERE shipping_rate_id = '$rate_id'";
     $dbs = new ps_DB; // DB Shiping_rate
     $dbs->query($q);
     if (!$dbs->next_record()) {
       $d["error"] = $PHPSHOP_LANG->_PHPSHOP_CHECKOUT_ERR_RATE_NOT_FOUND;
       return False;
     }
     
    return $this->rate_id_valid( $rate_id, $country, $zip, $totalweight );
  }
  /**************************************************************************
   * name: rate_id_valid()
   * created by: Ekkehard Domning
   * description: checks if the rate is valid for the country, zip and weight
   * parameters: $rate_id, $country, $zip, $weight
   * returns: true if fit
   **************************************************************************/
  function rate_id_valid($rate_id, $country, $zip, $weight) {
    global $PHPSHOP_LANG;
    $db = new ps_DB; // Rates
    $q = "SELECT * FROM #__pshop_shipping_rate WHERE ";
    $q .= "shipping_rate_id='$rate_id'";
    $db->query($q);
    if ($db->next_record()) {
      if (is_numeric($zip)) {
             if (
                  (!stristr($db->f("shipping_rate_country"),$country)
                  && $db->f("shipping_rate_country") != "") or
                  ($db->f("shipping_rate_weight_start") > $weight) or
                   ($db->f("shipping_rate_weight_end")  < $weight) or
                   ($db->f("shipping_rate_zip_start")   > $zip) or
                   ($db->f("shipping_rate_zip_end")     < $zip)
                ) {
                $d["error"] = $PHPSHOP_LANG->_PHPSHOP_CHECKOUT_ERR_OTHER_SHIP;
                return false;
             }
      }
      elseif (!is_numeric($zip)) {
             if (
                  (!stristr($db->f("shipping_rate_country"),$country)
                  && $db->f("shipping_rate_country") != "") or
                  ($db->f("shipping_rate_weight_start") > $weight) or
                   ($db->f("shipping_rate_weight_end")  < $weight) 
                ) {
                $d["error"] = $PHPSHOP_LANG->_PHPSHOP_CHECKOUT_ERR_OTHER_SHIP;
                return false;
             }
      }
      return true;
    }
    else
      return false;
  }

	
	/**
    * Show all configuration parameters for this Shipping method
    * @returns boolean False when the Shipping method has no configration
    */
    function show_configuration() { 
    
      return true;
   }
  /**
  * Returns the "is_writeable" status of the configuration file
  * @param void
  * @returns boolean True when the configuration file is writeable, false when not
  */
   function configfile_writeable() {
      return is_writeable( CLASSPATH."shipping/".$this->classname.".cfg.php" );
   }
   
	/**
	* Writes the configuration file for this shipping method
	* @param array An array of objects
	* @returns boolean True when writing was successful
	*/
   function write_configuration( &$d ) {
      
      return true;
   }
}

?>
