<?php
/**
* Xaneon Alias Manager 1.0 for Mambo 4.5.1
* @package Alias_Manager_1.0
* @version 1.0.3a
* @copyright (c) 2004 Xaneon Development (dev.xaneon.com)
* @license GNU/GPL
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

/**
* This file was originally based on the sef.php included with Mambo 4.5.1a,
* but has been substantially refactored and rewritten since then.
*/

/**
* This is THE function that rewrites Mambo's basic URL format to the SEF
* format. This is called on by most components when outputting a link:
* index.php?option=com_content&...    -> /content/...
* index.php?option=com_component&...  -> /component/option,com_component/...
*
* This version does Mambo's standard processing plus alias handling via
* lookups in Alias Manager's database:
* /any-mambo-url/...                  -> /alias-mapping/
* /component/option,com_component/... -> /component/...
*/
function sefRelToAbs( $string ) {
  global $mosConfig_sef, $mosConfig_live_site;

  if ($mosConfig_sef) {

    // Normalize all URLs so that lookups and comparisons work as expected.
    $string = str_replace( "&amp;", '&', $string );

    // This is a workaround for e.g. broken modules like com_login that
    // pass in the raw REQUEST_URI to sefRelToAbs. Without this workaround,
    // URLs generated by com_login would be broken as they don't get
    // rewritten properly.
    $uri = $_SERVER["REQUEST_URI"];
    if ($string == $uri) {
      $uri = (isset( $_SERVER["REDIRECT_URL"] ) ? $_SERVER["REDIRECT_URL"] : $uri);
      return $uri;
    }

    // If SEF is enabled, Alias Manager's configuration object should be
    // be available since it's initialized at the beginning of each page
    // request.
    global $aliasConfig;
    $aliasEnabled = (is_object( $aliasConfig ) && $aliasConfig->enabled == '1');

    // First, we need to get Mambo's standard processing out of the way.
    // This code implements basically the same functionality as Mambo 4.5.1
    // does out-of-the-box, with some improvements.
    $string = sefRelToAbsMambo( $string, false );

    // We need to check that this is a relative URL; we won't do any
    // rewriting for absolute URLs (those starting e.g. with http://)
    if ($string[0] == '/') {

      // If the Alias Manager component is enabled, let it process the URL
      if ($aliasEnabled) {
        $string = sefRelToAbsAlias( $string, $aliasConfig );
      }
      else {
        // Mambo 4.5.1 always outputs absolute URLs by default, so we'll follow
        // that convention if Alias Manager isn't enabled.
        $string = $mosConfig_live_site . $string;
      }

    } // if is relative URL

    // Preserve XHTML compliance with regards to ampersands in the URL.
    $string = str_replace( '&', "&amp;", $string );

  } // if mosConfig_sef

  return $string;
}

/**
* Loads a file from the Alias Manager distribution using require_once.
*/
function sefLoadAliasFile( $file ) {
  global $mosConfig_absolute_path;
  $path = "$mosConfig_absolute_path/administrator/components/com_alias/$file";
  if (file_exists( $path )) {
    require_once( $path );
    return true;
  }
  return false;
}

if ($mosConfig_sef) {

  // REDIRECT_URL should have been set by mod_rewrite, but it doesn't get
  // set for every URL (like the root, /). Here we ensure that all code
  // beyond this point can count on it having some value.
  if (!isset( $_SERVER["REDIRECT_URL"] )) {
    // TODO: to handle this properly in every case, we would probably need to
    // a reverse lookup from the alias database?
    $_SERVER["REDIRECT_URL"] = $_SERVER["REQUEST_URI"];
  }

  if (sefLoadAliasFile( "alias.class.php" )) {
    $aliasConfig = new mosAliasConfig();
    if (sefLoadAliasFile( "alias.sef.php" )) {
      if ($aliasConfig->enabled == '1') {
        $aliasGlobals = sefDoAliasRequest( $_SERVER["REQUEST_URI"], $aliasConfig );
      }
    }
  }

  $url_array = explode('/', $_SERVER["REQUEST_URI"]);

  if (in_array( "content", $url_array )) {
    sefDoContentRequest( $_SERVER["REQUEST_URI"], $url_array );
  }

  if (in_array( "component", $url_array )) {
    sefDoComponentRequest( $_SERVER["REQUEST_URI"], $url_array );
  }

  // Extract to globals
  //while (list($key, $value) = each($_GET)) {
  foreach ($_GET as $key => $value) {
    $GLOBALS[$key] = $value;
  }

  // Don't allow config vars to be passed as global
  include( "configuration.php" );

  if (isset( $aliasGlobals )) {
    foreach ($aliasGlobals as $key => $value) {
      $GLOBALS[$key] = $value;
      if ($key == "mosConfig_locale") {
        if (!setlocale( LC_TIME, $value )) {
          // Try setting it to the language value as plan B
          setlocale( LC_TIME, $aliasGlobals["mosConfig_lang"] );
        }
      }
    }
  }
}

?>