<?php
/**
* Xaneon Extensions 2.0 for Mambo 4.5.2
* @copyright (c) 2004-2005 Xaneon Development (dev.xaneon.com)
* @license XPL http://dev.xaneon.com/xpl/
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

if ($GLOBALS['option'] == 'com_installer')
  error_reporting( E_ALL );

if (!function_exists( 'com_install' )) {
  function com_install() {
    if (xclInstall()) {
      xclSetupRedirect( 'Installation succeeded!' );
    }
    return null;
  }
}

if (!function_exists( 'com_uninstall' )) {
  function com_uninstall() {
    return xclUninstall();
  }
}

if (!function_exists( 'com_upgrade' )) {
  function com_upgrade() {
    return xclUpgrade();
  }
}

function xclUpgrade() {
  $component = xclSetupGetComponentName();
  return false;
}

function xclUninstall() {
  $component = xclSetupGetComponentName();
  return true;
}

function xclInstall() {
  $component = xclSetupGetComponentName();

  switch ($GLOBALS['task']) {
    case 'uploadfile':
      $path = mosPathName( $GLOBALS['mosConfig_absolute_path'] . '/media', false );
      $xmlFile = xclFindXMLSetupFile( $path, $component );
      break;
    case 'installfromdir':
    default:
      $xmlFile = xclFindXMLSetupFile( $GLOBALS['userfile'], $component );
      break;
  }

  if (empty( $xmlFile ) || !file_exists( $xmlFile )) {
    xclOutputText( "Unable to find XML setup file ($component.xml).", 'red' );
    xclOutputText( "Please report this error verbatim to the component author.", 'red' );
    return false;
  }

  require_once( $GLOBALS['mosConfig_absolute_path'] .
    '/includes/domit/xml_domit_lite_include.php' );
  if (!($xmlDoc =& xclLoadXMLSetupFile( $xmlFile ))) {
    xclOutputText( "Unable to load XML setup file ($xmlFile).", 'red' );
    xclOutputText( "Please report this error verbatim to the component author.", 'red' );
    return false;
  }

  $db =& $GLOBALS['database'];

  // Fix component menu icon
  if (($adminMenu = $xmlDoc->getElementsByPath( 'administration/menu', 1 )) !== null) {
    $icon = $adminMenu->getAttribute( 'icon' );
    if (!empty( $icon )) {
      $query = "UPDATE #__components" .
        "\nSET admin_menu_img = '../administrator/components/com_$component/images/{$icon}'" .
        "\nWHERE admin_menu_link = 'option=com_{$component}'";
      $db->setQuery( $query );
      $result = $db->query();
    }
  }

  // Fix component submenu icons
  if (($subMenu = $xmlDoc->getElementsByPath( 'administration/submenu', 1 )) !== null) {
    foreach ($subMenu->childNodes as $menuItem) {
      $act = $menuItem->getAttribute( 'act' );
      $icon = $menuItem->getAttribute( 'icon' );
      if (!empty( $icon )) {
        $query = "UPDATE #__components" .
          "\nSET admin_menu_img = 'js/ThemeOffice/{$icon}'" .
          "\nWHERE admin_menu_link = 'option=com_{$component}&act={$act}'";
        $db->setQuery( $query );
        $result = $db->query();
      }
    }
  }

  // Make sure the configuration file is writable.
  if (($files = $xmlDoc->getElementsByPath( 'administration/files', 1 )) !== null) {
    foreach ($files->childNodes as $file) {
      $writable = $file->getAttribute( 'writable' );
      if (!empty( $writable ) && $writable == 'yes') {
        $filePath = realpath( dirname( __FILE__ ) .
          '/../' . $file->getText() );
        if (file_exists( $filePath )) {
          if (!is_writable( $filePath ))
            @chmod( $filePath, 0666 );
          if (!is_writable( dirname( $filePath ) ))
            @chmod( dirname( $filePath ), 0777 );
        }
      }
    }
  }

  return true;
}

function xclSetupGetComponentName() {
  // TODO: need to take into account Mac as well?
  $path = str_replace( '\\', '/', dirname( __FILE__ ) );
  $pattern = '/components/com_([0-9a-zA-Z_\-]+)/includes';
  if (eregi( $pattern, $path, $matches ))
    return $matches[1];
  return null;
}

function xclFindXMLSetupFile( $path, $component ) {
  if (!file_exists( $path ))
    return null; // Sanity check
  $filePath = mosPathName( "$path/$component.xml", false );
  if (file_exists( $filePath ))
    return $filePath; // Optimization
  $dir = dir( $path );
  while ($file = $dir->read()) {
    if ($file != '.' && $file != '..') {
      $filePath = mosPathName( "$path/$file", false );
      if (is_dir( $filePath )) {
        $filePath = xclFindXMLSetupFile( $filePath, $component );
        if ($filePath != null) {
          $dir->close();
          return $filePath;
        }
      }
      else if ($file == "$component.xml") {
        $dir->close();
        return $filePath;
      }
    }
  }
  $dir->close();
  return null;
}

function xclLoadXMLSetupFile( $path ) {
  if (file_exists( $path )) {
    $xmlDoc =& new DOMIT_Lite_Document();
    $xmlDoc->resolveErrors( true );
    if ($xmlDoc->loadXML( $path, false, true ))
      return $xmlDoc;
  }
  return null;
}

function xclOutputText( $text, $color = null, $newlines = true ) {
  echo( '<div align="left">' );
  if ($color) {
    echo( '<span' . ( $color ? " style=\"color: $color;\"" : '' ) . '>' );
  }
  if ($newlines) {
    $text = str_replace( "\n", "<br />\n", $text );
  }
  echo( '<b>' . $text . '</b>&nbsp;' );
  if ($color) {
    echo( '</span>' );
  }
  echo( '<br /></div>' );
}

function xclSetupRedirect( $msg = '' ) {
  $component = xclSetupGetComponentName();

  $url = $GLOBALS['mosConfig_live_site'] .
    '/administrator/index2.php?option=com_' .
    $component . '&act=about&task=postinstall';
  if (trim( $msg )) {
    $url .= (strpos( $url, '?' ) ? '&' : '?');
    $url .= 'mosmsg=' . urlencode( $msg );
  }

  if (headers_sent()) {
    echo( "<script>document.location.href='$url';</script>\n" );
  }
  else {
    header( 'Location: ' . $url );
  }
}

?>