<?php
/**
 * install.mamml.php
 * 
 * <p>Install file for MaMML. Includes {@link com_install} function.</p>
 * 
 * @package MaMML
 * @subpackage backend
 * @copyright  2004-2005 Schmalls / Joshua Thompson / All Rights Reserved
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @author Schmalls / Joshua Thompson <schmalls@gmail.com>
 * @version 0.5.0
 * @since 0.4.3
 * @link http://www.schmalls.com
 */
 
 /**
  *  Ensures this file is being included by a parent file
  */
 defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');
 
 /**
  * Mambo install function
  * 
  * <p>Creates the newsletter directory in /images/stories and gives it the 
  * correct permissions.</p>
  * 
  * @version 0.5.0
  * @since 0.4.3
  * @global string filesystem path to main site directory
  */
 function com_install(){
	global $mosConfig_absolute_path;

	// create newsletter directory if it doesn't exist'
	if (!file_exists($mosConfig_absolute_path . '/images/stories/newsletter/')){
		umask(0);
		@mkdir($mosConfig_absolute_path . '/images/stories/newsletter/');
	}
	// make newsletter directory writeable if it isn't
	if (!is_writable($mosConfig_absolute_path . '/images/stories/newsletter/')){
		@chmod($mosConfig_absolute_path . '/images/stories/newsletter/', 0777);
	}
	// make sure the mamml.php and admin.mamml.php files were copied
	if (!is_file($mosConfig_absolute_path . '/components/com_mamml/mamml.php') || !is_file($mosConfig_absolute_path . '/administrator/components/com_mamml/admin.mamml.php')) {
		// if not, output error message
		echo '<span style="color:red;font-weight:bold;">There was an error during installation.</span>';
	} // end if
 } // end function
?>
