<?php 
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' ); 
/**
* @version $Id: shop.product_details.php,v 1.11 2005/01/29 08:09:21 soeren_nb Exp $
* @package mambo-phpShop
* @subpackage HTML
* @copyright (C) 2004-2005 Soeren Eberhardt
*
* @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
* mambo-phpShop is Free Software.
* mambo-phpShop comes with absolute no warranty.
*
* www.mambo-phpshop.net
*/
mm_showMyFileName( __FILE__ );

require_once(CLASSPATH . 'ps_product_files.php' );
require_once(CLASSPATH . 'ps_product.php' );
$ps_product = new ps_product;

require_once(CLASSPATH . 'ps_product_category.php' );
$ps_product_category = new ps_product_category;

require_once(CLASSPATH . 'ps_product_attribute.php' );
$ps_product_attribute = new ps_product_attribute;

require_once(CLASSPATH . 'ps_reviews.php' );  

/* Flypage Parameter has old page syntax: shop.flypage
* so let's get the second part - flypage */
$flypage = mosGetParam($_REQUEST, "flypage", FLYPAGE);
$flypage = explode(".", $flypage );
$flypage = $flypage[1];

$product_id = mosgetparam($_REQUEST, "product_id", null);
$category_id = mosgetparam($_REQUEST, "category_id", null);
$Itemid = mosgetparam($_REQUEST, "Itemid", null);

// Get the product info from the database
$db->query( "SELECT * FROM #__pshop_product WHERE product_id='$product_id'" );

// Redirect back to Product Browse Page on Error
if( !$db->next_record() ) {
  mosRedirect( $_SERVER['PHP_SELF']."?option=com_phpshop&keyword={$_SESSION['keyword']}&category_id={$_SESSION['category_id']}&limitstart={$_SESSION['limitstart']}", $PHPSHOP_LANG->_PHPSHOP_FILES_NOT_FOUND );
}

// Let's have a look wether the product has images.
$database->setQuery( "SELECT COUNT(file_id) AS images FROM #__pshop_product_files WHERE file_product_id='$product_id' AND file_is_image='1'" );
$database->loadObject( $images );

$navigation_pathway = "";
$navigation_childlist = "";
if (!empty($category_id))  {
    $navigation_pathway = $ps_product_category->get_navigation_list($category_id);
          
    if ($ps_product_category->has_childs($category_id)) { 
      $navigation_childlist = $PHPSHOP_LANG->_PHPSHOP_MORE_CATEGORIES.": "
                            .$ps_product_category->get_child_list($category_id);
    }
}

/** GET THE PRODUCT NAME **/
  $product_name =$db->f("product_name");
  $product_description = $db->f("product_desc");
  
/** Show an "Edit PRODUCT"-Link ***/
  if ($perm->check("admin,storeadmin")) {
    $edit_link = "<a href=\"". sefRelToAbs($mosConfig_live_site."/index.php?page=product.product_form&next_page=shop.product_details&product_id=$product_id&option=com_phpshop&Itemid=$Itemid")."\">
      <img src=\"images/M_images/edit.png\" width=\"16\" height=\"16\" alt=\"". $PHPSHOP_LANG->_PHPSHOP_PRODUCT_FORM_EDIT_PRODUCT ."\" border=\"0\" /></a>";
  }
  else {
    $edit_link = "";
  }
  
/** LINK TO MANUFACTURER POP-UP **/
  $manufacturer_id = $ps_product->get_manufacturer_id($product_id);
  if( @$_REQUEST['output'] == "pdf" ) {
    $manufacturer_link = "&nbsp;<a target=\"_blank\" href=\"$mosConfig_live_site/index2.php?page=shop.manufacturer_page&amp;manufacturer_id=$manufacturer_id&amp;option=com_phpshop&amp;Itemid=$Itemid\">";
    $manufacturer_link .= "( ".$ps_product->get_mf_name($product_id) . " )</a>"; 
  }
  else {
    $manufacturer_link = "&nbsp;<a href=\"javascript:void window.open('$mosConfig_live_site/index2.php?page=shop.manufacturer_page&amp;manufacturer_id=$manufacturer_id&amp;option=com_phpshop&amp;Itemid=$Itemid', 'win2', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no');\">";
    $manufacturer_link .= "( ".$ps_product->get_mf_name($product_id) . " )</a>"; 
  }
/** PRODUCT PRICE **/
  if (_SHOW_PRICES == '1') {
    $product_price = "<strong>". $PHPSHOP_LANG->_PHPSHOP_CART_PRICE. ":</strong>";
    $product_price .= $ps_product->show_price( $product_id ); 
  }
  else
    $product_price = "";
  
/** PRODUCT IMAGE **/
  $product_image = "";
  $full_image = $db->f("product_full_image");
  if( @$_REQUEST['output'] == "pdf" ) {
    $product_image = $ps_product->image_tag($full_image, "", 0);
  }
  /* Wrap the Image into an URL when applicable */
  elseif ( $db->f("product_url") ) { 
    $product_image = "<a href=\"". $db->f("product_url")."\" title=\"".$product_name."\">";
    $product_image .= $ps_product->image_tag($full_image, "alt=\"".$db->f("product_name")."\"", 0);
    $product_image .= "</a>";
  }
  /* Show the Thumbnail with a Link to the full IMAGE */ 
  elseif( !$db->f("product_url") ) {
    if( !$db->f("product_full_image") ) {
      $product_image = "<img src=\"".IMAGEURL.NO_IMAGE."\" alt=\"".$db->f("product_name")."\" border=\"0\" />";
    }
    else {
      // file_exists doesn't work on remote files,
      // so returns false on remote files
      // This should fix the "Long Page generation bug"
      if( file_exists( IMAGEPATH."product/$full_image" )) {
        /* Get image width and height */
        if( $image_info = @getimagesize(IMAGEPATH."product/$full_image") ) {
          $width = $image_info[0]+20;
          $height = $image_info[1]+20;
        }
      }
      else {
        $width = 640;
        $height= 480;
      }
      if( stristr( $full_image, "http" ) ) {
        $imageurl = $full_image;
      }
      else {
        $imageurl = IMAGEURL."product/$full_image";
      }
      /* Build the JavaScript Link */
      $product_image = "<a href=\"javascript:void window.open('$imageurl', 'win2', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=$width,height=$height,directories=no,location=no');\">";
      $product_image .= $ps_product->image_tag($db->f("product_thumb_image"), "alt=\"".$db->f("product_name")."\"", 1);
      $product_image .= "<br />". $PHPSHOP_LANG->_PHPSHOP_FLYPAGE_ENLARGE_IMAGE ."</a>";
    }
  }
  /* MORE IMAGES ??? */
    $more_images = "";
  if( !empty($images->images) ) {
    /* Build the JavaScript Link */
    $more_images = "<a href=\"$mosConfig_live_site/index.php?option=com_phpshop&page=shop.view_images&flypage=".@$_REQUEST['flypage']."&product_id=$product_id&Itemid=$Itemid\">";
    $more_images .= "<img src=\"".IMAGEURL."ps_image/more_images.png\" width=\"16\" height=\"16\" border=\"0\" alt=\"".$PHPSHOP_LANG->_PHPSHOP_MORE_IMAGES ." (".$images->images.")\" />";
    $more_images .= "<br />".$PHPSHOP_LANG->_PHPSHOP_MORE_IMAGES." (".$images->images.")</a>";
  }
  /* Files? */
  $file_list = ps_product_files::get_file_list( $product_id );
  
/** AVAILABILITY **/
  // This is the place where it shows: 
  // Availability: 24h, In Stock: 5 etc.
  // You can make changes to this functionality in the file: classes/ps_product.php
  if( @$_REQUEST['output'] != "pdf" )
    $product_availability = $ps_product->get_availability($product_id); 

/* SHOW RATING */
  $product_rating = "";
  if (PSHOP_ALLOW_REVIEWS == '1') {
    $product_rating = "<span class=\"contentheading\">".$PHPSHOP_LANG->_PHPSHOP_CUSTOMER_RATING.":</span><br />";
    $product_rating .= ps_reviews::allvotes( $product_id );
  }

/* ADD-TO-CART */
  $addtocart = "";
  if (USE_AS_CATALOGUE != '1') { 
    $addtocart = "<form action=\"". $_SERVER['PHP_SELF'] ."\" method=\"post\" name=\"addtocart\" id=\"addtocart\">
      <table cellspacing=\"0\" style=\"margin-right:20px;padding-left:10px;\" cellpadding=\"0\" border=\"0\">
        <tr><td colspan=\"2\">"
          .$ps_product_attribute->list_attribute($product_id)
          // added for the advanced attribute modification
          .$ps_product_attribute->list_advanced_attribute($product_id)
          // end added for advanced attribute modification
          .$ps_product_attribute->list_custom_attribute($product_id)
          // end added for custom attribute modification
          ."&nbsp;<br />
        </td></tr>
        <tr>
          <td><input type=\"text\" class=\"inputbox\" size=\"4\" name=\"quantity\" value=\"1\" />&nbsp;&nbsp;</td>
          <td valign=\"middle\" align=\"right\" width=\"141\" height=\"36\" style=\"background-position:right;cursor:pointer;background-image: url('". IMAGEURL ."ps_image/".PSHOP_ADD_TO_CART_STYLE ."'); background-repeat: no-repeat;\" onclick=\"javascript: document.getElementById('addtocart').submit();\">
          <strong>&nbsp;&gt;&nbsp;".$PHPSHOP_LANG->_PHPSHOP_CART_ADD_TO ."&nbsp;&lt;&nbsp;&nbsp;</strong></td>
        </tr>
      </table>

      <input type=\"hidden\" name=\"page\" value=\"shop.cart\" />
      <input type=\"hidden\" name=\"func\" value=\"cartAdd\" />
      <input type=\"hidden\" name=\"option\" value=\"com_phpshop\" />
      <input type=\"hidden\" name=\"Itemid\" value=\"$Itemid\" />
    </form>";
  } 

/* LIST ALL REVIEWS **/
  if (PSHOP_ALLOW_REVIEWS == '1') {
      /*** Show all reviews available ***/
      $product_reviews = ps_reviews::product_reviews( $product_id );
      /*** Show a form for writing a review ***/
      $product_reviewform = ps_reviews::reviewform( $product_id ); 
  }
  else {
    $product_reviews = $product_reviewform = "";
  }
/* LINK TO VENDOR-INFO POP-UP **/
  $vend_id = $ps_product->get_vendor_id($product_id);  
  $vend_name = $ps_product->get_vendorname($product_id);
  if( @$_REQUEST['output'] == "pdf" ) {
    $vendor_link = "<a target=\"_blank\" href=\"$mosConfig_live_site/index2.php?page=shop.infopage&amp;vendor_id=$vend_id&amp;option=com_phpshop&amp;Itemid=$Itemid\">";
    $vendor_link .= $PHPSHOP_LANG->_PHPSHOP_VENDOR_FORM_INFO_LBL ."</a>";
  }
  else {
    $vendor_link = "<a href=\"javascript:void window.open('$mosConfig_live_site/index2.php?page=shop.infopage&amp;vendor_id=$vend_id&amp;output=lite&amp;option=com_phpshop&amp;Itemid=$Itemid', 'win2', 'status=no,toolbar=no,scrollbars=yes,titlebar=no,menubar=no,resizable=yes,width=640,height=480,directories=no,location=no');\">";
    $vendor_link .= $PHPSHOP_LANG->_PHPSHOP_VENDOR_FORM_INFO_LBL ."</a>";
  }

/** 
*   Read the template file into a String variable.
*   Then replace the placeholders with HTML formatted product details
*
* function read_file( $file, $defaultfile='') ***/
$template = read_file( PAGEPATH."templates/$flypage.php", PAGEPATH."templates/flypage.php");

/** NOW LET'S BEGIN AND FILL THE TEMPLATE **/
$template = str_replace( "{navigation_pathway}", $navigation_pathway, $template );
$template = str_replace( "{navigation_childlist}", $navigation_childlist, $template );
$template = str_replace( "{product_name}", $product_name, $template );
$template = str_replace( "{product_image}", $product_image, $template );
$template = str_replace( "{more_images}", $more_images, $template );
$template = str_replace( "{file_list}", $file_list, $template );
$template = str_replace( "{edit_link}", $edit_link, $template );
$template = str_replace( "{manufacturer_link}", $manufacturer_link, $template );
$template = str_replace( "{product_price}", $product_price, $template );
$template = str_replace( "{product_description}", $product_description, $template );
$template = str_replace( "{addtocart}", $addtocart, $template );
$template = str_replace( "{product_reviews}", $product_reviews, $template );
$template = str_replace( "{product_reviewform}", $product_reviewform, $template );
$template = str_replace( "{product_availability}", $product_availability, $template );
$template = str_replace( "{vendor_link}", $vendor_link, $template );
$template = str_replace( "{mosConfig_live_site}", $mosConfig_live_site, $template );

/* Finish and Print out the Page */
echo $template;

?>
