<?
/**
* Xaneon Extensions 2.0 for Mambo 4.5.2
* @copyright (c) 2004-2005 Xaneon Development (dev.xaneon.com)
* @license XPL http://dev.xaneon.com/xpl/
*/

/** Ensure this file is being included by a parent file */
defined( '_VALID_MOS' ) or die( 'Direct access to this location is not allowed.' );

function _T() {
  $argCount = func_num_args();
  if ($argCount < 1) {
    trigger_error( 'Missing arguments to _T()', E_USER_WARNING );
    return null;
  }
  $args = func_get_args();
  $text = $args[0];

  $texts =& $GLOBALS['_LANG'];
  if (is_array( $texts ) && array_key_exists( $text, $texts )) {
    $text = $texts[$text];
  }
  else {
    //$text = "!UNDEFINED!";
  }

  if ($argCount > 1) {
    $args = array_slice( $args, 1 );
    $text = xclReplaceLangVars( $text, $args );
  }
  return $text;
}

function xclReplaceLangVars( $text, $args ) {
  for ($i = 1; $i <= count( $args ); $i++)
    $text = str_replace( '%' . $i, $args[$i-1], $text );
  return $text;
}

function xclLoadLanguageConstants( $language = null) {
  if (is_null( $language )) {
    $language = $GLOBALS['mosConfig_lang'];
    if (false) { // TODO: adminLanguage support.
    }
  }
  $langPath = $GLOBALS['mosConfig_absolute_path'] .
    '/administrator/components/' .
    $GLOBALS['option'] . '/language';
  $fileName = "$langPath/$language.ini";
  if (!file_exists( $fileName )) {
    $fileName = "$langPath/en.ini";
  }
  $defines = parse_ini_file( $fileName, false );

  $GLOBALS['_LANG'] =& $defines;

  /*foreach ($defines as $name => $value) {
    $name = "${prefix}_" . strtoupper( $name );
    define( $name, $value );
  }*/
}

function xclGetLangTitle( $langCode, $langName = '' ) {
  $langs =& xclGetLangTitles();
  return array_key_exists($langCode, $langs) ? $langs[$langCode] : null;
}

function xclGetLangISOCode( $langName ) {
  $langs =& xclGetLangMappings();
  return array_key_exists($langName, $langs) ? $langs[$langName] : null;
}

function xclGetLangName( $langCode ) {
  $langs =& xclGetLangMappings();
  return array_search( $langCode, $langs );
}

function xclGetLocale( $langCode, $langName ) {
  return $langCode;
}

function xclGetLangMappings() {
  return array(
    // Checked as of 2004-11-14
    'albanian' => 'sq',
    'arabic' => 'ar',
    'bosnian' => 'bs',
    'brazilian_portuguese' => 'pt_BR',
    'bulgarian' => 'bg',
    'catalan' => 'ca',
    'croatian' => 'hr',
    'czech1250' => 'cs',
    'czechiso' => 'cs',
    'danish' => 'da',
    'dutch' => 'nl',
    'english' => 'en',
    'finnish' => 'fi',
    'french' => 'fr',
    'germanf' => 'de',
    'germani' => 'de',
    'greek' => 'el',
    'hebrew' => 'he',
    'hungarian_formal' => 'hu',
    'hungarian_informal' => 'hu',
    'italian' => 'it',
    'korean' => 'ko',
    'lithuanian' => 'lt',
    'mongolian' => 'mn',
    'norwegian' => 'no',
    'polish' => 'pl',
    'portuguese' => 'pt',
    'romanian' => 'ro',
    'serbian' => 'sr',
    'simplified_chinese' => 'zh_CN',
    'slovenian' => 'sl',
    'spanish' => 'es',
    'swedish' => 'sv',
    'tagalog' => 'tl',
    'thai' => 'th',
    'traditional_chinese' => 'zh_TW',
    'turkish' => 'tr',
    'vietnamese' => 'vi',
  );
}

function xclMamboIsLangAvailable( $langName ) {
  $fileName = mosPathName(
    $GLOBALS['mosConfig_absolute_path'] .
    '/language' ) . $langName . '.php';
  return file_exists( $fileName );
}

function xclGetLangTitles( $onlyInstalled = false ) {
  $langs = array(
    'ar' => 'Arabic',
    'bg' => 'Bulgarian',
    'bs' => 'Bosnian',
    'ca' => 'Catalan',
    'cs' => 'Czech',
    'da' => 'Danish',
    'de' => 'German',
    'el' => 'Greek',
    'en' => 'English',
    'es' => 'Spanish',
    'fi' => 'Finnish',
    'fr' => 'French',
    'he' => 'Hebrew',
    'hr' => 'Croatian',
    'hu' => 'Hungarian',
    'it' => 'Italian',
    'ko' => 'Korean',
    'lt' => 'Lithuanian',
    'mn' => 'Mongolian',
    'nl' => 'Dutch',
    'no' => 'Norwegian',
    'pl' => 'Polish',
    'pt' => 'Portuguese',
    'pt_BR' => 'Portuguese (Brazil)',
    'ro' => 'Romanian',
    'sl' => 'Slovenian',
    'sq' => 'Albanian',
    'sr' => 'Serbian',
    'sv' => 'Swedish',
    'th' => 'Thai',
    'tl' => 'Tagalog',
    'tr' => 'Turkish',
    'vi' => 'Vietnamese',
    'zh_CN' => 'Chinese (Simplified)',
    'zh_TW' => 'Chinese (Traditional)',
  );
  if ($onlyInstalled) {
    $map =& xclGetLangMappings();
    $installed = array();
    foreach ($map as $name => $code) {
      $status = xclMamboIsLangAvailable( $name );
      if (array_key_exists( $code, $installed )) {
        // Handle duplicate codes, e.g. w/ Hungarian
        if ($installed[$code] === false && $status)
          $installed[$code] = true;
      }
      else {
        $installed[$code] = $status;
      }
    }
    foreach ($installed as $code => $status) {
      if (!$status) unset( $langs[$code] );
    }
  }
  return $langs;
}

?>