<?php
/**
 * mamml.html.php
 * 
 * <p>Includes {@link frontend_html} class.</p>
 * 
 * @package MaMML
 * @subpackage frontend
 * @copyright  2004-2005 Schmalls / Joshua Thompson / All Rights Reserved
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 * @author Schmalls / Joshua Thompson <schmalls@gmail.com>
 * @version 0.5.0
 * @since 0.4.3
 * @link http://www.schmalls.com
 */
 
 /**
  *  Ensures this file is being included by a parent file
  */
 defined('_VALID_MOS') or die('Direct Access to this location is not allowed.');
 
 /**
  * Class to display html output for frontend
  * 
  * <p>Includes html output functions used by (@link mamml.php}.</p>
  * 
  * @package MaMML
  * @subpackage frontend
  * @author Schmalls / Joshua Thompson <schmalls@gmail.com>
  * @version 0.5.0
  * @since 0.4.3
  */
 class frontend_html {
	 
	 /**
	  * Shows subscriptions
	  * 
	  * <p>Creates a form with the user's information and subscriptions. 
	  * Each newsletter has a view archive link, and if the subscriber is an 
	  * admin or publisher for the newsletter, it also shows a create letter 
	  * link.</p>
	  * 
	  * @version 0.5.0
	  * @since 0.4.3
	  * @param int $userid the user's id
	  * @param string $action the action to send back
	  * @param array $subscriptions user information
	  * @param array $letters newsletter information
	  * @param string $test md5 of email address
	  * @param string $type the user type
	  * @global int Itemid to send to help pathway
	  */
	 function showSubscriptions($userid, $action, $subscriptions, $letters, $test, $type) {
		 global $Itemid;
?>
 <script language="javascript" type="text/javascript">
	function submitcombutton() {
		var form = document.mosForm;
				
		// do field validation
		if (form.name.value == "") {
			alert( "<?php echo _REGWARN_NAME;?>" );
		} else if (form.email.value == "") {
			alert( "<?php echo _REGWARN_MAIL;?>" );
		} else {
			form.submit();
		}
	}
 </script> 
 <form method="post" action="<?php echo sefRelToAbs('index.php?option=com_mamml&Itemid=' . $Itemid . '&action=' . $action . '&task=updateSubscriptions'); ?>" name="mosForm" >
 <input type="hidden" name="userid" value="<?php echo $userid; ?>" /> 
 <p><?php echo _SUBSCRIPTIONSFOR . " " . $subscriptions->name;?>:</p> 
 <table cellpadding="0" cellspacing="0" align="center">
	<tr>
		<td><?php echo _INPUT_NAME; ?></td>
		<td colspan="2"><input type="text" name="name" size="40" value="<?php echo $subscriptions->name; ?>" class="inputbox" /></td>
	</tr>
	<tr>
		<td><?php echo _INPUT_EMAIL; ?></td>
		<td colspan="2"><input type="text" name="email" size="40" value="<?php echo $subscriptions->email; ?>" class="inputbox" /></td>
	</tr> 
<?php
		// printout each letter
		foreach ($letters as $letter) {
			$list = 'list_' . $letter->id;
			// don't display this letter if user is not registered and it is hidden
			if ($letter->hidden == 1 && $subscriptions->$list == 0) {
				continue;
			} // end if
?>
	<tr>
		<td width="25">
			<input type="checkbox" name="<?php echo $letter->id; ?>" value="1" <?php if ( $subscriptions->$list != 0 ) { echo 'checked="checked"'; } ?> <?php if ( $subscriptions->$list == 2 || $subscriptions->$list == 3) { echo 'disabled="disabled"'; } ?> class="inputbox" />
			<?php if ( $subscriptions->$list == 2 || $subscriptions->$list == 3) { echo '<input type="hidden" name="' . $letter->id . '" value="' . $subscriptions->$list . '" />'; } ?>
		</td>
		<td align="left"><?php echo $letter->list_name; ?></td>
		<td align="left">
<?php
			if (($type == 'registered') || ($subscriptions->$list != 0)) {
?>
			<a href="index.php?option=com_mamml&amp;Itemid=<?php echo $Itemid; ?>&amp;userid=<?php echo $userid; ?>&amp;action=letter&amp;task=viewarchive&amp;listid=<?php echo $letter->id; ?>&amp;type=<?php echo $type; ?>&amp;test=<?php echo $test; ?>"><?php echo _VIEWARCHIVE; ?></a>
<?php
			} // end if
?>
		</td>
	</tr>
<?php
			if ($subscriptions->$list == 2 || $subscriptions->$list == 3) {
?>
	<tr>
		<td></td>
		<td></td>
		<td>
			<a href="index.php?option=com_mamml&amp;Itemid=<?php echo $Itemid; ?>&amp;userid=<?php echo $userid; ?>&amp;action=admin&amp;type=<?php echo $type; ?>&amp;task=create&amp;listid=<?php echo $letter->id; ?>&amp;test=<?php echo $test; ?>"><?php echo _CREATELETTER; ?></a>
		</td>
	</tr>
<?php
			} // end if
	 	} // end foreach
?>
    <tr> 
    	<td><input type="checkbox" name="receivehtml" value="1" class="inputbox" <?php if ( $subscriptions->receive_html != 0 ) { echo 'checked="checked"'; } ?> /></td> 
    	<td><?php echo _RECEIVE_HTML; ?></td>
		<td></td>
    </tr> 

    <tr> 
      	<td colspan="3">
			<input type="hidden" name="type" value="<?php echo $type; ?>" />
			<input type="hidden" name="test" value="<?php echo $test; ?>" />
			<input type="hidden" name="userid" value="<?php echo $userid; ?>" />
			<input type="button" value="<?php echo _CHANGE; ?>" class="button" onclick="submitcombutton()" /> 
		</td> 
    </tr> 
 </table> 
 </form> 
<?php
	 } // end showSubscriptions
	 
	 /**
	  * Displays a form to allow new unregistered subscribers to subscribe
	  * 
	  * <p>Creates a form to input a new unregistered subscriber's 
	  * information.</p>
	  * 
	  * @version 0.4.9
	  * @since 0.4.3
	  * @param array $letters newsletter information
	  * @global int Itemid to send to help with pathway
	  */
	 function newUnregistered($letters) {
		 global $Itemid;
?>
 <script language="javascript" type="text/javascript">
	function submitcombutton() {
		var form = document.mosForm;
				
		// do field validation
		if (form.name.value == "") {
			alert( "<?php echo _REGWARN_NAME;?>" );
		} else if (form.email.value == "") {
			alert( "<?php echo _REGWARN_MAIL;?>" );
		} else {
			form.submit();
		}
	}
 </script> 
 <form method="post" action="<?php echo sefRelToAbs('index.php?option=com_mamml&Itemid=' . $Itemid . '&action=unregistered&task=addUnregistered'); ?>" name="mosForm" >
 <table cellpadding="0" cellspacing="0" align="center">
	<tr>
		<td><?php echo _INPUT_NAME; ?></td>
		<td colspan="2"><input type="text" name="name" size="40" value="" class="inputbox" /></td>
	</tr>
	<tr>
		<td><?php echo _INPUT_EMAIL; ?></td>
		<td colspan="2"><input type="text" name="email" size="40" value="" class="inputbox" /></td>
	</tr> 
<?php
		foreach ($letters as $letter) {
?>
	<tr>
		<td width="25"> <input type="checkbox" name="<?php echo $letter->id; ?>" value="1" class="inputbox" /> </td>
		<td align="left"><?php echo $letter->list_name; ?></td>
		<td align="left">&nbsp;</td>
	</tr>
<?php	
	 	} // end foreach
?>
    <tr> 
    	<td><input type="checkbox" name="receivehtml" value="1" class="inputbox" /></td> 
    	<td><?php echo _RECEIVE_HTML; ?></td>
		<td></td>
    </tr> 
    <tr> 
      	<td colspan="3">
			<input type="button" value="<?php echo _SUBSCRIBE; ?>" class="button" onclick="submitcombutton()" /> 
		</td> 
    </tr> 
 </table> 
 </form> 
<?php
	 } // end newUnregistered
	 
	 /**
	  * Displays a new user registration form
	  * 
	  * <p>Creates a form to enter new user registration and subscription 
	  * information.</p>
	  * 
	  * @version 0.4.3
	  * @since 0.4.3
	  * @param array $letters newsletter information
	  * @global int Itemid to send to help with pathway
	  * @return boolean to tell whether it was successful
	  */
	 function registerForm($letters) {
		global $Itemid;
?> 
<script language="javascript" type="text/javascript">
	function submitcombutton() {
		var form = document.mosForm;
		var r = new RegExp("[\<|\>|\"|\'|\%|\;|\(|\)|\&|\+|\-]", "i");
				
		// do field validation
		if (form.name.value == "") {
			alert( "<?php echo _REGWARN_NAME;?>" );
		} else if (form.username.value == "") {
			alert( "<?php echo _REGWARN_UNAME;?>" );
		} else if (r.exec(form.username.value) || form.username.value.length < 3) {
			alert( "<?php printf( _VALID_AZ09, _PROMPT_UNAME, 2 );?>" );
		} else if (form.email.value == "") {
			alert( "<?php echo _REGWARN_MAIL;?>" );
		} else if (form.password.value.length < 6) {
			alert( "<?php echo _REGWARN_PASS;?>" );
		} else if (form.password2.value == "") {
			alert( "<?php echo _REGWARN_VPASS1;?>" );
		} else if ((form.password.value != "") && (form.password.value != form.password2.value)){
			alert( "<?php echo _REGWARN_VPASS2;?>" );
		} else if (r.exec(form.password.value)) {
			alert( "<?php printf( _VALID_AZ09, _REGISTER_PASS, 6 );?>" );
		} else {
			form.submit();
		}
	}
</script> 
<div class="componentheading"> <?php echo _REGISTER_TITLE; ?> </div> 
<form action="index.php" method="post" name="mosForm"> 
  <table cellpadding="0" cellspacing="0" border="0" width="100%" class="contentpane"> 
    <tr> 
      <td colspan="2"><?php echo _REGISTER_REQUIRED; ?></td> 
    </tr> 
    <tr> 
      <td width="30%"><?php echo _REGISTER_NAME; ?> *</td> 
      <td><input type="text" name="name" size="40" value="" class="inputbox" /></td> 
    </tr> 
    <tr> 
      <td><?php echo _REGISTER_UNAME; ?> *</td> 
      <td><input type="text" name="username" size="40" value="" class="inputbox" /></td> 
    <tr> 
      <td><?php echo _REGISTER_EMAIL; ?> *</td> 
      <td><input type="text" name="email" size="40" value="" class="inputbox" /></td> 
    </tr> 
    <tr> 
      <td><?php echo _REGISTER_PASS; ?> *</td> 
      <td><input class="inputbox" type="password" name="password" size="40" value="" /></td> 
    </tr> 
    <tr> 
      <td><?php echo _REGISTER_VPASS; ?> *</td> 
      <td><input class="inputbox" type="password" name="password2" size="40" value="" /></td> 
    </tr> 
    <tr> 
      <td colspan="2">&nbsp;</td> 
    </tr> 
    <tr> 
      <td colspan=2> </td> 
    </tr> 
    <tr> 
      <td colspan=2> <table cellpadding="0" cellspacing="0" align="center"> 
	<tr> 
	  <th colspan="2"><?php echo _SUBSCRIPTIONS; ?>:</th> 
	</tr> 
	<tr> 
<?php
				foreach($letters as $letter) {
?> 
	  <td width="25"><input type="checkbox" name="<?php echo $letter->id; ?>" value="1" /></td>
	  <td align="left"><?php echo $letter->list_name; ?></td>
	</tr>
<?php
				} // end foreach
	
?> 
	<tr> 
	  <td><input type="checkbox" name="receivehtml" value="1" /></td>
	  <td><?php echo _RECEIVE_HTML; ?></td> 
	</tr> 
        </table></td> 
    </tr> 
  </table> 
  <input type="hidden" name="option" value="com_mamml" /> 
  <input type="hidden" name="Itemid" value="<?php echo $Itemid; ?>" /> 
  <input type="hidden" name="action" value="registered" />
  <input type="hidden" name="task" value="doRegistration" /> 
  <input type="button" value="<?php echo _BUTTON_SEND_REG; ?>" class="button" onclick="submitcombutton()" /> 
</form> 
<?php
			return true;
	} // end function
	
	 /**
	  * Displays a login area
	  * 
	  * <p>Creates a form to enter username and password to login.</p>
	  * 
	  * @version 0.4.6
	  * @since 0.4.3
	  * @global string the site's language
	  * @global int Itemid to send to help with pathway
	  */
	 function showLogin () {
		global $mosConfig_lang, $Itemid;
		
		$return = 'index.php?option=com_mamml&Itemid=' . $Itemid;
		?>
		<form action="<?php echo sefRelToAbs( 'index.php?option=login' ); ?>" method="post" name="login" id="login">
		<table width="100%" border="0" align="center" cellpadding="4" cellspacing="0" class="contentpane">
		<tr>
			<td colspan="2" align="center"> 
				<br />
				<table>
				<tr>
					<td align="center">
					<?php echo _USERNAME; ?>
					<br /> 
					</td>
					<td align="center">
					<input name="username" type="text" class="inputbox" size="20" />
					</td>
				</tr>
				<tr>
					<td align="center">
					<?php echo _PASSWORD; ?>
					<br /> 
					</td>
					<td align="center">
					<input name="passwd" type="password" class="inputbox" size="20" />
					</td>
				</tr>
				<tr>
					<td align="center" colspan="2">
					<?php echo _REMEMBER_ME; ?>
					<input type="checkbox" name="remember" class="inputbox" value="yes" /> 
					</td>
				</tr>
				</table>
			</td>
		</tr>
		<tr>
			<td> 
			<noscript>
			<?php echo _CMN_JAVASCRIPT; ?>
			</noscript>
			</td>
		</tr>
		<tr>
			<td align="center" colspan="2">
			<br />
			<input type="submit" name="submit" class="button" value="<?php echo _BUTTON_LOGIN; ?>" />
			</td>
		</tr>
		</table>

		<input type="hidden" name="op2" value="login" />
		<input type="hidden" name="return" value="<?php echo sefRelToAbs($return); ?>" />
		<input type="hidden" name="lang" value="<?php echo $mosConfig_lang; ?>" />
		</form>
		<?php  
  	 } // end function 
 	
	 /**
	  * Displays a letter creation area
	  * 
	  * <p>Creates a form to input information for the specified newsletter 
	  * and options for what to do with this information. Displays options 
	  * to save, publish, and preview.</p>
	  * 
	  * @version 0.4.12
	  * @since 0.4.3
	  * @param int $userid the user's id
	  * @param int $listid the newsletter's id
	  * @param int $permissions the users permissions
	  * @param array $list_data layout and html information for the newsletter
	  * @param array $list information from the current mailing
	  * @param int $new tells whether this is a new letter or not
	  * @param array $contentitems site content item information
	  * @param string $type the user's type
	  * @param string $test md5 of email address
	  * @global string filesystem path to main directory
	  * @global int Itemid to help with pathway 
	  */
	 function createLetter($userid, $listid, $permissions, $list_data, $list, $new, $contentitems, $type, $test) {
		global $mosConfig_absolute_path, $Itemid;
		
?>
<script language="javascript" type="text/javascript">
function submitmailing(pressbutton) {
		var form = document.adminForm;
<?php
		if($list_data->html != 0){
			getEditorContents( 'editor1', 'content');
		} // end if
?>
  	submitform( pressbutton );
}
</script>
<form action="index.php" method="post" name="adminForm"> 
<span class="sectionname"><?php echo _CREATEMAILINGBELOW; ?>:</span><br /><br /> 
<table cellpadding="4" cellspacing="1" border="0" width="100%" class="adminform"> 
	<tr> 
		<td width="100"><strong><?php echo _SUBJECT; ?>:</strong></td> 
		<td width="85%"><input type="text" name="subject" class="inputbox" size="40" value="<?php echo $list->list_subject; ?>" /></td> 
	</tr> 
	<tr> 
		<td width="100"><strong><?php echo _SENDERNAME . " " . _LEAVEBLANKFORDEF; ?>:</strong></td> 
		<td width="85%"><input type="text" name="fromname" class="inputbox" size="40" value="" /></td> 
	</tr> 
	<tr> 
		<td width="100"><strong><?php echo _SENDEREMAIL . " " . _LEAVEBLANKFORDEF; ?>:</strong></td> 
		<td width="85%"><input type="text" name="fromemail" class="inputbox" size="40" value="" /></td> 
	</tr> 
	<tr> 
		<td width="100"><strong><?php echo _SENDERBOUNCE . " " . _LEAVEBLANKFORDEF; ?>:</strong></td> 
		<td width="85%"><input type="text" name="return" class="inputbox" size="40" value="" /></td> 
	</tr> 
	<tr> 
		<td valign="top"><strong><?php echo _CONTENT; ?>:</strong></td> 
		<td>
			<strong><?php echo _USABLETAGS; ?></strong><br />
			<?php echo _NAMEREP; ?>
		</td>
	</tr> 
	<tr> 
		<td>&nbsp;</td> 
		<td>
<?php
		$content = preg_replace('/<br \/>\{contentitem:(.{1,5})\|(.{1})}/','', $list->list_content);
		$content = preg_replace('/\n\r\{contentitem:(.{1,5})\|(.{1})}/','', $content);
		$alt_content = preg_replace('/\n\r\{contentitem:(.{1,5})\|(.{1})}/','', $list->list_textonly);
		if($list_data->html != 0){
			editorArea( 'editor1',  $content , 'content', 550, 350, '60', '20' ); 
?>
		</td>
	</tr>
	<tr> 
		<td valign="top"><strong><?php echo _NONHTML; ?>:</strong></td> 
		<td>
			<strong><?php echo _USABLETAGS; ?></strong><br /> 
			<?php echo _NAMEREP; ?>
		</td>
	</tr> 
	<tr> 
		<td>&nbsp;</td> 
		<td>
			<textarea name="alt_content" cols="60" rows="15"><?php echo $alt_content; ?></textarea> 
<?php
		} else {
?> 
			<textarea name="content" cols="60" rows="15"><?php echo $content; ?></textarea> 
<?php
		} // end if
?>
		</td> 
	</tr> 
	<tr> 
		<td><strong><?php echo _ATTACHMENTS; ?>:</strong></td> 
		<td><?php echo _SELECTMULTIPLE; ?></td> 
	</tr> 
	<tr> 
		<td>&nbsp;</td> 
		<td>
<?php
		$attachments = $list->attachments;
		$files = mosReadDirectory($mosConfig_absolute_path . '/images/stories/', '\.', true, true);
?> 
			<select name="attachments[]" multiple="multiple" class="inputbox" style="width: 400px;" size="10"> 
<?php
		if(sizeof($files) > 0){
			foreach ($files as $file){
				$file = str_replace($mosConfig_absolute_path . '/images/stories/', '', $file);
				if(in_array($file, $attachments)) {
					echo '<option selected="selected">' . $file . '</option>';
				} else {
					echo '<option>' . $file . '</option>';
				} // end if
			}	// end foreach		      
		} // end if
?> 
			</select>
		</td> 
	</tr> 
	<tr>
		<td><strong><?php echo _CONTENTITEM; ?>:</strong></td>
		<td>
			<?php echo _CONTENTITEMSELECT; ?><br />
			<?php echo _SELECTMULTIPLE; ?>
		</td>
	</tr>
	<tr> 
		<td>&nbsp;</td> 
		<td>
			<select name="contentitems[]" multiple="multiple" class="inputbox" style="width: 400px;" size="10"> 
<?php
		if(sizeof($contentitems) > 0){
			foreach ($contentitems AS $contentitem){
				$id = $contentitem->id;
				$section = $contentitem->section;
				$category = $contentitem->category;
				$title = $contentitem->title;
				if((substr_count($list->list_content, "{contentitem:" . $id . "|0}") != 0) || (substr_count($list->list_content, "{contentitem:" . $id . "|1}") != 0)){
					echo '<option selected value=' . $id . '>' . $section . '/' . $category . '/'. $title . '</option>';
				} else {
					echo '<option value=' . $id . '>' . $section . '/' . $category . '/'. $title . '</option>';
				} // end if
			}	// end foreach			      
		} // end if
?> 
			</select>
		</td> 
	</tr> 
	<tr>
		<td>
			<?php echo _INTROONLY; ?>
		</td>
		<td>
			<input type="checkbox" value="1" name="introonly" />
		</td>
	</tr>
	<tr>
		<td>&nbsp</td>
		<td>
			<input type="button" class="button" value="<?php echo _SEND_BUTTON; ?>" onclick="submitmailing('publish');" />
			<input type="button" class="button" value="<?php echo _E_SAVE; ?>" onclick="submitmailing('save');" />
			<input type="button" class="button" value="<?php echo _PREVIEW; ?>" onclick="submitmailing('preview');" />
		</td>
	</tr>
	<tr>
		<td colspan="2">
			<a href="javascript:history.go(-1)"><?php echo _BACK; ?></a>
		</td>
	</tr>
</table>
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="Itemid" value="<?php echo $Itemid; ?>" />
	<input type="hidden" name="userid" value="<?php echo $userid; ?>" />
	<input type="hidden" name="type" value="<?php echo $type; ?>" />
	<input type="hidden" name="new_list" value="<?php echo $new; ?>" /> 
	<input type="hidden" name="action" value="admin" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="listid" value="<?php echo $listid; ?>" />
	<input type="hidden" name="html" value="<?php echo $list_data->html; ?>" />
	<input type="hidden" name="test" value="<?php echo $test; ?>" />
	<input type="hidden" name="boxchecked" value="0" />
</form> 
<?php
	} // end function

	/**
	 * Displays preview options
	 * 
	 * <p>Creates a form to enter receiver information for a preview 
	 * mailing.</p>
	 * 
	 * @version 0.4.12
	 * @since 0.4.3
	 * @param int $listid the list to work with
	 * @param string $fromname sender information to pass through
	 * @param string $fromemail sender information to pass through
	 * @param string $frombounce sender information to pass through
	 * @param string $type the user's type
	 * @param int $userid the user's id
	 * @param string $test md5 of email address
	 * @global int Itemid to help with pathway
	 */
	function previewMailing($listid, $fromname, $fromemail, $frombounce, $type, $userid, $test){
		global $Itemid;
?>  
<span class="sectionname"><?php echo _WHICHEMAILTEST; ?>:</span><br /> 
<br /> 
<form action="index.php" method="post" name="mosForm"> 
	<input type="hidden" name="option" value="com_mamml" />
	<input type="hidden" name="Itemid" value="<?php echo $Itemid; ?>" />
	<input type="hidden" name="action" value="admin" />
	<input type="hidden" name="type" value="<?php echo $type; ?>" />
	<input type="hidden" name="userid" value="<?php echo $userid; ?>" />
	<input type="hidden" name="listid" value="<?php echo $listid; ?>" /> 
	<input type="hidden" name="task" value="preview" />
	<input type="hidden" name="fromname" value="<?php echo $fromname; ?>" />
	<input type="hidden" name="fromemail" value="<?php echo $fromemail; ?>" />
	<input type="hidden" name="frombounce" value="<?php echo $frombounce; ?>" />
	<input type="hidden" name="test" value="<?php echo $test; ?>" /> 
	<table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" class="contentpane">
		<tr> 
			<td><?php echo _INPUT_NAME; ?></td> 
			<td><input type="text" name="name" class="inputbox" /></td> 
		</tr> 
		<tr> 
			<td><?php echo _INPUT_EMAIL; ?></td> 
			<td><input type="text" name="emailaddress" class="inputbox" /> 
		</tr> 
		<tr> 
			<td colspan="2"><?php echo _SENDINHTML; ?>
			<input type="checkbox" value="1" name="html" class="inputbox" /></td> 
    	</tr>
		<tr>
			<td colspan="2"><input type="submit" name="submit" class="button" value="<?php echo _ENTER; ?>" /></td>
		</tr> 
	</table> 
</form> 
<?php
	 } // end function
	 
	/**
	 * Displays the archive of letters for a specific list
	 * 
	 * <p>Creates a list of all of the mailings for a newsletter as links.</p>
	 * 
	 * @version 0.4.11
	 * @since 0.4.3
	 * @param int $userid the user's id
	 * @param int $listid the list to work with
	 * @param string $type the user's type
	 * @param int $permissions the user's permissions for this list
	 * @param array $mailings array of objects containing the mailings' information
	 * @param string $test md5 of email
	 * @global int Itemid to help with pathway
	 */
	function viewArchive($userid, $listid, $type, $permissions, $mailings, $test) {
		 global $Itemid;
		 
		 // make the link
		 $link = 'index2.php?option=com_mamml&Itemid=' . $Itemid . '&action=letter&type=' . $type . '&userid=' . $userid . '&listid=' . $listid . '&task=view&test=' . $test . '&send_date=';
?>
<table width="100%" border="0" align="center" cellpadding="0" cellspacing="0" class="contentpane">
	<tr>
		<td class="sectiontableheader">&nbsp;</td>
		<td class="sectiontableheader"><?php echo _HEADER_NEWSLETTER_DATE; ?></td>
		<td class="sectiontableheader"><?php echo _HEADER_NEWSLETTER_SUBJECT; ?></td>
	</tr>
<?php
		 foreach ($mailings as $mailing) {
?>
	<tr>
		<td>&nbsp;</td>
		<td><?php echo $mailing->send_date; ?></td>
		<td><a href="<?php echo $link . $mailing->send_date; ?>" target="_blank"><?php echo $mailing->list_subject; ?></a></td>
	</tr>
<?php
		 } // end foreach
?>
</table>
<p><a href="javascript:history.go(-1)"><?php echo _BACK; ?></a></p>
<?php
	 } // end function
	 
	/**
	 * Displays the mailing
	 * 
	 * <p>Displays a mailings subject, senddate, html content, and text 
	 * content.</p>
	 * 
	 * @version 0.4.9
	 * @since 0.4.3
	 * @param array $mailing object containing the mailing's information
	 * @param string $send_date the send date of the mailing
	 * @global int Itemid to help with pathway
	 * @global string the url to the main site directory
	 * 
	 */
	function viewMailing($mailing, $send_date) {
		global $Itemid, $mosConfig_live_site;
		
		$send_date = mosFormatDate(str_replace(' ', '_', $send_date));
?>
<table width="100%" cellpadding="4" cellspacing="0" border="0" class="contentpane">
	<tr>
		<td width="150" class="sectiontableheader" valign="top"><?php echo _HEADER_NEWSLETTER_DATE; ?></td>
		<td><?php echo $send_date; ?></td>
	</tr>
	<tr>
		<td width="150" class="sectiontableheader" valign="top"><?php echo _HEADER_NEWSLETTER_SUBJECT; ?></td>
		<td><?php echo $mailing->list_subject; ?></td>
	</tr>
	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>
	<tr>
		<td width="150" class="sectiontableheader" valign="top"><?php echo _HEADER_NEWSLETTER_CONTENT; ?></td>
		<td><?php echo $mailing->list_content; ?></td>
	</tr>
	<tr>
		<td colspan="2">&nbsp;</td>
	</tr>
	<tr>
		<td width="150" class="sectiontableheader" valign="top"><?php echo _TEXTONLYSENT; ?></td>
		<td><?php echo nl2br($mailing->list_textonly); ?></td>
	</tr>
</table>
<?php
	} // end function
	 
 } // end class
 
?>
