<?php
// $Id: mod_events_latest.php,v 1.8 2004/11/08 08:22:16 davemac2 Exp $
//Latest Events Module//
/**
* Content code
* @package Mambo Open Source
* @Copyright (C) 2000 - 2003 Dave McDonnell
* @ All rights reserved
* @ Mambo Open Source is Free Software
* @ Released under GNU/GPL License : http://www.gnu.org/copyleft/gpl.html
**/

/**
* Latest_Events Module.
*
* Jan 17/04, rev 1.2  Dave McDonnell
*
* Interfaces to Eric Lamette's Events Component, rev RC 2
*
* Displays upcoming events and possibly recent past events according to
* a set of programmable paramters.  See defintion below.  These parameters
* can be specified in the module's parameters window in the mambo admin.
* interface.
*
* Rev 1.01 to 1.0: a few minor bugs were fixed in ver 1.01 from 1.0
* Rev 1.1: implements a new, highly flexible customFormat specifier which can
*          customize the event content information.
* Rev 1.11: fixes a bug when no events are displayed.  Crept in somehow. :)
* Rev 1.2: default display format string changed to display ${eventDate} rather
*          than ${startDate} to better represent mutli-day events. New mod
*          parameter 'norepeat' to control display of repeat type events.
* Rev 1.21: fixed customFormat specifier ${content}, now includes first 150 chars
*                of the envet content. -change made by Kaz McCoy
*          fixed events sorting bug. (thanks Thomas Nilsson!)
*          this module now calls the com_events class mosEventsRepeat to determine
*          event viewability which should fix those discrepancy bugs betweeb this and
*          the same events displayed/not displayed in the component
*/


// following line is to prevent direct access to this script via the url
defined( '_VALID_MOS' ) or die( 'Direct Access to this location is not allowed.' );

//
// Parameters:
// ===========
//
// maxEvents = max. no. of events to display in the module (1 to 10, default is 5)
//
// mode:
// = 0  (default) display events for current week and following week only up to 'maxEvents'.
//
// = 1  same as 'mode'=0 except some past events for the current week will also be
//      displayed if num of future events is less than $maxEvents.
//
// = 2  display events for +'days' range relative to current day up to $maxEvents.
//
// = 3  same as mode 2 except if there are < 'maxEvents' in the range,
//      then display past events within -'days' range.
//
// = 4  display events for current month up to 'maxEvents'.
//
// days: (default=7) range of days relative to current day to display events for mode 1 or 3.
//
// displayLinks = 1 (default is 0) display event titles as links to the 'view_detail' com_events
//                   task which will display details of the event.
//
// displayYear = 1 (default is 0) display year when displaying dates in the non-customized event's listing.
//
// New for rev 1.1:
//
// disableDateStyle = 1 (default is 0) disables the application of the css style 'mod_events_latest_date' to
//                  the displayed events.  Use this when full customization of the display format is desired.
//                  See customFormat parameter below.
//
// disableTitleStyle = 1 (default is 0) disables the application of the css style 'mod_events_latest_title' to
//                  the displayed event's title.  Use this when full customization of the display format is desired.
//                  See customFormat parameter below.
//
// customFormatStr = string (default is null).  allows a customized specification of the desired event fields and
//                format to be used to display the event in the module.  The string can specify html directly.
//                As well, certain event fields can be specified as ${event_field} in the string.  If desired,
//                the user can even specify overriding inline styles in the event format using <div> or <span>
//                to delineate.  Or the <div>'s or <span>'s can actually reference new css style classes which you
//                can create in the template css file.
//                The ${startDate} and ${endDate} are special event fields which can support further customization
//                of the date and time display by allowing a user to specify exactly how to display the date with
//                identical format control codes to the PHP 'date()' function.
//
//                Event fields available:
//
//                ${startDate}, ${endDate}, ${eventDate}, ${title}, ${category}, ${contact}, ${content}, ${addressInfo}, ${extraInfo},
//                ${createdByAlias}, ${createdByUserName}, ${createdByUserEmail}, ${createdByUserEmailLink},
//                ${eventDetailLink}, ${color}
//
//                ${startDate}, ${eventDate} and ${endDate} can also specify a format in the form of a strftime() format or a
//                date() function format.  If a '%' sign is detected in the format string, strftime() is assumed
//                to be used (supports locale international dates).  An example of a format used:
//                ${startDate('D, M jS, Y, @g:ia')}
//
// Note that the default customFormatStr is '${eventDate}<br />${title}' which will almost display the same information
// and in the same format as in rev 1.11.  ${eventDate} is the actual date of an event within an event's
// start and end publish date ranges.  This more accurately reflects a multi-day event's actual date.


//asdbg_break();

// CHECK EVENTS COMPONENT 
if (file_exists("administrator/components/com_events/events_config.php") ) { 
    include_once("administrator/components/com_events/events_config.php");
    if (!class_exists("mosEvents")) {
        include_once("components/com_events/events.class.php");
    }
} else { 
    die ("Events Calendar\n<br />This module needs the Events component");   
}

$content = mod_eventslatest::displayLatestEvents($module, $database);

function cmpByStartTime (&$a, &$b) {
	// this custom sort compare function compares the start times of events that are refernced by the a & b vars
  	list($date, $aStrtTime) = split(" ",$a->publish_up);
   	list($date, $bStrtTime) = split(" ",$b->publish_up);
   	if ($aStrtTime == $bStrtTime) return 0;
   	return ($aStrtTime > $bStrtTime) ? -1 : 1;
}

class mod_eventslatest {

// Note that we encapsulate all this in a class to create
// an isolated name space from everythng else (I hope).

// The function below is essentially the 'ShowEventsByDate' function in the com_events module,
// except no actual output is performed.  Rather this function returns an array of references to
// $rows within the $rows (ie events) input array which occur on the input '$date'.  This
// is determined by the complicated com_event algorithm according to the event's repeatting type.


function getEventsByDate(&$rows, $date, &$seenThisEvent, $noRepeats) {

// dmcd May 7/04  I now call Eric's events class since he encapsulated this function as well.
// better code maintainability

    $year = date('Y', $date);
    $month = date('m', $date);
    $day = date('d', $date);

    $num_events = count($rows);
    $chhours = "";
    $select_date = $year."-".$month."-".$day;
    $dayOfTheWeek = date("w",$date);
    $printcount = 0;
    $new_rows_events = array();

	if ($num_events>0){
            $eventCheck = new mosEventRepeat;
            
            for ($r = 0; $r < count($rows); $r++) {

                $row = $rows[$r];

                $id = $row->id;
                if(isset($seenThisEvent[$id]) && $noRepeats) continue;

                if($eventCheck->mosEventRepeat($row, $year, $month, $day)){
                    $seenThisEvent[$id] = 1;
	            $new_rows_events[] = &$rows[$r];                    
                } // end if
	    } // end for

        usort($new_rows_events, "cmpByStartTime");

	} // end if ($num_events>0)

	return $new_rows_events;

} // end function

function displayLatestEvents(&$module, &$database){
	
// Note that the arrays below are currently not being used.  Instead the strftime() function is used assuming
// the current set_locale() is used properly

global $my;
$gid=$my->gid;

$germanTrans = array('jan' => 'Jan', 'feb' => 'Feb', 'mar' => 'Mr', 'apr' => 'Apr', 'may' => 'Mai', 'jun' => 'Jun', 'jul' => 'Jul', 'aug' => 'Aug', 'sep' => 'Sep', 'oct' => 'Okt', 'nov' => 'Nov', 'dec' => 'Dez',
	'january' => 'Januar', 'february' => 'Februar', 'march' => 'Mrz', 'april' => 'April', 'may' => 'Mai', 'june' => 'Juni', 'july' => 'Juli', 'august' => 'August', 'september' => 'September',
	'october' => 'oktober', 'november' => 'November', 'december' => 'Dezember', 'mon' => 'Mo', 'tue' => 'Di', 'wed' => 'Mi', 'thu' => 'Do', 'fri' => 'Fr', 'sat' => 'Sa', 'sun' => 'So',
	'monday' => 'Montag', 'tuesday' => 'Dienstag', 'wednesday' => 'Mittwoch', 'thursday' => 'Donnerstag', 'friday' => 'Freitag', 'saturday' => 'Samstag', 'sunday' => 'Sonntag');
	
$frenchTrans = array('jan' => '', 'feb' => '', 'mar' => '', 'apr' => '', 'may' => '', 'jun' => '', 'jul' => '', 'aug' => '', 'sep' => '', 'oct' => '', 'nov' => '', 'dec' => '',
	'january' => 'janvier', 'february' => 'fvrier', 'march' => 'mars', 'april' => 'avril', 'may' => 'mai', 'june' => 'juin', 'july' => 'juli', 'august' => 'aot', 'september' => 'septembre',
	'october' => 'octobre', 'november' => 'novembre', 'december' => 'dcembre', 'mon' => '', 'tue' => '', 'wed' => '', 'thu' => '', 'fri' => '', 'sat' => '', 'sun' => '',
	'monday' => 'lundi', 'tuesday' => 'mardi', 'wednesday' => 'mercredi', 'thursday' => 'jeudi', 'friday' => 'vendredi', 'saturday' => 'samedi', 'sunday' => 'dimanche');

// get the module parameters from the modules database record
// Note that $module var will be set by the module loader function before this script is executed.
global $mosConfig_lang;

$params = mosParseParams( $module->params );

$mode = isset( $params->mode ) ? abs(intval($params->mode)) : 0;
$days = isset( $params->days ) ? abs(intval($params->days)) : 7;
$maxEvents = isset( $params->maxEvents ) ? abs(intval($params->maxEvents)) : 5;
$displayLinks = isset( $params->displayLinks ) ? abs(intval($params->displayLinks)) : 0;
$displayYear = isset( $params->displayYear ) ? abs(intval($params->displayYear)) : 0;
$disableTitleStyle = isset( $params->disableTitleStyle ) ? abs(intval($params->disableTitleStyle)) : 0;
$disableDateStyle = isset( $params->disableDateStyle ) ? abs(intval($params->disableDateStyle)) : 0;
$customFormatStr = isset( $params->customFormatStr ) ? $params->customFormatStr : NULL;
$norepeat = isset( $params->norepeat ) ? abs(intval($params->norepeat)) : 0;

if(!isset( $params->mode ) && defined("_MOD_LATEST_MODE"))
    $mode = abs(intval(_MOD_LATEST_MODE));
if(!isset( $params->days ) && defined("_MOD_LATEST_DAYS"))
    $days = abs(intval(_MOD_LATEST_DAYS));
if(!isset( $params->maxEvents ) && defined("_MOD_LATEST_MAXEVENTS"))
    $maxEvents = abs(intval(_MOD_LATEST_MAXEVENTS));
if(!isset( $params->displayLinks ) && defined("_MOD_LATEST_DISPLAYLINKS"))
    $displayLinks = abs(intval(_MOD_LATEST_DISPLAYLINKS)) == 'YES' ? 1 : 0;
if(!isset( $params->displayYear ) && defined("_MOD_LATEST_DISPLAYYEAR"))
    $displayYear = abs(intval(_MOD_LATEST_DISPLAYYEAR)) == 'YES' ? 1 : 0;
if(!isset( $params->disableDateStyle ) && defined("_MOD_LATEST_DISDATESTYLE"))
    $disableDateStyle = abs(intval(_MOD_LATEST_DISDATESTYLE)) == 'YES' ? 1 : 0;
if(!isset( $params->disableTitleStyle ) && defined("_MOD_LATEST_DISTITLESTYLE"))
    $disableTitleStyle = abs(intval(_MOD_LATEST_DISTITLESTYLE)) == 'YES' ? 1 : 0;
if(!isset( $params->customFormatStr ) && defined("_MOD_LATEST_CUSTFMTSTR")){
    $customFormatStr = _MOD_LATEST_CUSTFMTSTR;
    if($customFormatStr == '') $customFormatStr= NULL;
}

if($mode > 4) $mode = 0;

// $maxEvents hardcoded to 10 for now to avoid bad mistakes in params
if($maxEvents > 10) $maxEvents = 10;

// derive the event date range we want based on current date and 
// form the db query.

$todayBegin = date('Y-m-d')." 00:00:00";
$yesterdayEnd = date('Y-m-d', mktime(0,0,0,date('m'),date('d') - 1, date('Y')))." 23:59:59";

switch ($mode){
case 0:
case 1:

	// week start (ie. Sun or Mon) is according to what has been selected in the events
	// component configuration thru the events admin interface.
	
    if(!defined(_CAL_CONF_STARDAY)) DEFINE(_CAL_CONF_STARDAY, 0);
	$numDay=(date("w")-_CAL_CONF_STARDAY + 7)%7;
	// begin of this week
	$beginDate = date('Y-m-d', mktime(0,0,0,date('m'),date('d') - $numDay, date('Y')))." 00:00:00";
	//$thisWeekEnd = date('Y-m-d', mktime(0,0,0,date('m'),date('d') - date('w')+6, date('Y'))." 23:59:59";
	// end of next week
	$endDate = date('Y-m-d', mktime(0,0,0,date('m'),date('d') - $numDay + 13, date('Y')))." 23:59:59";
	break;
	
case 2:
case 3:
	// begin of today - $days
	$beginDate = date('Y-m-d', mktime(0,0,0,date('m'),date('d') - $days, date('Y')))." 00:00:00";
	// end of today + $days
	$endDate = date('Y-m-d', mktime(0,0,0,date('m'),date('d') + $days, date('Y')))." 23:59:59";
	break;
	
case 4:
default:
	// beginning of this month
	$beginDate = date('Y-m-d', mktime(0,0,0,date('m'),1, date('Y')))." 00:00:00";
	// end of this month
	$endDate = date('Y-m-d', mktime(0,0,0,date('m')+1,0, date('Y')))." 23:59:59";
	break;
}

$query = "SELECT #__events.* FROM #__events, #__categories as b"
	. "\nWHERE #__events.catid = b.id AND b.access <= $gid AND #__events.access <= $gid AND (#__events.state='1' AND #__events.checked_out='0')"
	. "\n	AND ((publish_up <= '$todayBegin%' AND publish_down >= '$todayBegin%')"
	. "\n	OR (publish_up <= '$endDate%' AND publish_down >= '$endDate%')"
	. "\n   OR (publish_up <= '$endDate%' AND publish_up >= '$todayBegin%')"
	. "\n   OR (publish_down <= '$endDate%' AND publish_down >= '$todayBegin%'))"
	. "\nORDER BY publish_up ASC";

// initialise the query in the $database connector
// this translates the '#__' prefix into the real database prefix

$database->setQuery( $query );

// retrieve the list of returned records as an array of objects

$rows = $database->loadObjectList();

// determine the events that occur each day within our range

$events = 0;
$date = mktime(0,0,0);
$lastDate = mktime(0,0,0,intval(substr($endDate,5,2)),intval(substr($endDate,8,2)),intval(substr($endDate,0,4)));
$i=0;

$content = '<table width="100%" border="0" cellspacing="0" cellpadding="0" align="center">';
$seenThisEvent = array();

if(count($rows)){

	while($date <= $lastDate){
		// get the events for this $date
		$eventsThisDay = mod_eventslatest::getEventsByDate($rows, $date, $seenThisEvent, $norepeat);
		if(count($eventsThisDay)) {
			// dmcd May 7/04  bug fix to not exceed maxEvents
                        $eventsToAdd = min($maxEvents-$events, count($eventsThisDay));
                        $eventsThisDay = array_slice($eventsThisDay, 0, $eventsToAdd);
                        
                        $eventsByRelDay[$i] = $eventsThisDay;
			$events += count($eventsByRelDay[$i]);
		}
		if($events >= $maxEvents) break;
		$date = mktime(0,0,0,date('m', $date),date('d', $date)+1,date('Y', $date));
		$i++;
	}
}
if($events < $maxEvents && ($mode==1 || $mode==3)){
	// display some recent previous events too up to a total of $maxEvents
$query = "SELECT #__events.* FROM #__events, #__categories as b"
	. "\nWHERE #__events.catid = b.id AND b.access <= $gid AND #__events.access <= $gid AND (#__events.state='1' AND #__events.checked_out='0')"
		. "\n	AND ((publish_up <= '$beginDate%' AND publish_down >= '$beginDate%')"
		. "\n	OR (publish_up <= '$yesterdayEnd%' AND publish_down >= '$yesterdayEnd%')"
		. "\n   OR (publish_up <= '$yesterdayEnd%' AND publish_up >= '$beginDate%')"
		. "\n   OR (publish_down <= '$yesterdayEnd%' AND publish_down >= '$beginDate%'))"
		. "\n  ORDER BY publish_up DESC";

	// initialise the query in the $database connector
	// this translates the '#__' prefix into the real database prefix
	$database->setQuery( $query );

	// retrieve the list of returned records as an array of objects

	$prows = $database->loadObjectList();

	if(count($prows)){
		
		// start from yesterday
		$date = mktime(23,59,59,date('m'),date('d')-1,date('Y'));
		$lastDate = mktime(0,0,0,intval(substr($beginDate,5,2)),intval(substr($beginDate,8,2)),intval(substr($beginDate,0,4)));
		$i=-1;
		
		while($date >= $lastDate){
			// get the events for this $date
			$eventsThisDay = mod_eventslatest::getEventsByDate($prows, $date, $seenThisEvent, $norepeat);
			if(count($eventsThisDay)) {
				$eventsByRelDay[$i] = $eventsThisDay;
				$events += count($eventsByRelDay[$i]);
			}
			if($events >= $maxEvents) break;
			$date = mktime(0,0,0,date('m', $date),date('d', $date)-1,date('Y', $date));
			$i--;
		}
	}
}

//asdbg_break();
if(isset($eventsByRelDay) && count($eventsByRelDay)){
	
	// Now to display these events, we just start at the smallest index of the $eventsByRelDay array
	// and work our way up.

	ksort($eventsByRelDay, SORT_NUMERIC);
	reset($eventsByRelDay);

	$firstTime=true;

	// initialize name of com_events module and task defined to view
	// event detail.  Note that these could change in future com_event
	// component revisions!!  Note that the '$itemId' can be left out in
	// the link parameters for event details below since the event.php
	// component handler will fetch its own id from the db menu table
	// anyways as far as I understand it.
	
	$com_events = 'com_events';
	$task_events = 'view_detail';



	// Note we MUST get the $Itemid value for the events component
	// here, or some mambo things can break.
	$database->setQuery("SELECT id FROM #__menu WHERE link = 'index.php?option=$com_events'");
	$Itemid = $database->loadResult();

	// get the com_events category names from the categories mos table
	
	$database->setQuery("SELECT id, name FROM #__categories WHERE section= 'com_events' AND published='1'");
	$category = $database->loadObjectList('id');

	// get the usernames and email addresses from the users mos table
	
	$database->setQuery("SELECT id, username, sendEmail, email FROM #__users WHERE block ='0'");
	$users = $database->loadObjectList('id');

	// see if $customFormatStr has been specified.  If not, set it to the default format
	// of date followed by event title.
        $defaultfFormatStr= '${eventDate}<br />${title}';
	if($customFormatStr == NULL) $customFormatStr = $defaultfFormatStr;
	else {
            $customFormatStr = preg_replace('/^"(.*)"$/', "\$1", $customFormatStr);
            $customFormatStr = preg_replace("/^'(.*)'$/", "\$1", $customFormatStr);
            // escape all " within the string
            $customFormatStr = preg_replace('/"/','\"', $customFormatStr);
        }
        
	// strip out event variables and run the string thru an html checker to make sure
	// it is legal html.  If not, we will not use the custom format and print an error
	// message in the module output.  This functionality is not here for now.

	// parse the event variables and reformat them into php syntax with special handling
	// for the startDate and endDate fields.
	//asdbg_break();
	$customFormat=$customFormatStr;
	$evalString = '"';
		
	while(preg_match('/\$\{(content|eventDetailLink|createdByAlias|color|createdByUserName|createdByUserEmail|createdByUserEmailLink|eventDate|endDate|startDate|title|category|contact|addressInfo|extraInfo)(\(([^\)]*)\))?[\t ]*\}(.*)$/',$customFormat,$matches)){
		$evalString .= substr($customFormat,0,strpos($customFormat,$matches[0]));

		switch ($matches[1]){

			case 'endDate':
			case 'startDate':
			case 'eventDate':
				// Note we need to examine the date specifiers used to determine if language translation will be
				// necessary.  Do this later when script is debugged.
					
				if(!$disableDateStyle) $evalString .= "<span class='mod_events_latest_date'>";

				if (!isset($matches[3]) || $matches[3] == ''){
					// no actual format specified, use default, eg. Fri Oct 12th, @7:30pm\
					// use the strftime function for international support
					if($mosConfig_lang == 'english'){
						$dateFormat = $displayYear ?  "'D, M jS, Y, @g:ia'": "'D, M jS, @g:ia'";
						$evalString .= '". date('.$dateFormat.',$'.$matches[1].')."';
					} else {
						$dateFormat = $displayYear ? "'%a %b %d, %Y @%I:%M%p'" : "'%a %b %d @%I:%M%p'";
						$evalString .= '". strftime('.$dateFormat.',$'.$matches[1].')."';
					}
				} else {
					$matches[3] = trim($matches[3]);
					// make sure the date format specifiers are surrounded by quotes
					if(!(preg_match('/^\'.*\'$/', $matches[3]) || preg_match('/^".*"$/', $matches[3])))
						$matches[3] = "'".$matches[3]."'";
						
					// if a '%' sign detected in date format string, we assume strftime() is to be used,
					if(preg_match("/\%/", $matches[3])) $evalString .= '". strftime('.$matches[3].', $'.$matches[1].')."';
					// otherwise the date() function is assumed.
					else $evalString .= '".date('.$matches[3].', $'.$matches[1].')."';
				}

				if(!$disableDateStyle) $evalString .= "</span>";
			break;

			case 'title':

				if (!$disableTitleStyle) $evalString .= "<span class='mod_events_latest_content'>";
				if ($displayLinks) $evalString .= "<a href='index.php?option=".$com_events."&amp;task=".$task_events."&amp;Itemid=".$Itemid.'&amp;agid=".$dayEvent->id."&amp;year=".$year."&amp;month=".$month."&amp;day=".$day."\'>';

			    $evalString .= '".$dayEvent->title."';

				if ($displayLinks) $evalString .= '</a>';
				if (!$disableTitleStyle) $evalString .= '</span>';
			break;

			case 'category':
				$evalString .= '".$category[$dayEvent->catid]->name."';
			break;

			case 'contact':
				$evalString .= '".$dayEvent->contact_info."';
			break;

			case 'content':  // Added by Kaz McCoy 1-10-2004
				$evalString .= '".substr($dayEvent->content, 0, 150)." ...';
			break;

			case 'addressInfo':
				$evalString .= '".$dayEvent->adresse_info."';
			break;

			case 'extraInfo':
				$evalString .= '".$dayEvent->extra_info."';
			break;

			case 'createdByAlias':
				$evalString .= '".$dayEvent->created_by_alias."';
			break;

			case 'createdByUserName':
				$evalString .= '".$users[$dayEvent->created_by]->username."';
			break;

			case 'createdByUserEmail':
				// Note that users email address will NOT be available if they don't want to receive email
                                $evalString .= $users[$dayEvent->created_by]->sendEmail ? '". $users[$dayEvent->created_by]->email."' : '';
			break;

			case 'createdByUserEmailLink':
				// Note that users email address will NOT be available if they don't want to receive email
				$evalString .= sefRelToAbs("index.php?option=".$com_events."&amp;task=".$task_events."&amp;Itemid=".$Itemid.'&amp;agid=".$dayEvent->id."&amp;year=".$year."&amp;month=".$month."&amp;day=".$day."');
			break;

			case 'color':
				$evalString .= '".$dayEvent->color_bar."';
			break;

			case 'eventDetailLink':
				$evalString .= "'index.php?option=".$com_events."&amp;task=".$task_events."&amp;Itemid=".$Itemid.'&amp;agid=".$dayEvent->id."&amp;year=".$year."&amp;month=".$month."&amp;day=".$day."\'';

			break;

			default:
			break;
		}
		$customFormat = $matches[4];
	}
	// if no event variables were found, I guess we just print the custom string.  Let the user figure it out
	if($evalString == '"') $evalString .= $customFormatStr . '"';
	else $evalString .= $customFormat. '"';
	
	foreach($eventsByRelDay as $relDay => $daysEvents){

		reset($daysEvents);

		// get all of the events for this day

		foreach($daysEvents as $dayEvent){
			// get the title and start time
			$startDate = $dayEvent->publish_up;
                        $eventDate = mktime(substr($startDate,11,2),substr($startDate,14,2), substr($startDate,17,2),
                                date('m'),date('d') + $relDay,date('Y'));
			$startDate = mktime(substr($startDate,11,2),substr($startDate,14,2), substr($startDate,17,2),
				substr($startDate,5,2), substr($startDate,8,2), substr($startDate,0,4));
			$endDate = $dayEvent->publish_down;
			$endDate = mktime(substr($endDate,11,2),substr($endDate,14,2), substr($endDate,17,2),
				substr($endDate,5,2), substr($endDate,8,2), substr($endDate,0,4));

			$year = date('Y', $startDate);
			$month = date('m', $startDate);
			$day = date('d', $startDate);
			
			if($firstTime) $content .= "<tr><td class='mod_events_latest_first'>";
			else $content .= "<tr><td class='mod_events_latest'>";

			//asdbg_break();
			if($firstTime && @eval('$eventStr = '.$evalString.";") != NULL){
                            //$evalString = '"<span class=\'mod_events_latest_date\'>". date(\'D, M jS, @g:ia\',$startDate)."</span><br /><span class=\'mod_events_latest_content\'>".$dayEvent->title."</span>"';
                            //$content .= "<span style='color:#ff0000;font-weight:bold;'>Syntax Error in Parameter 'customFormatStr'</span></td></tr><tr><td class='mod_events_latest'>";
                        }
                        eval('$eventStr = '.$evalString.";");
			$content .= $eventStr."</td></tr>\n";
			$firstTime=false;
		}
	}
} else { $content .= "<tr><td class='mod_events_latest_noevents'>No Latest Events</td></tr>\n"; }
$content .="</table>\n";
return $content;

} // end of function
} // end of class
?>

